/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.standalone.history;

import java.util.Collections;
import java.util.List;
import org.camunda.bpm.engine.history.HistoricTaskInstanceQuery;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.variable.Variables;

@RequiredHistoryLevel(value="audit")
public class HistoricTaskInstanceQueryTest
extends PluggableProcessEngineTestCase {
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testProcessVariableValueEqualsNumber() throws Exception {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", 123L));
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", 12345L));
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", (short)123));
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", 123.0));
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", 123));
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", null));
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", Variables.longValue(null)));
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", Collections.singletonMap("var", "123"));
        HistoricTaskInstanceQueryTest.assertEquals((long)4L, (long)this.historyService.createHistoricTaskInstanceQuery().processVariableValueEquals("var", (Object)Variables.numberValue((Number)123)).count());
        HistoricTaskInstanceQueryTest.assertEquals((long)4L, (long)this.historyService.createHistoricTaskInstanceQuery().processVariableValueEquals("var", (Object)Variables.numberValue((Number)123L)).count());
        HistoricTaskInstanceQueryTest.assertEquals((long)4L, (long)this.historyService.createHistoricTaskInstanceQuery().processVariableValueEquals("var", (Object)Variables.numberValue((Number)123.0)).count());
        HistoricTaskInstanceQueryTest.assertEquals((long)4L, (long)this.historyService.createHistoricTaskInstanceQuery().processVariableValueEquals("var", (Object)Variables.numberValue((Number)123)).count());
        HistoricTaskInstanceQueryTest.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().processVariableValueEquals("var", (Object)Variables.numberValue(null)).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testTaskVariableValueEqualsNumber() throws Exception {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        List tasks = this.taskService.createTaskQuery().processDefinitionKey("oneTaskProcess").list();
        HistoricTaskInstanceQueryTest.assertEquals((int)8, (int)tasks.size());
        this.taskService.setVariableLocal(((Task)tasks.get(0)).getId(), "var", (Object)123L);
        this.taskService.setVariableLocal(((Task)tasks.get(1)).getId(), "var", (Object)12345L);
        this.taskService.setVariableLocal(((Task)tasks.get(2)).getId(), "var", (Object)123);
        this.taskService.setVariableLocal(((Task)tasks.get(3)).getId(), "var", (Object)123.0);
        this.taskService.setVariableLocal(((Task)tasks.get(4)).getId(), "var", (Object)123);
        this.taskService.setVariableLocal(((Task)tasks.get(5)).getId(), "var", null);
        this.taskService.setVariableLocal(((Task)tasks.get(6)).getId(), "var", (Object)Variables.longValue(null));
        this.taskService.setVariableLocal(((Task)tasks.get(7)).getId(), "var", (Object)"123");
        HistoricTaskInstanceQueryTest.assertEquals((long)4L, (long)this.historyService.createHistoricTaskInstanceQuery().taskVariableValueEquals("var", (Object)Variables.numberValue((Number)123)).count());
        HistoricTaskInstanceQueryTest.assertEquals((long)4L, (long)this.historyService.createHistoricTaskInstanceQuery().taskVariableValueEquals("var", (Object)Variables.numberValue((Number)123L)).count());
        HistoricTaskInstanceQueryTest.assertEquals((long)4L, (long)this.historyService.createHistoricTaskInstanceQuery().taskVariableValueEquals("var", (Object)Variables.numberValue((Number)123.0)).count());
        HistoricTaskInstanceQueryTest.assertEquals((long)4L, (long)this.historyService.createHistoricTaskInstanceQuery().taskVariableValueEquals("var", (Object)Variables.numberValue((Number)123)).count());
        HistoricTaskInstanceQueryTest.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskVariableValueEquals("var", (Object)Variables.numberValue(null)).count());
    }

    @RequiredHistoryLevel(value="full")
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testTaskInvolvedUser() {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.identityService.setAuthenticatedUserId("aAssignerId");
        this.taskService.addCandidateUser(taskId, "aUserId");
        this.taskService.addCandidateUser(taskId, "bUserId");
        this.taskService.deleteCandidateUser(taskId, "aUserId");
        this.taskService.deleteCandidateUser(taskId, "bUserId");
        Task taskAssignee = this.taskService.newTask("newTask");
        taskAssignee.setAssignee("aUserId");
        this.taskService.saveTask(taskAssignee);
        HistoricTaskInstanceQueryTest.assertEquals((long)2L, (long)this.historyService.createHistoricTaskInstanceQuery().taskInvolvedUser("aUserId").count());
        HistoricTaskInstanceQueryTest.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskInvolvedUser("bUserId").count());
        HistoricTaskInstanceQueryTest.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().taskInvolvedUser("invalidUserId").count());
        this.taskService.deleteTask("newTask", true);
    }

    @RequiredHistoryLevel(value="full")
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testTaskInvolvedGroup() {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.identityService.setAuthenticatedUserId("aAssignerId");
        this.taskService.addCandidateGroup(taskId, "aGroupId");
        this.taskService.addCandidateGroup(taskId, "bGroupId");
        this.taskService.deleteCandidateGroup(taskId, "aGroupId");
        this.taskService.deleteCandidateGroup(taskId, "bGroupId");
        HistoricTaskInstanceQueryTest.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskInvolvedGroup("aGroupId").count());
        HistoricTaskInstanceQueryTest.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskInvolvedGroup("bGroupId").count());
        HistoricTaskInstanceQueryTest.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().taskInvolvedGroup("invalidGroupId").count());
        this.taskService.deleteTask("newTask", true);
    }

    @RequiredHistoryLevel(value="full")
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testTaskHadCandidateUser() {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.identityService.setAuthenticatedUserId("aAssignerId");
        this.taskService.addCandidateUser(taskId, "aUserId");
        this.taskService.addCandidateUser(taskId, "bUserId");
        this.taskService.deleteCandidateUser(taskId, "bUserId");
        Task taskAssignee = this.taskService.newTask("newTask");
        taskAssignee.setAssignee("aUserId");
        this.taskService.saveTask(taskAssignee);
        HistoricTaskInstanceQueryTest.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskHadCandidateUser("aUserId").count());
        HistoricTaskInstanceQueryTest.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskHadCandidateUser("bUserId").count());
        HistoricTaskInstanceQueryTest.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().taskHadCandidateUser("invalidUserId").count());
        this.taskService.deleteTask("newTask", true);
    }

    @RequiredHistoryLevel(value="full")
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testTaskHadCandidateGroup() {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.identityService.setAuthenticatedUserId("aAssignerId");
        this.taskService.addCandidateGroup(taskId, "bGroupId");
        this.taskService.deleteCandidateGroup(taskId, "bGroupId");
        HistoricTaskInstanceQueryTest.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskHadCandidateGroup("bGroupId").count());
        HistoricTaskInstanceQueryTest.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().taskHadCandidateGroup("invalidGroupId").count());
        this.taskService.deleteTask("newTask", true);
    }

    @RequiredHistoryLevel(value="full")
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testGroupTaskQuery() {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.identityService.setAuthenticatedUserId("aAssignerId");
        this.taskService.addCandidateUser(taskId, "aUserId");
        this.taskService.addCandidateGroup(taskId, "aGroupId");
        this.taskService.addCandidateGroup(taskId, "bGroupId");
        Task taskOne = this.taskService.newTask("taskOne");
        taskOne.setAssignee("aUserId");
        this.taskService.saveTask(taskOne);
        Task taskTwo = this.taskService.newTask("taskTwo");
        taskTwo.setAssignee("aUserId");
        this.taskService.saveTask(taskTwo);
        Task taskThree = this.taskService.newTask("taskThree");
        taskThree.setOwner("aUserId");
        this.taskService.saveTask(taskThree);
        this.taskService.deleteCandidateGroup(taskId, "aGroupId");
        this.taskService.deleteCandidateGroup(taskId, "bGroupId");
        this.historyService.createHistoricTaskInstanceQuery();
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        HistoricTaskInstanceQueryTest.assertEquals((long)4L, (long)query.taskInvolvedUser("aUserId").count());
        query = this.historyService.createHistoricTaskInstanceQuery();
        HistoricTaskInstanceQueryTest.assertEquals((long)1L, (long)query.taskHadCandidateUser("aUserId").count());
        query = this.historyService.createHistoricTaskInstanceQuery();
        HistoricTaskInstanceQueryTest.assertEquals((long)1L, (long)query.taskHadCandidateGroup("aGroupId").count());
        HistoricTaskInstanceQueryTest.assertEquals((long)1L, (long)query.taskHadCandidateGroup("bGroupId").count());
        HistoricTaskInstanceQueryTest.assertEquals((long)0L, (long)query.taskInvolvedUser("aUserId").count());
        query = this.historyService.createHistoricTaskInstanceQuery();
        HistoricTaskInstanceQueryTest.assertEquals((long)4L, (long)query.taskInvolvedUser("aUserId").count());
        HistoricTaskInstanceQueryTest.assertEquals((long)1L, (long)query.taskHadCandidateUser("aUserId").count());
        HistoricTaskInstanceQueryTest.assertEquals((long)1L, (long)query.taskInvolvedUser("aUserId").count());
        this.taskService.deleteTask("taskOne", true);
        this.taskService.deleteTask("taskTwo", true);
        this.taskService.deleteTask("taskThree", true);
    }
}

