/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.jobexecutor;

import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.cmd.AbstractSetJobDefinitionStateCmd;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.jobexecutor.JobHandler;
import org.camunda.bpm.engine.impl.jobexecutor.JobHandlerConfiguration;
import org.camunda.bpm.engine.impl.management.UpdateJobDefinitionSuspensionStateBuilderImpl;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.util.json.JSONObject;

public abstract class TimerChangeJobDefinitionSuspensionStateJobHandler
implements JobHandler<JobDefinitionSuspensionStateConfiguration> {
    protected static final String JOB_HANDLER_CFG_BY = "by";
    protected static final String JOB_HANDLER_CFG_JOB_DEFINITION_ID = "jobDefinitionId";
    protected static final String JOB_HANDLER_CFG_PROCESS_DEFINITION_ID = "processDefinitionId";
    protected static final String JOB_HANDLER_CFG_PROCESS_DEFINITION_KEY = "processDefinitionKey";
    protected static final String JOB_HANDLER_CFG_PROCESS_DEFINITION_TENANT_ID = "processDefinitionTenantId";
    protected static final String JOB_HANDLER_CFG_INCLUDE_JOBS = "includeJobs";

    @Override
    public void execute(JobDefinitionSuspensionStateConfiguration configuration, ExecutionEntity execution, CommandContext commandContext, String tenantId) {
        AbstractSetJobDefinitionStateCmd cmd = this.getCommand(configuration);
        cmd.disableLogUserOperation();
        cmd.execute(commandContext);
    }

    protected abstract AbstractSetJobDefinitionStateCmd getCommand(JobDefinitionSuspensionStateConfiguration var1);

    @Override
    public JobDefinitionSuspensionStateConfiguration newConfiguration(String canonicalString) {
        JSONObject jsonObject = new JSONObject(canonicalString);
        return JobDefinitionSuspensionStateConfiguration.fromJson(jsonObject);
    }

    @Override
    public void onDelete(JobDefinitionSuspensionStateConfiguration configuration, JobEntity jobEntity) {
    }

    public static class JobDefinitionSuspensionStateConfiguration
    implements JobHandlerConfiguration {
        protected String jobDefinitionId;
        protected String processDefinitionKey;
        protected String processDefinitionId;
        protected boolean includeJobs;
        protected String tenantId;
        protected boolean isTenantIdSet;
        protected String by;

        @Override
        public String toCanonicalString() {
            JSONObject json = new JSONObject();
            json.put(TimerChangeJobDefinitionSuspensionStateJobHandler.JOB_HANDLER_CFG_BY, this.by);
            json.put(TimerChangeJobDefinitionSuspensionStateJobHandler.JOB_HANDLER_CFG_JOB_DEFINITION_ID, this.jobDefinitionId);
            json.put(TimerChangeJobDefinitionSuspensionStateJobHandler.JOB_HANDLER_CFG_PROCESS_DEFINITION_KEY, this.processDefinitionKey);
            json.put(TimerChangeJobDefinitionSuspensionStateJobHandler.JOB_HANDLER_CFG_INCLUDE_JOBS, this.includeJobs);
            json.put(TimerChangeJobDefinitionSuspensionStateJobHandler.JOB_HANDLER_CFG_PROCESS_DEFINITION_ID, this.processDefinitionId);
            if (this.isTenantIdSet) {
                if (this.tenantId != null) {
                    json.put(TimerChangeJobDefinitionSuspensionStateJobHandler.JOB_HANDLER_CFG_PROCESS_DEFINITION_TENANT_ID, this.tenantId);
                } else {
                    json.put(TimerChangeJobDefinitionSuspensionStateJobHandler.JOB_HANDLER_CFG_PROCESS_DEFINITION_TENANT_ID, JSONObject.NULL);
                }
            }
            return json.toString();
        }

        public UpdateJobDefinitionSuspensionStateBuilderImpl createBuilder() {
            UpdateJobDefinitionSuspensionStateBuilderImpl builder = new UpdateJobDefinitionSuspensionStateBuilderImpl();
            if (TimerChangeJobDefinitionSuspensionStateJobHandler.JOB_HANDLER_CFG_PROCESS_DEFINITION_ID.equals(this.by)) {
                builder.byProcessDefinitionId(this.processDefinitionId);
            } else if (TimerChangeJobDefinitionSuspensionStateJobHandler.JOB_HANDLER_CFG_JOB_DEFINITION_ID.equals(this.by)) {
                builder.byJobDefinitionId(this.jobDefinitionId);
            } else if (TimerChangeJobDefinitionSuspensionStateJobHandler.JOB_HANDLER_CFG_PROCESS_DEFINITION_KEY.equals(this.by)) {
                builder.byProcessDefinitionKey(this.processDefinitionKey);
                if (this.isTenantIdSet) {
                    if (this.tenantId != null) {
                        builder.processDefinitionTenantId(this.tenantId);
                    } else {
                        builder.processDefinitionWithoutTenantId();
                    }
                }
            } else {
                throw new ProcessEngineException("Unexpected job handler configuration for property 'by': " + this.by);
            }
            builder.includeJobs(this.includeJobs);
            return builder;
        }

        public static JobDefinitionSuspensionStateConfiguration fromJson(JSONObject jsonObject) {
            JobDefinitionSuspensionStateConfiguration config = new JobDefinitionSuspensionStateConfiguration();
            config.by = jsonObject.getString(TimerChangeJobDefinitionSuspensionStateJobHandler.JOB_HANDLER_CFG_BY);
            if (jsonObject.has(TimerChangeJobDefinitionSuspensionStateJobHandler.JOB_HANDLER_CFG_JOB_DEFINITION_ID)) {
                config.jobDefinitionId = jsonObject.getString(TimerChangeJobDefinitionSuspensionStateJobHandler.JOB_HANDLER_CFG_JOB_DEFINITION_ID);
            }
            if (jsonObject.has(TimerChangeJobDefinitionSuspensionStateJobHandler.JOB_HANDLER_CFG_PROCESS_DEFINITION_ID)) {
                config.processDefinitionId = jsonObject.getString(TimerChangeJobDefinitionSuspensionStateJobHandler.JOB_HANDLER_CFG_PROCESS_DEFINITION_ID);
            }
            if (jsonObject.has(TimerChangeJobDefinitionSuspensionStateJobHandler.JOB_HANDLER_CFG_PROCESS_DEFINITION_KEY)) {
                config.processDefinitionKey = jsonObject.getString(TimerChangeJobDefinitionSuspensionStateJobHandler.JOB_HANDLER_CFG_PROCESS_DEFINITION_KEY);
            }
            if (jsonObject.has(TimerChangeJobDefinitionSuspensionStateJobHandler.JOB_HANDLER_CFG_PROCESS_DEFINITION_TENANT_ID)) {
                config.isTenantIdSet = true;
                if (!jsonObject.isNull(TimerChangeJobDefinitionSuspensionStateJobHandler.JOB_HANDLER_CFG_PROCESS_DEFINITION_TENANT_ID)) {
                    config.tenantId = jsonObject.getString(TimerChangeJobDefinitionSuspensionStateJobHandler.JOB_HANDLER_CFG_PROCESS_DEFINITION_TENANT_ID);
                }
            }
            if (jsonObject.has(TimerChangeJobDefinitionSuspensionStateJobHandler.JOB_HANDLER_CFG_INCLUDE_JOBS)) {
                config.includeJobs = jsonObject.getBoolean(TimerChangeJobDefinitionSuspensionStateJobHandler.JOB_HANDLER_CFG_INCLUDE_JOBS);
            }
            return config;
        }

        public static JobDefinitionSuspensionStateConfiguration byJobDefinitionId(String jobDefinitionId, boolean includeJobs) {
            JobDefinitionSuspensionStateConfiguration configuration = new JobDefinitionSuspensionStateConfiguration();
            configuration.by = TimerChangeJobDefinitionSuspensionStateJobHandler.JOB_HANDLER_CFG_JOB_DEFINITION_ID;
            configuration.jobDefinitionId = jobDefinitionId;
            configuration.includeJobs = includeJobs;
            return configuration;
        }

        public static JobDefinitionSuspensionStateConfiguration byProcessDefinitionId(String processDefinitionId, boolean includeJobs) {
            JobDefinitionSuspensionStateConfiguration configuration = new JobDefinitionSuspensionStateConfiguration();
            configuration.by = TimerChangeJobDefinitionSuspensionStateJobHandler.JOB_HANDLER_CFG_PROCESS_DEFINITION_ID;
            configuration.processDefinitionId = processDefinitionId;
            configuration.includeJobs = includeJobs;
            return configuration;
        }

        public static JobDefinitionSuspensionStateConfiguration byProcessDefinitionKey(String processDefinitionKey, boolean includeJobs) {
            JobDefinitionSuspensionStateConfiguration configuration = new JobDefinitionSuspensionStateConfiguration();
            configuration.by = TimerChangeJobDefinitionSuspensionStateJobHandler.JOB_HANDLER_CFG_PROCESS_DEFINITION_KEY;
            configuration.processDefinitionKey = processDefinitionKey;
            configuration.includeJobs = includeJobs;
            return configuration;
        }

        public static JobDefinitionSuspensionStateConfiguration ByProcessDefinitionKeyAndTenantId(String processDefinitionKey, String tenantId, boolean includeProcessInstances) {
            JobDefinitionSuspensionStateConfiguration configuration = JobDefinitionSuspensionStateConfiguration.byProcessDefinitionKey(processDefinitionKey, includeProcessInstances);
            configuration.isTenantIdSet = true;
            configuration.tenantId = tenantId;
            return configuration;
        }
    }
}

