/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.oplog;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.core.model.CoreActivity;
import org.camunda.bpm.engine.impl.oplog.UserOperationLogContextEntry;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyChange;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;

public class UserOperationLogContextEntryBuilder {
    protected UserOperationLogContextEntry entry;

    public static UserOperationLogContextEntryBuilder entry(String operationType, String entityType) {
        UserOperationLogContextEntryBuilder builder = new UserOperationLogContextEntryBuilder();
        builder.entry = new UserOperationLogContextEntry(operationType, entityType);
        return builder;
    }

    public UserOperationLogContextEntryBuilder inContextOf(JobEntity job) {
        this.entry.setJobDefinitionId(job.getJobDefinitionId());
        this.entry.setProcessInstanceId(job.getProcessInstanceId());
        this.entry.setProcessDefinitionId(job.getProcessDefinitionId());
        this.entry.setProcessDefinitionKey(job.getProcessDefinitionKey());
        this.entry.setDeploymentId(job.getDeploymentId());
        return this;
    }

    public UserOperationLogContextEntryBuilder inContextOf(JobDefinitionEntity jobDefinition) {
        this.entry.setJobDefinitionId(jobDefinition.getId());
        this.entry.setProcessDefinitionId(jobDefinition.getProcessDefinitionId());
        this.entry.setProcessDefinitionKey(jobDefinition.getProcessDefinitionKey());
        if (jobDefinition.getProcessDefinitionId() != null) {
            ProcessDefinitionEntity processDefinition = Context.getProcessEngineConfiguration().getDeploymentCache().findDeployedProcessDefinitionById(jobDefinition.getProcessDefinitionId());
            this.entry.setDeploymentId(processDefinition.getDeploymentId());
        }
        return this;
    }

    public UserOperationLogContextEntryBuilder inContextOf(ExecutionEntity execution) {
        this.entry.setProcessInstanceId(execution.getProcessInstanceId());
        this.entry.setProcessDefinitionId(execution.getProcessDefinitionId());
        ProcessDefinitionEntity processDefinition = execution.getProcessDefinition();
        this.entry.setProcessDefinitionKey(processDefinition.getKey());
        this.entry.setDeploymentId(processDefinition.getDeploymentId());
        return this;
    }

    public UserOperationLogContextEntryBuilder inContextOf(ProcessDefinitionEntity processDefinition) {
        this.entry.setProcessDefinitionId(processDefinition.getId());
        this.entry.setProcessDefinitionKey(processDefinition.getKey());
        this.entry.setDeploymentId(processDefinition.getDeploymentId());
        return this;
    }

    public UserOperationLogContextEntryBuilder inContextOf(TaskEntity task, List<PropertyChange> propertyChanges) {
        if ((propertyChanges == null || propertyChanges.isEmpty()) && "Create".equals(this.entry.getOperationType())) {
            propertyChanges = Arrays.asList(PropertyChange.EMPTY_CHANGE);
        }
        this.entry.setPropertyChanges(propertyChanges);
        CoreActivity definition = task.getProcessDefinition();
        if (definition != null) {
            this.entry.setProcessDefinitionKey(definition.getKey());
            this.entry.setDeploymentId(definition.getDeploymentId());
        } else if (task.getCaseDefinitionId() != null) {
            definition = task.getCaseDefinition();
            this.entry.setDeploymentId(definition.getDeploymentId());
        }
        this.entry.setProcessDefinitionId(task.getProcessDefinitionId());
        this.entry.setProcessInstanceId(task.getProcessInstanceId());
        this.entry.setExecutionId(task.getExecutionId());
        this.entry.setCaseDefinitionId(task.getCaseDefinitionId());
        this.entry.setCaseInstanceId(task.getCaseInstanceId());
        this.entry.setCaseExecutionId(task.getCaseExecutionId());
        this.entry.setTaskId(task.getId());
        return this;
    }

    public UserOperationLogContextEntryBuilder propertyChanges(List<PropertyChange> propertyChanges) {
        this.entry.setPropertyChanges(propertyChanges);
        return this;
    }

    public UserOperationLogContextEntryBuilder propertyChanges(PropertyChange propertyChange) {
        ArrayList<PropertyChange> propertyChanges = new ArrayList<PropertyChange>();
        propertyChanges.add(propertyChange);
        this.entry.setPropertyChanges(propertyChanges);
        return this;
    }

    public UserOperationLogContextEntry create() {
        return this.entry;
    }

    public UserOperationLogContextEntryBuilder jobId(String jobId) {
        this.entry.setJobId(jobId);
        return this;
    }

    public UserOperationLogContextEntryBuilder jobDefinitionId(String jobDefinitionId) {
        this.entry.setJobDefinitionId(jobDefinitionId);
        return this;
    }

    public UserOperationLogContextEntryBuilder processDefinitionId(String processDefinitionId) {
        this.entry.setProcessDefinitionId(processDefinitionId);
        return this;
    }

    public UserOperationLogContextEntryBuilder processDefinitionKey(String processDefinitionKey) {
        this.entry.setProcessDefinitionKey(processDefinitionKey);
        return this;
    }

    public UserOperationLogContextEntryBuilder processInstanceId(String processInstanceId) {
        this.entry.setProcessInstanceId(processInstanceId);
        return this;
    }

    public UserOperationLogContextEntryBuilder deploymentId(String deploymentId) {
        this.entry.setDeploymentId(deploymentId);
        return this;
    }

    public UserOperationLogContextEntryBuilder batchId(String batchId) {
        this.entry.setBatchId(batchId);
        return this;
    }
}

