/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.entity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.camunda.bpm.engine.ProcessEngineServices;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.bpmn.behavior.NoneStartEventActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.parser.EventSubscriptionDeclaration;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cfg.multitenancy.TenantIdProvider;
import org.camunda.bpm.engine.impl.cfg.multitenancy.TenantIdProviderProcessInstanceContext;
import org.camunda.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionEntity;
import org.camunda.bpm.engine.impl.cmmn.entity.runtime.CaseExecutionEntity;
import org.camunda.bpm.engine.impl.cmmn.execution.CmmnExecution;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnCaseDefinition;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.core.instance.CoreExecution;
import org.camunda.bpm.engine.impl.core.operation.CoreAtomicOperation;
import org.camunda.bpm.engine.impl.core.variable.CoreVariableInstance;
import org.camunda.bpm.engine.impl.core.variable.scope.AbstractVariableScope;
import org.camunda.bpm.engine.impl.core.variable.scope.VariableCollectionProvider;
import org.camunda.bpm.engine.impl.core.variable.scope.VariableInstanceFactory;
import org.camunda.bpm.engine.impl.core.variable.scope.VariableInstanceLifecycleListener;
import org.camunda.bpm.engine.impl.core.variable.scope.VariableListenerInvocationListener;
import org.camunda.bpm.engine.impl.core.variable.scope.VariableStore;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.db.EnginePersistenceLogger;
import org.camunda.bpm.engine.impl.db.HasDbReferences;
import org.camunda.bpm.engine.impl.db.HasDbRevision;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.impl.history.event.HistoryEvent;
import org.camunda.bpm.engine.impl.history.event.HistoryEventProcessor;
import org.camunda.bpm.engine.impl.history.event.HistoryEventTypes;
import org.camunda.bpm.engine.impl.history.producer.HistoryEventProducer;
import org.camunda.bpm.engine.impl.interceptor.AtomicOperationInvocation;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.jobexecutor.JobDeclaration;
import org.camunda.bpm.engine.impl.jobexecutor.MessageJobDeclaration;
import org.camunda.bpm.engine.impl.jobexecutor.TimerDeclarationImpl;
import org.camunda.bpm.engine.impl.persistence.entity.CompensateEventSubscriptionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntityReferencer;
import org.camunda.bpm.engine.impl.persistence.entity.ExternalTaskEntity;
import org.camunda.bpm.engine.impl.persistence.entity.IncidentEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.persistence.entity.MessageEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.SuspensionState;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;
import org.camunda.bpm.engine.impl.persistence.entity.VariableInstanceConcurrentLocalInitializer;
import org.camunda.bpm.engine.impl.persistence.entity.VariableInstanceEntity;
import org.camunda.bpm.engine.impl.persistence.entity.VariableInstanceEntityFactory;
import org.camunda.bpm.engine.impl.persistence.entity.VariableInstanceEntityPersistenceListener;
import org.camunda.bpm.engine.impl.persistence.entity.VariableInstanceHistoryListener;
import org.camunda.bpm.engine.impl.persistence.entity.VariableInstanceSequenceCounterListener;
import org.camunda.bpm.engine.impl.persistence.entity.util.FormPropertyStartContext;
import org.camunda.bpm.engine.impl.pvm.PvmActivity;
import org.camunda.bpm.engine.impl.pvm.PvmProcessDefinition;
import org.camunda.bpm.engine.impl.pvm.delegate.CompositeActivityBehavior;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ProcessDefinitionImpl;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.AtomicOperation;
import org.camunda.bpm.engine.impl.pvm.runtime.ExecutionStartContext;
import org.camunda.bpm.engine.impl.pvm.runtime.ProcessInstanceStartContext;
import org.camunda.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.operation.FoxAtomicOperationDeleteCascadeFireActivityEnd;
import org.camunda.bpm.engine.impl.pvm.runtime.operation.PvmAtomicOperation;
import org.camunda.bpm.engine.impl.util.BitMaskUtil;
import org.camunda.bpm.engine.impl.util.CollectionUtil;
import org.camunda.bpm.engine.impl.variable.VariableDeclaration;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.instance.FlowElement;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;
import org.camunda.bpm.model.xml.type.ModelElementType;

public class ExecutionEntity
extends PvmExecutionImpl
implements Execution,
ProcessInstance,
DbEntity,
HasDbRevision,
HasDbReferences,
VariableStore.VariablesProvider<VariableInstanceEntity> {
    private static final long serialVersionUID = 1L;
    protected static final EnginePersistenceLogger LOG = ProcessEngineLogger.PERSISTENCE_LOGGER;
    public static final int EVENT_SUBSCRIPTIONS_STATE_BIT = 1;
    public static final int TASKS_STATE_BIT = 2;
    public static final int JOBS_STATE_BIT = 3;
    public static final int INCIDENT_STATE_BIT = 4;
    public static final int VARIABLES_STATE_BIT = 5;
    public static final int SUB_PROCESS_INSTANCE_STATE_BIT = 6;
    public static final int SUB_CASE_INSTANCE_STATE_BIT = 7;
    public static final int EXTERNAL_TASKS_BIT = 8;
    protected transient ExecutionEntity processInstance;
    protected transient ExecutionEntity parent;
    protected transient List<ExecutionEntity> executions;
    protected transient ExecutionEntity superExecution;
    protected transient CaseExecutionEntity superCaseExecution;
    protected transient ExecutionEntity subProcessInstance;
    protected transient CaseExecutionEntity subCaseInstance;
    protected boolean shouldQueryForSubprocessInstance = false;
    protected boolean shouldQueryForSubCaseInstance = false;
    protected transient List<EventSubscriptionEntity> eventSubscriptions;
    protected transient List<JobEntity> jobs;
    protected transient List<TaskEntity> tasks;
    protected transient List<ExternalTaskEntity> externalTasks;
    protected transient List<IncidentEntity> incidents;
    protected int cachedEntityState;
    protected transient VariableStore<VariableInstanceEntity> variableStore = new VariableStore<VariableInstanceEntity>(this, Arrays.asList(new ExecutionEntityReferencer(this)));
    protected int suspensionState = SuspensionState.ACTIVE.getStateCode();
    protected int revision = 1;
    protected String processDefinitionId;
    protected String activityId;
    protected String activityName;
    protected String processInstanceId;
    protected String parentId;
    protected String superExecutionId;
    protected String superCaseExecutionId;

    @Override
    public ExecutionEntity createExecution() {
        return this.createExecution(false);
    }

    @Override
    public ExecutionEntity createExecution(boolean initializeExecutionStartContext) {
        ExecutionEntity createdExecution = ExecutionEntity.createNewExecution();
        createdExecution.setSequenceCounter(this.getSequenceCounter());
        createdExecution.setParent(this);
        createdExecution.setProcessDefinition(this.getProcessDefinition());
        createdExecution.setProcessInstance(this.getProcessInstance());
        createdExecution.setActivity(this.getActivity());
        createdExecution.setSuspensionState(this.getSuspensionState());
        createdExecution.activityInstanceId = this.activityInstanceId;
        if (this.tenantId != null) {
            createdExecution.setTenantId(this.tenantId);
        }
        if (initializeExecutionStartContext) {
            createdExecution.setStartContext(new ExecutionStartContext());
        } else if (this.startContext != null) {
            createdExecution.setStartContext(this.startContext);
        }
        createdExecution.skipCustomListeners = this.skipCustomListeners;
        createdExecution.skipIoMapping = this.skipIoMapping;
        LOG.createChildExecution(createdExecution, this);
        return createdExecution;
    }

    @Override
    public ExecutionEntity createSubProcessInstance(PvmProcessDefinition processDefinition, String businessKey, String caseInstanceId) {
        this.shouldQueryForSubprocessInstance = true;
        ExecutionEntity subProcessInstance = (ExecutionEntity)super.createSubProcessInstance(processDefinition, businessKey, caseInstanceId);
        String tenantId = ((ProcessDefinitionEntity)processDefinition).getTenantId();
        if (tenantId != null) {
            subProcessInstance.setTenantId(tenantId);
        } else {
            subProcessInstance.setTenantId(this.tenantId);
        }
        this.fireHistoricActivityInstanceUpdate();
        return subProcessInstance;
    }

    protected static ExecutionEntity createNewExecution() {
        ExecutionEntity newExecution = new ExecutionEntity();
        ExecutionEntity.initializeAssociations(newExecution);
        newExecution.insert();
        return newExecution;
    }

    @Override
    protected PvmExecutionImpl newExecution() {
        return ExecutionEntity.createNewExecution();
    }

    @Override
    public CaseExecutionEntity createSubCaseInstance(CmmnCaseDefinition caseDefinition) {
        return this.createSubCaseInstance(caseDefinition, null);
    }

    @Override
    public CaseExecutionEntity createSubCaseInstance(CmmnCaseDefinition caseDefinition, String businessKey) {
        CaseExecutionEntity subCaseInstance = (CaseExecutionEntity)caseDefinition.createCaseInstance(businessKey);
        String tenantId = ((CaseDefinitionEntity)caseDefinition).getTenantId();
        if (tenantId != null) {
            subCaseInstance.setTenantId(tenantId);
        } else {
            subCaseInstance.setTenantId(this.tenantId);
        }
        subCaseInstance.setSuperExecution(this);
        this.setSubCaseInstance(subCaseInstance);
        this.fireHistoricActivityInstanceUpdate();
        return subCaseInstance;
    }

    public void fireHistoricActivityInstanceUpdate() {
        ProcessEngineConfigurationImpl configuration = Context.getProcessEngineConfiguration();
        HistoryLevel historyLevel = configuration.getHistoryLevel();
        if (historyLevel.isHistoryEventProduced(HistoryEventTypes.ACTIVITY_INSTANCE_UPDATE, this)) {
            HistoryEventProcessor.processHistoryEvents(new HistoryEventProcessor.HistoryEventCreator(){

                @Override
                public HistoryEvent createHistoryEvent(HistoryEventProducer producer) {
                    return producer.createActivityInstanceUpdateEvt(ExecutionEntity.this);
                }
            });
        }
    }

    @Override
    public void initialize() {
        String initiatorVariableName;
        LOG.initializeExecution(this);
        ScopeImpl scope = this.getScopeActivity();
        this.ensureParentInitialized();
        List variableDeclarations = (List)scope.getProperty("variableDeclarations");
        if (variableDeclarations != null) {
            for (VariableDeclaration variableDeclaration : variableDeclarations) {
                variableDeclaration.initialize(this, this.parent);
            }
        }
        if (this.isProcessInstanceExecution() && (initiatorVariableName = (String)this.processDefinition.getProperty("initiatorVariableName")) != null) {
            String authenticatedUserId = Context.getCommandContext().getAuthenticatedUserId();
            this.setVariable(initiatorVariableName, authenticatedUserId);
        }
        for (EventSubscriptionDeclaration declaration : EventSubscriptionDeclaration.getDeclarationsForScope(scope).values()) {
            declaration.createSubscription(this);
        }
    }

    @Override
    public void initializeTimerDeclarations() {
        LOG.initializeTimerDeclaration(this);
        ScopeImpl scope = this.getScopeActivity();
        Collection<TimerDeclarationImpl> timerDeclarations = TimerDeclarationImpl.getDeclarationsForScope(scope).values();
        for (TimerDeclarationImpl timerDeclaration : timerDeclarations) {
            timerDeclaration.createTimerInstance(this);
        }
    }

    protected static void initializeAssociations(ExecutionEntity execution) {
        execution.executions = new ArrayList<ExecutionEntity>();
        execution.variableStore.setVariablesProvider(VariableCollectionProvider.emptyVariables());
        execution.variableStore.forceInitialization();
        execution.eventSubscriptions = new ArrayList<EventSubscriptionEntity>();
        execution.jobs = new ArrayList<JobEntity>();
        execution.tasks = new ArrayList<TaskEntity>();
        execution.externalTasks = new ArrayList<ExternalTaskEntity>();
        execution.incidents = new ArrayList<IncidentEntity>();
        execution.cachedEntityState = 0;
    }

    @Override
    public void start(Map<String, Object> variables) {
        if (this.tenantId == null) {
            this.provideTenantId(variables);
        }
        super.start(variables);
    }

    protected void provideTenantId(Map<String, Object> variables) {
        TenantIdProvider tenantIdProvider = Context.getProcessEngineConfiguration().getTenantIdProvider();
        if (tenantIdProvider != null) {
            VariableMap variableMap = Variables.fromMap(variables);
            ProcessDefinitionEntity processDefinition = this.getProcessDefinition();
            TenantIdProviderProcessInstanceContext ctx = null;
            ctx = this.superExecutionId != null ? new TenantIdProviderProcessInstanceContext((ProcessDefinition)processDefinition, variableMap, this.getSuperExecution()) : (this.superCaseExecutionId != null ? new TenantIdProviderProcessInstanceContext((ProcessDefinition)processDefinition, variableMap, this.getSuperCaseExecution()) : new TenantIdProviderProcessInstanceContext(processDefinition, variableMap));
            this.tenantId = tenantIdProvider.provideTenantIdForProcessInstance(ctx);
        }
    }

    public void startWithFormProperties(VariableMap properties) {
        if (this.isProcessInstanceExecution()) {
            ActivityImpl initial = this.processDefinition.getInitial();
            ProcessInstanceStartContext processInstanceStartContext = this.getProcessInstanceStartContext();
            if (processInstanceStartContext != null) {
                initial = processInstanceStartContext.getInitial();
            }
            FormPropertyStartContext formPropertyStartContext = new FormPropertyStartContext(initial);
            formPropertyStartContext.setFormProperties(properties);
            this.startContext = formPropertyStartContext;
            this.initialize();
            this.initializeTimerDeclarations();
            this.fireHistoricProcessStartEvent();
        }
        this.performOperation(PvmAtomicOperation.PROCESS_START);
    }

    @Override
    public void fireHistoricProcessStartEvent() {
        ProcessEngineConfigurationImpl configuration = Context.getProcessEngineConfiguration();
        HistoryLevel historyLevel = configuration.getHistoryLevel();
        if (historyLevel.isHistoryEventProduced(HistoryEventTypes.PROCESS_INSTANCE_START, this.processInstance)) {
            HistoryEventProcessor.processHistoryEvents(new HistoryEventProcessor.HistoryEventCreator(){

                @Override
                public HistoryEvent createHistoryEvent(HistoryEventProducer producer) {
                    return producer.createProcessInstanceStartEvt(ExecutionEntity.this.processInstance);
                }
            });
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        this.ensureParentInitialized();
        this.ensureActivityInitialized();
        if (this.activity != null && this.activity.getIoMapping() != null && !this.skipIoMapping) {
            this.activity.getIoMapping().executeOutputParameters(this);
        }
        this.clearExecution();
        this.removeEventSubscriptionsExceptCompensation();
    }

    protected void clearExecution() {
        for (VariableInstanceEntity variableInstance : this.variableStore.getVariables()) {
            this.invokeVariableLifecycleListenersDelete(variableInstance, this, Collections.singletonList(this.getVariablePersistenceListener()));
            this.variableStore.removeVariable(variableInstance.getName());
        }
        this.removeTasks(null);
        this.removeExternalTasks();
        this.removeJobs();
        this.removeIncidents();
    }

    @Override
    public void interrupt(String reason, boolean skipCustomListeners, boolean skipIoMappings) {
        if (this.preserveScope) {
            this.removeActivityJobs(reason);
        } else {
            this.removeJobs();
            this.removeEventSubscriptionsExceptCompensation();
        }
        this.removeTasks(reason);
        super.interrupt(reason, skipCustomListeners, skipIoMappings);
    }

    protected void removeActivityJobs(String reason) {
        if (this.activityId != null) {
            for (JobEntity job : this.getJobs()) {
                if (!this.activityId.equals(job.getActivityId())) continue;
                job.delete();
                this.removeJob(job);
            }
        }
    }

    @Override
    public <T extends CoreExecution> void performOperation(CoreAtomicOperation<T> operation) {
        if (operation instanceof AtomicOperation) {
            this.performOperation((AtomicOperation)operation);
        } else {
            super.performOperation(operation);
        }
    }

    @Override
    public <T extends CoreExecution> void performOperationSync(CoreAtomicOperation<T> operation) {
        if (operation instanceof AtomicOperation) {
            this.performOperationSync((AtomicOperation)operation);
        } else {
            super.performOperationSync(operation);
        }
    }

    public void performOperation(AtomicOperation executionOperation) {
        boolean async = executionOperation.isAsync(this);
        if (!async && this.requiresUnsuspendedExecution(executionOperation)) {
            this.ensureNotSuspended();
        }
        Context.getCommandInvocationContext().performOperation(executionOperation, this, async);
    }

    public void performOperationSync(AtomicOperation executionOperation) {
        if (this.requiresUnsuspendedExecution(executionOperation)) {
            this.ensureNotSuspended();
        }
        Context.getCommandInvocationContext().performOperation(executionOperation, this);
    }

    protected void ensureNotSuspended() {
        if (this.isSuspended()) {
            throw LOG.suspendedEntityException("Execution", this.id);
        }
    }

    protected boolean requiresUnsuspendedExecution(AtomicOperation executionOperation) {
        return executionOperation != PvmAtomicOperation.TRANSITION_NOTIFY_LISTENER_END && executionOperation != PvmAtomicOperation.TRANSITION_DESTROY_SCOPE && executionOperation != PvmAtomicOperation.TRANSITION_NOTIFY_LISTENER_TAKE && executionOperation != PvmAtomicOperation.TRANSITION_NOTIFY_LISTENER_END && executionOperation != PvmAtomicOperation.TRANSITION_CREATE_SCOPE && executionOperation != PvmAtomicOperation.TRANSITION_NOTIFY_LISTENER_START && executionOperation != PvmAtomicOperation.DELETE_CASCADE && executionOperation != PvmAtomicOperation.DELETE_CASCADE_FIRE_ACTIVITY_END;
    }

    public void scheduleAtomicOperationAsync(AtomicOperationInvocation executionOperationInvocation) {
        JobDeclaration messageJobDeclaration = null;
        List messageJobDeclarations = (List)this.getActivity().getProperty("messageJobDeclaration");
        if (messageJobDeclarations != null) {
            for (MessageJobDeclaration declaration : messageJobDeclarations) {
                if (!declaration.isApplicableForOperation(executionOperationInvocation.getOperation())) continue;
                messageJobDeclaration = declaration;
                break;
            }
        }
        if (messageJobDeclaration == null) {
            throw LOG.requiredAsyncContinuationException(this.getActivity().getId());
        }
        MessageEntity message = (MessageEntity)messageJobDeclaration.createJobInstance(executionOperationInvocation);
        Context.getCommandContext().getJobManager().send(message);
    }

    @Override
    public boolean isActive(String activityId) {
        return this.findExecution(activityId) != null;
    }

    @Override
    public void inactivate() {
        this.isActive = false;
    }

    public List<ExecutionEntity> getExecutions() {
        this.ensureExecutionsInitialized();
        return this.executions;
    }

    public List<ExecutionEntity> getExecutionsAsCopy() {
        return new ArrayList<ExecutionEntity>(this.getExecutions());
    }

    protected void ensureExecutionsInitialized() {
        if (this.executions == null) {
            if (this.isExecutionTreePrefetchEnabled()) {
                this.ensureExecutionTreeInitialized();
            } else {
                this.executions = Context.getCommandContext().getExecutionManager().findChildExecutionsByParentExecutionId(this.id);
            }
        }
    }

    protected boolean isExecutionTreePrefetchEnabled() {
        return Context.getProcessEngineConfiguration().isExecutionTreePrefetchEnabled();
    }

    public void setExecutions(List<ExecutionEntity> executions) {
        this.executions = executions;
    }

    @Override
    public String getProcessBusinessKey() {
        return this.getProcessInstance().getBusinessKey();
    }

    @Override
    public ProcessDefinitionEntity getProcessDefinition() {
        this.ensureProcessDefinitionInitialized();
        return (ProcessDefinitionEntity)this.processDefinition;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    @Override
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    protected void ensureProcessDefinitionInitialized() {
        if (this.processDefinition == null && this.processDefinitionId != null) {
            ProcessDefinitionEntity deployedProcessDefinition = Context.getProcessEngineConfiguration().getDeploymentCache().findDeployedProcessDefinitionById(this.processDefinitionId);
            this.setProcessDefinition(deployedProcessDefinition);
        }
    }

    @Override
    public void setProcessDefinition(ProcessDefinitionImpl processDefinition) {
        this.processDefinition = processDefinition;
        this.processDefinitionId = processDefinition.getId();
    }

    @Override
    public ExecutionEntity getProcessInstance() {
        this.ensureProcessInstanceInitialized();
        return this.processInstance;
    }

    protected void ensureProcessInstanceInitialized() {
        if (this.processInstance == null && this.processInstanceId != null) {
            if (this.isExecutionTreePrefetchEnabled()) {
                this.ensureExecutionTreeInitialized();
            } else {
                this.processInstance = Context.getCommandContext().getExecutionManager().findExecutionById(this.processInstanceId);
            }
        }
    }

    @Override
    public void setProcessInstance(PvmExecutionImpl processInstance) {
        this.processInstance = (ExecutionEntity)processInstance;
        if (processInstance != null) {
            this.processInstanceId = this.processInstance.getId();
        }
    }

    @Override
    public boolean isProcessInstanceExecution() {
        return this.parentId == null;
    }

    @Override
    public ActivityImpl getActivity() {
        this.ensureActivityInitialized();
        return super.getActivity();
    }

    @Override
    public String getActivityId() {
        return this.activityId;
    }

    protected void ensureActivityInitialized() {
        if (this.activity == null && this.activityId != null) {
            this.setActivity(this.getProcessDefinition().findActivity(this.activityId));
        }
    }

    @Override
    public void setActivity(PvmActivity activity) {
        super.setActivity(activity);
        if (activity != null) {
            this.activityId = activity.getId();
            this.activityName = (String)activity.getProperty("name");
        } else {
            this.activityId = null;
            this.activityName = null;
        }
    }

    @Override
    protected String generateActivityInstanceId(String activityId) {
        if (activityId.equals(this.processDefinitionId)) {
            return this.processInstanceId;
        }
        String nextId = Context.getProcessEngineConfiguration().getIdGenerator().getNextId();
        String compositeId = activityId + ":" + nextId;
        if (compositeId.length() > 64) {
            return String.valueOf(nextId);
        }
        return compositeId;
    }

    @Override
    public ExecutionEntity getParent() {
        this.ensureParentInitialized();
        return this.parent;
    }

    protected void ensureParentInitialized() {
        if (this.parent == null && this.parentId != null) {
            if (this.isExecutionTreePrefetchEnabled()) {
                this.ensureExecutionTreeInitialized();
            } else {
                this.parent = Context.getCommandContext().getExecutionManager().findExecutionById(this.parentId);
            }
        }
    }

    @Override
    public void setParentExecution(PvmExecutionImpl parent) {
        this.parent = (ExecutionEntity)parent;
        this.parentId = parent != null ? parent.getId() : null;
    }

    public String getSuperExecutionId() {
        return this.superExecutionId;
    }

    @Override
    public ExecutionEntity getSuperExecution() {
        this.ensureSuperExecutionInitialized();
        return this.superExecution;
    }

    @Override
    public void setSuperExecution(PvmExecutionImpl superExecution) {
        if (this.superExecutionId != null) {
            this.ensureSuperExecutionInitialized();
            this.superExecution.setSubProcessInstance(null);
        }
        this.superExecution = (ExecutionEntity)superExecution;
        if (superExecution != null) {
            this.superExecutionId = superExecution.getId();
            this.superExecution.setSubProcessInstance(this);
        } else {
            this.superExecutionId = null;
        }
    }

    protected void ensureSuperExecutionInitialized() {
        if (this.superExecution == null && this.superExecutionId != null) {
            this.superExecution = Context.getCommandContext().getExecutionManager().findExecutionById(this.superExecutionId);
        }
    }

    @Override
    public ExecutionEntity getSubProcessInstance() {
        this.ensureSubProcessInstanceInitialized();
        return this.subProcessInstance;
    }

    @Override
    public void setSubProcessInstance(PvmExecutionImpl subProcessInstance) {
        this.shouldQueryForSubprocessInstance = subProcessInstance != null;
        this.subProcessInstance = (ExecutionEntity)subProcessInstance;
    }

    protected void ensureSubProcessInstanceInitialized() {
        if (this.shouldQueryForSubprocessInstance && this.subProcessInstance == null) {
            this.subProcessInstance = Context.getCommandContext().getExecutionManager().findSubProcessInstanceBySuperExecutionId(this.id);
        }
    }

    public String getSuperCaseExecutionId() {
        return this.superCaseExecutionId;
    }

    public void setSuperCaseExecutionId(String superCaseExecutionId) {
        this.superCaseExecutionId = superCaseExecutionId;
    }

    @Override
    public CaseExecutionEntity getSuperCaseExecution() {
        this.ensureSuperCaseExecutionInitialized();
        return this.superCaseExecution;
    }

    @Override
    public void setSuperCaseExecution(CmmnExecution superCaseExecution) {
        this.superCaseExecution = (CaseExecutionEntity)superCaseExecution;
        if (superCaseExecution != null) {
            this.superCaseExecutionId = superCaseExecution.getId();
            this.caseInstanceId = superCaseExecution.getCaseInstanceId();
        } else {
            this.superCaseExecutionId = null;
            this.caseInstanceId = null;
        }
    }

    protected void ensureSuperCaseExecutionInitialized() {
        if (this.superCaseExecution == null && this.superCaseExecutionId != null) {
            this.superCaseExecution = Context.getCommandContext().getCaseExecutionManager().findCaseExecutionById(this.superCaseExecutionId);
        }
    }

    @Override
    public CaseExecutionEntity getSubCaseInstance() {
        this.ensureSubCaseInstanceInitialized();
        return this.subCaseInstance;
    }

    @Override
    public void setSubCaseInstance(CmmnExecution subCaseInstance) {
        this.shouldQueryForSubCaseInstance = subCaseInstance != null;
        this.subCaseInstance = (CaseExecutionEntity)subCaseInstance;
    }

    protected void ensureSubCaseInstanceInitialized() {
        if (this.shouldQueryForSubCaseInstance && this.subCaseInstance == null) {
            this.subCaseInstance = Context.getCommandContext().getCaseExecutionManager().findSubCaseInstanceBySuperExecutionId(this.id);
        }
    }

    @Override
    public void remove() {
        super.remove();
        this.clearExecution();
        this.removeEventSubscriptions();
        Context.getCommandContext().getExecutionManager().deleteExecution(this);
    }

    protected void removeEventSubscriptionsExceptCompensation() {
        List<EventSubscriptionEntity> eventSubscriptions = this.getEventSubscriptions();
        for (EventSubscriptionEntity eventSubscriptionEntity : eventSubscriptions) {
            if ("compensate".equals(eventSubscriptionEntity.getEventType())) continue;
            eventSubscriptionEntity.delete();
        }
    }

    public void removeEventSubscriptions() {
        for (EventSubscriptionEntity eventSubscription : this.getEventSubscriptions()) {
            if (this.getReplacedBy() != null) {
                eventSubscription.setExecution(this.getReplacedBy());
                continue;
            }
            eventSubscription.delete();
        }
    }

    private void removeJobs() {
        for (JobEntity job : this.getJobs()) {
            if (this.isReplacedByParent()) {
                job.setExecution(this.getReplacedBy());
                continue;
            }
            job.delete();
        }
    }

    private void removeIncidents() {
        for (IncidentEntity incident : this.getIncidents()) {
            if (this.isReplacedByParent()) {
                incident.setExecution(this.getReplacedBy());
                continue;
            }
            incident.delete();
        }
    }

    protected void removeTasks(String reason) {
        if (reason == null) {
            reason = "deleted";
        }
        for (TaskEntity task : this.getTasks()) {
            if (this.isReplacedByParent()) {
                if (task.getExecution() != null && task.getExecution() == this.replacedBy) continue;
                task.setExecution(this.replacedBy);
                this.getReplacedBy().addTask(task);
                continue;
            }
            task.delete(reason, false, this.skipCustomListeners);
        }
    }

    protected void removeExternalTasks() {
        for (ExternalTaskEntity externalTask : this.getExternalTasks()) {
            externalTask.delete();
        }
    }

    @Override
    public ExecutionEntity getReplacedBy() {
        return (ExecutionEntity)this.replacedBy;
    }

    @Override
    public ExecutionEntity resolveReplacedBy() {
        return (ExecutionEntity)super.resolveReplacedBy();
    }

    @Override
    public void replace(PvmExecutionImpl execution) {
        ExecutionEntity replacedExecution = (ExecutionEntity)execution;
        replacedExecution.moveTasksTo(this);
        replacedExecution.moveExternalTasksTo(this);
        replacedExecution.moveActivityLocalJobsTo(this);
        if (!replacedExecution.isEnded()) {
            if (replacedExecution.getParent() == this) {
                replacedExecution.moveVariablesTo(this);
            } else {
                replacedExecution.moveConcurrentLocalVariablesTo(this);
            }
        }
        super.replace(replacedExecution);
    }

    @Override
    public void onConcurrentExpand(PvmExecutionImpl scopeExecution) {
        ExecutionEntity scopeExecutionEntity = (ExecutionEntity)scopeExecution;
        scopeExecutionEntity.moveConcurrentLocalVariablesTo(this);
        super.onConcurrentExpand(scopeExecutionEntity);
    }

    protected void moveTasksTo(ExecutionEntity other) {
        CommandContext commandContext = Context.getCommandContext();
        for (TaskEntity task : this.getTasksInternal()) {
            task.setExecution(other);
            List<VariableInstanceEntity> variables = commandContext.getVariableInstanceManager().findVariableInstancesByTaskId(task.getId());
            for (VariableInstanceEntity variable : variables) {
                variable.setExecution(other);
            }
            other.addTask(task);
        }
        this.getTasksInternal().clear();
    }

    protected void moveExternalTasksTo(ExecutionEntity other) {
        for (ExternalTaskEntity externalTask : this.getExternalTasksInternal()) {
            externalTask.setExecutionId(other.getId());
            externalTask.setExecution(other);
            other.addExternalTask(externalTask);
        }
        this.getExternalTasksInternal().clear();
    }

    protected void moveActivityLocalJobsTo(ExecutionEntity other) {
        if (this.activityId != null) {
            for (JobEntity job : this.getJobs()) {
                if (!this.activityId.equals(job.getActivityId())) continue;
                this.removeJob(job);
                job.setExecution(other);
            }
        }
    }

    protected void moveVariablesTo(ExecutionEntity other) {
        List<VariableInstanceEntity> variables = this.variableStore.getVariables();
        this.variableStore.removeVariables();
        for (VariableInstanceEntity variable : variables) {
            this.moveVariableTo(variable, other);
        }
    }

    protected void moveVariableTo(VariableInstanceEntity variable, ExecutionEntity other) {
        if (other.variableStore.containsKey(variable.getName())) {
            VariableInstanceEntity existingInstance = other.variableStore.getVariable(variable.getName());
            existingInstance.setValue(variable.getTypedValue(false));
            this.invokeVariableLifecycleListenersUpdate(existingInstance, this);
            this.invokeVariableLifecycleListenersDelete(variable, this, Collections.singletonList(this.getVariablePersistenceListener()));
        } else {
            other.variableStore.addVariable(variable);
        }
    }

    protected void moveConcurrentLocalVariablesTo(ExecutionEntity other) {
        List<VariableInstanceEntity> variables = this.variableStore.getVariables();
        for (VariableInstanceEntity variable : variables) {
            if (!variable.isConcurrentLocal()) continue;
            this.moveVariableTo(variable, other);
        }
    }

    public boolean isExecutingScopeLeafActivity() {
        return this.isActive && this.getActivity() != null && this.getActivity().isScope() && this.activityInstanceId != null && !(this.getActivity().getActivityBehavior() instanceof CompositeActivityBehavior);
    }

    @Override
    public Collection<VariableInstanceEntity> provideVariables() {
        return Context.getCommandContext().getVariableInstanceManager().findVariableInstancesByExecutionId(this.id);
    }

    protected boolean isAutoFireHistoryEvents() {
        ActivityImpl currentActivity = this.getActivity();
        return !(this.startContext != null && this.startContext.isDelayFireHistoricVariableEvents() || currentActivity != null && this.isAsyncStartEvent(currentActivity));
    }

    protected boolean isAsyncStartEvent(ActivityImpl activity) {
        return activity.isAsyncBefore() && activity.getActivityBehavior() instanceof NoneStartEventActivityBehavior;
    }

    public void fireHistoricVariableInstanceCreateEvents() {
        List<VariableInstanceEntity> variableInstances = this.variableStore.getVariables();
        VariableInstanceHistoryListener historyListener = new VariableInstanceHistoryListener();
        if (variableInstances != null) {
            for (VariableInstanceEntity variable : variableInstances) {
                historyListener.onCreate(variable, (AbstractVariableScope)this);
            }
        }
    }

    protected void ensureExecutionTreeInitialized() {
        ExecutionEntity processInstance;
        List<ExecutionEntity> executions = Context.getCommandContext().getExecutionManager().findExecutionsByProcessInstanceId(this.processInstanceId);
        ExecutionEntity executionEntity = processInstance = this.isProcessInstanceExecution() ? this : null;
        if (processInstance == null) {
            for (ExecutionEntity execution : executions) {
                if (!execution.isProcessInstanceExecution()) continue;
                processInstance = execution;
            }
        }
        processInstance.restoreProcessInstance(executions, null, null, null, null, null, null);
    }

    public void restoreProcessInstance(Collection<ExecutionEntity> executions, Collection<EventSubscriptionEntity> eventSubscriptions, Collection<VariableInstanceEntity> variables, Collection<TaskEntity> tasks, Collection<JobEntity> jobs, Collection<IncidentEntity> incidents, Collection<ExternalTaskEntity> externalTasks) {
        ExecutionEntity execution;
        if (!this.isProcessInstanceExecution()) {
            throw LOG.restoreProcessInstanceException(this);
        }
        HashMap<String, ExecutionEntity> executionsMap = new HashMap<String, ExecutionEntity>();
        for (ExecutionEntity execution2 : executions) {
            executionsMap.put(execution2.getId(), execution2);
        }
        HashMap variablesByScope = new HashMap();
        if (variables != null) {
            for (VariableInstanceEntity variable : variables) {
                CollectionUtil.addToMapOfLists(variablesByScope, variable.getVariableScopeId(), variable);
            }
        }
        for (ExecutionEntity execution3 : executions) {
            if (execution3.executions == null) {
                execution3.executions = new ArrayList<ExecutionEntity>();
            }
            if (execution3.eventSubscriptions == null && eventSubscriptions != null) {
                execution3.eventSubscriptions = new ArrayList<EventSubscriptionEntity>();
            }
            if (variables != null) {
                execution3.variableStore.setVariablesProvider(new VariableCollectionProvider((Collection)variablesByScope.get(execution3.id)));
            }
            String parentId = execution3.getParentId();
            ExecutionEntity parent = (ExecutionEntity)executionsMap.get(parentId);
            if (!execution3.isProcessInstanceExecution()) {
                execution3.processInstance = this;
                execution3.parent = parent;
                if (parent.executions == null) {
                    parent.executions = new ArrayList<ExecutionEntity>();
                }
                parent.executions.add(execution3);
                continue;
            }
            execution3.processInstance = execution3;
        }
        if (eventSubscriptions != null) {
            for (EventSubscriptionEntity eventSubscription : eventSubscriptions) {
                ExecutionEntity executionEntity = (ExecutionEntity)executionsMap.get(eventSubscription.getExecutionId());
                if (executionEntity != null) {
                    executionEntity.addEventSubscription(eventSubscription);
                    continue;
                }
                throw LOG.executionNotFoundException(eventSubscription.getExecutionId());
            }
        }
        if (jobs != null) {
            for (JobEntity job : jobs) {
                execution = (ExecutionEntity)executionsMap.get(job.getExecutionId());
                job.setExecution(execution);
            }
        }
        if (tasks != null) {
            for (TaskEntity task : tasks) {
                execution = (ExecutionEntity)executionsMap.get(task.getExecutionId());
                task.setExecution(execution);
                execution.addTask(task);
                if (variables == null) continue;
                task.variableStore.setVariablesProvider(new VariableCollectionProvider((Collection)variablesByScope.get(task.id)));
            }
        }
        if (incidents != null) {
            for (IncidentEntity incident : incidents) {
                execution = (ExecutionEntity)executionsMap.get(incident.getExecutionId());
                incident.setExecution(execution);
            }
        }
        if (externalTasks != null) {
            for (ExternalTaskEntity externalTask : externalTasks) {
                execution = (ExecutionEntity)executionsMap.get(externalTask.getExecutionId());
                externalTask.setExecution(execution);
                execution.addExternalTask(externalTask);
            }
        }
    }

    @Override
    public Object getPersistentState() {
        HashMap<String, Object> persistentState = new HashMap<String, Object>();
        persistentState.put("processDefinitionId", this.processDefinitionId);
        persistentState.put("businessKey", this.businessKey);
        persistentState.put("activityId", this.activityId);
        persistentState.put("activityInstanceId", this.activityInstanceId);
        persistentState.put("isActive", this.isActive);
        persistentState.put("isConcurrent", this.isConcurrent);
        persistentState.put("isScope", this.isScope);
        persistentState.put("isEventScope", this.isEventScope);
        persistentState.put("parentId", this.parentId);
        persistentState.put("superExecution", this.superExecutionId);
        persistentState.put("superCaseExecutionId", this.superCaseExecutionId);
        persistentState.put("caseInstanceId", this.caseInstanceId);
        persistentState.put("suspensionState", this.suspensionState);
        persistentState.put("cachedEntityState", this.getCachedEntityState());
        persistentState.put("sequenceCounter", this.getSequenceCounter());
        return persistentState;
    }

    public void insert() {
        Context.getCommandContext().getExecutionManager().insertExecution(this);
    }

    @Override
    public void deleteCascade2(String deleteReason) {
        this.deleteReason = deleteReason;
        this.deleteRoot = true;
        this.performOperation(new FoxAtomicOperationDeleteCascadeFireActivityEnd());
    }

    @Override
    public int getRevisionNext() {
        return this.revision + 1;
    }

    @Override
    public void forceUpdate() {
        Context.getCommandContext().getDbEntityManager().forceUpdate(this);
    }

    @Override
    public String toString() {
        if (this.isProcessInstanceExecution()) {
            return "ProcessInstance[" + this.getToStringIdentity() + "]";
        }
        return (this.isConcurrent ? "Concurrent" : "") + (this.isScope ? "Scope" : "") + "Execution[" + this.getToStringIdentity() + "]";
    }

    @Override
    protected String getToStringIdentity() {
        return this.id;
    }

    public List<EventSubscriptionEntity> getEventSubscriptionsInternal() {
        this.ensureEventSubscriptionsInitialized();
        return this.eventSubscriptions;
    }

    public List<EventSubscriptionEntity> getEventSubscriptions() {
        return new ArrayList<EventSubscriptionEntity>(this.getEventSubscriptionsInternal());
    }

    public List<CompensateEventSubscriptionEntity> getCompensateEventSubscriptions() {
        List<EventSubscriptionEntity> eventSubscriptions = this.getEventSubscriptionsInternal();
        ArrayList<CompensateEventSubscriptionEntity> result = new ArrayList<CompensateEventSubscriptionEntity>(eventSubscriptions.size());
        for (EventSubscriptionEntity eventSubscriptionEntity : eventSubscriptions) {
            if (!(eventSubscriptionEntity instanceof CompensateEventSubscriptionEntity)) continue;
            result.add((CompensateEventSubscriptionEntity)eventSubscriptionEntity);
        }
        return result;
    }

    public List<CompensateEventSubscriptionEntity> getCompensateEventSubscriptions(String activityId) {
        List<EventSubscriptionEntity> eventSubscriptions = this.getEventSubscriptionsInternal();
        ArrayList<CompensateEventSubscriptionEntity> result = new ArrayList<CompensateEventSubscriptionEntity>(eventSubscriptions.size());
        for (EventSubscriptionEntity eventSubscriptionEntity : eventSubscriptions) {
            if (!(eventSubscriptionEntity instanceof CompensateEventSubscriptionEntity) || !activityId.equals(eventSubscriptionEntity.getActivityId())) continue;
            result.add((CompensateEventSubscriptionEntity)eventSubscriptionEntity);
        }
        return result;
    }

    protected void ensureEventSubscriptionsInitialized() {
        if (this.eventSubscriptions == null) {
            this.eventSubscriptions = Context.getCommandContext().getEventSubscriptionManager().findEventSubscriptionsByExecution(this.id);
        }
    }

    public void addEventSubscription(EventSubscriptionEntity eventSubscriptionEntity) {
        List<EventSubscriptionEntity> eventSubscriptionsInternal = this.getEventSubscriptionsInternal();
        if (!eventSubscriptionsInternal.contains(eventSubscriptionEntity)) {
            eventSubscriptionsInternal.add(eventSubscriptionEntity);
        }
    }

    public void removeEventSubscription(EventSubscriptionEntity eventSubscriptionEntity) {
        this.getEventSubscriptionsInternal().remove(eventSubscriptionEntity);
    }

    protected void ensureJobsInitialized() {
        if (this.jobs == null) {
            this.jobs = Context.getCommandContext().getJobManager().findJobsByExecutionId(this.id);
        }
    }

    protected List<JobEntity> getJobsInternal() {
        this.ensureJobsInitialized();
        return this.jobs;
    }

    public List<JobEntity> getJobs() {
        return new ArrayList<JobEntity>(this.getJobsInternal());
    }

    public void addJob(JobEntity jobEntity) {
        List<JobEntity> jobsInternal = this.getJobsInternal();
        if (!jobsInternal.contains(jobEntity)) {
            jobsInternal.add(jobEntity);
        }
    }

    public void removeJob(JobEntity job) {
        this.getJobsInternal().remove(job);
    }

    protected void ensureIncidentsInitialized() {
        if (this.incidents == null) {
            this.incidents = Context.getCommandContext().getIncidentManager().findIncidentsByExecution(this.id);
        }
    }

    protected List<IncidentEntity> getIncidentsInternal() {
        this.ensureIncidentsInitialized();
        return this.incidents;
    }

    public List<IncidentEntity> getIncidents() {
        return new ArrayList<IncidentEntity>(this.getIncidentsInternal());
    }

    public void addIncident(IncidentEntity incident) {
        List<IncidentEntity> incidentsInternal = this.getIncidentsInternal();
        if (!incidentsInternal.contains(incident)) {
            incidentsInternal.add(incident);
        }
    }

    public void removeIncident(IncidentEntity incident) {
        this.getIncidentsInternal().remove(incident);
    }

    public IncidentEntity getIncidentByCauseIncidentId(String causeIncidentId) {
        for (IncidentEntity incident : this.getIncidents()) {
            if (incident.getCauseIncidentId() == null || !incident.getCauseIncidentId().equals(causeIncidentId)) continue;
            return incident;
        }
        return null;
    }

    protected void ensureTasksInitialized() {
        if (this.tasks == null) {
            this.tasks = Context.getCommandContext().getTaskManager().findTasksByExecutionId(this.id);
        }
    }

    protected List<TaskEntity> getTasksInternal() {
        this.ensureTasksInitialized();
        return this.tasks;
    }

    public List<TaskEntity> getTasks() {
        return new ArrayList<TaskEntity>(this.getTasksInternal());
    }

    public void addTask(TaskEntity taskEntity) {
        List<TaskEntity> tasksInternal = this.getTasksInternal();
        if (!tasksInternal.contains(taskEntity)) {
            tasksInternal.add(taskEntity);
        }
    }

    public void removeTask(TaskEntity task) {
        this.getTasksInternal().remove(task);
    }

    protected void ensureExternalTasksInitialized() {
        if (this.externalTasks == null) {
            this.externalTasks = Context.getCommandContext().getExternalTaskManager().findExternalTasksByExecutionId(this.id);
        }
    }

    protected List<ExternalTaskEntity> getExternalTasksInternal() {
        this.ensureExternalTasksInitialized();
        return this.externalTasks;
    }

    public void addExternalTask(ExternalTaskEntity externalTask) {
        this.getExternalTasksInternal().add(externalTask);
    }

    public void removeExternalTask(ExternalTaskEntity externalTask) {
        this.getExternalTasksInternal().remove(externalTask);
    }

    public List<ExternalTaskEntity> getExternalTasks() {
        return new ArrayList<ExternalTaskEntity>(this.getExternalTasksInternal());
    }

    @Override
    protected VariableStore<CoreVariableInstance> getVariableStore() {
        return this.variableStore;
    }

    @Override
    protected VariableInstanceFactory<CoreVariableInstance> getVariableInstanceFactory() {
        return VariableInstanceEntityFactory.INSTANCE;
    }

    @Override
    protected List<VariableInstanceLifecycleListener<CoreVariableInstance>> getVariableInstanceLifecycleListeners(AbstractVariableScope sourceScope) {
        ArrayList<VariableInstanceLifecycleListener<CoreVariableInstance>> listeners = new ArrayList<VariableInstanceLifecycleListener<CoreVariableInstance>>();
        listeners.add(this.getVariablePersistenceListener());
        listeners.add(new VariableInstanceConcurrentLocalInitializer(this));
        listeners.add(VariableInstanceSequenceCounterListener.INSTANCE);
        if (this.isAutoFireHistoryEvents()) {
            listeners.add(VariableInstanceHistoryListener.INSTANCE);
        }
        listeners.add(VariableListenerInvocationListener.INSTANCE);
        return listeners;
    }

    public VariableInstanceLifecycleListener<CoreVariableInstance> getVariablePersistenceListener() {
        return VariableInstanceEntityPersistenceListener.INSTANCE;
    }

    public Collection<VariableInstanceEntity> getVariablesInternal() {
        return this.variableStore.getVariables();
    }

    public void removeVariableInternal(VariableInstanceEntity variable) {
        if (this.variableStore.containsValue(variable)) {
            this.variableStore.removeVariable(variable.getName());
        }
    }

    public void addVariableInternal(VariableInstanceEntity variable) {
        if (this.variableStore.containsKey(variable.getName())) {
            VariableInstanceEntity existingVariable = this.variableStore.getVariable(variable.getName());
            existingVariable.setValue(variable.getTypedValue());
            variable.delete();
        } else {
            this.variableStore.addVariable(variable);
        }
    }

    public void setCachedEntityState(int cachedEntityState) {
        this.cachedEntityState = cachedEntityState;
        if (this.jobs == null && !BitMaskUtil.isBitOn(cachedEntityState, 3)) {
            this.jobs = new ArrayList<JobEntity>();
        }
        if (this.tasks == null && !BitMaskUtil.isBitOn(cachedEntityState, 2)) {
            this.tasks = new ArrayList<TaskEntity>();
        }
        if (this.eventSubscriptions == null && !BitMaskUtil.isBitOn(cachedEntityState, 1)) {
            this.eventSubscriptions = new ArrayList<EventSubscriptionEntity>();
        }
        if (this.incidents == null && !BitMaskUtil.isBitOn(cachedEntityState, 4)) {
            this.incidents = new ArrayList<IncidentEntity>();
        }
        if (!this.variableStore.isInitialized() && !BitMaskUtil.isBitOn(cachedEntityState, 5)) {
            this.variableStore.setVariablesProvider(VariableCollectionProvider.emptyVariables());
            this.variableStore.forceInitialization();
        }
        if (this.externalTasks == null && !BitMaskUtil.isBitOn(cachedEntityState, 8)) {
            this.externalTasks = new ArrayList<ExternalTaskEntity>();
        }
        this.shouldQueryForSubprocessInstance = BitMaskUtil.isBitOn(cachedEntityState, 6);
        this.shouldQueryForSubCaseInstance = BitMaskUtil.isBitOn(cachedEntityState, 7);
    }

    public int getCachedEntityState() {
        this.cachedEntityState = 0;
        this.cachedEntityState = BitMaskUtil.setBit(this.cachedEntityState, 2, this.tasks == null || this.tasks.size() > 0);
        this.cachedEntityState = BitMaskUtil.setBit(this.cachedEntityState, 1, this.eventSubscriptions == null || this.eventSubscriptions.size() > 0);
        this.cachedEntityState = BitMaskUtil.setBit(this.cachedEntityState, 3, this.jobs == null || this.jobs.size() > 0);
        this.cachedEntityState = BitMaskUtil.setBit(this.cachedEntityState, 4, this.incidents == null || this.incidents.size() > 0);
        this.cachedEntityState = BitMaskUtil.setBit(this.cachedEntityState, 5, !this.variableStore.isInitialized() || !this.variableStore.isEmpty());
        this.cachedEntityState = BitMaskUtil.setBit(this.cachedEntityState, 6, this.shouldQueryForSubprocessInstance);
        this.cachedEntityState = BitMaskUtil.setBit(this.cachedEntityState, 7, this.shouldQueryForSubCaseInstance);
        this.cachedEntityState = BitMaskUtil.setBit(this.cachedEntityState, 8, this.externalTasks == null || this.externalTasks.size() > 0);
        return this.cachedEntityState;
    }

    public int getCachedEntityStateRaw() {
        return this.cachedEntityState;
    }

    @Override
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @Override
    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    @Override
    public int getRevision() {
        return this.revision;
    }

    @Override
    public void setRevision(int revision) {
        this.revision = revision;
    }

    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    public void setSuperExecutionId(String superExecutionId) {
        this.superExecutionId = superExecutionId;
    }

    @Override
    public Set<String> getReferencedEntityIds() {
        HashSet<String> referenceIds = new HashSet<String>();
        if (this.superExecutionId != null) {
            referenceIds.add(this.superExecutionId);
        }
        if (this.parentId != null) {
            referenceIds.add(this.parentId);
        }
        return referenceIds;
    }

    public int getSuspensionState() {
        return this.suspensionState;
    }

    public void setSuspensionState(int suspensionState) {
        this.suspensionState = suspensionState;
    }

    @Override
    public boolean isSuspended() {
        return this.suspensionState == SuspensionState.SUSPENDED.getStateCode();
    }

    @Override
    public ProcessInstanceStartContext getProcessInstanceStartContext() {
        if (this.isProcessInstanceExecution() && this.startContext == null) {
            ActivityImpl activity = this.getActivity();
            this.startContext = new ProcessInstanceStartContext(activity);
        }
        return super.getProcessInstanceStartContext();
    }

    @Override
    public String getCurrentActivityId() {
        return this.activityId;
    }

    @Override
    public String getCurrentActivityName() {
        return this.activityName;
    }

    @Override
    public FlowElement getBpmnModelElementInstance() {
        BpmnModelInstance bpmnModelInstance = this.getBpmnModelInstance();
        if (bpmnModelInstance != null) {
            ModelElementInstance modelElementInstance = null;
            modelElementInstance = "take".equals(this.eventName) ? bpmnModelInstance.getModelElementById(this.transition.getId()) : bpmnModelInstance.getModelElementById(this.activityId);
            try {
                return (FlowElement)modelElementInstance;
            }
            catch (ClassCastException e) {
                ModelElementType elementType = modelElementInstance.getElementType();
                throw LOG.castModelInstanceException(modelElementInstance, "FlowElement", elementType.getTypeName(), elementType.getTypeNamespace(), e);
            }
        }
        return null;
    }

    @Override
    public BpmnModelInstance getBpmnModelInstance() {
        if (this.processDefinitionId != null) {
            return Context.getProcessEngineConfiguration().getDeploymentCache().findBpmnModelInstanceForProcessDefinition(this.processDefinitionId);
        }
        return null;
    }

    @Override
    public ProcessEngineServices getProcessEngineServices() {
        return Context.getProcessEngineConfiguration().getProcessEngine();
    }
}

