/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.application.impl.deployment;

import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;

public class DeploymentRegistrationTest
extends PluggableProcessEngineTestCase {
    protected static final String DEPLOYMENT_NAME = "my-deployment";
    protected static final String PROCESS_KEY = "process-1";
    protected static final String BPMN_RESOURCE = "path/to/my/process1.bpmn";

    public void testNoRegistrationCheckIfNoProcessApplicationIsDeployed() {
        Deployment deployment1 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(BPMN_RESOURCE, this.createProcessWithServiceTask(PROCESS_KEY)).deploy();
        Deployment deployment2 = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addDeploymentResources(deployment1.getId()).deploy();
        this.processEngineConfiguration.getDeploymentCache().discardProcessDefinitionCache();
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        DeploymentRegistrationTest.assertEquals((int)1, (int)this.processEngineConfiguration.getDeploymentCache().getProcessDefinitionCache().size());
        this.deleteDeployments(deployment1, deployment2);
    }

    protected void deleteDeployments(Deployment ... deployments) {
        for (Deployment deployment : deployments) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
            this.managementService.unregisterProcessApplication(deployment.getId(), false);
        }
    }

    protected BpmnModelInstance createProcessWithServiceTask(String key) {
        return ((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)key).startEvent().serviceTask().camundaExpression("${true}")).endEvent().done();
    }
}

