/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization.history;

import java.util.HashMap;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.history.HistoricDecisionInstanceQuery;
import org.camunda.bpm.engine.query.Query;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.authorization.AuthorizationTest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

@RequiredHistoryLevel(value="full")
public class HistoricDecisionInstanceAuthorizationTest
extends AuthorizationTest {
    protected static final String PROCESS_KEY = "testProcess";
    protected static final String DECISION_DEFINITION_KEY = "testDecision";

    @Override
    public void setUp() throws Exception {
        this.deploymentId = this.createDeployment(null, "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml").getId();
        super.setUp();
    }

    @Override
    public void tearDown() {
        super.tearDown();
        this.deleteDeployment(this.deploymentId);
    }

    public void testQueryWithoutAuthorization() {
        this.startProcessInstanceAndEvaluateDecision();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        this.verifyQueryResults((Query<?, ?>)query, 0);
    }

    public void testQueryWithReadPermissionOnDecisionDefinition() {
        this.startProcessInstanceAndEvaluateDecision();
        this.createGrantAuthorization((Resource)Resources.DECISION_DEFINITION, DECISION_DEFINITION_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
    }

    public void testQueryWithReadPermissionOnAnyDecisionDefinition() {
        this.startProcessInstanceAndEvaluateDecision();
        this.createGrantAuthorization((Resource)Resources.DECISION_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
    }

    public void testQueryWithMultiple() {
        this.startProcessInstanceAndEvaluateDecision();
        this.createGrantAuthorization((Resource)Resources.DECISION_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        this.createGrantAuthorization((Resource)Resources.DECISION_DEFINITION, DECISION_DEFINITION_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
    }

    public void testDeleteHistoricDecisionInstanceWithoutAuthorization() {
        this.startProcessInstanceAndEvaluateDecision();
        String decisionDefinitionId = this.selectDecisionDefinitionByKey(DECISION_DEFINITION_KEY).getId();
        try {
            this.historyService.deleteHistoricDecisionInstance(decisionDefinitionId);
            HistoricDecisionInstanceAuthorizationTest.fail((String)"expect authorization exception");
        }
        catch (AuthorizationException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.is((Object)"The user with id 'test' does not have 'DELETE_HISTORY' permission on resource 'testDecision' of type 'DecisionDefinition'."));
        }
    }

    public void testDeleteHistoricDecisionInstanceWithDeleteHistoryPermissionOnDecisionDefinition() {
        this.startProcessInstanceAndEvaluateDecision();
        this.createGrantAuthorization((Resource)Resources.DECISION_DEFINITION, "*", this.userId, new Permission[]{Permissions.DELETE_HISTORY});
        String decisionDefinitionId = this.selectDecisionDefinitionByKey(DECISION_DEFINITION_KEY).getId();
        this.historyService.deleteHistoricDecisionInstance(decisionDefinitionId);
        this.disableAuthorization();
        Assert.assertThat((Object)this.historyService.createHistoricDecisionInstanceQuery().count(), (Matcher)CoreMatchers.is((Object)0L));
        this.enableAuthorization();
    }

    public void testDeleteHistoricDecisionInstanceWithDeleteHistoryPermissionOnAnyDecisionDefinition() {
        this.startProcessInstanceAndEvaluateDecision();
        this.createGrantAuthorization((Resource)Resources.DECISION_DEFINITION, DECISION_DEFINITION_KEY, this.userId, new Permission[]{Permissions.DELETE_HISTORY});
        String decisionDefinitionId = this.selectDecisionDefinitionByKey(DECISION_DEFINITION_KEY).getId();
        this.historyService.deleteHistoricDecisionInstance(decisionDefinitionId);
        this.disableAuthorization();
        Assert.assertThat((Object)this.historyService.createHistoricDecisionInstanceQuery().count(), (Matcher)CoreMatchers.is((Object)0L));
        this.enableAuthorization();
    }

    protected void startProcessInstanceAndEvaluateDecision() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("input1", null);
        this.startProcessInstanceByKey(PROCESS_KEY, variables);
    }
}

