/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.dmn;

import java.util.Map;
import org.camunda.bpm.dmn.engine.DmnDecisionTableResult;
import org.camunda.bpm.engine.DecisionService;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.exception.NotFoundException;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class DecisionServiceTest {
    protected static final String DMN_FILE = "org/camunda/bpm/engine/test/api/dmn/Example.dmn";
    protected static final String DMN_FILE_SECOND_VERSION = "org/camunda/bpm/engine/test/api/dmn/Example_v2.dmn";
    protected static final String DRD_DISH_RESOURCE = "org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml";
    protected static final String DECISION_DEFINITION_KEY = "decision";
    protected static final String RESULT_OF_FIRST_VERSION = "ok";
    protected static final String RESULT_OF_SECOND_VERSION = "notok";
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    protected DecisionService decisionService;
    protected RepositoryService repositoryService;

    @Before
    public void init() {
        this.decisionService = this.engineRule.getDecisionService();
        this.repositoryService = this.engineRule.getRepositoryService();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/dmn/Example.dmn"})
    @Test
    public void evaluateDecisionById() {
        DecisionDefinition decisionDefinition = (DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().singleResult();
        DmnDecisionTableResult decisionResult = this.decisionService.evaluateDecisionTableById(decisionDefinition.getId(), (Map)this.createVariables());
        this.assertThatDecisionHasResult(decisionResult, RESULT_OF_FIRST_VERSION);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/dmn/Example.dmn"})
    @Test
    public void evaluateDecisionByKey() {
        DmnDecisionTableResult decisionResult = this.decisionService.evaluateDecisionTableByKey(DECISION_DEFINITION_KEY, (Map)this.createVariables());
        this.assertThatDecisionHasResult(decisionResult, RESULT_OF_FIRST_VERSION);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/dmn/Example.dmn"})
    @Test
    public void evaluateDecisionByKeyAndLatestVersion() {
        this.testRule.deploy(DMN_FILE_SECOND_VERSION);
        DmnDecisionTableResult decisionResult = this.decisionService.evaluateDecisionTableByKey(DECISION_DEFINITION_KEY, (Map)this.createVariables());
        this.assertThatDecisionHasResult(decisionResult, RESULT_OF_SECOND_VERSION);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/dmn/Example.dmn"})
    @Test
    public void evaluateDecisionByKeyAndVersion() {
        this.testRule.deploy(DMN_FILE_SECOND_VERSION);
        DmnDecisionTableResult decisionResult = this.decisionService.evaluateDecisionTableByKeyAndVersion(DECISION_DEFINITION_KEY, Integer.valueOf(1), (Map)this.createVariables());
        this.assertThatDecisionHasResult(decisionResult, RESULT_OF_FIRST_VERSION);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/dmn/Example.dmn"})
    @Test
    public void evaluateDecisionByKeyAndNullVersion() {
        this.testRule.deploy(DMN_FILE_SECOND_VERSION);
        DmnDecisionTableResult decisionResult = this.decisionService.evaluateDecisionTableByKeyAndVersion(DECISION_DEFINITION_KEY, null, (Map)this.createVariables());
        this.assertThatDecisionHasResult(decisionResult, RESULT_OF_SECOND_VERSION);
    }

    @Test
    public void evaluateDecisionByNullId() {
        this.thrown.expect(NotValidException.class);
        this.thrown.expectMessage("either decision definition id or key must be set");
        this.decisionService.evaluateDecisionTableById(null, null);
    }

    @Test
    public void evaluateDecisionByNonExistingId() {
        this.thrown.expect(NotFoundException.class);
        this.thrown.expectMessage("no deployed decision definition found with id 'unknown'");
        this.decisionService.evaluateDecisionTableById("unknown", null);
    }

    @Test
    public void evaluateDecisionByNullKey() {
        this.thrown.expect(NotValidException.class);
        this.thrown.expectMessage("either decision definition id or key must be set");
        this.decisionService.evaluateDecisionTableByKey(null, null);
    }

    @Test
    public void evaluateDecisionByNonExistingKey() {
        this.thrown.expect(NotFoundException.class);
        this.thrown.expectMessage("no decision definition deployed with key 'unknown'");
        this.decisionService.evaluateDecisionTableByKey("unknown", null);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/dmn/Example.dmn"})
    @Test
    public void evaluateDecisionByKeyWithNonExistingVersion() {
        DecisionDefinition decisionDefinition = (DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().singleResult();
        this.thrown.expect(NotFoundException.class);
        this.thrown.expectMessage("no decision definition deployed with key = 'decision' and version = '42'");
        this.decisionService.evaluateDecisionTableByKeyAndVersion(decisionDefinition.getKey(), Integer.valueOf(42), null);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    @Test
    public void evaluateDecisionWithRequiredDecisions() {
        DmnDecisionTableResult decisionResult = this.decisionService.evaluateDecisionTableByKey("dish-decision", (Map)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend"));
        this.assertThatDecisionHasResult(decisionResult, "Light salad");
    }

    protected VariableMap createVariables() {
        return Variables.createVariables().putValue("status", (Object)"silver").putValue("sum", (Object)723);
    }

    protected void assertThatDecisionHasResult(DmnDecisionTableResult decisionResult, Object expectedValue) {
        Assert.assertThat((Object)decisionResult, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)decisionResult.size(), (Matcher)CoreMatchers.is((Object)1));
        String value = (String)decisionResult.getSingleResult().getFirstEntry();
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)expectedValue));
    }
}

