/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy;

import java.util.Arrays;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;
import org.camunda.bpm.engine.runtime.ProcessInstantiationBuilder;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class MultiTenancyProcessInstantiationTest
extends PluggableProcessEngineTestCase {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";
    protected static final BpmnModelInstance PROCESS = Bpmn.createExecutableProcess((String)"testProcess").startEvent().userTask("userTask").endEvent().done();

    public void testStartProcessInstanceByKeyAndTenantId() {
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{PROCESS});
        this.deploymentForTenant(TENANT_TWO, new BpmnModelInstance[]{PROCESS});
        this.runtimeService.createProcessInstanceByKey("testProcess").processDefinitionTenantId(TENANT_ONE).execute();
        Assert.assertThat((Object)this.runtimeService.createProcessInstanceQuery().tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testStartProcessInstanceByKeyForAnyTenant() {
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{PROCESS});
        this.runtimeService.createProcessInstanceByKey("testProcess").execute();
        Assert.assertThat((Object)this.runtimeService.createProcessInstanceQuery().tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testStartProcessInstanceByKeyWithoutTenantId() {
        this.deployment(new BpmnModelInstance[]{PROCESS});
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{PROCESS});
        this.runtimeService.createProcessInstanceByKey("testProcess").processDefinitionWithoutTenantId().execute();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)((ProcessInstance)query.singleResult()).getTenantId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    public void testFailToStartProcessInstanceByKeyForOtherTenant() {
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{PROCESS});
        try {
            this.runtimeService.createProcessInstanceByKey("testProcess").processDefinitionTenantId(TENANT_TWO).execute();
            MultiTenancyProcessInstantiationTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"no processes deployed"));
        }
    }

    public void testFailToStartProcessInstanceByKeyForMultipleTenants() {
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{PROCESS});
        this.deploymentForTenant(TENANT_TWO, new BpmnModelInstance[]{PROCESS});
        try {
            this.runtimeService.createProcessInstanceByKey("testProcess").execute();
            MultiTenancyProcessInstantiationTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"multiple tenants"));
        }
    }

    public void testFailToStartProcessInstanceByIdAndTenantId() {
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{PROCESS});
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        try {
            this.runtimeService.createProcessInstanceById(processDefinition.getId()).processDefinitionTenantId(TENANT_ONE).execute();
            MultiTenancyProcessInstantiationTest.fail((String)"expected exception");
        }
        catch (BadUserRequestException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Cannot specify a tenant-id"));
        }
    }

    public void testFailToStartProcessInstanceByIdWithoutTenantId() {
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{PROCESS});
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        try {
            this.runtimeService.createProcessInstanceById(processDefinition.getId()).processDefinitionWithoutTenantId().execute();
            MultiTenancyProcessInstantiationTest.fail((String)"expected exception");
        }
        catch (BadUserRequestException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Cannot specify a tenant-id"));
        }
    }

    public void testStartProcessInstanceAtActivityByKeyAndTenantId() {
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{PROCESS});
        this.deploymentForTenant(TENANT_TWO, new BpmnModelInstance[]{PROCESS});
        ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("testProcess").processDefinitionTenantId(TENANT_ONE).startBeforeActivity("userTask")).execute();
        Assert.assertThat((Object)this.runtimeService.createProcessInstanceQuery().tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testStartProcessInstanceAtActivityByKeyForAnyTenant() {
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{PROCESS});
        ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("testProcess").startBeforeActivity("userTask")).execute();
        Assert.assertThat((Object)this.runtimeService.createProcessInstanceQuery().tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testStartProcessInstanceAtActivityByKeyWithoutTenantId() {
        this.deployment(new BpmnModelInstance[]{PROCESS});
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{PROCESS});
        ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("testProcess").processDefinitionWithoutTenantId().startBeforeActivity("userTask")).execute();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)((ProcessInstance)query.singleResult()).getTenantId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    public void testFailToStartProcessInstanceAtActivityByKeyForOtherTenant() {
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{PROCESS});
        try {
            ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("testProcess").processDefinitionTenantId(TENANT_TWO).startBeforeActivity("userTask")).execute();
            MultiTenancyProcessInstantiationTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"no processes deployed"));
        }
    }

    public void testFailToStartProcessInstanceAtActivityByKeyForMultipleTenants() {
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{PROCESS});
        this.deploymentForTenant(TENANT_TWO, new BpmnModelInstance[]{PROCESS});
        try {
            ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("testProcess").startBeforeActivity("userTask")).execute();
            MultiTenancyProcessInstantiationTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"multiple tenants"));
        }
    }

    public void testFailToStartProcessInstanceAtActivityByIdAndTenantId() {
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{PROCESS});
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        try {
            ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceById(processDefinition.getId()).processDefinitionTenantId(TENANT_ONE).startBeforeActivity("userTask")).execute();
            MultiTenancyProcessInstantiationTest.fail((String)"expected exception");
        }
        catch (BadUserRequestException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Cannot specify a tenant-id"));
        }
    }

    public void testFailToStartProcessInstanceAtActivityByIdWithoutTenantId() {
        this.deployment(new BpmnModelInstance[]{PROCESS});
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        try {
            ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceById(processDefinition.getId()).processDefinitionWithoutTenantId().startBeforeActivity("userTask")).execute();
            MultiTenancyProcessInstantiationTest.fail((String)"expected exception");
        }
        catch (BadUserRequestException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Cannot specify a tenant-id"));
        }
    }

    public void testStartProcessInstanceByKeyWithoutTenantIdNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        this.deployment(new BpmnModelInstance[]{PROCESS});
        this.runtimeService.createProcessInstanceByKey("testProcess").processDefinitionWithoutTenantId().execute();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testFailToStartProcessInstanceByKeyNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{PROCESS});
        try {
            this.runtimeService.createProcessInstanceByKey("testProcess").execute();
            MultiTenancyProcessInstantiationTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"no processes deployed with key 'testProcess'"));
        }
    }

    public void testFailToStartProcessInstanceByKeyWithTenantIdNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{PROCESS});
        try {
            this.runtimeService.createProcessInstanceByKey("testProcess").processDefinitionTenantId(TENANT_ONE).execute();
            MultiTenancyProcessInstantiationTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Cannot create an instance of the process definition"));
        }
    }

    public void testFailToStartProcessInstanceByIdNoAuthenticatedTenants() {
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{PROCESS});
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        this.identityService.setAuthentication("user", null, null);
        try {
            this.runtimeService.createProcessInstanceById(processDefinition.getId()).execute();
            MultiTenancyProcessInstantiationTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Cannot create an instance of the process definition"));
        }
    }

    public void testStartProcessInstanceByKeyWithTenantIdAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{PROCESS});
        this.deploymentForTenant(TENANT_TWO, new BpmnModelInstance[]{PROCESS});
        this.runtimeService.createProcessInstanceByKey("testProcess").processDefinitionTenantId(TENANT_ONE).execute();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testStartProcessInstanceByIdAuthenticatedTenant() {
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{PROCESS});
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.runtimeService.createProcessInstanceById(processDefinition.getId()).execute();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testStartProcessInstanceByKeyWithAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{PROCESS});
        this.deploymentForTenant(TENANT_TWO, new BpmnModelInstance[]{PROCESS});
        this.runtimeService.createProcessInstanceByKey("testProcess").execute();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testStartProcessInstanceByKeyWithTenantIdDisabledTenantCheck() {
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{PROCESS});
        this.runtimeService.createProcessInstanceByKey("testProcess").processDefinitionTenantId(TENANT_ONE).execute();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }
}

