/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy;

import java.util.List;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.JobQuery;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.camunda.bpm.model.bpmn.builder.StartEventBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MultiTenancyTimerStartEventTest {
    protected static final BpmnModelInstance PROCESS = ((StartEventBuilder)Bpmn.createExecutableProcess().startEvent().timerWithDuration("PT1M")).userTask().endEvent().done();
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected ManagementService managementService;
    protected RuntimeService runtimeService;
    protected RepositoryService repositoryService;

    @Before
    public void initServices() {
        this.managementService = this.engineRule.getManagementService();
        this.runtimeService = this.engineRule.getRuntimeService();
        this.repositoryService = this.engineRule.getRepositoryService();
    }

    @Test
    public void startProcessInstanceWithTenantId() {
        this.testRule.deployForTenant(TENANT_ONE, PROCESS);
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertThat((Object)job.getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
        this.managementService.executeJob(job.getId());
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        Assert.assertThat((Object)processInstance, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)processInstance.getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
    }

    @Test
    public void startProcessInstanceTwoTenants() {
        this.testRule.deployForTenant(TENANT_ONE, PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, PROCESS);
        Job jobForTenantOne = (Job)this.managementService.createJobQuery().tenantIdIn(new String[]{TENANT_ONE}).singleResult();
        Assert.assertThat((Object)jobForTenantOne, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.managementService.executeJob(jobForTenantOne.getId());
        Job jobForTenantTwo = (Job)this.managementService.createJobQuery().tenantIdIn(new String[]{TENANT_TWO}).singleResult();
        Assert.assertThat((Object)jobForTenantTwo, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.managementService.executeJob(jobForTenantTwo.getId());
        Assert.assertThat((Object)this.runtimeService.createProcessInstanceQuery().tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)this.runtimeService.createProcessInstanceQuery().tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void deleteJobsWhileUndeployment() {
        Deployment deploymentForTenantOne = this.testRule.deployForTenant(TENANT_ONE, PROCESS);
        Deployment deploymentForTenantTwo = this.testRule.deployForTenant(TENANT_TWO, PROCESS);
        JobQuery query = this.managementService.createJobQuery();
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)1L));
        this.repositoryService.deleteDeployment(deploymentForTenantOne.getId(), true);
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)1L));
        this.repositoryService.deleteDeployment(deploymentForTenantTwo.getId(), true);
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    public void dontCreateNewJobsWhileReDeployment() {
        this.testRule.deployForTenant(TENANT_ONE, PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, PROCESS);
        this.testRule.deployForTenant(TENANT_ONE, PROCESS);
        JobQuery query = this.managementService.createJobQuery();
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void failedJobRetryTimeCycle() {
        this.testRule.deployForTenant(TENANT_ONE, ((ServiceTaskBuilder)((StartEventBuilder)((StartEventBuilder)Bpmn.createExecutableProcess((String)"failingProcess").startEvent().timerWithDuration("PT1M")).camundaFailedJobRetryTimeCycle("R5/PT1M")).serviceTask().camundaExpression("${failing}")).endEvent().done());
        this.testRule.deployForTenant(TENANT_TWO, ((ServiceTaskBuilder)((StartEventBuilder)((StartEventBuilder)Bpmn.createExecutableProcess((String)"failingProcess").startEvent().timerWithDuration("PT1M")).camundaFailedJobRetryTimeCycle("R4/PT1M")).serviceTask().camundaExpression("${failing}")).endEvent().done());
        List jobs = this.managementService.createJobQuery().timers().list();
        this.executeFailingJobs(jobs);
        Job jobTenantOne = (Job)this.managementService.createJobQuery().tenantIdIn(new String[]{TENANT_ONE}).singleResult();
        Job jobTenantTwo = (Job)this.managementService.createJobQuery().tenantIdIn(new String[]{TENANT_TWO}).singleResult();
        Assert.assertThat((Object)jobTenantOne.getRetries(), (Matcher)CoreMatchers.is((Object)4));
        Assert.assertThat((Object)jobTenantTwo.getRetries(), (Matcher)CoreMatchers.is((Object)3));
    }

    protected void executeFailingJobs(List<Job> jobs) {
        for (Job job : jobs) {
            try {
                this.managementService.executeJob(job.getId());
                Assert.fail((String)"expected exception");
            }
            catch (Exception e) {}
        }
    }
}

