/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.delegate.DelegateCaseExecution;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.history.HistoricDecisionInstance;
import org.camunda.bpm.engine.impl.cfg.multitenancy.TenantIdProvider;
import org.camunda.bpm.engine.impl.cfg.multitenancy.TenantIdProviderCaseInstanceContext;
import org.camunda.bpm.engine.impl.cfg.multitenancy.TenantIdProviderHistoricDecisionInstanceContext;
import org.camunda.bpm.engine.impl.cfg.multitenancy.TenantIdProviderProcessInstanceContext;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstantiationBuilder;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.multitenancy.StaticTenantIdTestProvider;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.BusinessRuleTaskBuilder;
import org.camunda.bpm.model.bpmn.builder.CallActivityBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class TenantIdProviderTest {
    protected static final String CONFIGURATION_RESOURCE = "org/camunda/bpm/engine/test/api/multitenancy/TenantIdProviderTest.camunda.cfg.xml";
    protected static final String PROCESS_DEFINITION_KEY = "testProcess";
    protected static final String DECISION_DEFINITION_KEY = "decision";
    protected static final String CASE_DEFINITION_KEY = "caseTaskCase";
    protected static final String DMN_FILE = "org/camunda/bpm/engine/test/api/multitenancy/simpleDecisionTable.dmn";
    protected static final String CMMN_FILE = "org/camunda/bpm/engine/test/api/multitenancy/CaseWithCaseTask.cmmn";
    protected static final String CMMN_VARIABLE_FILE = "org/camunda/bpm/engine/test/api/multitenancy/CaseWithCaseTaskVariables.cmmn";
    protected static final String CMMN_SUBPROCESS_FILE = "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn";
    protected static final String TENANT_ID = "tenant1";
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule("org/camunda/bpm/engine/test/api/multitenancy/TenantIdProviderTest.camunda.cfg.xml");
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule(bootstrapRule);
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);

    @After
    public void tearDown() {
        TestTenantIdProvider.reset();
    }

    @Test
    public void providerCalledForProcessDefinitionWithoutTenantId() {
        ContextLoggingTenantIdProvider tenantIdProvider = new ContextLoggingTenantIdProvider();
        TestTenantIdProvider.delegate = tenantIdProvider;
        this.testRule.deploy(Bpmn.createExecutableProcess((String)PROCESS_DEFINITION_KEY).startEvent().done());
        this.engineRule.getRuntimeService().startProcessInstanceByKey(PROCESS_DEFINITION_KEY);
        Assert.assertThat((Object)tenantIdProvider.parameters.size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void providerNotCalledForProcessDefinitionWithTenantId() {
        ContextLoggingTenantIdProvider tenantIdProvider = new ContextLoggingTenantIdProvider();
        TestTenantIdProvider.delegate = tenantIdProvider;
        this.testRule.deployForTenant(TENANT_ID, Bpmn.createExecutableProcess((String)PROCESS_DEFINITION_KEY).startEvent().done());
        this.engineRule.getRuntimeService().startProcessInstanceByKey(PROCESS_DEFINITION_KEY);
        Assert.assertThat((Object)tenantIdProvider.parameters.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void providerCalledForStartedProcessInstanceByStartFormWithoutTenantId() {
        ContextLoggingTenantIdProvider tenantIdProvider = new ContextLoggingTenantIdProvider();
        TestTenantIdProvider.delegate = tenantIdProvider;
        this.testRule.deploy(Bpmn.createExecutableProcess((String)PROCESS_DEFINITION_KEY).startEvent().done(), "org/camunda/bpm/engine/test/api/form/util/request.form");
        String processDefinitionId = ((ProcessDefinition)this.engineRule.getRepositoryService().createProcessDefinitionQuery().singleResult()).getId();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("employeeName", "demo");
        ProcessInstance procInstance = this.engineRule.getFormService().submitStartForm(processDefinitionId, properties);
        Assert.assertNotNull((Object)procInstance);
        Assert.assertThat((Object)tenantIdProvider.parameters.size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void providerNotCalledForStartedProcessInstanceByStartFormWithTenantId() {
        ContextLoggingTenantIdProvider tenantIdProvider = new ContextLoggingTenantIdProvider();
        TestTenantIdProvider.delegate = tenantIdProvider;
        this.testRule.deployForTenant(TENANT_ID, Bpmn.createExecutableProcess((String)PROCESS_DEFINITION_KEY).startEvent().done(), "org/camunda/bpm/engine/test/api/form/util/request.form");
        String processDefinitionId = ((ProcessDefinition)this.engineRule.getRepositoryService().createProcessDefinitionQuery().singleResult()).getId();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("employeeName", "demo");
        ProcessInstance procInstance = this.engineRule.getFormService().submitStartForm(processDefinitionId, properties);
        Assert.assertNotNull((Object)procInstance);
        Assert.assertThat((Object)tenantIdProvider.parameters.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void providerCalledForStartedProcessInstanceByModificationWithoutTenantId() {
        ContextLoggingTenantIdProvider tenantIdProvider = new ContextLoggingTenantIdProvider();
        TestTenantIdProvider.delegate = tenantIdProvider;
        this.testRule.deploy(Bpmn.createExecutableProcess((String)PROCESS_DEFINITION_KEY).startEvent().userTask("task").endEvent().done(), "org/camunda/bpm/engine/test/api/form/util/request.form");
        String processInstanceId = ((ProcessInstantiationBuilder)this.engineRule.getRuntimeService().createProcessInstanceByKey(PROCESS_DEFINITION_KEY).startBeforeActivity("task")).execute().getProcessInstanceId();
        Assert.assertNotNull((Object)this.engineRule.getRuntimeService().getActivityInstance(processInstanceId));
        Assert.assertThat((Object)tenantIdProvider.parameters.size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void providerNotCalledForStartedProcessInstanceByModificationWithTenantId() {
        ContextLoggingTenantIdProvider tenantIdProvider = new ContextLoggingTenantIdProvider();
        TestTenantIdProvider.delegate = tenantIdProvider;
        this.testRule.deployForTenant(TENANT_ID, Bpmn.createExecutableProcess((String)PROCESS_DEFINITION_KEY).startEvent().userTask("task").endEvent().done(), "org/camunda/bpm/engine/test/api/form/util/request.form");
        String processInstanceId = ((ProcessInstantiationBuilder)this.engineRule.getRuntimeService().createProcessInstanceByKey(PROCESS_DEFINITION_KEY).startBeforeActivity("task")).execute().getProcessInstanceId();
        Assert.assertNotNull((Object)this.engineRule.getRuntimeService().getActivityInstance(processInstanceId));
        Assert.assertThat((Object)tenantIdProvider.parameters.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void providerCalledWithVariables() {
        ContextLoggingTenantIdProvider tenantIdProvider = new ContextLoggingTenantIdProvider();
        TestTenantIdProvider.delegate = tenantIdProvider;
        this.testRule.deploy(Bpmn.createExecutableProcess((String)PROCESS_DEFINITION_KEY).startEvent().done());
        this.engineRule.getRuntimeService().startProcessInstanceByKey(PROCESS_DEFINITION_KEY, (Map)Variables.createVariables().putValue("varName", (Object)true));
        Assert.assertThat((Object)tenantIdProvider.parameters.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)((Boolean)tenantIdProvider.parameters.get(0).getVariables().get((Object)"varName")), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void providerCalledWithProcessDefinition() {
        ContextLoggingTenantIdProvider tenantIdProvider = new ContextLoggingTenantIdProvider();
        TestTenantIdProvider.delegate = tenantIdProvider;
        this.testRule.deploy(Bpmn.createExecutableProcess((String)PROCESS_DEFINITION_KEY).startEvent().done());
        ProcessDefinition deployedProcessDefinition = (ProcessDefinition)this.engineRule.getRepositoryService().createProcessDefinitionQuery().singleResult();
        this.engineRule.getRuntimeService().startProcessInstanceByKey(PROCESS_DEFINITION_KEY);
        ProcessDefinition passedProcessDefinition = tenantIdProvider.parameters.get(0).getProcessDefinition();
        Assert.assertThat((Object)passedProcessDefinition, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)passedProcessDefinition.getId(), (Matcher)CoreMatchers.is((Object)deployedProcessDefinition.getId()));
    }

    @Test
    public void setsTenantId() {
        String tenantId = TENANT_ID;
        StaticTenantIdTestProvider tenantIdProvider = new StaticTenantIdTestProvider(tenantId);
        TestTenantIdProvider.delegate = tenantIdProvider;
        this.testRule.deploy(Bpmn.createExecutableProcess((String)PROCESS_DEFINITION_KEY).startEvent().userTask().done());
        this.engineRule.getRuntimeService().startProcessInstanceByKey(PROCESS_DEFINITION_KEY);
        ProcessInstance processInstance = (ProcessInstance)this.engineRule.getRuntimeService().createProcessInstanceQuery().singleResult();
        Assert.assertThat((Object)processInstance.getTenantId(), (Matcher)CoreMatchers.is((Object)tenantId));
    }

    @Test
    public void setNullTenantId() {
        String tenantId = null;
        StaticTenantIdTestProvider tenantIdProvider = new StaticTenantIdTestProvider(tenantId);
        TestTenantIdProvider.delegate = tenantIdProvider;
        this.testRule.deploy(Bpmn.createExecutableProcess((String)PROCESS_DEFINITION_KEY).startEvent().userTask().done());
        this.engineRule.getRuntimeService().startProcessInstanceByKey(PROCESS_DEFINITION_KEY);
        ProcessInstance processInstance = (ProcessInstance)this.engineRule.getRuntimeService().createProcessInstanceQuery().singleResult();
        Assert.assertThat((Object)processInstance.getTenantId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void providerCalledForProcessDefinitionWithoutTenantId_SubProcessInstance() {
        ContextLoggingTenantIdProvider tenantIdProvider = new ContextLoggingTenantIdProvider();
        TestTenantIdProvider.delegate = tenantIdProvider;
        this.testRule.deploy(Bpmn.createExecutableProcess((String)PROCESS_DEFINITION_KEY).startEvent().done(), ((CallActivityBuilder)Bpmn.createExecutableProcess((String)"superProcess").startEvent().callActivity().calledElement(PROCESS_DEFINITION_KEY)).done());
        this.engineRule.getRuntimeService().startProcessInstanceByKey("superProcess");
        Assert.assertThat((Object)tenantIdProvider.parameters.size(), (Matcher)CoreMatchers.is((Object)2));
    }

    @Test
    public void providerNotCalledForProcessDefinitionWithTenantId_SubProcessInstance() {
        ContextLoggingTenantIdProvider tenantIdProvider = new ContextLoggingTenantIdProvider();
        TestTenantIdProvider.delegate = tenantIdProvider;
        this.testRule.deployForTenant(TENANT_ID, Bpmn.createExecutableProcess((String)PROCESS_DEFINITION_KEY).startEvent().done(), ((CallActivityBuilder)Bpmn.createExecutableProcess((String)"superProcess").startEvent().callActivity().calledElement(PROCESS_DEFINITION_KEY)).done());
        this.engineRule.getRuntimeService().startProcessInstanceByKey("superProcess");
        Assert.assertThat((Object)tenantIdProvider.parameters.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void providerCalledWithVariables_SubProcessInstance() {
        ContextLoggingTenantIdProvider tenantIdProvider = new ContextLoggingTenantIdProvider();
        TestTenantIdProvider.delegate = tenantIdProvider;
        this.testRule.deploy(Bpmn.createExecutableProcess((String)PROCESS_DEFINITION_KEY).startEvent().done(), ((CallActivityBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"superProcess").startEvent().callActivity().calledElement(PROCESS_DEFINITION_KEY)).camundaIn("varName", "varName")).done());
        this.engineRule.getRuntimeService().startProcessInstanceByKey("superProcess", (Map)Variables.createVariables().putValue("varName", (Object)true));
        Assert.assertThat((Object)tenantIdProvider.parameters.get(1).getVariables().size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)((Boolean)tenantIdProvider.parameters.get(1).getVariables().get((Object)"varName")), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void providerCalledWithProcessDefinition_SubProcessInstance() {
        ContextLoggingTenantIdProvider tenantIdProvider = new ContextLoggingTenantIdProvider();
        TestTenantIdProvider.delegate = tenantIdProvider;
        this.testRule.deploy(Bpmn.createExecutableProcess((String)PROCESS_DEFINITION_KEY).startEvent().done(), ((CallActivityBuilder)Bpmn.createExecutableProcess((String)"superProcess").startEvent().callActivity().calledElement(PROCESS_DEFINITION_KEY)).done());
        ProcessDefinition deployedProcessDefinition = (ProcessDefinition)this.engineRule.getRepositoryService().createProcessDefinitionQuery().processDefinitionKey(PROCESS_DEFINITION_KEY).singleResult();
        this.engineRule.getRuntimeService().startProcessInstanceByKey("superProcess");
        ProcessDefinition passedProcessDefinition = tenantIdProvider.parameters.get(1).getProcessDefinition();
        Assert.assertThat((Object)passedProcessDefinition, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)passedProcessDefinition.getId(), (Matcher)CoreMatchers.is((Object)deployedProcessDefinition.getId()));
    }

    @Test
    public void providerCalledWithSuperProcessInstance() {
        ContextLoggingTenantIdProvider tenantIdProvider = new ContextLoggingTenantIdProvider();
        TestTenantIdProvider.delegate = tenantIdProvider;
        this.testRule.deploy(Bpmn.createExecutableProcess((String)PROCESS_DEFINITION_KEY).startEvent().done(), ((CallActivityBuilder)Bpmn.createExecutableProcess((String)"superProcess").startEvent().callActivity().calledElement(PROCESS_DEFINITION_KEY)).done());
        ProcessDefinition superProcessDefinition = (ProcessDefinition)this.engineRule.getRepositoryService().createProcessDefinitionQuery().processDefinitionKey("superProcess").singleResult();
        this.engineRule.getRuntimeService().startProcessInstanceByKey("superProcess");
        DelegateExecution superExecution = tenantIdProvider.parameters.get(1).getSuperExecution();
        Assert.assertThat((Object)superExecution, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)superExecution.getProcessDefinitionId(), (Matcher)CoreMatchers.is((Object)superProcessDefinition.getId()));
    }

    @Test
    public void setsTenantId_SubProcessInstance() {
        String tenantId = TENANT_ID;
        SetValueOnSubProcessInstanceTenantIdProvider tenantIdProvider = new SetValueOnSubProcessInstanceTenantIdProvider(tenantId);
        TestTenantIdProvider.delegate = tenantIdProvider;
        this.testRule.deploy(Bpmn.createExecutableProcess((String)PROCESS_DEFINITION_KEY).startEvent().userTask().done(), ((CallActivityBuilder)Bpmn.createExecutableProcess((String)"superProcess").startEvent().callActivity().calledElement(PROCESS_DEFINITION_KEY)).done());
        this.engineRule.getRuntimeService().startProcessInstanceByKey("superProcess");
        ProcessInstance subProcessInstance = (ProcessInstance)this.engineRule.getRuntimeService().createProcessInstanceQuery().processDefinitionKey(PROCESS_DEFINITION_KEY).singleResult();
        Assert.assertThat((Object)subProcessInstance.getTenantId(), (Matcher)CoreMatchers.is((Object)tenantId));
        ProcessInstance superProcessInstance = (ProcessInstance)this.engineRule.getRuntimeService().createProcessInstanceQuery().processDefinitionKey("superProcess").singleResult();
        Assert.assertThat((Object)superProcessInstance.getTenantId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void setNullTenantId_SubProcessInstance() {
        String tenantId = null;
        SetValueOnSubProcessInstanceTenantIdProvider tenantIdProvider = new SetValueOnSubProcessInstanceTenantIdProvider(tenantId);
        TestTenantIdProvider.delegate = tenantIdProvider;
        this.testRule.deploy(Bpmn.createExecutableProcess((String)PROCESS_DEFINITION_KEY).startEvent().userTask().done(), ((CallActivityBuilder)Bpmn.createExecutableProcess((String)"superProcess").startEvent().callActivity().calledElement(PROCESS_DEFINITION_KEY)).done());
        this.engineRule.getRuntimeService().startProcessInstanceByKey("superProcess");
        ProcessInstance processInstance = (ProcessInstance)this.engineRule.getRuntimeService().createProcessInstanceQuery().processDefinitionKey(PROCESS_DEFINITION_KEY).singleResult();
        Assert.assertThat((Object)processInstance.getTenantId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void tenantIdInheritedFromSuperProcessInstance() {
        String tenantId = TENANT_ID;
        SetValueOnRootProcessInstanceTenantIdProvider tenantIdProvider = new SetValueOnRootProcessInstanceTenantIdProvider(tenantId);
        TestTenantIdProvider.delegate = tenantIdProvider;
        this.testRule.deploy(Bpmn.createExecutableProcess((String)PROCESS_DEFINITION_KEY).startEvent().userTask().done(), ((CallActivityBuilder)Bpmn.createExecutableProcess((String)"superProcess").startEvent().callActivity().calledElement(PROCESS_DEFINITION_KEY)).done());
        this.engineRule.getRuntimeService().startProcessInstanceByKey("superProcess");
        ProcessInstance processInstance = (ProcessInstance)this.engineRule.getRuntimeService().createProcessInstanceQuery().processDefinitionKey(PROCESS_DEFINITION_KEY).singleResult();
        Assert.assertThat((Object)processInstance.getTenantId(), (Matcher)CoreMatchers.is((Object)tenantId));
    }

    @Test
    public void providerCalledForProcessDefinitionWithoutTenantId_ProcessTask() {
        ContextLoggingTenantIdProvider tenantIdProvider = new ContextLoggingTenantIdProvider();
        TestTenantIdProvider.delegate = tenantIdProvider;
        this.testRule.deploy(Bpmn.createExecutableProcess((String)PROCESS_DEFINITION_KEY).startEvent().userTask().done(), "org/camunda/bpm/engine/test/api/multitenancy/CaseWithProcessTask.cmmn");
        this.engineRule.getCaseService().createCaseInstanceByKey("testCase");
        CaseExecution caseExecution = (CaseExecution)this.engineRule.getCaseService().createCaseExecutionQuery().activityId("PI_ProcessTask_1").singleResult();
        this.engineRule.getCaseService().manuallyStartCaseExecution(caseExecution.getId());
        Assert.assertThat((Object)tenantIdProvider.parameters.size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void providerNotCalledForProcessDefinitionWithTenantId_ProcessTask() {
        ContextLoggingTenantIdProvider tenantIdProvider = new ContextLoggingTenantIdProvider();
        TestTenantIdProvider.delegate = tenantIdProvider;
        this.testRule.deployForTenant(TENANT_ID, Bpmn.createExecutableProcess((String)PROCESS_DEFINITION_KEY).startEvent().userTask().done(), "org/camunda/bpm/engine/test/api/multitenancy/CaseWithProcessTask.cmmn");
        this.engineRule.getCaseService().createCaseInstanceByKey("testCase");
        CaseExecution caseExecution = (CaseExecution)this.engineRule.getCaseService().createCaseExecutionQuery().activityId("PI_ProcessTask_1").singleResult();
        this.engineRule.getCaseService().manuallyStartCaseExecution(caseExecution.getId());
        Assert.assertThat((Object)tenantIdProvider.parameters.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void providerCalledWithVariables_ProcessTask() {
        ContextLoggingTenantIdProvider tenantIdProvider = new ContextLoggingTenantIdProvider();
        TestTenantIdProvider.delegate = tenantIdProvider;
        this.testRule.deploy(Bpmn.createExecutableProcess((String)PROCESS_DEFINITION_KEY).startEvent().userTask().done(), "org/camunda/bpm/engine/test/api/multitenancy/CaseWithProcessTask.cmmn");
        this.engineRule.getCaseService().createCaseInstanceByKey("testCase", (Map)Variables.createVariables().putValue("varName", (Object)true));
        CaseExecution caseExecution = (CaseExecution)this.engineRule.getCaseService().createCaseExecutionQuery().activityId("PI_ProcessTask_1").singleResult();
        this.engineRule.getCaseService().manuallyStartCaseExecution(caseExecution.getId());
        Assert.assertThat((Object)tenantIdProvider.parameters.size(), (Matcher)CoreMatchers.is((Object)1));
        VariableMap variables = tenantIdProvider.parameters.get(0).getVariables();
        Assert.assertThat((Object)variables.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)((Boolean)variables.get((Object)"varName")), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void providerCalledWithProcessDefinition_ProcessTask() {
        ContextLoggingTenantIdProvider tenantIdProvider = new ContextLoggingTenantIdProvider();
        TestTenantIdProvider.delegate = tenantIdProvider;
        this.testRule.deploy(Bpmn.createExecutableProcess((String)PROCESS_DEFINITION_KEY).startEvent().userTask().done(), "org/camunda/bpm/engine/test/api/multitenancy/CaseWithProcessTask.cmmn");
        this.engineRule.getCaseService().createCaseInstanceByKey("testCase");
        CaseExecution caseExecution = (CaseExecution)this.engineRule.getCaseService().createCaseExecutionQuery().activityId("PI_ProcessTask_1").singleResult();
        this.engineRule.getCaseService().manuallyStartCaseExecution(caseExecution.getId());
        Assert.assertThat((Object)tenantIdProvider.parameters.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)tenantIdProvider.parameters.get(0).getProcessDefinition(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void providerCalledWithSuperCaseExecution() {
        ContextLoggingTenantIdProvider tenantIdProvider = new ContextLoggingTenantIdProvider();
        TestTenantIdProvider.delegate = tenantIdProvider;
        this.testRule.deploy(Bpmn.createExecutableProcess((String)PROCESS_DEFINITION_KEY).startEvent().userTask().done(), "org/camunda/bpm/engine/test/api/multitenancy/CaseWithProcessTask.cmmn");
        this.engineRule.getCaseService().createCaseInstanceByKey("testCase");
        CaseExecution caseExecution = (CaseExecution)this.engineRule.getCaseService().createCaseExecutionQuery().activityId("PI_ProcessTask_1").singleResult();
        this.engineRule.getCaseService().manuallyStartCaseExecution(caseExecution.getId());
        Assert.assertThat((Object)tenantIdProvider.parameters.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)tenantIdProvider.parameters.get(0).getSuperCaseExecution(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void providerCalledForDecisionDefinitionWithoutTenantId() {
        ContextLoggingTenantIdProvider tenantIdProvider = new ContextLoggingTenantIdProvider();
        TestTenantIdProvider.delegate = tenantIdProvider;
        this.testRule.deploy(DMN_FILE);
        this.engineRule.getDecisionService().evaluateDecisionTableByKey(DECISION_DEFINITION_KEY).variables((Map)this.createVariables()).evaluate();
        Assert.assertThat((Object)tenantIdProvider.dmnParameters.size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void providerNotCalledForDecisionDefinitionWithTenantId() {
        ContextLoggingTenantIdProvider tenantIdProvider = new ContextLoggingTenantIdProvider();
        TestTenantIdProvider.delegate = tenantIdProvider;
        this.testRule.deployForTenant(TENANT_ID, DMN_FILE);
        this.engineRule.getDecisionService().evaluateDecisionTableByKey(DECISION_DEFINITION_KEY).variables((Map)this.createVariables()).evaluate();
        Assert.assertThat((Object)tenantIdProvider.dmnParameters.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void providerCalledWithDecisionDefinition() {
        ContextLoggingTenantIdProvider tenantIdProvider = new ContextLoggingTenantIdProvider();
        TestTenantIdProvider.delegate = tenantIdProvider;
        this.testRule.deploy(DMN_FILE);
        DecisionDefinition deployedDecisionDefinition = (DecisionDefinition)this.engineRule.getRepositoryService().createDecisionDefinitionQuery().singleResult();
        this.engineRule.getDecisionService().evaluateDecisionTableByKey(DECISION_DEFINITION_KEY).variables((Map)this.createVariables()).evaluate();
        DecisionDefinition passedDecisionDefinition = tenantIdProvider.dmnParameters.get(0).getDecisionDefinition();
        Assert.assertThat((Object)passedDecisionDefinition, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)passedDecisionDefinition.getId(), (Matcher)CoreMatchers.is((Object)deployedDecisionDefinition.getId()));
    }

    @Test
    public void setsTenantIdForHistoricDecisionInstance() {
        String tenantId = TENANT_ID;
        StaticTenantIdTestProvider tenantIdProvider = new StaticTenantIdTestProvider(tenantId);
        TestTenantIdProvider.delegate = tenantIdProvider;
        this.testRule.deploy(DMN_FILE);
        this.engineRule.getDecisionService().evaluateDecisionTableByKey(DECISION_DEFINITION_KEY).variables((Map)this.createVariables()).evaluate();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.engineRule.getHistoryService().createHistoricDecisionInstanceQuery().singleResult();
        Assert.assertThat((Object)historicDecisionInstance.getTenantId(), (Matcher)CoreMatchers.is((Object)tenantId));
    }

    @Test
    public void setNullTenantIdForHistoricDecisionInstance() {
        String tenantId = null;
        StaticTenantIdTestProvider tenantIdProvider = new StaticTenantIdTestProvider(tenantId);
        TestTenantIdProvider.delegate = tenantIdProvider;
        this.testRule.deploy(DMN_FILE);
        this.engineRule.getDecisionService().evaluateDecisionTableByKey(DECISION_DEFINITION_KEY).variables((Map)this.createVariables()).evaluate();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.engineRule.getHistoryService().createHistoricDecisionInstanceQuery().singleResult();
        Assert.assertThat((Object)historicDecisionInstance.getTenantId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void providerCalledForHistoricDecisionDefinitionWithoutTenantId_BusinessRuleTask() {
        ContextLoggingTenantIdProvider tenantIdProvider = new ContextLoggingTenantIdProvider();
        TestTenantIdProvider.delegate = tenantIdProvider;
        BpmnModelInstance process = ((BusinessRuleTaskBuilder)Bpmn.createExecutableProcess((String)PROCESS_DEFINITION_KEY).startEvent().businessRuleTask().camundaDecisionRef(DECISION_DEFINITION_KEY)).endEvent().done();
        this.testRule.deploy(process, DMN_FILE);
        this.engineRule.getRuntimeService().startProcessInstanceByKey(PROCESS_DEFINITION_KEY, (Map)this.createVariables());
        Assert.assertThat((Object)tenantIdProvider.dmnParameters.size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void providerNotCalledForHistoricDecisionDefinitionWithTenantId_BusinessRuleTask() {
        ContextLoggingTenantIdProvider tenantIdProvider = new ContextLoggingTenantIdProvider();
        TestTenantIdProvider.delegate = tenantIdProvider;
        this.testRule.deployForTenant(TENANT_ID, ((BusinessRuleTaskBuilder)Bpmn.createExecutableProcess((String)PROCESS_DEFINITION_KEY).startEvent().businessRuleTask().camundaDecisionRef(DECISION_DEFINITION_KEY)).endEvent().done(), DMN_FILE);
        this.engineRule.getRuntimeService().startProcessInstanceByKey(PROCESS_DEFINITION_KEY, (Map)this.createVariables());
        Assert.assertThat((Object)tenantIdProvider.dmnParameters.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void providerCalledWithExecution_BusinessRuleTasks() {
        ContextLoggingTenantIdProvider tenantIdProvider = new ContextLoggingTenantIdProvider();
        TestTenantIdProvider.delegate = tenantIdProvider;
        BpmnModelInstance process = ((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)Bpmn.createExecutableProcess((String)PROCESS_DEFINITION_KEY).startEvent().businessRuleTask().camundaDecisionRef(DECISION_DEFINITION_KEY)).camundaAsyncAfter()).endEvent().done();
        this.testRule.deploy(process, DMN_FILE);
        this.engineRule.getRuntimeService().startProcessInstanceByKey(PROCESS_DEFINITION_KEY, (Map)this.createVariables());
        Execution execution = (Execution)this.engineRule.getRuntimeService().createExecutionQuery().processDefinitionKey(PROCESS_DEFINITION_KEY).singleResult();
        Assert.assertThat((Object)tenantIdProvider.dmnParameters.size(), (Matcher)CoreMatchers.is((Object)1));
        ExecutionEntity passedExecution = (ExecutionEntity)tenantIdProvider.dmnParameters.get(0).getExecution();
        Assert.assertThat((Object)passedExecution, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)passedExecution.getParent().getId(), (Matcher)CoreMatchers.is((Object)execution.getId()));
    }

    @Test
    public void setsTenantIdForHistoricDecisionInstance_BusinessRuleTask() {
        String tenantId = TENANT_ID;
        SetValueOnHistoricDecisionInstanceTenantIdProvider tenantIdProvider = new SetValueOnHistoricDecisionInstanceTenantIdProvider(tenantId);
        TestTenantIdProvider.delegate = tenantIdProvider;
        BpmnModelInstance process = ((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)Bpmn.createExecutableProcess((String)PROCESS_DEFINITION_KEY).startEvent().businessRuleTask().camundaDecisionRef(DECISION_DEFINITION_KEY)).camundaAsyncAfter()).endEvent().done();
        this.testRule.deploy(process, DMN_FILE);
        ((ProcessInstantiationBuilder)this.engineRule.getRuntimeService().createProcessInstanceByKey(PROCESS_DEFINITION_KEY).setVariables((Map)this.createVariables())).execute();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.engineRule.getHistoryService().createHistoricDecisionInstanceQuery().decisionDefinitionKey(DECISION_DEFINITION_KEY).singleResult();
        Assert.assertThat((Object)historicDecisionInstance.getTenantId(), (Matcher)CoreMatchers.is((Object)tenantId));
    }

    @Test
    public void setNullTenantIdForHistoricDecisionInstance_BusinessRuleTask() {
        String tenantId = null;
        SetValueOnHistoricDecisionInstanceTenantIdProvider tenantIdProvider = new SetValueOnHistoricDecisionInstanceTenantIdProvider(tenantId);
        TestTenantIdProvider.delegate = tenantIdProvider;
        BpmnModelInstance process = ((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)Bpmn.createExecutableProcess((String)PROCESS_DEFINITION_KEY).startEvent().businessRuleTask().camundaDecisionRef(DECISION_DEFINITION_KEY)).camundaAsyncAfter()).endEvent().done();
        this.testRule.deploy(process, DMN_FILE);
        ((ProcessInstantiationBuilder)this.engineRule.getRuntimeService().createProcessInstanceByKey(PROCESS_DEFINITION_KEY).setVariables((Map)this.createVariables())).execute();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.engineRule.getHistoryService().createHistoricDecisionInstanceQuery().decisionDefinitionKey(DECISION_DEFINITION_KEY).singleResult();
        Assert.assertThat((Object)historicDecisionInstance.getTenantId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    protected VariableMap createVariables() {
        return Variables.createVariables().putValue("status", (Object)"gold");
    }

    @Test
    public void providerCalledForCaseDefinitionWithoutTenantId() {
        ContextLoggingTenantIdProvider tenantIdProvider = new ContextLoggingTenantIdProvider();
        TestTenantIdProvider.delegate = tenantIdProvider;
        this.testRule.deploy(CMMN_FILE);
        this.engineRule.getCaseService().withCaseDefinitionByKey(CASE_DEFINITION_KEY).create();
        Assert.assertThat((Object)tenantIdProvider.caseParameters.size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void providerNotCalledForCaseInstanceWithTenantId() {
        ContextLoggingTenantIdProvider tenantIdProvider = new ContextLoggingTenantIdProvider();
        TestTenantIdProvider.delegate = tenantIdProvider;
        this.testRule.deployForTenant(TENANT_ID, CMMN_FILE);
        this.engineRule.getCaseService().withCaseDefinitionByKey(CASE_DEFINITION_KEY).create();
        Assert.assertThat((Object)tenantIdProvider.caseParameters.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void providerCalledForCaseInstanceWithVariables() {
        ContextLoggingTenantIdProvider tenantIdProvider = new ContextLoggingTenantIdProvider();
        TestTenantIdProvider.delegate = tenantIdProvider;
        this.testRule.deploy(CMMN_FILE);
        this.engineRule.getCaseService().withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariables((Map)Variables.createVariables().putValue("varName", (Object)true)).create();
        Assert.assertThat((Object)tenantIdProvider.caseParameters.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)((Boolean)tenantIdProvider.caseParameters.get(0).getVariables().get((Object)"varName")), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void providerCalledWithCaseDefinition() {
        ContextLoggingTenantIdProvider tenantIdProvider = new ContextLoggingTenantIdProvider();
        TestTenantIdProvider.delegate = tenantIdProvider;
        this.testRule.deploy(CMMN_FILE);
        CaseDefinition deployedCaseDefinition = (CaseDefinition)this.engineRule.getRepositoryService().createCaseDefinitionQuery().singleResult();
        this.engineRule.getCaseService().withCaseDefinitionByKey(CASE_DEFINITION_KEY).create();
        CaseDefinition passedCaseDefinition = tenantIdProvider.caseParameters.get(0).getCaseDefinition();
        Assert.assertThat((Object)passedCaseDefinition, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)passedCaseDefinition.getId(), (Matcher)CoreMatchers.is((Object)deployedCaseDefinition.getId()));
    }

    @Test
    public void setsTenantIdForCaseInstance() {
        String tenantId = TENANT_ID;
        StaticTenantIdTestProvider tenantIdProvider = new StaticTenantIdTestProvider(tenantId);
        TestTenantIdProvider.delegate = tenantIdProvider;
        this.testRule.deploy(CMMN_FILE);
        this.engineRule.getCaseService().withCaseDefinitionByKey(CASE_DEFINITION_KEY).create();
        CaseInstance caseInstance = (CaseInstance)this.engineRule.getCaseService().createCaseInstanceQuery().singleResult();
        Assert.assertThat((Object)caseInstance.getTenantId(), (Matcher)CoreMatchers.is((Object)tenantId));
    }

    @Test
    public void setNullTenantIdForCaseInstance() {
        String tenantId = null;
        StaticTenantIdTestProvider tenantIdProvider = new StaticTenantIdTestProvider(tenantId);
        TestTenantIdProvider.delegate = tenantIdProvider;
        this.testRule.deploy(CMMN_FILE);
        this.engineRule.getCaseService().withCaseDefinitionByKey(CASE_DEFINITION_KEY).create();
        CaseInstance caseInstance = (CaseInstance)this.engineRule.getCaseService().createCaseInstanceQuery().singleResult();
        Assert.assertThat((Object)caseInstance.getTenantId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void providerCalledForCaseDefinitionWithoutTenantId_SubCaseInstance() {
        ContextLoggingTenantIdProvider tenantIdProvider = new ContextLoggingTenantIdProvider();
        TestTenantIdProvider.delegate = tenantIdProvider;
        this.testRule.deploy(CMMN_SUBPROCESS_FILE, CMMN_FILE);
        this.engineRule.getCaseService().withCaseDefinitionByKey(CASE_DEFINITION_KEY).create();
        this.startCaseTask();
        Assert.assertThat((Object)tenantIdProvider.caseParameters.size(), (Matcher)CoreMatchers.is((Object)2));
    }

    @Test
    public void providerNotCalledForCaseDefinitionWithTenantId_SubCaseInstance() {
        ContextLoggingTenantIdProvider tenantIdProvider = new ContextLoggingTenantIdProvider();
        TestTenantIdProvider.delegate = tenantIdProvider;
        this.testRule.deployForTenant(TENANT_ID, CMMN_SUBPROCESS_FILE, CMMN_FILE);
        this.engineRule.getCaseService().withCaseDefinitionByKey(CASE_DEFINITION_KEY).create();
        this.startCaseTask();
        Assert.assertThat((Object)tenantIdProvider.caseParameters.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void providerCalledWithVariables_SubCaseInstance() {
        ContextLoggingTenantIdProvider tenantIdProvider = new ContextLoggingTenantIdProvider();
        TestTenantIdProvider.delegate = tenantIdProvider;
        this.testRule.deploy(CMMN_SUBPROCESS_FILE, CMMN_VARIABLE_FILE);
        this.engineRule.getCaseService().withCaseDefinitionByKey(CASE_DEFINITION_KEY).setVariables((Map)Variables.createVariables().putValue("varName", (Object)true)).create();
        this.startCaseTask();
        Assert.assertThat((Object)tenantIdProvider.caseParameters.get(1).getVariables().size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)((Boolean)tenantIdProvider.caseParameters.get(1).getVariables().get((Object)"varName")), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void providerCalledWithCaseDefinition_SubCaseInstance() {
        ContextLoggingTenantIdProvider tenantIdProvider = new ContextLoggingTenantIdProvider();
        TestTenantIdProvider.delegate = tenantIdProvider;
        this.testRule.deploy(CMMN_SUBPROCESS_FILE, CMMN_FILE);
        CaseDefinition deployedCaseDefinition = (CaseDefinition)this.engineRule.getRepositoryService().createCaseDefinitionQuery().caseDefinitionKey("oneTaskCase").singleResult();
        this.engineRule.getCaseService().withCaseDefinitionByKey(CASE_DEFINITION_KEY).create();
        this.startCaseTask();
        CaseDefinition passedCaseDefinition = tenantIdProvider.caseParameters.get(1).getCaseDefinition();
        Assert.assertThat((Object)passedCaseDefinition, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)passedCaseDefinition.getId(), (Matcher)CoreMatchers.is((Object)deployedCaseDefinition.getId()));
    }

    @Test
    public void providerCalledWithSuperCaseInstance() {
        ContextLoggingTenantIdProvider tenantIdProvider = new ContextLoggingTenantIdProvider();
        TestTenantIdProvider.delegate = tenantIdProvider;
        this.testRule.deploy(CMMN_SUBPROCESS_FILE, CMMN_FILE);
        CaseDefinition superCaseDefinition = (CaseDefinition)this.engineRule.getRepositoryService().createCaseDefinitionQuery().caseDefinitionKey(CASE_DEFINITION_KEY).singleResult();
        this.engineRule.getCaseService().withCaseDefinitionByKey(CASE_DEFINITION_KEY).create();
        this.startCaseTask();
        DelegateCaseExecution superCaseExecution = tenantIdProvider.caseParameters.get(1).getSuperCaseExecution();
        Assert.assertThat((Object)superCaseExecution, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)superCaseExecution.getCaseDefinitionId(), (Matcher)CoreMatchers.is((Object)superCaseDefinition.getId()));
    }

    @Test
    public void setsTenantId_SubCaseInstance() {
        String tenantId = TENANT_ID;
        SetValueOnSubCaseInstanceTenantIdProvider tenantIdProvider = new SetValueOnSubCaseInstanceTenantIdProvider(tenantId);
        TestTenantIdProvider.delegate = tenantIdProvider;
        this.testRule.deploy(CMMN_SUBPROCESS_FILE, CMMN_FILE);
        this.engineRule.getCaseService().withCaseDefinitionByKey(CASE_DEFINITION_KEY).create();
        this.startCaseTask();
        CaseInstance subCaseInstance = (CaseInstance)this.engineRule.getCaseService().createCaseInstanceQuery().caseDefinitionKey("oneTaskCase").singleResult();
        Assert.assertThat((Object)subCaseInstance.getTenantId(), (Matcher)CoreMatchers.is((Object)tenantId));
        CaseInstance superCaseInstance = (CaseInstance)this.engineRule.getCaseService().createCaseInstanceQuery().caseDefinitionKey(CASE_DEFINITION_KEY).singleResult();
        Assert.assertThat((Object)superCaseInstance.getTenantId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void setNullTenantId_SubCaseInstance() {
        String tenantId = null;
        SetValueOnSubCaseInstanceTenantIdProvider tenantIdProvider = new SetValueOnSubCaseInstanceTenantIdProvider(tenantId);
        TestTenantIdProvider.delegate = tenantIdProvider;
        this.testRule.deploy(CMMN_SUBPROCESS_FILE, CMMN_FILE);
        this.engineRule.getCaseService().withCaseDefinitionByKey(CASE_DEFINITION_KEY).create();
        this.startCaseTask();
        CaseInstance caseInstance = (CaseInstance)this.engineRule.getCaseService().createCaseInstanceQuery().caseDefinitionKey("oneTaskCase").singleResult();
        Assert.assertThat((Object)caseInstance.getTenantId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void tenantIdInheritedFromSuperCaseInstance() {
        String tenantId = TENANT_ID;
        SetValueOnRootCaseInstanceTenantIdProvider tenantIdProvider = new SetValueOnRootCaseInstanceTenantIdProvider(tenantId);
        TestTenantIdProvider.delegate = tenantIdProvider;
        this.testRule.deploy(CMMN_SUBPROCESS_FILE, CMMN_FILE);
        this.engineRule.getCaseService().withCaseDefinitionByKey(CASE_DEFINITION_KEY).create();
        this.startCaseTask();
        CaseInstance caseInstance = (CaseInstance)this.engineRule.getCaseService().createCaseInstanceQuery().caseDefinitionKey("oneTaskCase").singleResult();
        Assert.assertThat((Object)caseInstance.getTenantId(), (Matcher)CoreMatchers.is((Object)tenantId));
    }

    @Test
    public void providerCalledForCaseInstanceWithSuperCaseExecution() {
        ContextLoggingTenantIdProvider tenantIdProvider = new ContextLoggingTenantIdProvider();
        TestTenantIdProvider.delegate = tenantIdProvider;
        this.testRule.deploy(CMMN_SUBPROCESS_FILE, CMMN_FILE);
        this.engineRule.getCaseService().withCaseDefinitionByKey(CASE_DEFINITION_KEY).create();
        this.startCaseTask();
        Assert.assertThat((Object)tenantIdProvider.caseParameters.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)tenantIdProvider.caseParameters.get(1).getSuperCaseExecution(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    protected void startCaseTask() {
        CaseExecution caseExecution = (CaseExecution)this.engineRule.getCaseService().createCaseExecutionQuery().activityId("PI_CaseTask_1").singleResult();
        this.engineRule.getCaseService().withCaseExecution(caseExecution.getId()).manualStart();
    }

    public static class SetValueOnRootCaseInstanceTenantIdProvider
    implements TenantIdProvider {
        private final String tenantIdToSet;

        public SetValueOnRootCaseInstanceTenantIdProvider(String tenantIdToSet) {
            this.tenantIdToSet = tenantIdToSet;
        }

        public String provideTenantIdForProcessInstance(TenantIdProviderProcessInstanceContext ctx) {
            return null;
        }

        public String provideTenantIdForHistoricDecisionInstance(TenantIdProviderHistoricDecisionInstanceContext ctx) {
            return null;
        }

        public String provideTenantIdForCaseInstance(TenantIdProviderCaseInstanceContext ctx) {
            return ctx.getSuperCaseExecution() == null ? this.tenantIdToSet : null;
        }
    }

    public static class SetValueOnSubCaseInstanceTenantIdProvider
    implements TenantIdProvider {
        private final String tenantIdToSet;

        public SetValueOnSubCaseInstanceTenantIdProvider(String tenantIdToSet) {
            this.tenantIdToSet = tenantIdToSet;
        }

        public String provideTenantIdForProcessInstance(TenantIdProviderProcessInstanceContext ctx) {
            return null;
        }

        public String provideTenantIdForHistoricDecisionInstance(TenantIdProviderHistoricDecisionInstanceContext ctx) {
            return null;
        }

        public String provideTenantIdForCaseInstance(TenantIdProviderCaseInstanceContext ctx) {
            return ctx.getSuperCaseExecution() != null ? this.tenantIdToSet : null;
        }
    }

    public static class SetValueOnHistoricDecisionInstanceTenantIdProvider
    implements TenantIdProvider {
        private final String tenantIdToSet;

        public SetValueOnHistoricDecisionInstanceTenantIdProvider(String tenantIdToSet) {
            this.tenantIdToSet = tenantIdToSet;
        }

        public String provideTenantIdForProcessInstance(TenantIdProviderProcessInstanceContext ctx) {
            return null;
        }

        public String provideTenantIdForHistoricDecisionInstance(TenantIdProviderHistoricDecisionInstanceContext ctx) {
            return ctx.getExecution() != null ? this.tenantIdToSet : null;
        }

        public String provideTenantIdForCaseInstance(TenantIdProviderCaseInstanceContext ctx) {
            return null;
        }
    }

    public static class SetValueOnRootProcessInstanceTenantIdProvider
    implements TenantIdProvider {
        private final String tenantIdToSet;

        public SetValueOnRootProcessInstanceTenantIdProvider(String tenantIdToSet) {
            this.tenantIdToSet = tenantIdToSet;
        }

        public String provideTenantIdForProcessInstance(TenantIdProviderProcessInstanceContext ctx) {
            return ctx.getSuperExecution() == null ? this.tenantIdToSet : null;
        }

        public String provideTenantIdForHistoricDecisionInstance(TenantIdProviderHistoricDecisionInstanceContext ctx) {
            return null;
        }

        public String provideTenantIdForCaseInstance(TenantIdProviderCaseInstanceContext ctx) {
            return null;
        }
    }

    public static class SetValueOnSubProcessInstanceTenantIdProvider
    implements TenantIdProvider {
        private final String tenantIdToSet;

        public SetValueOnSubProcessInstanceTenantIdProvider(String tenantIdToSet) {
            this.tenantIdToSet = tenantIdToSet;
        }

        public String provideTenantIdForProcessInstance(TenantIdProviderProcessInstanceContext ctx) {
            return ctx.getSuperExecution() != null ? this.tenantIdToSet : null;
        }

        public String provideTenantIdForHistoricDecisionInstance(TenantIdProviderHistoricDecisionInstanceContext ctx) {
            return null;
        }

        public String provideTenantIdForCaseInstance(TenantIdProviderCaseInstanceContext ctx) {
            return null;
        }
    }

    public static class ContextLoggingTenantIdProvider
    implements TenantIdProvider {
        protected List<TenantIdProviderProcessInstanceContext> parameters = new ArrayList<TenantIdProviderProcessInstanceContext>();
        protected List<TenantIdProviderHistoricDecisionInstanceContext> dmnParameters = new ArrayList<TenantIdProviderHistoricDecisionInstanceContext>();
        protected List<TenantIdProviderCaseInstanceContext> caseParameters = new ArrayList<TenantIdProviderCaseInstanceContext>();

        public String provideTenantIdForProcessInstance(TenantIdProviderProcessInstanceContext ctx) {
            this.parameters.add(ctx);
            return null;
        }

        public String provideTenantIdForHistoricDecisionInstance(TenantIdProviderHistoricDecisionInstanceContext ctx) {
            this.dmnParameters.add(ctx);
            return null;
        }

        public String provideTenantIdForCaseInstance(TenantIdProviderCaseInstanceContext ctx) {
            this.caseParameters.add(ctx);
            return null;
        }
    }

    public static class TestTenantIdProvider
    implements TenantIdProvider {
        protected static TenantIdProvider delegate;

        public String provideTenantIdForProcessInstance(TenantIdProviderProcessInstanceContext ctx) {
            if (delegate != null) {
                return delegate.provideTenantIdForProcessInstance(ctx);
            }
            return null;
        }

        public static void reset() {
            delegate = null;
        }

        public String provideTenantIdForHistoricDecisionInstance(TenantIdProviderHistoricDecisionInstanceContext ctx) {
            if (delegate != null) {
                return delegate.provideTenantIdForHistoricDecisionInstance(ctx);
            }
            return null;
        }

        public String provideTenantIdForCaseInstance(TenantIdProviderCaseInstanceContext ctx) {
            if (delegate != null) {
                return delegate.provideTenantIdForCaseInstance(ctx);
            }
            return null;
        }
    }
}

