/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.tenantcheck;

import java.io.InputStream;
import java.util.Arrays;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.dmn.DmnModelInstance;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MultiTenancyDecisionDefinitionCmdsTenantCheckTest {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String DMN_MODEL = "org/camunda/bpm/engine/test/api/multitenancy/simpleDecisionTable.dmn";
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    protected RepositoryService repositoryService;
    protected IdentityService identityService;
    protected ProcessEngineConfiguration processEngineConfiguration;
    protected String decisionDefinitionId;

    @Before
    public void setUp() {
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.repositoryService = this.engineRule.getRepositoryService();
        this.identityService = this.engineRule.getIdentityService();
        this.testRule.deployForTenant(TENANT_ONE, DMN_MODEL);
        this.decisionDefinitionId = ((DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().singleResult()).getId();
    }

    @Test
    public void failToGetDecisionModelNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Cannot get the decision definition");
        this.repositoryService.getDecisionModel(this.decisionDefinitionId);
    }

    @Test
    public void getDecisionModelWithAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        InputStream inputStream = this.repositoryService.getDecisionModel(this.decisionDefinitionId);
        Assert.assertThat((Object)inputStream, (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void getDecisionModelDisabledTenantCheck() {
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        InputStream inputStream = this.repositoryService.getDecisionModel(this.decisionDefinitionId);
        Assert.assertThat((Object)inputStream, (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void failToGetDecisionDiagramNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Cannot get the decision definition");
        this.repositoryService.getDecisionDiagram(this.decisionDefinitionId);
    }

    @Test
    public void getDecisionDiagramWithAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        InputStream inputStream = this.repositoryService.getDecisionDiagram(this.decisionDefinitionId);
        Assert.assertThat((Object)inputStream, (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void getDecisionDiagramDisabledTenantCheck() {
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        InputStream inputStream = this.repositoryService.getDecisionDiagram(this.decisionDefinitionId);
        Assert.assertThat((Object)inputStream, (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void failToGetDecisionDefinitionNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Cannot get the decision definition");
        this.repositoryService.getDecisionDefinition(this.decisionDefinitionId);
    }

    @Test
    public void getDecisionDefinitionWithAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        DecisionDefinition definition = this.repositoryService.getDecisionDefinition(this.decisionDefinitionId);
        Assert.assertThat((Object)definition.getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
    }

    @Test
    public void getDecisionDefinitionDisabledTenantCheck() {
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        DecisionDefinition definition = this.repositoryService.getDecisionDefinition(this.decisionDefinitionId);
        Assert.assertThat((Object)definition.getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
    }

    @Test
    public void failToGetDmnModelInstanceNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Cannot get the decision definition");
        this.repositoryService.getDmnModelInstance(this.decisionDefinitionId);
    }

    @Test
    public void getDmnModelInstanceWithAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        DmnModelInstance modelInstance = this.repositoryService.getDmnModelInstance(this.decisionDefinitionId);
        Assert.assertThat((Object)modelInstance, (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void getDmnModelInstanceDisabledTenantCheck() {
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        DmnModelInstance modelInstance = this.repositoryService.getDmnModelInstance(this.decisionDefinitionId);
        Assert.assertThat((Object)modelInstance, (Matcher)CoreMatchers.notNullValue());
    }
}

