/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime.migration;

import java.util.Date;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.migration.MigrationPlan;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.EventSubscription;
import org.camunda.bpm.engine.runtime.Incident;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.runtime.FailingDelegate;
import org.camunda.bpm.engine.test.api.runtime.migration.MigrationTestRule;
import org.camunda.bpm.engine.test.api.runtime.migration.ModifiableBpmnModelInstance;
import org.camunda.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.camunda.bpm.engine.test.util.ClockTestUtil;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.BoundaryEventBuilder;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.camunda.bpm.model.bpmn.builder.StartEventBuilder;
import org.camunda.bpm.model.bpmn.builder.SubProcessBuilder;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MigrationBoundaryEventsTest {
    public static final String AFTER_BOUNDARY_TASK = "afterBoundary";
    public static final String MESSAGE_NAME = "Message";
    public static final String SIGNAL_NAME = "Signal";
    public static final String TIMER_DATE = "2016-02-11T12:13:14Z";
    public static final String NEW_TIMER_DATE = "2018-02-11T12:13:14Z";
    protected ProcessEngineRule rule = new ProvidedProcessEngineRule();
    protected MigrationTestRule testHelper = new MigrationTestRule(this.rule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.rule).around((TestRule)this.testHelper);

    @Test
    public void testMigrateMessageBoundaryEventOnUserTask() {
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).activityBuilder("userTask").boundaryEvent("boundary").message(MESSAGE_NAME)).userTask(AFTER_BOUNDARY_TASK).endEvent().done();
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").mapActivities("boundary", "newBoundary").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertEventSubscriptionMigrated("boundary", "newBoundary", MESSAGE_NAME);
        this.testHelper.completeTask("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateMessageBoundaryEventOnUserTaskAndCorrelateMessage() {
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).activityBuilder("userTask").boundaryEvent("boundary").message(MESSAGE_NAME)).userTask(AFTER_BOUNDARY_TASK).endEvent().done();
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").mapActivities("boundary", "newBoundary").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.correlateMessage(MESSAGE_NAME);
        this.testHelper.completeTask(AFTER_BOUNDARY_TASK);
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateMessageBoundaryEventAndTriggerByOldMessageName() {
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).activityBuilder("userTask").boundaryEvent("boundary").message(MESSAGE_NAME)).userTask(AFTER_BOUNDARY_TASK).endEvent().done();
        BpmnModelInstance targetProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).activityBuilder("userTask").boundaryEvent("boundary").message("newMessage")).userTask(AFTER_BOUNDARY_TASK).endEvent().done();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").mapActivities("boundary", "boundary").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertEventSubscriptionMigrated("boundary", "boundary", MESSAGE_NAME);
        EventSubscription eventSubscription = (EventSubscription)this.rule.getRuntimeService().createEventSubscriptionQuery().eventName("newMessage").singleResult();
        Assert.assertNull((Object)eventSubscription);
        this.testHelper.correlateMessage(MESSAGE_NAME);
        this.testHelper.completeTask(AFTER_BOUNDARY_TASK);
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateMessageBoundaryEventOnScopeUserTask() {
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SCOPE_TASK_PROCESS).activityBuilder("userTask").boundaryEvent("boundary").message(MESSAGE_NAME)).userTask(AFTER_BOUNDARY_TASK).endEvent().done();
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").mapActivities("boundary", "newBoundary").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertEventSubscriptionMigrated("boundary", "newBoundary", MESSAGE_NAME);
        this.testHelper.completeTask("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateMessageBoundaryEventOnScopeUserTaskAndCorrelateMessage() {
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SCOPE_TASK_PROCESS).activityBuilder("userTask").boundaryEvent("boundary").message(MESSAGE_NAME)).userTask(AFTER_BOUNDARY_TASK).endEvent().done();
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").mapActivities("boundary", "newBoundary").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.correlateMessage(MESSAGE_NAME);
        this.testHelper.completeTask(AFTER_BOUNDARY_TASK);
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateMessageBoundaryEventOnConcurrentUserTask() {
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_GATEWAY_PROCESS).activityBuilder("userTask1").boundaryEvent("boundary").message(MESSAGE_NAME)).userTask(AFTER_BOUNDARY_TASK).endEvent().done();
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask1").mapActivities("boundary", "newBoundary").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertEventSubscriptionMigrated("boundary", "newBoundary", MESSAGE_NAME);
        this.testHelper.completeTask("userTask1");
        this.testHelper.completeTask("userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateMessageBoundaryEventOnConcurrentUserTaskAndCorrelateMessage() {
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_GATEWAY_PROCESS).activityBuilder("userTask1").boundaryEvent("boundary").message(MESSAGE_NAME)).userTask(AFTER_BOUNDARY_TASK).endEvent().done();
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask1").mapActivities("boundary", "newBoundary").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.correlateMessage(MESSAGE_NAME);
        this.testHelper.completeTask(AFTER_BOUNDARY_TASK);
        this.testHelper.completeTask("userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateMessageBoundaryEventOnConcurrentScopeUserTask() {
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_SCOPE_TASKS).activityBuilder("userTask1").boundaryEvent("boundary").message(MESSAGE_NAME)).userTask(AFTER_BOUNDARY_TASK).endEvent().done();
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask1").mapActivities("boundary", "newBoundary").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertEventSubscriptionMigrated("boundary", "newBoundary", MESSAGE_NAME);
        this.testHelper.completeTask("userTask1");
        this.testHelper.completeTask("userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateMessageBoundaryEventOnConcurrentScopeUserTaskAndCorrelateMessage() {
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_SCOPE_TASKS).activityBuilder("userTask1").boundaryEvent("boundary").message(MESSAGE_NAME)).userTask(AFTER_BOUNDARY_TASK).endEvent().done();
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask1").mapActivities("boundary", "newBoundary").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.correlateMessage(MESSAGE_NAME);
        this.testHelper.completeTask(AFTER_BOUNDARY_TASK);
        this.testHelper.completeTask("userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateMessageBoundaryEventToSubProcess() {
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).activityBuilder("subProcess").boundaryEvent("boundary").message(MESSAGE_NAME)).userTask(AFTER_BOUNDARY_TASK).endEvent().done();
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("boundary", "newBoundary").mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertEventSubscriptionMigrated("boundary", "newBoundary", MESSAGE_NAME);
        this.testHelper.completeTask("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateMessageBoundaryEventToSubProcessAndCorrelateMessage() {
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).activityBuilder("subProcess").boundaryEvent("boundary").message(MESSAGE_NAME)).userTask(AFTER_BOUNDARY_TASK).endEvent().done();
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("boundary", "newBoundary").mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.correlateMessage(MESSAGE_NAME);
        this.testHelper.completeTask(AFTER_BOUNDARY_TASK);
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateMessageBoundaryEventToSubProcessWithScopeUserTask() {
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SCOPE_TASK_SUBPROCESS_PROCESS).activityBuilder("subProcess").boundaryEvent("boundary").message(MESSAGE_NAME)).userTask(AFTER_BOUNDARY_TASK).endEvent().done();
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("boundary", "newBoundary").mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertEventSubscriptionMigrated("boundary", "newBoundary", MESSAGE_NAME);
        this.testHelper.completeTask("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateMessageBoundaryEventToSubProcessWithScopeUserTaskAndCorrelateMessage() {
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SCOPE_TASK_SUBPROCESS_PROCESS).activityBuilder("subProcess").boundaryEvent("boundary").message(MESSAGE_NAME)).userTask(AFTER_BOUNDARY_TASK).endEvent().done();
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("boundary", "newBoundary").mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.correlateMessage(MESSAGE_NAME);
        this.testHelper.completeTask(AFTER_BOUNDARY_TASK);
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateMessageBoundaryEventToParallelSubProcess() {
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_SUBPROCESS_PROCESS).activityBuilder("subProcess1").boundaryEvent("boundary").message(MESSAGE_NAME)).userTask(AFTER_BOUNDARY_TASK).endEvent().done();
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess1", "subProcess1").mapActivities("boundary", "newBoundary").mapActivities("subProcess2", "subProcess2").mapActivities("userTask1", "userTask1").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertEventSubscriptionMigrated("boundary", "newBoundary", MESSAGE_NAME);
        this.testHelper.completeTask("userTask1");
        this.testHelper.completeTask("userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateMessageBoundaryEventToParallelSubProcessAndCorrelateMessage() {
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_SUBPROCESS_PROCESS).activityBuilder("subProcess1").boundaryEvent("boundary").message(MESSAGE_NAME)).userTask(AFTER_BOUNDARY_TASK).endEvent().done();
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess1", "subProcess1").mapActivities("boundary", "newBoundary").mapActivities("subProcess2", "subProcess2").mapActivities("userTask1", "userTask1").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.correlateMessage(MESSAGE_NAME);
        this.testHelper.completeTask(AFTER_BOUNDARY_TASK);
        this.testHelper.completeTask("userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateSignalBoundaryEventOnUserTask() {
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).activityBuilder("userTask").boundaryEvent("boundary").signal(SIGNAL_NAME)).userTask(AFTER_BOUNDARY_TASK).endEvent().done();
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").mapActivities("boundary", "newBoundary").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertEventSubscriptionMigrated("boundary", "newBoundary", SIGNAL_NAME);
        this.testHelper.completeTask("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateSignalBoundaryEventOnUserTaskAndCorrelateSignal() {
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).activityBuilder("userTask").boundaryEvent("boundary").signal(SIGNAL_NAME)).userTask(AFTER_BOUNDARY_TASK).endEvent().done();
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").mapActivities("boundary", "newBoundary").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.sendSignal(SIGNAL_NAME);
        this.testHelper.completeTask(AFTER_BOUNDARY_TASK);
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateSignalBoundaryEventOnUserTaskAndSendOldSignalName() {
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).activityBuilder("userTask").boundaryEvent("boundary").signal(SIGNAL_NAME)).userTask(AFTER_BOUNDARY_TASK).endEvent().done();
        BpmnModelInstance targetProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).activityBuilder("userTask").boundaryEvent("boundary").signal("newSignal")).userTask(AFTER_BOUNDARY_TASK).endEvent().done();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").mapActivities("boundary", "boundary").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertEventSubscriptionMigrated("boundary", "boundary", SIGNAL_NAME);
        EventSubscription eventSubscription = (EventSubscription)this.rule.getRuntimeService().createEventSubscriptionQuery().eventName("newSignal").singleResult();
        Assert.assertNull((Object)eventSubscription);
        this.testHelper.sendSignal(SIGNAL_NAME);
        this.testHelper.completeTask(AFTER_BOUNDARY_TASK);
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateSignalBoundaryEventOnScopeUserTask() {
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SCOPE_TASK_PROCESS).activityBuilder("userTask").boundaryEvent("boundary").signal(SIGNAL_NAME)).userTask(AFTER_BOUNDARY_TASK).endEvent().done();
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").mapActivities("boundary", "newBoundary").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertEventSubscriptionMigrated("boundary", "newBoundary", SIGNAL_NAME);
        this.testHelper.completeTask("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateSignalBoundaryEventOnScopeUserTaskAndCorrelateSignal() {
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SCOPE_TASK_PROCESS).activityBuilder("userTask").boundaryEvent("boundary").signal(SIGNAL_NAME)).userTask(AFTER_BOUNDARY_TASK).endEvent().done();
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").mapActivities("boundary", "newBoundary").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.sendSignal(SIGNAL_NAME);
        this.testHelper.completeTask(AFTER_BOUNDARY_TASK);
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateSignalBoundaryEventOnConcurrentUserTask() {
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_GATEWAY_PROCESS).activityBuilder("userTask1").boundaryEvent("boundary").signal(SIGNAL_NAME)).userTask(AFTER_BOUNDARY_TASK).endEvent().done();
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask1").mapActivities("boundary", "newBoundary").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertEventSubscriptionMigrated("boundary", "newBoundary", SIGNAL_NAME);
        this.testHelper.completeTask("userTask1");
        this.testHelper.completeTask("userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateSignalBoundaryEventOnConcurrentUserTaskAndCorrelateSignal() {
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_GATEWAY_PROCESS).activityBuilder("userTask1").boundaryEvent("boundary").signal(SIGNAL_NAME)).userTask(AFTER_BOUNDARY_TASK).endEvent().done();
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask1").mapActivities("boundary", "newBoundary").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.sendSignal(SIGNAL_NAME);
        this.testHelper.completeTask(AFTER_BOUNDARY_TASK);
        this.testHelper.completeTask("userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateSignalBoundaryEventOnConcurrentScopeUserTask() {
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_SCOPE_TASKS).activityBuilder("userTask1").boundaryEvent("boundary").signal(SIGNAL_NAME)).userTask(AFTER_BOUNDARY_TASK).endEvent().done();
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask1").mapActivities("boundary", "newBoundary").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertEventSubscriptionMigrated("boundary", "newBoundary", SIGNAL_NAME);
        this.testHelper.completeTask("userTask1");
        this.testHelper.completeTask("userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateSignalBoundaryEventOnConcurrentScopeUserTaskAndCorrelateSignal() {
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_SCOPE_TASKS).activityBuilder("userTask1").boundaryEvent("boundary").signal(SIGNAL_NAME)).userTask(AFTER_BOUNDARY_TASK).endEvent().done();
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask1").mapActivities("boundary", "newBoundary").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.sendSignal(SIGNAL_NAME);
        this.testHelper.completeTask(AFTER_BOUNDARY_TASK);
        this.testHelper.completeTask("userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateSignalBoundaryEventToSubProcess() {
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).activityBuilder("subProcess").boundaryEvent("boundary").signal(SIGNAL_NAME)).userTask(AFTER_BOUNDARY_TASK).endEvent().done();
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("boundary", "newBoundary").mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertEventSubscriptionMigrated("boundary", "newBoundary", SIGNAL_NAME);
        this.testHelper.completeTask("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateSignalBoundaryEventToSubProcessAndCorrelateSignal() {
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).activityBuilder("subProcess").boundaryEvent("boundary").signal(SIGNAL_NAME)).userTask(AFTER_BOUNDARY_TASK).endEvent().done();
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("boundary", "newBoundary").mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.sendSignal(SIGNAL_NAME);
        this.testHelper.completeTask(AFTER_BOUNDARY_TASK);
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateSignalBoundaryEventToSubProcessWithScopeUserTask() {
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SCOPE_TASK_SUBPROCESS_PROCESS).activityBuilder("subProcess").boundaryEvent("boundary").signal(SIGNAL_NAME)).userTask(AFTER_BOUNDARY_TASK).endEvent().done();
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("boundary", "newBoundary").mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertEventSubscriptionMigrated("boundary", "newBoundary", SIGNAL_NAME);
        this.testHelper.completeTask("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateSignalBoundaryEventToSubProcessWithScopeUserTaskAndCorrelateSignal() {
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SCOPE_TASK_SUBPROCESS_PROCESS).activityBuilder("subProcess").boundaryEvent("boundary").signal(SIGNAL_NAME)).userTask(AFTER_BOUNDARY_TASK).endEvent().done();
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("boundary", "newBoundary").mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.sendSignal(SIGNAL_NAME);
        this.testHelper.completeTask(AFTER_BOUNDARY_TASK);
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateSignalBoundaryEventToParallelSubProcess() {
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_SUBPROCESS_PROCESS).activityBuilder("subProcess1").boundaryEvent("boundary").signal(SIGNAL_NAME)).userTask(AFTER_BOUNDARY_TASK).endEvent().done();
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess1", "subProcess1").mapActivities("boundary", "newBoundary").mapActivities("subProcess2", "subProcess2").mapActivities("userTask1", "userTask1").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertEventSubscriptionMigrated("boundary", "newBoundary", SIGNAL_NAME);
        this.testHelper.completeTask("userTask1");
        this.testHelper.completeTask("userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateSignalBoundaryEventToParallelSubProcessAndCorrelateSignal() {
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_SUBPROCESS_PROCESS).activityBuilder("subProcess1").boundaryEvent("boundary").signal(SIGNAL_NAME)).userTask(AFTER_BOUNDARY_TASK).endEvent().done();
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess1", "subProcess1").mapActivities("boundary", "newBoundary").mapActivities("subProcess2", "subProcess2").mapActivities("userTask1", "userTask1").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.sendSignal(SIGNAL_NAME);
        this.testHelper.completeTask(AFTER_BOUNDARY_TASK);
        this.testHelper.completeTask("userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateTimerBoundaryEventOnUserTask() {
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).activityBuilder("userTask").boundaryEvent("boundary").timerWithDate(TIMER_DATE)).userTask(AFTER_BOUNDARY_TASK).endEvent().done();
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").mapActivities("boundary", "newBoundary").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertBoundaryTimerJobMigrated("boundary", "newBoundary");
        this.testHelper.completeTask("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateTimerBoundaryEventOnUserTaskAndTriggerTimer() {
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).activityBuilder("userTask").boundaryEvent("boundary").timerWithDate(TIMER_DATE)).userTask(AFTER_BOUNDARY_TASK).endEvent().done();
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").mapActivities("boundary", "newBoundary").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.triggerTimer();
        this.testHelper.completeTask(AFTER_BOUNDARY_TASK);
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateTimerBoundaryEventOnUserTaskAndTriggerTimerWithOldDueDate() {
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).activityBuilder("userTask").boundaryEvent("boundary").timerWithDate(TIMER_DATE)).userTask(AFTER_BOUNDARY_TASK).endEvent().done();
        BpmnModelInstance targetProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).activityBuilder("userTask").boundaryEvent("boundary").timerWithDate(NEW_TIMER_DATE)).userTask(AFTER_BOUNDARY_TASK).endEvent().done();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").mapActivities("boundary", "boundary").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertBoundaryTimerJobMigrated("boundary", "boundary");
        this.testHelper.triggerTimer();
        this.testHelper.completeTask(AFTER_BOUNDARY_TASK);
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateTimerBoundaryEventOnScopeUserTask() {
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SCOPE_TASK_PROCESS).activityBuilder("userTask").boundaryEvent("boundary").timerWithDate(TIMER_DATE)).userTask(AFTER_BOUNDARY_TASK).endEvent().done();
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").mapActivities("boundary", "newBoundary").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertBoundaryTimerJobMigrated("boundary", "newBoundary");
        this.testHelper.completeTask("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateTimerBoundaryEventOnScopeUserTaskAndTriggerTimer() {
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SCOPE_TASK_PROCESS).activityBuilder("userTask").boundaryEvent("boundary").timerWithDate(TIMER_DATE)).userTask(AFTER_BOUNDARY_TASK).endEvent().done();
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").mapActivities("boundary", "newBoundary").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.triggerTimer();
        this.testHelper.completeTask(AFTER_BOUNDARY_TASK);
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateTimerBoundaryEventOnConcurrentUserTask() {
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_GATEWAY_PROCESS).activityBuilder("userTask1").boundaryEvent("boundary").timerWithDate(TIMER_DATE)).userTask(AFTER_BOUNDARY_TASK).endEvent().done();
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask1").mapActivities("boundary", "newBoundary").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertBoundaryTimerJobMigrated("boundary", "newBoundary");
        this.testHelper.completeTask("userTask1");
        this.testHelper.completeTask("userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateTimerBoundaryEventOnConcurrentUserTaskAndTriggerTimer() {
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_GATEWAY_PROCESS).activityBuilder("userTask1").boundaryEvent("boundary").timerWithDate(TIMER_DATE)).userTask(AFTER_BOUNDARY_TASK).endEvent().done();
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask1").mapActivities("boundary", "newBoundary").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.triggerTimer();
        this.testHelper.completeTask(AFTER_BOUNDARY_TASK);
        this.testHelper.completeTask("userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateTimerBoundaryEventOnConcurrentScopeUserTask() {
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_SCOPE_TASKS).activityBuilder("userTask1").boundaryEvent("boundary").timerWithDate(TIMER_DATE)).userTask(AFTER_BOUNDARY_TASK).endEvent().done();
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask1").mapActivities("boundary", "newBoundary").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertBoundaryTimerJobMigrated("boundary", "newBoundary");
        this.testHelper.completeTask("userTask1");
        this.testHelper.completeTask("userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateTimerBoundaryEventOnConcurrentScopeUserTaskAndTriggerTimer() {
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_SCOPE_TASKS).activityBuilder("userTask1").boundaryEvent("boundary").timerWithDate(TIMER_DATE)).userTask(AFTER_BOUNDARY_TASK).endEvent().done();
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask1").mapActivities("boundary", "newBoundary").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.triggerTimer();
        this.testHelper.completeTask(AFTER_BOUNDARY_TASK);
        this.testHelper.completeTask("userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateTimerBoundaryEventToSubProcess() {
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).activityBuilder("subProcess").boundaryEvent("boundary").timerWithDate(TIMER_DATE)).userTask(AFTER_BOUNDARY_TASK).endEvent().done();
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("boundary", "newBoundary").mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertBoundaryTimerJobMigrated("boundary", "newBoundary");
        this.testHelper.completeTask("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateTimerBoundaryEventToSubProcessAndTriggerTimer() {
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).activityBuilder("subProcess").boundaryEvent("boundary").timerWithDate(TIMER_DATE)).userTask(AFTER_BOUNDARY_TASK).endEvent().done();
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("boundary", "newBoundary").mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.triggerTimer();
        this.testHelper.completeTask(AFTER_BOUNDARY_TASK);
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateTimerBoundaryEventToSubProcessWithScopeUserTask() {
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SCOPE_TASK_SUBPROCESS_PROCESS).activityBuilder("subProcess").boundaryEvent("boundary").timerWithDate(TIMER_DATE)).userTask(AFTER_BOUNDARY_TASK).endEvent().done();
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("boundary", "newBoundary").mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertBoundaryTimerJobMigrated("boundary", "newBoundary");
        this.testHelper.completeTask("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateTimerBoundaryEventToSubProcessWithScopeUserTaskAndTriggerTimer() {
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SCOPE_TASK_SUBPROCESS_PROCESS).activityBuilder("subProcess").boundaryEvent("boundary").timerWithDate(TIMER_DATE)).userTask(AFTER_BOUNDARY_TASK).endEvent().done();
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("boundary", "newBoundary").mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.triggerTimer();
        this.testHelper.completeTask(AFTER_BOUNDARY_TASK);
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateTimerBoundaryEventToParallelSubProcess() {
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_SUBPROCESS_PROCESS).activityBuilder("subProcess1").boundaryEvent("boundary").timerWithDate(TIMER_DATE)).userTask(AFTER_BOUNDARY_TASK).endEvent().done();
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess1", "subProcess1").mapActivities("boundary", "newBoundary").mapActivities("subProcess2", "subProcess2").mapActivities("userTask1", "userTask1").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertBoundaryTimerJobMigrated("boundary", "newBoundary");
        this.testHelper.completeTask("userTask1");
        this.testHelper.completeTask("userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateTimerBoundaryEventToParallelSubProcessAndTriggerTimer() {
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_SUBPROCESS_PROCESS).activityBuilder("subProcess1").boundaryEvent("boundary").timerWithDate(TIMER_DATE)).userTask(AFTER_BOUNDARY_TASK).endEvent().done();
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess1", "subProcess1").mapActivities("boundary", "newBoundary").mapActivities("subProcess2", "subProcess2").mapActivities("userTask1", "userTask1").mapActivities("userTask2", "userTask2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.triggerTimer();
        this.testHelper.completeTask(AFTER_BOUNDARY_TASK);
        this.testHelper.completeTask("userTask2");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateMultipleBoundaryEvents() {
        BpmnModelInstance testProcess = ((BoundaryEventBuilder)((BoundaryEventBuilder)((BoundaryEventBuilder)((BoundaryEventBuilder)((BoundaryEventBuilder)((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).activityBuilder("subProcess").boundaryEvent("timerBoundary1").timerWithDate(TIMER_DATE)).moveToActivity("subProcess").boundaryEvent("messageBoundary1").message(MESSAGE_NAME)).moveToActivity("subProcess").boundaryEvent("signalBoundary1").signal(SIGNAL_NAME)).moveToActivity("userTask").boundaryEvent("timerBoundary2").timerWithDate(TIMER_DATE)).moveToActivity("userTask").boundaryEvent("messageBoundary2").message(MESSAGE_NAME)).moveToActivity("userTask").boundaryEvent("signalBoundary2").signal(SIGNAL_NAME)).done();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(testProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(testProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("timerBoundary1", "timerBoundary1").mapActivities("signalBoundary1", "signalBoundary1").mapActivities("userTask", "userTask").mapActivities("messageBoundary2", "messageBoundary2").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertEventSubscriptionRemoved("messageBoundary1", MESSAGE_NAME);
        this.testHelper.assertEventSubscriptionRemoved("signalBoundary2", SIGNAL_NAME);
        this.testHelper.assertEventSubscriptionMigrated("signalBoundary1", "signalBoundary1", SIGNAL_NAME);
        this.testHelper.assertEventSubscriptionMigrated("messageBoundary2", "messageBoundary2", MESSAGE_NAME);
        this.testHelper.assertEventSubscriptionCreated("messageBoundary1", MESSAGE_NAME);
        this.testHelper.assertEventSubscriptionCreated("signalBoundary2", SIGNAL_NAME);
        this.testHelper.assertBoundaryTimerJobRemoved("timerBoundary2");
        this.testHelper.assertBoundaryTimerJobMigrated("timerBoundary1", "timerBoundary1");
        this.testHelper.assertBoundaryTimerJobCreated("timerBoundary2");
        this.testHelper.completeTask("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateBoundaryEventAndEventSubProcess() {
        BpmnModelInstance testProcess = ((BoundaryEventBuilder)((StartEventBuilder)((SubProcessBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.SUBPROCESS_PROCESS).addSubProcessTo("subProcess").triggerByEvent()).embeddedSubProcess().startEvent("eventStart").message(MESSAGE_NAME)).endEvent().subProcessDone().moveToActivity("userTask").boundaryEvent("boundary").signal(SIGNAL_NAME)).done();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(testProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(testProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("boundary", "boundary").mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertEventSubscriptionRemoved("eventStart", MESSAGE_NAME);
        this.testHelper.assertEventSubscriptionMigrated("boundary", "boundary", SIGNAL_NAME);
        this.testHelper.assertEventSubscriptionCreated("eventStart", MESSAGE_NAME);
        this.testHelper.completeTask("userTask");
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testMigrateIncidentForJob() {
        BpmnModelInstance sourceProcess = ((ServiceTaskBuilder)((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).userTaskBuilder("userTask").boundaryEvent("boundary").timerWithDate(TIMER_DATE)).serviceTask("failingTask").camundaClass(FailingDelegate.class.getName())).endEvent().done();
        ModifiableBpmnModelInstance targetProcess = ModifiableBpmnModelInstance.modify(sourceProcess).changeElementId("userTask", "newUserTask").changeElementId("boundary", "newBoundary");
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        Job jobBeforeMigration = (Job)this.rule.getManagementService().createJobQuery().singleResult();
        Assert.assertNotNull((Object)jobBeforeMigration);
        this.executeJob(jobBeforeMigration);
        Incident incidentBeforeMigration = (Incident)this.rule.getRuntimeService().createIncidentQuery().singleResult();
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "newUserTask").mapActivities("boundary", "newBoundary").build();
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        Job jobAfterMigration = (Job)this.rule.getManagementService().createJobQuery().jobId(jobBeforeMigration.getId()).singleResult();
        Assert.assertNotNull((Object)jobAfterMigration);
        Incident incidentAfterMigration = (Incident)this.rule.getRuntimeService().createIncidentQuery().singleResult();
        Assert.assertNotNull((Object)incidentAfterMigration);
        Assert.assertEquals((Object)incidentBeforeMigration.getId(), (Object)incidentAfterMigration.getId());
        Assert.assertEquals((Object)jobAfterMigration.getId(), (Object)incidentAfterMigration.getConfiguration());
        Assert.assertEquals((Object)"newBoundary", (Object)incidentAfterMigration.getActivityId());
        Assert.assertEquals((Object)targetProcessDefinition.getId(), (Object)incidentAfterMigration.getProcessDefinitionId());
        Assert.assertEquals((Object)jobAfterMigration.getJobDefinitionId(), (Object)incidentAfterMigration.getJobDefinitionId());
    }

    @Test
    public void testUpdateEventMessage() {
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).activityBuilder("userTask").boundaryEvent("boundary").message(MESSAGE_NAME)).userTask(AFTER_BOUNDARY_TASK).endEvent().done();
        BpmnModelInstance targetProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).activityBuilder("userTask").boundaryEvent("boundary").message("newMessage")).userTask(AFTER_BOUNDARY_TASK).endEvent().done();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").mapActivities("boundary", "boundary").updateEventTrigger().build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertEventSubscriptionMigrated("boundary", MESSAGE_NAME, "boundary", "newMessage");
        this.rule.getRuntimeService().correlateMessage("newMessage");
        this.testHelper.completeTask(AFTER_BOUNDARY_TASK);
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testUpdateEventSignal() {
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).activityBuilder("userTask").boundaryEvent("boundary").signal(SIGNAL_NAME)).userTask(AFTER_BOUNDARY_TASK).endEvent().done();
        BpmnModelInstance targetProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).activityBuilder("userTask").boundaryEvent("boundary").signal("newSignal")).userTask(AFTER_BOUNDARY_TASK).endEvent().done();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").mapActivities("boundary", "boundary").updateEventTrigger().build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertEventSubscriptionMigrated("boundary", SIGNAL_NAME, "boundary", "newSignal");
        this.rule.getRuntimeService().signalEventReceived("newSignal");
        this.testHelper.completeTask(AFTER_BOUNDARY_TASK);
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testUpdateEventTimer() {
        ClockTestUtil.setClockToDateWithoutMilliseconds();
        BpmnModelInstance sourceProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).activityBuilder("userTask").boundaryEvent("boundary").timerWithDate(TIMER_DATE)).userTask(AFTER_BOUNDARY_TASK).endEvent().done();
        BpmnModelInstance targetProcess = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).activityBuilder("userTask").boundaryEvent("boundary").timerWithDuration("PT50M")).userTask(AFTER_BOUNDARY_TASK).endEvent().done();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(sourceProcess);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(targetProcess);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").mapActivities("boundary", "boundary").updateEventTrigger().build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        Date newDueDate = new DateTime((Object)ClockUtil.getCurrentTime()).plusMinutes(50).toDate();
        this.testHelper.assertJobMigrated(this.testHelper.snapshotBeforeMigration.getJobs().get(0), "boundary", newDueDate);
        Job jobAfterMigration = this.testHelper.snapshotAfterMigration.getJobs().get(0);
        this.rule.getManagementService().executeJob(jobAfterMigration.getId());
        this.testHelper.completeTask(AFTER_BOUNDARY_TASK);
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    protected void executeJob(Job job) {
        ManagementService managementService = this.rule.getManagementService();
        while (job != null && job.getRetries() > 0) {
            try {
                managementService.executeJob(job.getId());
            }
            catch (Exception exception) {
                // empty catch block
            }
            job = (Job)managementService.createJobQuery().jobId(job.getId()).singleResult();
        }
    }
}

