/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.sequenceflow;

import java.util.Map;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.impl.util.CollectionUtil;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.bpmn.sequenceflow.ConditionalSequenceFlowTestOrder;

public class ConditionalSequenceFlowTest
extends PluggableProcessEngineTestCase {
    @Deployment
    public void testUelExpression() {
        Map variables = CollectionUtil.singletonMap((String)"input", (Object)"right");
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("condSeqFlowUelExpr", variables);
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(pi.getId()).singleResult();
        ConditionalSequenceFlowTest.assertNotNull((Object)task);
        ConditionalSequenceFlowTest.assertEquals((String)"task right", (String)task.getName());
    }

    @Deployment
    public void testValueAndMethodExpression() {
        ConditionalSequenceFlowTestOrder order = new ConditionalSequenceFlowTestOrder(150);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("uelExpressions", CollectionUtil.singletonMap((String)"order", (Object)order));
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        ConditionalSequenceFlowTest.assertEquals((String)"Standard service", (String)task.getName());
        order = new ConditionalSequenceFlowTestOrder(300);
        processInstance = this.runtimeService.startProcessInstanceByKey("uelExpressions", CollectionUtil.singletonMap((String)"order", (Object)order));
        task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        ConditionalSequenceFlowTest.assertEquals((String)"Premium service", (String)task.getName());
    }

    @Deployment
    public void testNoExpressionTrueThrowsException() {
        Map variables = CollectionUtil.singletonMap((String)"input", (Object)"non-existing-value");
        try {
            this.runtimeService.startProcessInstanceByKey("condSeqFlowUelExpr", variables);
            ConditionalSequenceFlowTest.fail((String)"Expected ProcessEngineException");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("No conditional sequence flow leaving the Flow Node 'theStart' could be selected for continuing the process", e.getMessage());
        }
    }
}

