/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.cmmn.sentry;

import org.camunda.bpm.engine.impl.cmmn.entity.runtime.CaseExecutionEntity;
import org.camunda.bpm.engine.impl.test.CmmnProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;

public class SentryExitCriteriaTest
extends CmmnProcessEngineTestCase {
    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/sentry/SentryExitCriteriaTest.testExitTask.cmmn"})
    public void testExitTask() {
        String caseInstanceId = this.createCaseInstance().getId();
        CaseExecution firstHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_1");
        String firstHumanTaskId = firstHumanTask.getId();
        SentryExitCriteriaTest.assertTrue((boolean)firstHumanTask.isEnabled());
        CaseExecution secondHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_2");
        String secondHumanTaskId = secondHumanTask.getId();
        SentryExitCriteriaTest.assertTrue((boolean)secondHumanTask.isEnabled());
        this.manualStart(firstHumanTaskId);
        secondHumanTask = this.queryCaseExecutionById(secondHumanTaskId);
        SentryExitCriteriaTest.assertTrue((boolean)secondHumanTask.isEnabled());
        SentryExitCriteriaTest.assertNull((Object)this.caseService.getVariable(caseInstanceId, "exit"));
        this.complete(firstHumanTaskId);
        secondHumanTask = this.queryCaseExecutionById(secondHumanTaskId);
        SentryExitCriteriaTest.assertNull((Object)secondHumanTask);
        Object exitVariable = this.caseService.getVariable(caseInstanceId, "exit");
        SentryExitCriteriaTest.assertNotNull((Object)exitVariable);
        SentryExitCriteriaTest.assertTrue((boolean)((Boolean)exitVariable));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/sentry/SentryExitCriteriaTest.testExitStage.cmmn"})
    public void testExitStage() {
        String caseInstanceId = this.createCaseInstance().getId();
        CaseExecution firstHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_1");
        String firstHumanTaskId = firstHumanTask.getId();
        SentryExitCriteriaTest.assertTrue((boolean)firstHumanTask.isEnabled());
        CaseExecution stage = this.queryCaseExecutionByActivityId("PI_Stage_1");
        String stageId = stage.getId();
        SentryExitCriteriaTest.assertTrue((boolean)stage.isEnabled());
        this.manualStart(stageId);
        stage = this.queryCaseExecutionById(stageId);
        SentryExitCriteriaTest.assertTrue((boolean)stage.isActive());
        CaseExecution milestone = this.queryCaseExecutionByActivityId("PI_Milestone_1");
        String milestoneId = milestone.getId();
        SentryExitCriteriaTest.assertTrue((boolean)milestone.isAvailable());
        CaseExecution secondHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_2");
        String secondHumanTaskId = secondHumanTask.getId();
        SentryExitCriteriaTest.assertTrue((boolean)secondHumanTask.isEnabled());
        this.manualStart(firstHumanTaskId);
        stage = this.queryCaseExecutionById(stageId);
        SentryExitCriteriaTest.assertTrue((boolean)stage.isActive());
        SentryExitCriteriaTest.assertNull((Object)this.caseService.getVariable(caseInstanceId, "exit"));
        SentryExitCriteriaTest.assertNull((Object)this.caseService.getVariable(caseInstanceId, "parentTerminate"));
        this.complete(firstHumanTaskId);
        stage = this.queryCaseExecutionById(stageId);
        SentryExitCriteriaTest.assertNull((Object)stage);
        milestone = this.queryCaseExecutionById(milestoneId);
        SentryExitCriteriaTest.assertNull((Object)milestone);
        secondHumanTask = this.queryCaseExecutionById(secondHumanTaskId);
        SentryExitCriteriaTest.assertNull((Object)secondHumanTask);
        Object exitVariable = this.caseService.getVariable(caseInstanceId, "exit");
        SentryExitCriteriaTest.assertNotNull((Object)exitVariable);
        SentryExitCriteriaTest.assertTrue((boolean)((Boolean)exitVariable));
        Object parentTerminateVariable = this.caseService.getVariable(caseInstanceId, "parentTerminate");
        SentryExitCriteriaTest.assertNotNull((Object)parentTerminateVariable);
        SentryExitCriteriaTest.assertTrue((boolean)((Boolean)parentTerminateVariable));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/sentry/SentryExitCriteriaTest.testAndJoin.cmmn"})
    public void testAndJoin() {
        String caseInstanceId = this.createCaseInstance().getId();
        CaseExecution firstHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_1");
        String firstHumanTaskId = firstHumanTask.getId();
        SentryExitCriteriaTest.assertTrue((boolean)firstHumanTask.isEnabled());
        CaseExecution secondHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_2");
        String secondHumanTaskId = secondHumanTask.getId();
        SentryExitCriteriaTest.assertTrue((boolean)secondHumanTask.isEnabled());
        CaseExecution thirdHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_3");
        String thirdHumanTaskId = thirdHumanTask.getId();
        SentryExitCriteriaTest.assertTrue((boolean)thirdHumanTask.isEnabled());
        this.manualStart(firstHumanTaskId);
        this.complete(firstHumanTaskId);
        thirdHumanTask = this.queryCaseExecutionById(thirdHumanTaskId);
        SentryExitCriteriaTest.assertTrue((boolean)thirdHumanTask.isEnabled());
        SentryExitCriteriaTest.assertNull((Object)this.caseService.getVariable(caseInstanceId, "exit"));
        this.manualStart(secondHumanTaskId);
        this.complete(secondHumanTaskId);
        thirdHumanTask = this.queryCaseExecutionById(thirdHumanTaskId);
        SentryExitCriteriaTest.assertNull((Object)thirdHumanTask);
        Object exitVariable = this.caseService.getVariable(caseInstanceId, "exit");
        SentryExitCriteriaTest.assertNotNull((Object)exitVariable);
        SentryExitCriteriaTest.assertTrue((boolean)((Boolean)exitVariable));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/sentry/SentryExitCriteriaTest.testAndFork.cmmn"})
    public void testAndFork() {
        this.createCaseInstance();
        CaseExecution firstHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_1");
        String firstHumanTaskId = firstHumanTask.getId();
        SentryExitCriteriaTest.assertTrue((boolean)firstHumanTask.isEnabled());
        CaseExecution secondHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_2");
        String secondHumanTaskId = secondHumanTask.getId();
        SentryExitCriteriaTest.assertTrue((boolean)secondHumanTask.isEnabled());
        CaseExecution thirdHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_3");
        String thirdHumanTaskId = thirdHumanTask.getId();
        SentryExitCriteriaTest.assertTrue((boolean)thirdHumanTask.isEnabled());
        this.manualStart(firstHumanTaskId);
        this.complete(firstHumanTaskId);
        secondHumanTask = this.queryCaseExecutionById(secondHumanTaskId);
        SentryExitCriteriaTest.assertNull((Object)secondHumanTask);
        thirdHumanTask = this.queryCaseExecutionById(thirdHumanTaskId);
        SentryExitCriteriaTest.assertNull((Object)thirdHumanTask);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/sentry/SentryExitCriteriaTest.testOrJoin.cmmn"})
    public void testOrJoin() {
        String caseInstanceId = this.createCaseInstance().getId();
        CaseExecution firstHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_1");
        String firstHumanTaskId = firstHumanTask.getId();
        SentryExitCriteriaTest.assertTrue((boolean)firstHumanTask.isEnabled());
        CaseExecution secondHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_2");
        String secondHumanTaskId = secondHumanTask.getId();
        SentryExitCriteriaTest.assertTrue((boolean)secondHumanTask.isEnabled());
        CaseExecution thirdHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_3");
        String thirdHumanTaskId = thirdHumanTask.getId();
        SentryExitCriteriaTest.assertTrue((boolean)thirdHumanTask.isEnabled());
        this.manualStart(firstHumanTaskId);
        this.complete(firstHumanTaskId);
        thirdHumanTask = this.queryCaseExecutionById(thirdHumanTaskId);
        SentryExitCriteriaTest.assertNull((Object)thirdHumanTask);
        Object exitVariable = this.caseService.getVariable(caseInstanceId, "exit");
        SentryExitCriteriaTest.assertNotNull((Object)exitVariable);
        SentryExitCriteriaTest.assertTrue((boolean)((Boolean)exitVariable));
        this.manualStart(secondHumanTaskId);
        this.complete(secondHumanTaskId);
        thirdHumanTask = this.queryCaseExecutionById(thirdHumanTaskId);
        SentryExitCriteriaTest.assertNull((Object)thirdHumanTask);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/sentry/SentryExitCriteriaTest.testOrFork.cmmn"})
    public void testOrFork() {
        this.createCaseInstance();
        CaseExecution firstHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_1");
        String firstHumanTaskId = firstHumanTask.getId();
        SentryExitCriteriaTest.assertTrue((boolean)firstHumanTask.isEnabled());
        CaseExecution secondHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_2");
        String secondHumanTaskId = secondHumanTask.getId();
        SentryExitCriteriaTest.assertTrue((boolean)secondHumanTask.isEnabled());
        CaseExecution thirdHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_3");
        String thirdHumanTaskId = thirdHumanTask.getId();
        SentryExitCriteriaTest.assertTrue((boolean)thirdHumanTask.isEnabled());
        this.manualStart(firstHumanTaskId);
        this.caseService.withCaseExecution(firstHumanTaskId).setVariable("value", (Object)80).complete();
        secondHumanTask = this.queryCaseExecutionById(secondHumanTaskId);
        SentryExitCriteriaTest.assertNotNull((Object)secondHumanTask);
        SentryExitCriteriaTest.assertTrue((boolean)secondHumanTask.isEnabled());
        thirdHumanTask = this.queryCaseExecutionById(thirdHumanTaskId);
        SentryExitCriteriaTest.assertNull((Object)thirdHumanTask);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/sentry/SentryExitCriteriaTest.testCycle.cmmn"})
    public void testCycle() {
        this.createCaseInstance();
        CaseExecution firstHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_1");
        String firstHumanTaskId = firstHumanTask.getId();
        SentryExitCriteriaTest.assertTrue((boolean)firstHumanTask.isEnabled());
        CaseExecution secondHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_2");
        String secondHumanTaskId = secondHumanTask.getId();
        SentryExitCriteriaTest.assertTrue((boolean)secondHumanTask.isEnabled());
        CaseExecution thirdHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_3");
        String thirdHumanTaskId = thirdHumanTask.getId();
        SentryExitCriteriaTest.assertTrue((boolean)thirdHumanTask.isEnabled());
        this.manualStart(firstHumanTaskId);
        this.complete(firstHumanTaskId);
        firstHumanTask = this.queryCaseExecutionById(firstHumanTaskId);
        SentryExitCriteriaTest.assertNull((Object)firstHumanTask);
        secondHumanTask = this.queryCaseExecutionById(secondHumanTaskId);
        SentryExitCriteriaTest.assertNull((Object)secondHumanTask);
        thirdHumanTask = this.queryCaseExecutionById(thirdHumanTaskId);
        SentryExitCriteriaTest.assertNull((Object)thirdHumanTask);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/sentry/SentryExitCriteriaTest.testCycleWithStage.cmmn"})
    public void testCycleWithStage() {
        String caseInstanceId = this.createCaseInstance().getId();
        CaseExecution stage = this.queryCaseExecutionByActivityId("PI_Stage_1");
        String stageId = stage.getId();
        this.manualStart(stageId);
        CaseExecution firstHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_1");
        String firstHumanTaskId = firstHumanTask.getId();
        SentryExitCriteriaTest.assertTrue((boolean)firstHumanTask.isEnabled());
        CaseExecution innerFirstHumanTask = this.queryCaseExecutionByActivityId("PI_Inner_HumanTask_1");
        String innerFirstHumanTaskId = innerFirstHumanTask.getId();
        SentryExitCriteriaTest.assertTrue((boolean)innerFirstHumanTask.isEnabled());
        CaseExecution innerSecondHumanTask = this.queryCaseExecutionByActivityId("PI_Inner_HumanTask_2");
        String innerSecondHumanTaskId = innerSecondHumanTask.getId();
        SentryExitCriteriaTest.assertTrue((boolean)innerSecondHumanTask.isEnabled());
        CaseExecution innerThirdHumanTask = this.queryCaseExecutionByActivityId("PI_Inner_HumanTask_3");
        String innerThirdHumanTaskId = innerThirdHumanTask.getId();
        SentryExitCriteriaTest.assertTrue((boolean)innerThirdHumanTask.isEnabled());
        this.suspend(stageId);
        stage = this.queryCaseExecutionById(stageId);
        SentryExitCriteriaTest.assertNull((Object)stage);
        firstHumanTask = this.queryCaseExecutionById(firstHumanTaskId);
        SentryExitCriteriaTest.assertNull((Object)firstHumanTask);
        innerFirstHumanTask = this.queryCaseExecutionById(innerFirstHumanTaskId);
        SentryExitCriteriaTest.assertNull((Object)innerFirstHumanTask);
        innerSecondHumanTask = this.queryCaseExecutionById(innerSecondHumanTaskId);
        SentryExitCriteriaTest.assertNull((Object)innerSecondHumanTask);
        innerThirdHumanTask = this.queryCaseExecutionById(innerThirdHumanTaskId);
        SentryExitCriteriaTest.assertNull((Object)innerThirdHumanTask);
        Object variable = this.caseService.getVariable(caseInstanceId, "parentSuspend");
        SentryExitCriteriaTest.assertNotNull((Object)variable);
        SentryExitCriteriaTest.assertTrue((boolean)((Boolean)variable));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/sentry/SentryExitCriteriaTest.testExitTaskWithIfPart.cmmn"})
    public void testExitTaskWithIfPartSatisfied() {
        this.createCaseInstance();
        CaseExecution firstHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_1");
        String firstHumanTaskId = firstHumanTask.getId();
        SentryExitCriteriaTest.assertTrue((boolean)firstHumanTask.isEnabled());
        CaseExecution secondHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_2");
        String secondHumanTaskId = secondHumanTask.getId();
        SentryExitCriteriaTest.assertTrue((boolean)secondHumanTask.isEnabled());
        this.manualStart(firstHumanTaskId);
        this.caseService.withCaseExecution(firstHumanTaskId).setVariable("value", (Object)100).complete();
        firstHumanTask = this.queryCaseExecutionById(firstHumanTaskId);
        SentryExitCriteriaTest.assertNull((Object)firstHumanTask);
        secondHumanTask = this.queryCaseExecutionById(secondHumanTaskId);
        SentryExitCriteriaTest.assertNull((Object)secondHumanTask);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/sentry/SentryExitCriteriaTest.testExitTaskWithIfPart.cmmn"})
    public void testExitTaskWithIfPartNotSatisfied() {
        this.createCaseInstance();
        CaseExecution firstHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_1");
        String firstHumanTaskId = firstHumanTask.getId();
        SentryExitCriteriaTest.assertTrue((boolean)firstHumanTask.isEnabled());
        CaseExecution secondHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_2");
        String secondHumanTaskId = secondHumanTask.getId();
        SentryExitCriteriaTest.assertTrue((boolean)secondHumanTask.isEnabled());
        this.manualStart(firstHumanTaskId);
        this.caseService.withCaseExecution(firstHumanTaskId).setVariable("value", (Object)99).complete();
        firstHumanTask = this.queryCaseExecutionById(firstHumanTaskId);
        SentryExitCriteriaTest.assertNull((Object)firstHumanTask);
        secondHumanTask = this.queryCaseExecutionById(secondHumanTaskId);
        SentryExitCriteriaTest.assertTrue((boolean)secondHumanTask.isEnabled());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/sentry/SentryExitCriteriaTest.testExitTaskByInstanceCreation.cmmn"})
    public void testExitTaskByInstanceCreation() {
        this.createCaseInstance();
        CaseExecution firstHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_1");
        SentryExitCriteriaTest.assertTrue((boolean)firstHumanTask.isEnabled());
        CaseExecution secondHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_2");
        SentryExitCriteriaTest.assertNull((Object)secondHumanTask);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/sentry/SentryExitCriteriaTest.testExitCriteriaOnCasePlanModel.cmmn"})
    public void testExitCriteriaOnCasePlanModel() {
        String caseInstanceId = this.createCaseInstance().getId();
        CaseExecution firstHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_1");
        String firstHumanTaskId = firstHumanTask.getId();
        SentryExitCriteriaTest.assertTrue((boolean)firstHumanTask.isEnabled());
        this.manualStart(firstHumanTaskId);
        this.complete(firstHumanTaskId);
        CaseExecution caseInstance = this.queryCaseExecutionById(caseInstanceId);
        SentryExitCriteriaTest.assertTrue((boolean)((CaseExecutionEntity)caseInstance).isTerminated());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/sentry/SentryExitCriteriaTest.testExitOnParentSuspendInsideStage.cmmn"})
    public void FAILING_testExitOnParentSuspendInsideStage() {
        this.createCaseInstance();
        CaseExecution stage = this.queryCaseExecutionByActivityId("PI_Stage_1");
        String stageId = stage.getId();
        this.manualStart(stageId);
        CaseExecution firstHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_1");
        String firstHumanTaskId = firstHumanTask.getId();
        SentryExitCriteriaTest.assertTrue((boolean)firstHumanTask.isEnabled());
        CaseExecution secondHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_2");
        String secondHumanTaskId = secondHumanTask.getId();
        SentryExitCriteriaTest.assertTrue((boolean)secondHumanTask.isEnabled());
        this.suspend(stageId);
        stage = this.queryCaseExecutionById(stageId);
        SentryExitCriteriaTest.assertTrue((boolean)((CaseExecutionEntity)stage).isSuspended());
        firstHumanTask = this.queryCaseExecutionById(firstHumanTaskId);
        SentryExitCriteriaTest.assertTrue((boolean)((CaseExecutionEntity)firstHumanTask).isSuspended());
        secondHumanTask = this.queryCaseExecutionById(secondHumanTaskId);
        SentryExitCriteriaTest.assertNull((Object)secondHumanTask);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/sentry/SentryExitCriteriaTest.testExitOnParentResumeInsideStage.cmmn"})
    public void FAILING_testExitOnParentResumeInsideStage() {
        this.createCaseInstance();
        CaseExecution stage = this.queryCaseExecutionByActivityId("PI_Stage_1");
        String stageId = stage.getId();
        this.manualStart(stageId);
        CaseExecution firstHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_1");
        String firstHumanTaskId = firstHumanTask.getId();
        SentryExitCriteriaTest.assertTrue((boolean)firstHumanTask.isEnabled());
        CaseExecution secondHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_2");
        String secondHumanTaskId = secondHumanTask.getId();
        SentryExitCriteriaTest.assertTrue((boolean)secondHumanTask.isEnabled());
        this.suspend(stageId);
        stage = this.queryCaseExecutionById(stageId);
        SentryExitCriteriaTest.assertTrue((boolean)((CaseExecutionEntity)stage).isSuspended());
        firstHumanTask = this.queryCaseExecutionById(firstHumanTaskId);
        SentryExitCriteriaTest.assertTrue((boolean)((CaseExecutionEntity)firstHumanTask).isSuspended());
        secondHumanTask = this.queryCaseExecutionById(secondHumanTaskId);
        SentryExitCriteriaTest.assertTrue((boolean)((CaseExecutionEntity)secondHumanTask).isSuspended());
        this.resume(stageId);
        stage = this.queryCaseExecutionById(stageId);
        SentryExitCriteriaTest.assertTrue((boolean)((CaseExecutionEntity)stage).isActive());
        firstHumanTask = this.queryCaseExecutionById(firstHumanTaskId);
        SentryExitCriteriaTest.assertTrue((boolean)firstHumanTask.isEnabled());
        secondHumanTask = this.queryCaseExecutionById(secondHumanTaskId);
        SentryExitCriteriaTest.assertNull((Object)secondHumanTask);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/sentry/SentryExitCriteriaTest.testExitDisabledTask.cmmn"})
    public void testExitDisabledTask() {
        this.createCaseInstance();
        CaseExecution firstHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_1");
        String firstHumanTaskId = firstHumanTask.getId();
        SentryExitCriteriaTest.assertTrue((boolean)firstHumanTask.isEnabled());
        CaseExecution secondHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_2");
        String secondHumanTaskId = secondHumanTask.getId();
        SentryExitCriteriaTest.assertTrue((boolean)secondHumanTask.isEnabled());
        this.disable(secondHumanTaskId);
        this.manualStart(firstHumanTaskId);
        firstHumanTask = this.queryCaseExecutionById(firstHumanTaskId);
        SentryExitCriteriaTest.assertTrue((boolean)firstHumanTask.isActive());
        secondHumanTask = this.queryCaseExecutionById(secondHumanTaskId);
        SentryExitCriteriaTest.assertNull((Object)secondHumanTask);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/sentry/SentryExitCriteriaTest.testExitDisabledTask.cmmn"})
    public void testExitSuspendedTask() {
        this.createCaseInstance();
        CaseExecution firstHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_1");
        String firstHumanTaskId = firstHumanTask.getId();
        SentryExitCriteriaTest.assertTrue((boolean)firstHumanTask.isEnabled());
        CaseExecution secondHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_2");
        String secondHumanTaskId = secondHumanTask.getId();
        SentryExitCriteriaTest.assertTrue((boolean)secondHumanTask.isEnabled());
        this.manualStart(secondHumanTaskId);
        this.suspend(secondHumanTaskId);
        this.manualStart(firstHumanTaskId);
        firstHumanTask = this.queryCaseExecutionById(firstHumanTaskId);
        SentryExitCriteriaTest.assertTrue((boolean)firstHumanTask.isActive());
        secondHumanTask = this.queryCaseExecutionById(secondHumanTaskId);
        SentryExitCriteriaTest.assertNull((Object)secondHumanTask);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/sentry/SentryExitCriteriaTest.testExitAvailableTask.cmmn"})
    public void testExitAvailableTask() {
        this.createCaseInstance();
        CaseExecution firstHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_1");
        String firstHumanTaskId = firstHumanTask.getId();
        SentryExitCriteriaTest.assertTrue((boolean)firstHumanTask.isEnabled());
        CaseExecution secondHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_2");
        String secondHumanTaskId = secondHumanTask.getId();
        SentryExitCriteriaTest.assertTrue((boolean)secondHumanTask.isAvailable());
        CaseExecution thirdHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_3");
        String thirdHumanTaskId = thirdHumanTask.getId();
        SentryExitCriteriaTest.assertTrue((boolean)thirdHumanTask.isEnabled());
        this.manualStart(firstHumanTaskId);
        firstHumanTask = this.queryCaseExecutionById(firstHumanTaskId);
        SentryExitCriteriaTest.assertTrue((boolean)firstHumanTask.isActive());
        secondHumanTask = this.queryCaseExecutionById(secondHumanTaskId);
        SentryExitCriteriaTest.assertNull((Object)secondHumanTask);
        thirdHumanTask = this.queryCaseExecutionById(thirdHumanTaskId);
        SentryExitCriteriaTest.assertTrue((boolean)thirdHumanTask.isEnabled());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/sentry/SentryExitCriteriaTest.testExitDisabledTask.cmmn"})
    public void testExitActiveTask() {
        this.createCaseInstance();
        CaseExecution firstHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_1");
        String firstHumanTaskId = firstHumanTask.getId();
        SentryExitCriteriaTest.assertTrue((boolean)firstHumanTask.isEnabled());
        CaseExecution secondHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_2");
        String secondHumanTaskId = secondHumanTask.getId();
        SentryExitCriteriaTest.assertTrue((boolean)secondHumanTask.isEnabled());
        this.manualStart(secondHumanTaskId);
        secondHumanTask = this.queryCaseExecutionById(secondHumanTaskId);
        SentryExitCriteriaTest.assertTrue((boolean)secondHumanTask.isActive());
        Task secondTask = (Task)this.taskService.createTaskQuery().singleResult();
        SentryExitCriteriaTest.assertNotNull((Object)secondTask);
        this.manualStart(firstHumanTaskId);
        firstHumanTask = this.queryCaseExecutionById(firstHumanTaskId);
        SentryExitCriteriaTest.assertTrue((boolean)firstHumanTask.isActive());
        secondHumanTask = this.queryCaseExecutionById(secondHumanTaskId);
        SentryExitCriteriaTest.assertNull((Object)secondHumanTask);
        secondTask = (Task)this.taskService.createTaskQuery().taskId(secondTask.getId()).singleResult();
        SentryExitCriteriaTest.assertNull((Object)secondTask);
    }
}

