/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.dmn.businessruletask;

import java.util.Map;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.exception.dmn.DecisionDefinitionNotFoundException;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.dmn.businessruletask.TestPojo;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.builder.BusinessRuleTaskBuilder;
import org.camunda.bpm.model.bpmn.builder.EndEventBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class DmnBusinessRuleTaskTest {
    public static final String DECISION_PROCESS = "org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionRef.bpmn20.xml";
    public static final String DECISION_PROCESS_EXPRESSION = "org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionRefExpression.bpmn20.xml";
    public static final String DECISION_PROCESS_LATEST = "org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionRefLatestBinding.bpmn20.xml";
    public static final String DECISION_PROCESS_DEPLOYMENT = "org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionRefDeploymentBinding.bpmn20.xml";
    public static final String DECISION_PROCESS_VERSION = "org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionRefVersionBinding.bpmn20.xml";
    public static final String DECISION_OKAY_DMN = "org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionOkay.dmn11.xml";
    public static final String DECISION_NOT_OKAY_DMN = "org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionNotOkay.dmn11.xml";
    public static final String DECISION_POJO_DMN = "org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testPojo.dmn11.xml";
    public static final String DRD_DISH_RESOURCE = "org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml";
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    protected RuntimeService runtimeService;

    @Before
    public void init() {
        this.runtimeService = this.engineRule.getRuntimeService();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionRef.bpmn20.xml", "org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionRefExpression.bpmn20.xml", "org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionOkay.dmn11.xml"})
    @Test
    public void decisionRef() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        Assert.assertEquals((Object)"okay", (Object)this.getDecisionResult(processInstance));
        processInstance = this.startExpressionProcess("testDecision", 1);
        Assert.assertEquals((Object)"okay", (Object)this.getDecisionResult(processInstance));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionRef.bpmn20.xml"})
    @Test
    public void noDecisionFound() {
        this.thrown.expect(DecisionDefinitionNotFoundException.class);
        this.thrown.expectMessage("no decision definition deployed with key 'testDecision'");
        this.runtimeService.startProcessInstanceByKey("testProcess");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionRefExpression.bpmn20.xml"})
    @Test
    public void noDecisionFoundRefByExpression() {
        this.thrown.expect(DecisionDefinitionNotFoundException.class);
        this.thrown.expectMessage("no decision definition deployed with key = 'testDecision', version = '1' and tenant-id 'null");
        this.startExpressionProcess("testDecision", 1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionRefLatestBinding.bpmn20.xml", "org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionOkay.dmn11.xml"})
    @Test
    public void decisionRefLatestBinding() {
        this.testRule.deploy(DECISION_NOT_OKAY_DMN);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        Assert.assertEquals((Object)"not okay", (Object)this.getDecisionResult(processInstance));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionRefDeploymentBinding.bpmn20.xml", "org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionOkay.dmn11.xml"})
    @Test
    public void decisionRefDeploymentBinding() {
        this.testRule.deploy(DECISION_NOT_OKAY_DMN);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        Assert.assertEquals((Object)"okay", (Object)this.getDecisionResult(processInstance));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionRefVersionBinding.bpmn20.xml", "org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionRefExpression.bpmn20.xml", "org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionOkay.dmn11.xml"})
    @Test
    public void decisionRefVersionBinding() {
        this.testRule.deploy(DECISION_NOT_OKAY_DMN);
        this.testRule.deploy(DECISION_OKAY_DMN);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        Assert.assertEquals((Object)"not okay", (Object)this.getDecisionResult(processInstance));
        processInstance = this.startExpressionProcess("testDecision", 2);
        Assert.assertEquals((Object)"not okay", (Object)this.getDecisionResult(processInstance));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionRef.bpmn20.xml", "org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testPojo.dmn11.xml"})
    @Test
    public void testPojo() {
        VariableMap variables = Variables.createVariables().putValue("pojo", (Object)new TestPojo("okay", 13.37));
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess", (Map)variables);
        Assert.assertEquals((Object)"okay", (Object)this.getDecisionResult(processInstance));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    @Test
    public void evaluateDecisionWithRequiredDecisions() {
        this.testRule.deploy(((EndEventBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().businessRuleTask().camundaDecisionRef("dish-decision")).camundaResultVariable("result")).camundaMapDecisionResult("singleEntry")).endEvent().camundaAsyncBefore()).done());
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process", (Map)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend"));
        Assert.assertEquals((Object)"Light salad", (Object)this.getDecisionResult(processInstance));
    }

    protected ProcessInstance startExpressionProcess(Object decisionKey, Object version) {
        VariableMap variables = Variables.createVariables().putValue("decision", decisionKey).putValue("version", version);
        return this.runtimeService.startProcessInstanceByKey("testProcessExpression", (Map)variables);
    }

    protected Object getDecisionResult(ProcessInstance processInstance) {
        return this.runtimeService.getVariable(processInstance.getId(), "result");
    }
}

