/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.dmn.deployment;

import java.io.InputStream;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.impl.util.IoUtil;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.repository.DecisionDefinitionQuery;
import org.camunda.bpm.engine.repository.DecisionRequirementsDefinition;
import org.camunda.bpm.engine.repository.DecisionRequirementsDefinitionQuery;
import org.camunda.bpm.engine.repository.DeploymentQuery;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class DecisionDefinitionDeployerTest {
    protected static final String DMN_CHECK_ORDER_RESOURCE = "org/camunda/bpm/engine/test/dmn/deployment/DecisionDefinitionDeployerTest.testDmnDeployment.dmn11.xml";
    protected static final String DMN_CHECK_ORDER_RESOURCE_DMN_SUFFIX = "org/camunda/bpm/engine/test/dmn/deployment/DecisionDefinitionDeployerTest.testDmnDeployment.dmn";
    protected static final String DMN_SCORE_RESOURCE = "org/camunda/bpm/engine/test/dmn/deployment/dmnScore.dmn11.xml";
    protected static final String DRD_SCORE_RESOURCE = "org/camunda/bpm/engine/test/dmn/deployment/drdScore.dmn11.xml";
    protected static final String DRD_SCORE_V2_RESOURCE = "org/camunda/bpm/engine/test/dmn/deployment/drdScore_v2.dmn11.xml";
    protected static final String DRD_DISH_RESOURCE = "org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml";
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    protected RepositoryService repositoryService;

    @Before
    public void initServices() {
        this.repositoryService = this.engineRule.getRepositoryService();
    }

    @Test
    public void dmnDeployment() {
        String deploymentId = this.testRule.deploy(DMN_CHECK_ORDER_RESOURCE).getId();
        DeploymentQuery deploymentQuery = this.repositoryService.createDeploymentQuery();
        Assert.assertEquals((long)1L, (long)deploymentQuery.count());
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        Assert.assertEquals((long)1L, (long)query.count());
        DecisionDefinition decisionDefinition = (DecisionDefinition)query.singleResult();
        Assert.assertTrue((boolean)decisionDefinition.getId().startsWith("decision:1:"));
        Assert.assertEquals((Object)"http://camunda.org/schema/1.0/dmn", (Object)decisionDefinition.getCategory());
        Assert.assertEquals((Object)"CheckOrder", (Object)decisionDefinition.getName());
        Assert.assertEquals((Object)"decision", (Object)decisionDefinition.getKey());
        Assert.assertEquals((long)1L, (long)decisionDefinition.getVersion());
        Assert.assertEquals((Object)DMN_CHECK_ORDER_RESOURCE, (Object)decisionDefinition.getResourceName());
        Assert.assertEquals((Object)deploymentId, (Object)decisionDefinition.getDeploymentId());
        Assert.assertNull((Object)decisionDefinition.getDiagramResourceName());
    }

    @Test
    public void dmnDeploymentWithDmnSuffix() {
        String deploymentId = this.testRule.deploy(DMN_CHECK_ORDER_RESOURCE_DMN_SUFFIX).getId();
        DeploymentQuery deploymentQuery = this.repositoryService.createDeploymentQuery();
        Assert.assertEquals((long)1L, (long)deploymentQuery.count());
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        Assert.assertEquals((long)1L, (long)query.count());
        DecisionDefinition decisionDefinition = (DecisionDefinition)query.singleResult();
        Assert.assertTrue((boolean)decisionDefinition.getId().startsWith("decision:1:"));
        Assert.assertEquals((Object)"http://camunda.org/schema/1.0/dmn", (Object)decisionDefinition.getCategory());
        Assert.assertEquals((Object)"CheckOrder", (Object)decisionDefinition.getName());
        Assert.assertEquals((Object)"decision", (Object)decisionDefinition.getKey());
        Assert.assertEquals((long)1L, (long)decisionDefinition.getVersion());
        Assert.assertEquals((Object)DMN_CHECK_ORDER_RESOURCE_DMN_SUFFIX, (Object)decisionDefinition.getResourceName());
        Assert.assertEquals((Object)deploymentId, (Object)decisionDefinition.getDeploymentId());
        Assert.assertNull((Object)decisionDefinition.getDiagramResourceName());
    }

    @Deployment
    @Test
    public void longDecisionDefinitionKey() {
        DecisionDefinition decisionDefinition = (DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().singleResult();
        Assert.assertFalse((boolean)decisionDefinition.getId().startsWith("o123456789"));
        Assert.assertEquals((Object)"o123456789o123456789o123456789o123456789o123456789o123456789o123456789", (Object)decisionDefinition.getKey());
    }

    @Test
    public void duplicateIdInDeployment() {
        String resourceName1 = "org/camunda/bpm/engine/test/dmn/deployment/DecisionDefinitionDeployerTest.testDuplicateIdInDeployment.dmn11.xml";
        String resourceName2 = "org/camunda/bpm/engine/test/dmn/deployment/DecisionDefinitionDeployerTest.testDuplicateIdInDeployment2.dmn11.xml";
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("duplicateDecision");
        this.repositoryService.createDeployment().addClasspathResource(resourceName1).addClasspathResource(resourceName2).name("duplicateIds").deploy();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/DecisionDefinitionDeployerTest.testDecisionDiagramResource.dmn11.xml", "org/camunda/bpm/engine/test/dmn/deployment/DecisionDefinitionDeployerTest.testDecisionDiagramResource.png"})
    @Test
    public void getDecisionDiagramResource() {
        String resourcePrefix = "org/camunda/bpm/engine/test/dmn/deployment/DecisionDefinitionDeployerTest.testDecisionDiagramResource";
        DecisionDefinition decisionDefinition = (DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().singleResult();
        Assert.assertEquals((Object)(resourcePrefix + ".dmn11.xml"), (Object)decisionDefinition.getResourceName());
        Assert.assertEquals((Object)"decision", (Object)decisionDefinition.getKey());
        String diagramResourceName = decisionDefinition.getDiagramResourceName();
        Assert.assertEquals((Object)(resourcePrefix + ".png"), (Object)diagramResourceName);
        InputStream diagramStream = this.repositoryService.getResourceAsStream(decisionDefinition.getDeploymentId(), diagramResourceName);
        byte[] diagramBytes = IoUtil.readInputStream((InputStream)diagramStream, (String)"diagram stream");
        Assert.assertEquals((long)2540L, (long)diagramBytes.length);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/DecisionDefinitionDeployerTest.testMultipleDecisionDiagramResource.dmn11.xml", "org/camunda/bpm/engine/test/dmn/deployment/DecisionDefinitionDeployerTest.testMultipleDecisionDiagramResource.decision1.png", "org/camunda/bpm/engine/test/dmn/deployment/DecisionDefinitionDeployerTest.testMultipleDecisionDiagramResource.decision2.png", "org/camunda/bpm/engine/test/dmn/deployment/DecisionDefinitionDeployerTest.testMultipleDecisionDiagramResource.decision3.png"})
    @Test
    public void multipleDiagramResourcesProvided() {
        String resourcePrefix = "org/camunda/bpm/engine/test/dmn/deployment/DecisionDefinitionDeployerTest.testMultipleDecisionDiagramResource.";
        DecisionDefinitionQuery decisionDefinitionQuery = this.repositoryService.createDecisionDefinitionQuery();
        Assert.assertEquals((long)3L, (long)decisionDefinitionQuery.count());
        for (DecisionDefinition decisionDefinition : decisionDefinitionQuery.list()) {
            Assert.assertEquals((Object)(resourcePrefix + decisionDefinition.getKey() + ".png"), (Object)decisionDefinition.getDiagramResourceName());
        }
    }

    @Test
    public void drdDeployment() {
        String deploymentId = this.testRule.deploy(DRD_SCORE_RESOURCE).getId();
        DecisionRequirementsDefinitionQuery query = this.repositoryService.createDecisionRequirementsDefinitionQuery();
        Assert.assertEquals((long)1L, (long)query.count());
        DecisionRequirementsDefinition decisionRequirementsDefinition = (DecisionRequirementsDefinition)query.singleResult();
        Assert.assertTrue((boolean)decisionRequirementsDefinition.getId().startsWith("score:1:"));
        Assert.assertEquals((Object)"score", (Object)decisionRequirementsDefinition.getKey());
        Assert.assertEquals((Object)"Score", (Object)decisionRequirementsDefinition.getName());
        Assert.assertEquals((Object)"test-drd-1", (Object)decisionRequirementsDefinition.getCategory());
        Assert.assertEquals((long)1L, (long)decisionRequirementsDefinition.getVersion());
        Assert.assertEquals((Object)DRD_SCORE_RESOURCE, (Object)decisionRequirementsDefinition.getResourceName());
        Assert.assertEquals((Object)deploymentId, (Object)decisionRequirementsDefinition.getDeploymentId());
        Assert.assertNull((Object)decisionRequirementsDefinition.getDiagramResourceName());
        List decisions = ((DecisionDefinitionQuery)this.repositoryService.createDecisionDefinitionQuery().orderByDecisionDefinitionKey().asc()).list();
        Assert.assertEquals((long)2L, (long)decisions.size());
        DecisionDefinition firstDecision = (DecisionDefinition)decisions.get(0);
        Assert.assertEquals((Object)"score-decision", (Object)firstDecision.getKey());
        Assert.assertEquals((Object)decisionRequirementsDefinition.getId(), (Object)firstDecision.getDecisionRequirementsDefinitionId());
        DecisionDefinition secondDecision = (DecisionDefinition)decisions.get(1);
        Assert.assertEquals((Object)"score-result", (Object)secondDecision.getKey());
        Assert.assertEquals((Object)decisionRequirementsDefinition.getId(), (Object)secondDecision.getDecisionRequirementsDefinitionId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/DecisionDefinitionDeployerTest.testDmnDeployment.dmn11.xml"})
    @Test
    public void noDrdForSingleDecisionDeployment() {
        Assert.assertEquals((long)1L, (long)this.repositoryService.createDecisionDefinitionQuery().count());
        Assert.assertEquals((long)0L, (long)this.repositoryService.createDecisionRequirementsDefinitionQuery().count());
        DecisionDefinition decisionDefinition = (DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().singleResult();
        Assert.assertNull((Object)decisionDefinition.getDecisionRequirementsDefinitionId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdScore.dmn11.xml", "org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    @Test
    public void multipleDrdDeployment() {
        List decisionRequirementsDefinitions = ((DecisionRequirementsDefinitionQuery)this.repositoryService.createDecisionRequirementsDefinitionQuery().orderByDecisionRequirementsDefinitionCategory().asc()).list();
        Assert.assertEquals((long)2L, (long)decisionRequirementsDefinitions.size());
        Assert.assertEquals((Object)"score", (Object)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(0)).getKey());
        Assert.assertEquals((Object)"dish", (Object)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(1)).getKey());
        List decisions = ((DecisionDefinitionQuery)this.repositoryService.createDecisionDefinitionQuery().orderByDecisionDefinitionCategory().asc()).list();
        Assert.assertEquals((long)5L, (long)decisions.size());
        Assert.assertEquals((Object)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(0)).getId(), (Object)((DecisionDefinition)decisions.get(0)).getDecisionRequirementsDefinitionId());
        Assert.assertEquals((Object)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(0)).getId(), (Object)((DecisionDefinition)decisions.get(1)).getDecisionRequirementsDefinitionId());
        Assert.assertEquals((Object)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(1)).getId(), (Object)((DecisionDefinition)decisions.get(2)).getDecisionRequirementsDefinitionId());
        Assert.assertEquals((Object)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(1)).getId(), (Object)((DecisionDefinition)decisions.get(3)).getDecisionRequirementsDefinitionId());
        Assert.assertEquals((Object)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(1)).getId(), (Object)((DecisionDefinition)decisions.get(4)).getDecisionRequirementsDefinitionId());
    }

    @Test
    public void duplicateDrdIdInDeployment() {
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("definitions");
        this.repositoryService.createDeployment().addClasspathResource(DRD_SCORE_RESOURCE).addClasspathResource(DRD_SCORE_V2_RESOURCE).name("duplicateIds").deploy();
    }

    @Test
    public void deployMultipleDecisionsWithSameDrdId() {
        this.testRule.deploy(DMN_SCORE_RESOURCE, DMN_CHECK_ORDER_RESOURCE);
        Assert.assertEquals((long)2L, (long)this.repositoryService.createDecisionDefinitionQuery().count());
        Assert.assertEquals((long)0L, (long)this.repositoryService.createDecisionRequirementsDefinitionQuery().count());
    }

    @Test
    public void deployDecisionIndependentFromDrd() {
        String deploymentIdDecision = this.testRule.deploy(DMN_SCORE_RESOURCE).getId();
        String deploymentIdDrd = this.testRule.deploy(DRD_SCORE_RESOURCE).getId();
        DecisionRequirementsDefinitionQuery query = this.repositoryService.createDecisionRequirementsDefinitionQuery();
        Assert.assertEquals((long)1L, (long)query.count());
        DecisionRequirementsDefinition decisionRequirementsDefinition = (DecisionRequirementsDefinition)query.singleResult();
        Assert.assertEquals((long)1L, (long)decisionRequirementsDefinition.getVersion());
        Assert.assertEquals((Object)deploymentIdDrd, (Object)decisionRequirementsDefinition.getDeploymentId());
        List decisions = ((DecisionDefinitionQuery)this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey("score-decision").orderByDecisionDefinitionVersion().asc()).list();
        Assert.assertEquals((long)2L, (long)decisions.size());
        DecisionDefinition firstDecision = (DecisionDefinition)decisions.get(0);
        Assert.assertEquals((long)1L, (long)firstDecision.getVersion());
        Assert.assertEquals((Object)deploymentIdDecision, (Object)firstDecision.getDeploymentId());
        Assert.assertNull((Object)firstDecision.getDecisionRequirementsDefinitionId());
        DecisionDefinition secondDecision = (DecisionDefinition)decisions.get(1);
        Assert.assertEquals((long)2L, (long)secondDecision.getVersion());
        Assert.assertEquals((Object)deploymentIdDrd, (Object)secondDecision.getDeploymentId());
        Assert.assertEquals((Object)decisionRequirementsDefinition.getId(), (Object)secondDecision.getDecisionRequirementsDefinitionId());
    }
}

