/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history;

import java.util.List;
import org.camunda.bpm.engine.history.HistoricActivityInstance;
import org.camunda.bpm.engine.history.HistoricActivityInstanceQuery;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;

@RequiredHistoryLevel(value="audit")
public class HistoricActivityInstanceSequenceCounterTest
extends PluggableProcessEngineTestCase {
    @Deployment(resources={"org/camunda/bpm/engine/test/standalone/entity/ExecutionSequenceCounterTest.testSequence.bpmn20.xml"})
    public void testSequence() {
        HistoricActivityInstanceQuery query = (HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().orderPartiallyByOccurrence().asc();
        this.runtimeService.startProcessInstanceByKey("process");
        this.verifyOrder(query, "theStart", "theService1", "theService2", "theEnd");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/standalone/entity/ExecutionSequenceCounterTest.testForkSameSequenceLengthWithoutWaitStates.bpmn20.xml"})
    public void testFork() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        HistoricActivityInstanceQuery query = (HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().orderPartiallyByOccurrence().asc();
        query.executionId(processInstanceId);
        this.verifyOrder(query, "theStart", "theService", "fork", "theService2", "theEnd2");
        String firstExecutionId = ((HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("theService1").singleResult()).getExecutionId();
        query.executionId(firstExecutionId);
        this.verifyOrder(query, "theService1", "theEnd1");
        query = (HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().orderPartiallyByOccurrence().asc();
        this.verifyOrder(query, "theStart", "theService", "fork", "theService1", "theEnd1", "theService2", "theEnd2");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/standalone/entity/ExecutionSequenceCounterTest.testForkAndJoinDifferentSequenceLength.bpmn20.xml"})
    public void testForkAndJoin() {
        HistoricActivityInstanceQuery query = (HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().orderPartiallyByOccurrence().asc();
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        query.executionId(processInstanceId);
        this.verifyOrder(query, "theStart", "theService", "fork", "join", "theService4", "theEnd");
        String firstExecutionId = ((HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("theService1").singleResult()).getExecutionId();
        String secondExecutionId = ((HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("theService2").singleResult()).getExecutionId();
        query.executionId(firstExecutionId);
        this.verifyOrder(query, "theService1", "join");
        query.executionId(secondExecutionId);
        this.verifyOrder(query, "theService2", "theService3");
        query = (HistoricActivityInstanceQuery)((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().orderPartiallyByOccurrence().asc()).orderByActivityId().asc();
        this.verifyOrder(query, "theStart", "theService", "fork", "theService1", "theService2", "join", "theService3", "join", "theService4", "theEnd");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/standalone/entity/ExecutionSequenceCounterTest.testSequenceInsideSubProcess.bpmn20.xml"})
    public void testSequenceInsideSubProcess() {
        HistoricActivityInstanceQuery query = (HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().orderPartiallyByOccurrence().asc();
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        query.executionId(processInstanceId);
        this.verifyOrder(query, "theStart", "theService1", "theService2", "theEnd");
        String subProcessExecutionId = ((HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("subProcess").singleResult()).getExecutionId();
        query.executionId(subProcessExecutionId);
        this.verifyOrder(query, "subProcess", "innerStart", "innerService", "innerEnd");
        query = (HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().orderPartiallyByOccurrence().asc();
        this.verifyOrder(query, "theStart", "theService1", "subProcess", "innerStart", "innerService", "innerEnd", "theService2", "theEnd");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/standalone/entity/ExecutionSequenceCounterTest.testSequentialMultiInstance.bpmn20.xml"})
    public void testSequentialMultiInstance() {
        HistoricActivityInstanceQuery query = (HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().orderPartiallyByOccurrence().asc();
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        query.executionId(processInstanceId);
        this.verifyOrder(query, "theStart", "theService1", "theService3", "theEnd");
        String taskExecutionId = ((HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("theService2").list().get(0)).getExecutionId();
        query.executionId(taskExecutionId);
        this.verifyOrder(query, "theService2#multiInstanceBody", "theService2", "theService2");
        query = (HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().orderPartiallyByOccurrence().asc();
        this.verifyOrder(query, "theStart", "theService1", "theService2#multiInstanceBody", "theService2", "theService2", "theService3", "theEnd");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/standalone/entity/ExecutionSequenceCounterTest.testParallelMultiInstance.bpmn20.xml"})
    public void testParallelMultiInstance() {
        HistoricActivityInstanceQuery query = (HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().orderPartiallyByOccurrence().asc();
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        query.executionId(processInstanceId);
        this.verifyOrder(query, "theStart", "theService1", "theService3", "theEnd");
        List taskActivityInstances = this.historyService.createHistoricActivityInstanceQuery().activityId("theService2").list();
        for (HistoricActivityInstance activityInstance : taskActivityInstances) {
            query.executionId(activityInstance.getExecutionId());
            this.verifyOrder(query, "theService2");
        }
        query = (HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().orderPartiallyByOccurrence().asc();
        this.verifyOrder(query, "theStart", "theService1", "theService2#multiInstanceBody", "theService2", "theService2", "theService3", "theEnd");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/standalone/entity/ExecutionSequenceCounterTest.testLoop.bpmn20.xml"})
    public void testLoop() {
        HistoricActivityInstanceQuery query = (HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().orderPartiallyByOccurrence().asc();
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        query.executionId(processInstanceId);
        this.verifyOrder(query, "theStart", "theService1", "join", "theScript", "fork", "join", "theScript", "fork", "theService2", "theEnd");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/standalone/entity/ExecutionSequenceCounterTest.testInterruptingBoundaryEvent.bpmn20.xml"})
    public void testInterruptingBoundaryEvent() {
        HistoricActivityInstanceQuery query = (HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().orderPartiallyByOccurrence().asc();
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        this.runtimeService.correlateMessage("newMessage");
        this.verifyOrder(query, "theStart", "theService1", "theTask", "messageBoundary", "theServiceAfterMessage", "theEnd2");
        query.executionId(processInstanceId);
        this.verifyOrder(query, "theStart", "theService1", "messageBoundary", "theServiceAfterMessage", "theEnd2");
        String taskExecutionId = ((HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("theTask").singleResult()).getExecutionId();
        query.executionId(taskExecutionId);
        this.verifyOrder(query, "theTask");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/standalone/entity/ExecutionSequenceCounterTest.testNonInterruptingBoundaryEvent.bpmn20.xml"})
    public void testNonInterruptingBoundaryEvent() {
        HistoricActivityInstanceQuery query = (HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().orderPartiallyByOccurrence().asc();
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        this.runtimeService.correlateMessage("newMessage");
        this.runtimeService.correlateMessage("newMessage");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        query.executionId(processInstanceId);
        this.verifyOrder(query, "theStart", "theService1", "theEnd1");
        String taskExecutionId = ((HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("theTask").singleResult()).getExecutionId();
        query.executionId(taskExecutionId);
        this.verifyOrder(query, "theTask");
        List activityInstances = this.historyService.createHistoricActivityInstanceQuery().activityId("messageBoundary").list();
        for (HistoricActivityInstance historicActivityInstance : activityInstances) {
            query.executionId(historicActivityInstance.getExecutionId());
            this.verifyOrder(query, "messageBoundary", "theServiceAfterMessage", "theEnd2");
        }
        query = (HistoricActivityInstanceQuery)((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().orderPartiallyByOccurrence().asc()).orderByActivityId().asc();
        this.verifyOrder(query, "theStart", "theService1", "messageBoundary", "theTask", "theServiceAfterMessage", "theEnd2", "messageBoundary", "theServiceAfterMessage", "theEnd2", "theEnd1");
    }

    protected void verifyOrder(HistoricActivityInstanceQuery query, String ... expectedOrder) {
        HistoricActivityInstanceSequenceCounterTest.assertEquals((long)expectedOrder.length, (long)query.count());
        List activityInstances = query.list();
        for (int i = 0; i < expectedOrder.length; ++i) {
            HistoricActivityInstance activityInstance = (HistoricActivityInstance)activityInstances.get(i);
            String currentActivityId = activityInstance.getActivityId();
            String expectedActivityId = expectedOrder[i];
            HistoricActivityInstanceSequenceCounterTest.assertEquals((String)expectedActivityId, (String)currentActivityId);
        }
    }
}

