/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.history.DurationReportResult;
import org.camunda.bpm.engine.impl.cfg.CommandChecker;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.db.TenantCheck;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.query.PeriodUnit;
import org.camunda.bpm.engine.query.Report;

public abstract class AbstractHistoricProcessInstanceReport
implements Command<Object>,
Report,
Serializable {
    private static final long serialVersionUID = 1L;
    protected transient CommandExecutor commandExecutor;
    protected ReportType reportType;
    protected PeriodUnit reportPeriodUnit;
    protected TenantCheck tenantCheck = new TenantCheck();

    protected AbstractHistoricProcessInstanceReport() {
    }

    protected AbstractHistoricProcessInstanceReport(CommandExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkReadHistoryAnyProcessDefinition();
        }
        return this.executeDuration(commandContext);
    }

    @Override
    public List<DurationReportResult> duration(PeriodUnit periodUnit) {
        EnsureUtil.ensureNotNull(NotValidException.class, "periodUnit", (Object)periodUnit);
        this.reportType = ReportType.DURATION;
        this.reportPeriodUnit = periodUnit;
        if (this.commandExecutor != null) {
            return (List)this.commandExecutor.execute(this);
        }
        return this.executeDuration(Context.getCommandContext());
    }

    public List<DurationReportResult> executeDuration(CommandContext commandContext) {
        return !this.hasExcludingConditions() ? this.executeDurationReport(commandContext) : new ArrayList();
    }

    public abstract List<DurationReportResult> executeDurationReport(CommandContext var1);

    protected boolean hasExcludingConditions() {
        return false;
    }

    public CommandExecutor getCommandExecutor() {
        return this.commandExecutor;
    }

    public AbstractHistoricProcessInstanceReport setCommandExecutor(CommandExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
        return this;
    }

    public PeriodUnit getReportPeriodUnit() {
        return this.reportPeriodUnit;
    }

    public String getReportPeriodUnitName() {
        return this.getReportPeriodUnit().toString();
    }

    public ReportType getReportType() {
        return this.reportType;
    }

    public String getReportTypeName() {
        return this.getReportType().toString();
    }

    public TenantCheck getTenantCheck() {
        return this.tenantCheck;
    }

    public static enum ReportType {
        DURATION;

    }
}

