/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.io.Serializable;
import java.util.Map;
import org.camunda.bpm.engine.impl.cfg.CommandChecker;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.form.FormPropertyHelper;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.deploy.DeploymentCache;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.pvm.runtime.ProcessInstanceStartContext;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;

public class SubmitStartFormCmd
implements Command<ProcessInstance>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final String processDefinitionId;
    protected final String businessKey;
    protected VariableMap variables;

    public SubmitStartFormCmd(String processDefinitionId, String businessKey, Map<String, Object> properties) {
        this.processDefinitionId = processDefinitionId;
        this.businessKey = businessKey;
        this.variables = Variables.fromMap(properties);
    }

    @Override
    public ProcessInstance execute(CommandContext commandContext) {
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        DeploymentCache deploymentCache = processEngineConfiguration.getDeploymentCache();
        ProcessDefinitionEntity processDefinition = deploymentCache.findDeployedProcessDefinitionById(this.processDefinitionId);
        EnsureUtil.ensureNotNull("No process definition found for id = '" + this.processDefinitionId + "'", "processDefinition", (Object)processDefinition);
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkCreateProcessInstance(processDefinition);
        }
        ExecutionEntity processInstance = null;
        processInstance = this.businessKey != null ? processDefinition.createProcessInstance(this.businessKey) : processDefinition.createProcessInstance();
        if (processDefinition.getInitial().isAsyncBefore()) {
            processInstance.setStartContext(new ProcessInstanceStartContext(processInstance.getActivity()));
            FormPropertyHelper.initFormPropertiesOnScope(this.variables, processInstance);
            processInstance.start();
        } else {
            processInstance.startWithFormProperties(this.variables);
        }
        return processInstance;
    }
}

