/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.history.parser;

import org.camunda.bpm.dmn.engine.DmnDecision;
import org.camunda.bpm.dmn.engine.delegate.DmnDecisionTableEvaluationEvent;
import org.camunda.bpm.dmn.engine.delegate.DmnDecisionTableEvaluationListener;
import org.camunda.bpm.engine.impl.cmmn.entity.runtime.CaseExecutionEntity;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.context.CoreExecutionContext;
import org.camunda.bpm.engine.impl.core.instance.CoreExecution;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.impl.history.event.HistoryEvent;
import org.camunda.bpm.engine.impl.history.event.HistoryEventTypes;
import org.camunda.bpm.engine.impl.history.producer.DmnHistoryEventProducer;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.repository.DecisionDefinition;

public class HistoryDecisionTableListener
implements DmnDecisionTableEvaluationListener {
    protected DmnHistoryEventProducer eventProducer;
    protected HistoryLevel historyLevel;

    public HistoryDecisionTableListener(DmnHistoryEventProducer historyEventProducer, HistoryLevel historyLevel) {
        this.eventProducer = historyEventProducer;
        this.historyLevel = historyLevel;
    }

    public void notify(DmnDecisionTableEvaluationEvent evaluationEvent) {
        HistoryEvent historyEvent = this.createHistoryEvent(evaluationEvent);
        if (historyEvent != null) {
            Context.getProcessEngineConfiguration().getHistoryEventHandler().handleEvent(historyEvent);
        }
    }

    protected HistoryEvent createHistoryEvent(DmnDecisionTableEvaluationEvent evaluationEvent) {
        DmnDecision decisionTable = evaluationEvent.getDecisionTable();
        if (this.isDeployedDecisionTable(decisionTable) && this.historyLevel.isHistoryEventProduced(HistoryEventTypes.DMN_DECISION_EVALUATE, decisionTable)) {
            CoreExecutionContext<? extends CoreExecution> executionContext = Context.getCoreExecutionContext();
            if (executionContext != null) {
                CoreExecution coreExecution = executionContext.getExecution();
                if (coreExecution instanceof ExecutionEntity) {
                    ExecutionEntity execution = (ExecutionEntity)coreExecution;
                    return this.eventProducer.createDecisionEvaluatedEvt(execution, evaluationEvent);
                }
                if (coreExecution instanceof CaseExecutionEntity) {
                    CaseExecutionEntity caseExecution = (CaseExecutionEntity)coreExecution;
                    return this.eventProducer.createDecisionEvaluatedEvt(caseExecution, evaluationEvent);
                }
            }
            return this.eventProducer.createDecisionEvaluatedEvt(evaluationEvent);
        }
        return null;
    }

    protected boolean isDeployedDecisionTable(DmnDecision decision) {
        if (decision instanceof DecisionDefinition) {
            return ((DecisionDefinition)decision).getId() != null;
        }
        return false;
    }
}

