/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.runtime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.impl.ExecutionQueryImpl;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.bpmn.parser.EventSubscriptionDeclaration;
import org.camunda.bpm.engine.impl.cmd.CommandLogger;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.deploy.DeploymentCache;
import org.camunda.bpm.engine.impl.persistence.entity.EventSubscriptionManager;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.MessageEventSubscriptionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.runtime.CorrelationHandler;
import org.camunda.bpm.engine.impl.runtime.CorrelationHandlerResult;
import org.camunda.bpm.engine.impl.runtime.CorrelationSet;
import org.camunda.bpm.engine.runtime.Execution;

public class DefaultCorrelationHandler
implements CorrelationHandler {
    private static final CommandLogger LOG = ProcessEngineLogger.CMD_LOGGER;

    @Override
    public CorrelationHandlerResult correlateMessage(CommandContext commandContext, String messageName, CorrelationSet correlationSet) {
        List<CorrelationHandlerResult> correlations = this.correlateMessageToExecutions(commandContext, messageName, correlationSet);
        if (correlations.size() > 1) {
            throw LOG.exceptionCorrelateMessageToSingleExecution(messageName, correlations.size(), correlationSet);
        }
        if (correlations.size() == 1) {
            return correlations.get(0);
        }
        correlations = this.correlateStartMessages(commandContext, messageName, correlationSet);
        if (correlations.size() > 1) {
            throw LOG.exceptionCorrelateMessageToSingleProcessDefinition(messageName, correlations.size(), correlationSet);
        }
        if (correlations.size() == 1) {
            return correlations.get(0);
        }
        return null;
    }

    @Override
    public List<CorrelationHandlerResult> correlateMessages(CommandContext commandContext, String messageName, CorrelationSet correlationSet) {
        ArrayList<CorrelationHandlerResult> results = new ArrayList<CorrelationHandlerResult>();
        results.addAll(this.correlateMessageToExecutions(commandContext, messageName, correlationSet));
        results.addAll(this.correlateStartMessages(commandContext, messageName, correlationSet));
        return results;
    }

    protected List<CorrelationHandlerResult> correlateMessageToExecutions(CommandContext commandContext, String messageName, CorrelationSet correlationSet) {
        String processInstanceId;
        String businessKey;
        ExecutionQueryImpl query = new ExecutionQueryImpl();
        Map<String, Object> correlationKeys = correlationSet.getCorrelationKeys();
        if (correlationKeys != null) {
            for (Map.Entry<String, Object> correlationKey : correlationKeys.entrySet()) {
                query.processVariableValueEquals(correlationKey.getKey(), correlationKey.getValue());
            }
        }
        if ((businessKey = correlationSet.getBusinessKey()) != null) {
            query.processInstanceBusinessKey(businessKey);
        }
        if ((processInstanceId = correlationSet.getProcessInstanceId()) != null) {
            query.processInstanceId(processInstanceId);
        }
        if (messageName != null) {
            query.messageEventSubscriptionName(messageName);
        } else {
            query.messageEventSubscription();
        }
        if (correlationSet.isTenantIdSet) {
            String tenantId = correlationSet.getTenantId();
            if (tenantId != null) {
                query.tenantIdIn(tenantId);
            } else {
                query.withoutTenantId();
            }
        }
        query.active();
        List matchingExecutions = query.evaluateExpressionsAndExecuteList(commandContext, null);
        ArrayList<CorrelationHandlerResult> result = new ArrayList<CorrelationHandlerResult>(matchingExecutions.size());
        for (Execution matchingExecution : matchingExecutions) {
            CorrelationHandlerResult correlationResult = CorrelationHandlerResult.matchedExecution((ExecutionEntity)matchingExecution);
            result.add(correlationResult);
        }
        return result;
    }

    @Override
    public List<CorrelationHandlerResult> correlateStartMessages(CommandContext commandContext, String messageName, CorrelationSet correlationSet) {
        if (messageName == null) {
            return Collections.emptyList();
        }
        if (correlationSet.getProcessDefinitionId() == null) {
            return this.correlateStartMessageByEventSubscription(commandContext, messageName, correlationSet);
        }
        CorrelationHandlerResult correlationResult = this.correlateStartMessageByProcessDefinitionId(commandContext, messageName, correlationSet.getProcessDefinitionId());
        if (correlationResult != null) {
            return Collections.singletonList(correlationResult);
        }
        return Collections.emptyList();
    }

    protected List<CorrelationHandlerResult> correlateStartMessageByEventSubscription(CommandContext commandContext, String messageName, CorrelationSet correlationSet) {
        ArrayList<CorrelationHandlerResult> results = new ArrayList<CorrelationHandlerResult>();
        DeploymentCache deploymentCache = commandContext.getProcessEngineConfiguration().getDeploymentCache();
        List<MessageEventSubscriptionEntity> messageEventSubscriptions = this.findMessageStartEventSubscriptions(commandContext, messageName, correlationSet);
        for (MessageEventSubscriptionEntity messageEventSubscription : messageEventSubscriptions) {
            if (messageEventSubscription.getConfiguration() == null) continue;
            String processDefinitionId = messageEventSubscription.getConfiguration();
            ProcessDefinitionEntity processDefinition = deploymentCache.findDeployedProcessDefinitionById(processDefinitionId);
            if (processDefinition != null && !processDefinition.isSuspended()) {
                CorrelationHandlerResult result = CorrelationHandlerResult.matchedProcessDefinition(processDefinition, messageEventSubscription.getActivityId());
                results.add(result);
                continue;
            }
            LOG.couldNotFindProcessDefinitionForEventSubscription(messageEventSubscription, processDefinitionId);
        }
        return results;
    }

    protected List<MessageEventSubscriptionEntity> findMessageStartEventSubscriptions(CommandContext commandContext, String messageName, CorrelationSet correlationSet) {
        EventSubscriptionManager eventSubscriptionManager = commandContext.getEventSubscriptionManager();
        if (correlationSet.isTenantIdSet) {
            MessageEventSubscriptionEntity eventSubscription = eventSubscriptionManager.findMessageStartEventSubscriptionByNameAndTenantId(messageName, correlationSet.getTenantId());
            if (eventSubscription != null) {
                return Collections.singletonList(eventSubscription);
            }
            return Collections.emptyList();
        }
        return eventSubscriptionManager.findMessageStartEventSubscriptionByName(messageName);
    }

    protected CorrelationHandlerResult correlateStartMessageByProcessDefinitionId(CommandContext commandContext, String messageName, String processDefinitionId) {
        String startActivityId;
        DeploymentCache deploymentCache = commandContext.getProcessEngineConfiguration().getDeploymentCache();
        ProcessDefinitionEntity processDefinition = deploymentCache.findDeployedProcessDefinitionById(processDefinitionId);
        if (processDefinition != null && !processDefinition.isSuspended() && (startActivityId = this.findStartActivityIdByMessage(processDefinition, messageName)) != null) {
            return CorrelationHandlerResult.matchedProcessDefinition(processDefinition, startActivityId);
        }
        return null;
    }

    protected String findStartActivityIdByMessage(ProcessDefinitionEntity processDefinition, String messageName) {
        for (EventSubscriptionDeclaration declaration : EventSubscriptionDeclaration.getDeclarationsForScope(processDefinition).values()) {
            if (!this.isMessageStartEventWithName(declaration, messageName)) continue;
            return declaration.getActivityId();
        }
        return null;
    }

    protected boolean isMessageStartEventWithName(EventSubscriptionDeclaration declaration, String messageName) {
        return "message".equals(declaration.getEventType()) && declaration.isStartEvent() && messageName.equals(declaration.getEventName());
    }
}

