/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization.history;

import java.util.List;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.history.HistoricTaskInstanceQuery;
import org.camunda.bpm.engine.impl.AbstractQuery;
import org.camunda.bpm.engine.query.Query;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.authorization.AuthorizationTest;

@RequiredHistoryLevel(value="activity")
public class HistoricTaskInstanceAuthorizationTest
extends AuthorizationTest {
    protected static final String PROCESS_KEY = "oneTaskProcess";
    protected static final String MESSAGE_START_PROCESS_KEY = "messageStartProcess";
    protected static final String CASE_KEY = "oneTaskCase";
    protected String deploymentId;

    @Override
    public void setUp() throws Exception {
        this.deploymentId = this.createDeployment(null, "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/authorization/messageStartEventProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/authorization/oneTaskCase.cmmn").getId();
        super.setUp();
    }

    @Override
    public void tearDown() {
        super.tearDown();
        this.deleteDeployment(this.deploymentId);
    }

    public void testQueryAfterStandaloneTask() {
        String taskId = "myTask";
        this.createTask(taskId);
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        this.verifyQueryResults(query, 1);
        this.deleteTask(taskId, true);
    }

    public void testSimpleQueryWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        this.verifyQueryResults(query, 0);
    }

    public void testSimpleQueryWithReadHistoryPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        this.verifyQueryResults(query, 1);
    }

    public void testSimpleQueryWithReadHistoryPermissionOnAnyProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        this.verifyQueryResults(query, 1);
    }

    public void testSimpleQueryWithMultiple() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        this.verifyQueryResults(query, 1);
    }

    public void testQueryWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        this.verifyQueryResults(query, 0);
    }

    public void testQueryWithReadHistoryPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        this.verifyQueryResults(query, 3);
    }

    public void testQueryWithReadHistoryPermissionOnAnyProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        this.verifyQueryResults(query, 7);
    }

    public void testQueryAfterCaseTask() {
        this.createCaseInstanceByKey(CASE_KEY);
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        this.verifyQueryResults(query, 1);
    }

    public void testMixedQueryWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.createTask("one");
        this.createTask("two");
        this.createTask("three");
        this.createTask("four");
        this.createTask("five");
        this.createCaseInstanceByKey(CASE_KEY);
        this.createCaseInstanceByKey(CASE_KEY);
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        this.verifyQueryResults(query, 7);
        this.deleteTask("one", true);
        this.deleteTask("two", true);
        this.deleteTask("three", true);
        this.deleteTask("four", true);
        this.deleteTask("five", true);
    }

    public void testMixedQueryWithReadHistoryPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.createTask("one");
        this.createTask("two");
        this.createTask("three");
        this.createTask("four");
        this.createTask("five");
        this.createCaseInstanceByKey(CASE_KEY);
        this.createCaseInstanceByKey(CASE_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        this.verifyQueryResults(query, 10);
        this.deleteTask("one", true);
        this.deleteTask("two", true);
        this.deleteTask("three", true);
        this.deleteTask("four", true);
        this.deleteTask("five", true);
    }

    public void testMixedQueryWithReadHistoryPermissionOnAnyProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.createTask("one");
        this.createTask("two");
        this.createTask("three");
        this.createTask("four");
        this.createTask("five");
        this.createCaseInstanceByKey(CASE_KEY);
        this.createCaseInstanceByKey(CASE_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        this.verifyQueryResults(query, 14);
        this.deleteTask("one", true);
        this.deleteTask("two", true);
        this.deleteTask("three", true);
        this.deleteTask("four", true);
        this.deleteTask("five", true);
    }

    public void testQueryAfterDeletingDeployment() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        this.disableAuthorization();
        List tasks = this.taskService.createTaskQuery().list();
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        this.enableAuthorization();
        this.disableAuthorization();
        this.repositoryService.deleteDeployment(this.deploymentId);
        this.enableAuthorization();
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        this.verifyQueryResults(query, 3);
        this.disableAuthorization();
        List instances = this.historyService.createHistoricProcessInstanceQuery().list();
        for (HistoricProcessInstance instance : instances) {
            this.historyService.deleteHistoricProcessInstance(instance.getId());
        }
        this.enableAuthorization();
    }

    public void testDeleteStandaloneTask() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.historyService.deleteHistoricTaskInstance(taskId);
        this.disableAuthorization();
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery().taskId(taskId);
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
        this.deleteTask(taskId, true);
    }

    public void testDeleteProcessTaskWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        try {
            this.historyService.deleteHistoricTaskInstance(taskId);
            HistoricTaskInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to delete the historic task instance");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.DELETE_HISTORY.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testDeleteProcessTaskWithDeleteHistoryPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.DELETE_HISTORY});
        this.historyService.deleteHistoricTaskInstance(taskId);
        this.disableAuthorization();
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery().taskId(taskId);
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
    }

    public void testDeleteProcessTaskWithDeleteHistoryPermissionOnAnyProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.DELETE_HISTORY});
        this.historyService.deleteHistoricTaskInstance(taskId);
        this.disableAuthorization();
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery().taskId(taskId);
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
    }

    public void testDeleteHistoricTaskInstanceAfterDeletingDeployment() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.complete(taskId);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.DELETE_HISTORY});
        this.disableAuthorization();
        this.repositoryService.deleteDeployment(this.deploymentId);
        this.enableAuthorization();
        this.historyService.deleteHistoricTaskInstance(taskId);
        this.disableAuthorization();
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery().taskId(taskId);
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
        this.disableAuthorization();
        this.historyService.deleteHistoricProcessInstance(processInstanceId);
        this.enableAuthorization();
    }

    protected void verifyQueryResults(HistoricTaskInstanceQuery query, int countExpected) {
        this.verifyQueryResults((Query<?, ?>)((AbstractQuery)query), countExpected);
    }
}

