/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.form;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.form.FormField;
import org.camunda.bpm.engine.form.FormProperty;
import org.camunda.bpm.engine.form.StartFormData;
import org.camunda.bpm.engine.form.TaskFormData;
import org.camunda.bpm.engine.history.HistoricVariableInstance;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.form.type.AbstractFormFieldType;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.impl.util.CollectionUtil;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.api.form.Address;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.type.ValueType;
import org.camunda.bpm.engine.variable.value.ObjectValue;
import org.camunda.bpm.engine.variable.value.SerializationDataFormat;
import org.camunda.bpm.engine.variable.value.TypedValue;

public class FormServiceTest
extends PluggableProcessEngineTestCase {
    public void setUp() throws Exception {
        this.identityService.saveUser(this.identityService.newUser("fozzie"));
        this.identityService.saveGroup(this.identityService.newGroup("management"));
        this.identityService.createMembership("fozzie", "management");
    }

    public void tearDown() throws Exception {
        this.identityService.deleteGroup("management");
        this.identityService.deleteUser("fozzie");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/form/util/VacationRequest_deprecated_forms.bpmn20.xml", "org/camunda/bpm/engine/test/api/form/util/approve.form", "org/camunda/bpm/engine/test/api/form/util/request.form", "org/camunda/bpm/engine/test/api/form/util/adjustRequest.form"})
    public void testGetStartFormByProcessDefinitionId() {
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().list();
        FormServiceTest.assertEquals((int)1, (int)processDefinitions.size());
        ProcessDefinition processDefinition = (ProcessDefinition)processDefinitions.get(0);
        Object startForm = this.formService.getRenderedStartForm(processDefinition.getId(), "juel");
        FormServiceTest.assertNotNull((Object)startForm);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testGetStartFormByProcessDefinitionIdWithoutStartform() {
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().list();
        FormServiceTest.assertEquals((int)1, (int)processDefinitions.size());
        ProcessDefinition processDefinition = (ProcessDefinition)processDefinitions.get(0);
        Object startForm = this.formService.getRenderedStartForm(processDefinition.getId());
        FormServiceTest.assertNull((Object)startForm);
    }

    public void testGetStartFormByKeyNullKey() {
        try {
            this.formService.getRenderedStartForm(null);
            FormServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testGetStartFormByIdNullId() {
        try {
            this.formService.getRenderedStartForm(null);
            FormServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testGetStartFormByIdUnexistingProcessDefinitionId() {
        try {
            this.formService.getRenderedStartForm("unexistingId");
            FormServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("no deployed process definition found with id", ae.getMessage());
        }
    }

    public void testGetTaskFormNullTaskId() {
        try {
            this.formService.getRenderedTaskForm(null);
            FormServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testGetTaskFormUnexistingTaskId() {
        try {
            this.formService.getRenderedTaskForm("unexistingtask");
            FormServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("Task 'unexistingtask' not found", ae.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/form/FormsProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/form/start.form", "org/camunda/bpm/engine/test/api/form/task.form"})
    public void testTaskFormPropertyDefaultsAndFormRendering() {
        String procDefId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId();
        StartFormData startForm = this.formService.getStartFormData(procDefId);
        FormServiceTest.assertNotNull((Object)startForm);
        FormServiceTest.assertEquals((String)this.deploymentId, (String)startForm.getDeploymentId());
        FormServiceTest.assertEquals((String)"org/camunda/bpm/engine/test/api/form/start.form", (String)startForm.getFormKey());
        FormServiceTest.assertEquals(new ArrayList(), (Object)startForm.getFormProperties());
        FormServiceTest.assertEquals((String)procDefId, (String)startForm.getProcessDefinition().getId());
        Object renderedStartForm = this.formService.getRenderedStartForm(procDefId, "juel");
        FormServiceTest.assertEquals((Object)"start form content", (Object)renderedStartForm);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("room", "5b");
        properties.put("speaker", "Mike");
        String processInstanceId = this.formService.submitStartFormData(procDefId, properties).getId();
        HashMap<String, String> expectedVariables = new HashMap<String, String>();
        expectedVariables.put("room", "5b");
        expectedVariables.put("speaker", "Mike");
        Map variables = this.runtimeService.getVariables(processInstanceId);
        FormServiceTest.assertEquals(expectedVariables, (Object)variables);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        String taskId = task.getId();
        TaskFormData taskForm = this.formService.getTaskFormData(taskId);
        FormServiceTest.assertEquals((String)this.deploymentId, (String)taskForm.getDeploymentId());
        FormServiceTest.assertEquals((String)"org/camunda/bpm/engine/test/api/form/task.form", (String)taskForm.getFormKey());
        FormServiceTest.assertEquals(new ArrayList(), (Object)taskForm.getFormProperties());
        FormServiceTest.assertEquals((String)taskId, (String)taskForm.getTask().getId());
        FormServiceTest.assertEquals((Object)"Mike is speaking in room 5b", (Object)this.formService.getRenderedTaskForm(taskId, "juel"));
        properties = new HashMap();
        properties.put("room", "3f");
        this.formService.submitTaskFormData(taskId, properties);
        expectedVariables = new HashMap();
        expectedVariables.put("room", "3f");
        expectedVariables.put("speaker", "Mike");
        variables = this.runtimeService.getVariables(processInstanceId);
        FormServiceTest.assertEquals(expectedVariables, (Object)variables);
    }

    @Deployment
    public void testFormPropertyHandlingDeprecated() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("room", "5b");
        properties.put("speaker", "Mike");
        properties.put("duration", "45");
        properties.put("free", "true");
        String procDefId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId();
        String processInstanceId = this.formService.submitStartFormData(procDefId, properties).getId();
        HashMap<String, Object> expectedVariables = new HashMap<String, Object>();
        expectedVariables.put("room", "5b");
        expectedVariables.put("SpeakerName", "Mike");
        expectedVariables.put("duration", new Long(45L));
        expectedVariables.put("free", Boolean.TRUE);
        Map variables = this.runtimeService.getVariables(processInstanceId);
        FormServiceTest.assertEquals(expectedVariables, (Object)variables);
        Address address = new Address();
        address.setStreet("broadway");
        this.runtimeService.setVariable(processInstanceId, "address", (Object)address);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        TaskFormData taskFormData = this.formService.getTaskFormData(taskId);
        List formProperties = taskFormData.getFormProperties();
        FormProperty propertyRoom = (FormProperty)formProperties.get(0);
        FormServiceTest.assertEquals((String)"room", (String)propertyRoom.getId());
        FormServiceTest.assertEquals((String)"5b", (String)propertyRoom.getValue());
        FormProperty propertyDuration = (FormProperty)formProperties.get(1);
        FormServiceTest.assertEquals((String)"duration", (String)propertyDuration.getId());
        FormServiceTest.assertEquals((String)"45", (String)propertyDuration.getValue());
        FormProperty propertySpeaker = (FormProperty)formProperties.get(2);
        FormServiceTest.assertEquals((String)"speaker", (String)propertySpeaker.getId());
        FormServiceTest.assertEquals((String)"Mike", (String)propertySpeaker.getValue());
        FormProperty propertyStreet = (FormProperty)formProperties.get(3);
        FormServiceTest.assertEquals((String)"street", (String)propertyStreet.getId());
        FormServiceTest.assertEquals((String)"broadway", (String)propertyStreet.getValue());
        FormProperty propertyFree = (FormProperty)formProperties.get(4);
        FormServiceTest.assertEquals((String)"free", (String)propertyFree.getId());
        FormServiceTest.assertEquals((String)"true", (String)propertyFree.getValue());
        FormServiceTest.assertEquals((int)5, (int)formProperties.size());
        try {
            this.formService.submitTaskFormData(taskId, new HashMap());
            FormServiceTest.fail((String)"expected exception about required form property 'street'");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            properties = new HashMap();
            properties.put("speaker", "its not allowed to update speaker!");
            this.formService.submitTaskFormData(taskId, properties);
            FormServiceTest.fail((String)"expected exception about a non writable form property 'speaker'");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        properties = new HashMap();
        properties.put("street", "rubensstraat");
        this.formService.submitTaskFormData(taskId, properties);
        expectedVariables = new HashMap();
        expectedVariables.put("room", "5b");
        expectedVariables.put("SpeakerName", "Mike");
        expectedVariables.put("duration", new Long(45L));
        expectedVariables.put("free", Boolean.TRUE);
        variables = this.runtimeService.getVariables(processInstanceId);
        address = (Address)variables.remove("address");
        FormServiceTest.assertEquals((String)"rubensstraat", (String)address.getStreet());
        FormServiceTest.assertEquals(expectedVariables, (Object)variables);
    }

    @Deployment
    public void testFormPropertyHandling() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("room", "5b");
        properties.put("speaker", "Mike");
        properties.put("duration", 45L);
        properties.put("free", "true");
        String procDefId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId();
        String processInstanceId = this.formService.submitStartForm(procDefId, properties).getId();
        HashMap<String, Object> expectedVariables = new HashMap<String, Object>();
        expectedVariables.put("room", "5b");
        expectedVariables.put("SpeakerName", "Mike");
        expectedVariables.put("duration", new Long(45L));
        expectedVariables.put("free", Boolean.TRUE);
        Map variables = this.runtimeService.getVariables(processInstanceId);
        FormServiceTest.assertEquals(expectedVariables, (Object)variables);
        Address address = new Address();
        address.setStreet("broadway");
        this.runtimeService.setVariable(processInstanceId, "address", (Object)address);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        TaskFormData taskFormData = this.formService.getTaskFormData(taskId);
        List formProperties = taskFormData.getFormProperties();
        FormProperty propertyRoom = (FormProperty)formProperties.get(0);
        FormServiceTest.assertEquals((String)"room", (String)propertyRoom.getId());
        FormServiceTest.assertEquals((String)"5b", (String)propertyRoom.getValue());
        FormProperty propertyDuration = (FormProperty)formProperties.get(1);
        FormServiceTest.assertEquals((String)"duration", (String)propertyDuration.getId());
        FormServiceTest.assertEquals((String)"45", (String)propertyDuration.getValue());
        FormProperty propertySpeaker = (FormProperty)formProperties.get(2);
        FormServiceTest.assertEquals((String)"speaker", (String)propertySpeaker.getId());
        FormServiceTest.assertEquals((String)"Mike", (String)propertySpeaker.getValue());
        FormProperty propertyStreet = (FormProperty)formProperties.get(3);
        FormServiceTest.assertEquals((String)"street", (String)propertyStreet.getId());
        FormServiceTest.assertEquals((String)"broadway", (String)propertyStreet.getValue());
        FormProperty propertyFree = (FormProperty)formProperties.get(4);
        FormServiceTest.assertEquals((String)"free", (String)propertyFree.getId());
        FormServiceTest.assertEquals((String)"true", (String)propertyFree.getValue());
        FormServiceTest.assertEquals((int)5, (int)formProperties.size());
        try {
            this.formService.submitTaskForm(taskId, new HashMap());
            FormServiceTest.fail((String)"expected exception about required form property 'street'");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            properties = new HashMap();
            properties.put("speaker", "its not allowed to update speaker!");
            this.formService.submitTaskForm(taskId, properties);
            FormServiceTest.fail((String)"expected exception about a non writable form property 'speaker'");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        properties = new HashMap();
        properties.put("street", "rubensstraat");
        this.formService.submitTaskForm(taskId, properties);
        expectedVariables = new HashMap();
        expectedVariables.put("room", "5b");
        expectedVariables.put("SpeakerName", "Mike");
        expectedVariables.put("duration", new Long(45L));
        expectedVariables.put("free", Boolean.TRUE);
        variables = this.runtimeService.getVariables(processInstanceId);
        address = (Address)variables.remove("address");
        FormServiceTest.assertEquals((String)"rubensstraat", (String)address.getStreet());
        FormServiceTest.assertEquals(expectedVariables, (Object)variables);
    }

    @Deployment
    public void testFormPropertyDetails() {
        String procDefId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId();
        StartFormData startFormData = this.formService.getStartFormData(procDefId);
        FormProperty property = (FormProperty)startFormData.getFormProperties().get(0);
        FormServiceTest.assertEquals((String)"speaker", (String)property.getId());
        FormServiceTest.assertNull((Object)property.getValue());
        FormServiceTest.assertTrue((boolean)property.isReadable());
        FormServiceTest.assertTrue((boolean)property.isWritable());
        FormServiceTest.assertFalse((boolean)property.isRequired());
        FormServiceTest.assertEquals((String)"string", (String)property.getType().getName());
        property = (FormProperty)startFormData.getFormProperties().get(1);
        FormServiceTest.assertEquals((String)"start", (String)property.getId());
        FormServiceTest.assertNull((Object)property.getValue());
        FormServiceTest.assertTrue((boolean)property.isReadable());
        FormServiceTest.assertTrue((boolean)property.isWritable());
        FormServiceTest.assertFalse((boolean)property.isRequired());
        FormServiceTest.assertEquals((String)"date", (String)property.getType().getName());
        FormServiceTest.assertEquals((Object)"dd-MMM-yyyy", (Object)property.getType().getInformation("datePattern"));
        property = (FormProperty)startFormData.getFormProperties().get(2);
        FormServiceTest.assertEquals((String)"direction", (String)property.getId());
        FormServiceTest.assertNull((Object)property.getValue());
        FormServiceTest.assertTrue((boolean)property.isReadable());
        FormServiceTest.assertTrue((boolean)property.isWritable());
        FormServiceTest.assertFalse((boolean)property.isRequired());
        FormServiceTest.assertEquals((String)"enum", (String)property.getType().getName());
        Map values = (Map)property.getType().getInformation("values");
        LinkedHashMap<String, String> expectedValues = new LinkedHashMap<String, String>();
        expectedValues.put("left", "Go Left");
        expectedValues.put("right", "Go Right");
        expectedValues.put("up", "Go Up");
        expectedValues.put("down", "Go Down");
        Iterator expectedValuesIterator = expectedValues.entrySet().iterator();
        for (Map.Entry entry : values.entrySet()) {
            Map.Entry expectedEntryAtLocation = expectedValuesIterator.next();
            FormServiceTest.assertEquals((String)((String)expectedEntryAtLocation.getKey()), (String)((String)entry.getKey()));
            FormServiceTest.assertEquals((String)((String)expectedEntryAtLocation.getValue()), (String)((String)entry.getValue()));
        }
        FormServiceTest.assertEquals(expectedValues, (Object)values);
    }

    @Deployment
    public void testInvalidFormKeyReference() {
        try {
            this.formService.getRenderedStartForm(((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId(), "juel");
            FormServiceTest.fail();
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("Form with formKey 'IDoNotExist' does not exist", e.getMessage());
        }
    }

    @Deployment
    public void testSubmitStartFormDataWithBusinessKey() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("duration", "45");
        properties.put("speaker", "Mike");
        String procDefId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId();
        ProcessInstance processInstance = this.formService.submitStartFormData(procDefId, "123", properties);
        FormServiceTest.assertEquals((String)"123", (String)processInstance.getBusinessKey());
        FormServiceTest.assertEquals((String)processInstance.getId(), (String)((ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceBusinessKey("123").singleResult()).getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/form/FormsProcess.bpmn20.xml"})
    public void testSubmitStartFormDataTypedVariables() {
        String procDefId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId();
        String stringValue = "some string";
        String serializedValue = "some value";
        ProcessInstance processInstance = this.formService.submitStartForm(procDefId, (Map)Variables.createVariables().putValueTyped("boolean", (TypedValue)Variables.booleanValue(null)).putValueTyped("string", (TypedValue)Variables.stringValue((String)stringValue)).putValueTyped("serializedObject", Variables.serializedObjectValue((String)serializedValue).objectTypeName(String.class.getName()).serializationDataFormat((SerializationDataFormat)Variables.SerializationDataFormats.JAVA).create()).putValueTyped("object", Variables.objectValue((Object)serializedValue).create()));
        VariableMap variables = this.runtimeService.getVariablesTyped(processInstance.getId(), false);
        FormServiceTest.assertEquals((Object)Variables.booleanValue(null), (Object)variables.getValueTyped("boolean"));
        FormServiceTest.assertEquals((Object)Variables.stringValue((String)stringValue), (Object)variables.getValueTyped("string"));
        FormServiceTest.assertNotNull((Object)((ObjectValue)variables.getValueTyped("serializedObject")).getValueSerialized());
        FormServiceTest.assertNotNull((Object)((ObjectValue)variables.getValueTyped("object")).getValueSerialized());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/form/FormsProcess.bpmn20.xml"})
    public void testSubmitTaskFormDataTypedVariables() {
        String procDefId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId();
        ProcessInstance processInstance = this.formService.submitStartForm(procDefId, (Map)Variables.createVariables());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        String stringValue = "some string";
        String serializedValue = "some value";
        this.formService.submitTaskForm(task.getId(), (Map)Variables.createVariables().putValueTyped("boolean", (TypedValue)Variables.booleanValue(null)).putValueTyped("string", (TypedValue)Variables.stringValue((String)stringValue)).putValueTyped("serializedObject", Variables.serializedObjectValue((String)serializedValue).objectTypeName(String.class.getName()).serializationDataFormat((SerializationDataFormat)Variables.SerializationDataFormats.JAVA).create()).putValueTyped("object", Variables.objectValue((Object)serializedValue).create()));
        VariableMap variables = this.runtimeService.getVariablesTyped(processInstance.getId(), false);
        FormServiceTest.assertEquals((Object)Variables.booleanValue(null), (Object)variables.getValueTyped("boolean"));
        FormServiceTest.assertEquals((Object)Variables.stringValue((String)stringValue), (Object)variables.getValueTyped("string"));
        FormServiceTest.assertNotNull((Object)((ObjectValue)variables.getValueTyped("serializedObject")).getValueSerialized());
        FormServiceTest.assertNotNull((Object)((ObjectValue)variables.getValueTyped("object")).getValueSerialized());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/form/FormsProcess.bpmn20.xml"})
    public void testSubmitFormVariablesNull() {
        String procDefId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId();
        this.formService.submitStartForm(procDefId, null);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        FormServiceTest.assertNotNull((Object)task);
        this.formService.submitTaskForm(task.getId(), null);
    }

    public void testSubmitTaskFormForStandaloneTask() {
        String id = "standaloneTask";
        Task task = this.taskService.newTask(id);
        this.taskService.saveTask(task);
        this.formService.submitTaskForm(task.getId(), (Map)Variables.createVariables().putValue("foo", (Object)"bar"));
        if (this.processEngineConfiguration.getHistoryLevel().getId() >= HistoryLevel.HISTORY_LEVEL_AUDIT.getId()) {
            HistoricVariableInstance variableInstance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().taskIdIn(new String[]{id}).singleResult();
            FormServiceTest.assertNotNull((Object)variableInstance);
            FormServiceTest.assertEquals((String)"foo", (String)variableInstance.getName());
            FormServiceTest.assertEquals((Object)"bar", (Object)variableInstance.getValue());
        }
        this.taskService.deleteTask(id, true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testSubmitTaskFormForCmmnHumanTask() {
        this.caseService.createCaseInstanceByKey("oneTaskCase");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        String stringValue = "some string";
        String serializedValue = "some value";
        this.formService.submitTaskForm(task.getId(), (Map)Variables.createVariables().putValueTyped("boolean", (TypedValue)Variables.booleanValue(null)).putValueTyped("string", (TypedValue)Variables.stringValue((String)stringValue)).putValueTyped("serializedObject", Variables.serializedObjectValue((String)serializedValue).objectTypeName(String.class.getName()).serializationDataFormat((SerializationDataFormat)Variables.SerializationDataFormats.JAVA).create()).putValueTyped("object", Variables.objectValue((Object)serializedValue).create()));
    }

    @Deployment
    public void testSubmitStartFormWithBusinessKey() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("duration", 45L);
        properties.put("speaker", "Mike");
        String procDefId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId();
        ProcessInstance processInstance = this.formService.submitStartForm(procDefId, "123", properties);
        FormServiceTest.assertEquals((String)"123", (String)processInstance.getBusinessKey());
        FormServiceTest.assertEquals((String)processInstance.getId(), (String)((ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceBusinessKey("123").singleResult()).getId());
        Map variables = this.runtimeService.getVariables(processInstance.getId());
        FormServiceTest.assertEquals((Object)"Mike", variables.get("SpeakerName"));
        FormServiceTest.assertEquals((Object)45L, variables.get("duration"));
    }

    @Deployment
    public void testSubmitStartFormWithoutProperties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("duration", 45L);
        properties.put("speaker", "Mike");
        String procDefId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId();
        ProcessInstance processInstance = this.formService.submitStartForm(procDefId, "123", properties);
        FormServiceTest.assertEquals((String)"123", (String)processInstance.getBusinessKey());
        FormServiceTest.assertEquals((String)processInstance.getId(), (String)((ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceBusinessKey("123").singleResult()).getId());
        Map variables = this.runtimeService.getVariables(processInstance.getId());
        FormServiceTest.assertEquals((Object)"Mike", variables.get("speaker"));
        FormServiceTest.assertEquals((Object)45L, variables.get("duration"));
    }

    public void testGetStartFormKeyEmptyArgument() {
        try {
            this.formService.getStartFormKey(null);
            FormServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("The process definition id is mandatory, but 'null' has been provided.", ae.getMessage());
        }
        try {
            this.formService.getStartFormKey("");
            FormServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("The process definition id is mandatory, but '' has been provided.", ae.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/form/FormsProcess.bpmn20.xml"})
    public void testGetStartFormKey() {
        String processDefinitionId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId();
        String expectedFormKey = this.formService.getStartFormData(processDefinitionId).getFormKey();
        String actualFormKey = this.formService.getStartFormKey(processDefinitionId);
        FormServiceTest.assertEquals((String)expectedFormKey, (String)actualFormKey);
    }

    public void testGetTaskFormKeyEmptyArguments() {
        try {
            this.formService.getTaskFormKey(null, "23");
            FormServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("The process definition id is mandatory, but 'null' has been provided.", ae.getMessage());
        }
        try {
            this.formService.getTaskFormKey("", "23");
            FormServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("The process definition id is mandatory, but '' has been provided.", ae.getMessage());
        }
        try {
            this.formService.getTaskFormKey("42", null);
            FormServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("The task definition key is mandatory, but 'null' has been provided.", ae.getMessage());
        }
        try {
            this.formService.getTaskFormKey("42", "");
            FormServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("The task definition key is mandatory, but '' has been provided.", ae.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/form/FormsProcess.bpmn20.xml"})
    public void testGetTaskFormKey() {
        String processDefinitionId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId();
        this.runtimeService.startProcessInstanceById(processDefinitionId);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        FormServiceTest.assertNotNull((Object)task);
        String expectedFormKey = this.formService.getTaskFormData(task.getId()).getFormKey();
        String actualFormKey = this.formService.getTaskFormKey(task.getProcessDefinitionId(), task.getTaskDefinitionKey());
        FormServiceTest.assertEquals((String)expectedFormKey, (String)actualFormKey);
    }

    @Deployment
    public void testGetTaskFormKeyWithExpression() {
        this.runtimeService.startProcessInstanceByKey("FormsProcess", CollectionUtil.singletonMap((String)"dynamicKey", (Object)"test"));
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        FormServiceTest.assertNotNull((Object)task);
        FormServiceTest.assertEquals((String)"test", (String)this.formService.getTaskFormData(task.getId()).getFormKey());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/form/FormServiceTest.startFormFields.bpmn20.xml"})
    public void testGetStartFormVariables() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        VariableMap variables = this.formService.getStartFormVariables(processDefinition.getId());
        FormServiceTest.assertEquals((int)4, (int)variables.size());
        FormServiceTest.assertEquals((Object)"someString", (Object)variables.get((Object)"stringField"));
        FormServiceTest.assertEquals((Object)"someString", (Object)variables.getValueTyped("stringField").getValue());
        FormServiceTest.assertEquals((Object)ValueType.STRING, (Object)variables.getValueTyped("stringField").getType());
        FormServiceTest.assertEquals((Object)5L, (Object)variables.get((Object)"longField"));
        FormServiceTest.assertEquals((Object)5L, (Object)variables.getValueTyped("longField").getValue());
        FormServiceTest.assertEquals((Object)ValueType.LONG, (Object)variables.getValueTyped("longField").getType());
        FormServiceTest.assertNull((Object)variables.get((Object)"customField"));
        FormServiceTest.assertNull((Object)variables.getValueTyped("customField").getValue());
        FormServiceTest.assertEquals((Object)ValueType.STRING, (Object)variables.getValueTyped("customField").getType());
        FormServiceTest.assertNotNull((Object)variables.get((Object)"dateField"));
        FormServiceTest.assertEquals((Object)variables.get((Object)"dateField"), (Object)variables.getValueTyped("dateField").getValue());
        FormServiceTest.assertEquals((Object)ValueType.STRING, (Object)variables.getValueTyped("dateField").getType());
        AbstractFormFieldType dateFormType = this.processEngineConfiguration.getFormTypes().getFormType("date");
        Date dateValue = (Date)dateFormType.convertToModelValue(variables.getValueTyped("dateField")).getValue();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(dateValue);
        FormServiceTest.assertEquals((int)10, (int)calendar.get(5));
        FormServiceTest.assertEquals((int)0, (int)calendar.get(2));
        FormServiceTest.assertEquals((int)2013, (int)calendar.get(1));
        variables = this.formService.getStartFormVariables(processDefinition.getId(), Arrays.asList("stringField"), true);
        FormServiceTest.assertEquals((int)1, (int)variables.size());
        FormServiceTest.assertEquals((Object)"someString", (Object)variables.get((Object)"stringField"));
        FormServiceTest.assertEquals((Object)"someString", (Object)variables.getValueTyped("stringField").getValue());
        FormServiceTest.assertEquals((Object)ValueType.STRING, (Object)variables.getValueTyped("stringField").getType());
        variables = this.formService.getStartFormVariables(processDefinition.getId(), Arrays.asList("non-existing!"), true);
        FormServiceTest.assertEquals((int)0, (int)variables.size());
        variables = this.formService.getStartFormVariables(processDefinition.getId(), null, true);
        FormServiceTest.assertEquals((int)4, (int)variables.size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/form/FormServiceTest.startFormFieldsUnknownType.bpmn20.xml"})
    public void testGetStartFormVariablesEnumType() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        VariableMap startFormVariables = this.formService.getStartFormVariables(processDefinition.getId());
        FormServiceTest.assertEquals((Object)"a", (Object)startFormVariables.get((Object)"enumField"));
        FormServiceTest.assertEquals((Object)ValueType.STRING, (Object)startFormVariables.getValueTyped("enumField").getType());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/form/FormServiceTest.taskFormFields.bpmn20.xml"})
    public void testGetTaskFormVariables() {
        HashMap<String, Object> processVars = new HashMap<String, Object>();
        processVars.put("someString", "initialValue");
        processVars.put("initialBooleanVariable", true);
        processVars.put("initialLongVariable", 1L);
        processVars.put("serializable", Arrays.asList("a", "b", "c"));
        this.runtimeService.startProcessInstanceByKey("testProcess", processVars);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        VariableMap variables = this.formService.getTaskFormVariables(task.getId());
        FormServiceTest.assertEquals((int)7, (int)variables.size());
        FormServiceTest.assertEquals((Object)"someString", (Object)variables.get((Object)"stringField"));
        FormServiceTest.assertEquals((Object)"someString", (Object)variables.getValueTyped("stringField").getValue());
        FormServiceTest.assertEquals((Object)ValueType.STRING, (Object)variables.getValueTyped("stringField").getType());
        FormServiceTest.assertEquals((Object)5L, (Object)variables.get((Object)"longField"));
        FormServiceTest.assertEquals((Object)5L, (Object)variables.getValueTyped("longField").getValue());
        FormServiceTest.assertEquals((Object)ValueType.LONG, (Object)variables.getValueTyped("longField").getType());
        FormServiceTest.assertNull((Object)variables.get((Object)"customField"));
        FormServiceTest.assertNull((Object)variables.getValueTyped("customField").getValue());
        FormServiceTest.assertEquals((Object)ValueType.STRING, (Object)variables.getValueTyped("customField").getType());
        FormServiceTest.assertEquals((Object)"initialValue", (Object)variables.get((Object)"someString"));
        FormServiceTest.assertEquals((Object)"initialValue", (Object)variables.getValueTyped("someString").getValue());
        FormServiceTest.assertEquals((Object)ValueType.STRING, (Object)variables.getValueTyped("someString").getType());
        FormServiceTest.assertEquals((Object)true, (Object)variables.get((Object)"initialBooleanVariable"));
        FormServiceTest.assertEquals((Object)true, (Object)variables.getValueTyped("initialBooleanVariable").getValue());
        FormServiceTest.assertEquals((Object)ValueType.BOOLEAN, (Object)variables.getValueTyped("initialBooleanVariable").getType());
        FormServiceTest.assertEquals((Object)1L, (Object)variables.get((Object)"initialLongVariable"));
        FormServiceTest.assertEquals((Object)1L, (Object)variables.getValueTyped("initialLongVariable").getValue());
        FormServiceTest.assertEquals((Object)ValueType.LONG, (Object)variables.getValueTyped("initialLongVariable").getType());
        FormServiceTest.assertNotNull((Object)variables.get((Object)"serializable"));
        this.taskService.setVariableLocal(task.getId(), "initialLongVariable", (Object)2L);
        variables = this.formService.getTaskFormVariables(task.getId());
        FormServiceTest.assertEquals((int)7, (int)variables.size());
        FormServiceTest.assertEquals((Object)2L, (Object)variables.get((Object)"initialLongVariable"));
        FormServiceTest.assertEquals((Object)2L, (Object)variables.getValueTyped("initialLongVariable").getValue());
        FormServiceTest.assertEquals((Object)ValueType.LONG, (Object)variables.getValueTyped("initialLongVariable").getType());
        variables = this.formService.getTaskFormVariables(task.getId(), Arrays.asList("someString"), true);
        FormServiceTest.assertEquals((int)1, (int)variables.size());
        FormServiceTest.assertEquals((Object)"initialValue", (Object)variables.get((Object)"someString"));
        FormServiceTest.assertEquals((Object)"initialValue", (Object)variables.getValueTyped("someString").getValue());
        FormServiceTest.assertEquals((Object)ValueType.STRING, (Object)variables.getValueTyped("someString").getType());
        variables = this.formService.getTaskFormVariables(task.getId(), Arrays.asList("initialBooleanVariable"), true);
        FormServiceTest.assertEquals((int)1, (int)variables.size());
        FormServiceTest.assertEquals((Object)true, (Object)variables.get((Object)"initialBooleanVariable"));
        FormServiceTest.assertEquals((Object)true, (Object)variables.getValueTyped("initialBooleanVariable").getValue());
        FormServiceTest.assertEquals((Object)ValueType.BOOLEAN, (Object)variables.getValueTyped("initialBooleanVariable").getType());
        variables = this.formService.getTaskFormVariables(task.getId(), Arrays.asList("non-existing!"), true);
        FormServiceTest.assertEquals((int)0, (int)variables.size());
        variables = this.formService.getTaskFormVariables(task.getId(), null, true);
        FormServiceTest.assertEquals((int)7, (int)variables.size());
    }

    public void testGetTaskFormVariables_StandaloneTask() {
        HashMap<String, Object> processVars = new HashMap<String, Object>();
        processVars.put("someString", "initialValue");
        processVars.put("initialBooleanVariable", true);
        processVars.put("initialLongVariable", 1L);
        processVars.put("serializable", Arrays.asList("a", "b", "c"));
        Task standaloneTask = this.taskService.newTask();
        standaloneTask.setName("A Standalone Task");
        this.taskService.saveTask(standaloneTask);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.setVariables(task.getId(), processVars);
        VariableMap variables = this.formService.getTaskFormVariables(task.getId());
        FormServiceTest.assertEquals((int)4, (int)variables.size());
        FormServiceTest.assertEquals((Object)"initialValue", (Object)variables.get((Object)"someString"));
        FormServiceTest.assertEquals((Object)"initialValue", (Object)variables.getValueTyped("someString").getValue());
        FormServiceTest.assertEquals((Object)ValueType.STRING, (Object)variables.getValueTyped("someString").getType());
        FormServiceTest.assertEquals((Object)true, (Object)variables.get((Object)"initialBooleanVariable"));
        FormServiceTest.assertEquals((Object)true, (Object)variables.getValueTyped("initialBooleanVariable").getValue());
        FormServiceTest.assertEquals((Object)ValueType.BOOLEAN, (Object)variables.getValueTyped("initialBooleanVariable").getType());
        FormServiceTest.assertEquals((Object)1L, (Object)variables.get((Object)"initialLongVariable"));
        FormServiceTest.assertEquals((Object)1L, (Object)variables.getValueTyped("initialLongVariable").getValue());
        FormServiceTest.assertEquals((Object)ValueType.LONG, (Object)variables.getValueTyped("initialLongVariable").getType());
        FormServiceTest.assertNotNull((Object)variables.get((Object)"serializable"));
        this.taskService.setVariable(task.getId(), "initialLongVariable", (Object)2L);
        variables = this.formService.getTaskFormVariables(task.getId());
        FormServiceTest.assertEquals((int)4, (int)variables.size());
        FormServiceTest.assertEquals((Object)2L, (Object)variables.get((Object)"initialLongVariable"));
        FormServiceTest.assertEquals((Object)2L, (Object)variables.getValueTyped("initialLongVariable").getValue());
        FormServiceTest.assertEquals((Object)ValueType.LONG, (Object)variables.getValueTyped("initialLongVariable").getType());
        variables = this.formService.getTaskFormVariables(task.getId(), Arrays.asList("someString"), true);
        FormServiceTest.assertEquals((int)1, (int)variables.size());
        FormServiceTest.assertEquals((Object)"initialValue", (Object)variables.get((Object)"someString"));
        FormServiceTest.assertEquals((Object)"initialValue", (Object)variables.getValueTyped("someString").getValue());
        FormServiceTest.assertEquals((Object)ValueType.STRING, (Object)variables.getValueTyped("someString").getType());
        variables = this.formService.getTaskFormVariables(task.getId(), Arrays.asList("non-existing!"), true);
        FormServiceTest.assertEquals((int)0, (int)variables.size());
        variables = this.formService.getTaskFormVariables(task.getId(), null, true);
        FormServiceTest.assertEquals((int)4, (int)variables.size());
        this.taskService.deleteTask(task.getId(), true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testSubmitStartFormWithObjectVariables() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        HashMap variables = new HashMap();
        variables.put("var", new ArrayList());
        ProcessInstance processInstance = this.formService.submitStartForm(processDefinition.getId(), variables);
        ArrayList var = (ArrayList)this.runtimeService.getVariable(processInstance.getId(), "var");
        FormServiceTest.assertNotNull((Object)var);
        FormServiceTest.assertTrue((boolean)var.isEmpty());
        if (this.processEngineConfiguration.getHistoryLevel().getId() >= ProcessEngineConfigurationImpl.HISTORYLEVEL_FULL) {
            FormServiceTest.assertEquals((long)0L, (long)this.historyService.createHistoricDetailQuery().formFields().count());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/twoTasksProcess.bpmn20.xml"})
    public void testSubmitTaskFormWithObjectVariables() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("twoTasksProcess");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        FormServiceTest.assertNotNull((Object)task);
        HashMap variables = new HashMap();
        variables.put("var", new ArrayList());
        this.formService.submitTaskForm(task.getId(), variables);
        ArrayList var = (ArrayList)this.runtimeService.getVariable(processInstance.getId(), "var");
        FormServiceTest.assertNotNull((Object)var);
        FormServiceTest.assertTrue((boolean)var.isEmpty());
        if (this.processEngineConfiguration.getHistoryLevel().getId() >= ProcessEngineConfigurationImpl.HISTORYLEVEL_FULL) {
            FormServiceTest.assertEquals((long)0L, (long)this.historyService.createHistoricDetailQuery().formFields().count());
        }
    }

    @Deployment
    public void testSubmitTaskFormContainingReadonlyVariable() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinition.getId());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        FormServiceTest.assertNotNull((Object)task);
        this.formService.submitTaskForm(task.getId(), new HashMap());
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment
    public void testGetTaskFormWithoutLabels() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        TaskFormData formData = this.formService.getTaskFormData(task.getId());
        List formFields = formData.getFormFields();
        FormServiceTest.assertEquals((int)3, (int)formFields.size());
        ArrayList<String> formFieldIds = new ArrayList<String>();
        for (FormField field : formFields) {
            FormServiceTest.assertNull((Object)field.getLabel());
            formFieldIds.add(field.getId());
        }
        FormServiceTest.assertTrue((boolean)formFieldIds.containsAll(Arrays.asList("stringField", "customField", "longField")));
        Object startForm = this.formService.getRenderedTaskForm(task.getId());
        FormServiceTest.assertNotNull((Object)startForm);
    }

    public void testDeployTaskFormWithoutFieldTypes() {
        try {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/form/FormServiceTest.testDeployTaskFormWithoutFieldTypes.bpmn20.xml").deploy();
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("form field must have a 'type' attribute", e.getMessage());
        }
    }

    @Deployment
    public void testGetStartFormWithoutLabels() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        this.runtimeService.startProcessInstanceById(processDefinition.getId());
        StartFormData formData = this.formService.getStartFormData(processDefinition.getId());
        List formFields = formData.getFormFields();
        FormServiceTest.assertEquals((int)3, (int)formFields.size());
        ArrayList<String> formFieldIds = new ArrayList<String>();
        for (FormField field : formFields) {
            FormServiceTest.assertNull((Object)field.getLabel());
            formFieldIds.add(field.getId());
        }
        FormServiceTest.assertTrue((boolean)formFieldIds.containsAll(Arrays.asList("stringField", "customField", "longField")));
        Object startForm = this.formService.getRenderedStartForm(processDefinition.getId());
        FormServiceTest.assertNotNull((Object)startForm);
    }

    public void testDeployStartFormWithoutFieldTypes() {
        try {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/form/FormServiceTest.testDeployStartFormWithoutFieldTypes.bpmn20.xml").deploy();
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("form field must have a 'type' attribute", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/form/util/VacationRequest_deprecated_forms.bpmn20.xml", "org/camunda/bpm/engine/test/api/form/util/approve.form", "org/camunda/bpm/engine/test/api/form/util/request.form", "org/camunda/bpm/engine/test/api/form/util/adjustRequest.form"})
    public void testTaskFormsWithVacationRequestProcess() {
        String procDefId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId();
        Object startForm = this.formService.getRenderedStartForm(procDefId, "juel");
        FormServiceTest.assertNotNull((Object)startForm);
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        String processDefinitionId = processDefinition.getId();
        FormServiceTest.assertEquals((String)"org/camunda/bpm/engine/test/api/form/util/request.form", (String)this.formService.getStartFormData(processDefinitionId).getFormKey());
        HashMap<String, String> formProperties = new HashMap<String, String>();
        formProperties.put("employeeName", "kermit");
        formProperties.put("numberOfDays", "4");
        formProperties.put("vacationMotivation", "I'm tired");
        this.formService.submitStartFormData(procDefId, formProperties);
        Task task = (Task)this.taskService.createTaskQuery().taskCandidateGroup("management").singleResult();
        FormServiceTest.assertEquals((String)"Vacation request by kermit", (String)task.getDescription());
        Object taskForm = this.formService.getRenderedTaskForm(task.getId(), "juel");
        FormServiceTest.assertNotNull((Object)taskForm);
        this.taskService.complete(task.getId(), CollectionUtil.singletonMap((String)"vacationApproved", (Object)"false"));
        task = (Task)this.taskService.createTaskQuery().singleResult();
        FormServiceTest.assertEquals((String)"Adjust vacation request", (String)task.getName());
    }

    @Deployment
    public void testTaskFormUnavailable() {
        String procDefId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId();
        FormServiceTest.assertNull((Object)this.formService.getRenderedStartForm(procDefId));
        this.runtimeService.startProcessInstanceByKey("noStartOrTaskForm");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        FormServiceTest.assertNull((Object)this.formService.getRenderedTaskForm(task.getId()));
    }
}

