/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.tenantcheck;

import java.io.InputStream;
import java.util.Arrays;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.cmmn.CmmnModelInstance;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MultiTenancyCaseDefinitionCmdsTenantCheckTest {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String CMMN_MODEL = "org/camunda/bpm/engine/test/api/cmmn/emptyStageCase.cmmn";
    protected static final String CMMN_DIAGRAM = "org/camunda/bpm/engine/test/api/cmmn/emptyStageCase.png";
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    protected RepositoryService repositoryService;
    protected IdentityService identityService;
    protected ProcessEngineConfiguration processEngineConfiguration;
    protected String caseDefinitionId;

    @Before
    public void setUp() {
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.repositoryService = this.engineRule.getRepositoryService();
        this.identityService = this.engineRule.getIdentityService();
        this.testRule.deployForTenant(TENANT_ONE, CMMN_MODEL, CMMN_DIAGRAM);
        this.caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
    }

    @Test
    public void failToGetCaseModelNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Cannot get the case definition");
        this.repositoryService.getCaseModel(this.caseDefinitionId);
    }

    @Test
    public void getCaseModelWithAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        InputStream inputStream = this.repositoryService.getCaseModel(this.caseDefinitionId);
        Assert.assertThat((Object)inputStream, (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void getCaseModelDisabledTenantCheck() {
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        InputStream inputStream = this.repositoryService.getCaseModel(this.caseDefinitionId);
        Assert.assertThat((Object)inputStream, (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void failToGetCaseDiagramNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Cannot get the case definition");
        this.repositoryService.getCaseDiagram(this.caseDefinitionId);
    }

    @Test
    public void getCaseDiagramWithAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        InputStream inputStream = this.repositoryService.getCaseDiagram(this.caseDefinitionId);
        Assert.assertThat((Object)inputStream, (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void getCaseDiagramDisabledTenantCheck() {
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        InputStream inputStream = this.repositoryService.getCaseDiagram(this.caseDefinitionId);
        Assert.assertThat((Object)inputStream, (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void failToGetCaseDefinitionNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Cannot get the case definition");
        this.repositoryService.getCaseDefinition(this.caseDefinitionId);
    }

    @Test
    public void getCaseDefinitionWithAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        CaseDefinition definition = this.repositoryService.getCaseDefinition(this.caseDefinitionId);
        Assert.assertThat((Object)definition.getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
    }

    @Test
    public void getCaseDefinitionDisabledTenantCheck() {
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        CaseDefinition definition = this.repositoryService.getCaseDefinition(this.caseDefinitionId);
        Assert.assertThat((Object)definition.getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
    }

    @Test
    public void failToGetCmmnModelInstanceNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Cannot get the case definition");
        this.repositoryService.getCmmnModelInstance(this.caseDefinitionId);
    }

    @Test
    public void getCmmnModelInstanceWithAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        CmmnModelInstance modelInstance = this.repositoryService.getCmmnModelInstance(this.caseDefinitionId);
        Assert.assertThat((Object)modelInstance, (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void getCmmnModelInstanceDisabledTenantCheck() {
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        CmmnModelInstance modelInstance = this.repositoryService.getCmmnModelInstance(this.caseDefinitionId);
        Assert.assertThat((Object)modelInstance, (Matcher)CoreMatchers.notNullValue());
    }
}

