/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.repository;

import java.util.List;
import junit.framework.TestCase;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.exception.NotFoundException;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.impl.persistence.deploy.DeploymentCache;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ProcessInstanceWithVariables;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class DeleteProcessDefinitionTest {
    @Rule
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    protected RepositoryService repositoryService;
    protected RuntimeService runtimeService;
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected Deployment deployment;

    @Before
    public void initServices() {
        this.repositoryService = this.engineRule.getRepositoryService();
        this.runtimeService = this.engineRule.getRuntimeService();
        this.processEngineConfiguration = (ProcessEngineConfigurationImpl)this.engineRule.getProcessEngine().getProcessEngineConfiguration();
    }

    @After
    public void cleanUp() {
        if (this.deployment != null) {
            this.repositoryService.deleteDeployment(this.deployment.getId(), true);
            this.deployment = null;
        }
    }

    @Test
    public void testDeleteProcessDefinitionNullId() {
        this.thrown.expect(NullValueException.class);
        this.thrown.expectMessage("processDefinitionId is null");
        this.repositoryService.deleteProcessDefinition(null);
    }

    @Test
    public void testDeleteNonExistingProcessDefinition() {
        this.thrown.expect(NotFoundException.class);
        this.thrown.expectMessage("No process definition found with id 'notexist': processDefinition is null");
        this.repositoryService.deleteProcessDefinition("notexist");
    }

    @Test
    public void testDeleteProcessDefinition() {
        this.deployment = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/repository/twoProcesses.bpmn20.xml").deploy();
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().list();
        this.repositoryService.deleteProcessDefinition(((ProcessDefinition)processDefinitions.get(0)).getId());
        Assert.assertEquals((long)1L, (long)this.repositoryService.createProcessDefinitionQuery().count());
    }

    @Test
    public void testDeleteProcessDefinitionWithProcessInstance() {
        BpmnModelInstance bpmnModel = Bpmn.createExecutableProcess((String)"process").startEvent().userTask().endEvent().done();
        this.deployment = this.repositoryService.createDeployment().addModelInstance("process.bpmn", bpmnModel).deploy();
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("process").singleResult();
        this.runtimeService.createProcessInstanceByKey("process").executeWithVariablesInReturn();
        try {
            this.repositoryService.deleteProcessDefinition(processDefinition.getId());
            TestCase.fail((String)"Should fail, since there exists a process instance");
        }
        catch (ProcessEngineException pee) {
            TestCase.assertTrue((boolean)pee.getMessage().contains("Deletion of process definition without cascading failed."));
        }
        Assert.assertEquals((long)1L, (long)this.repositoryService.createProcessDefinitionQuery().count());
    }

    @Test
    public void testDeleteProcessDefinitionCascade() {
        BpmnModelInstance bpmnModel = Bpmn.createExecutableProcess((String)"process").startEvent().userTask().endEvent().done();
        this.deployment = this.repositoryService.createDeployment().addModelInstance("process.bpmn", bpmnModel).deploy();
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("process").singleResult();
        this.runtimeService.createProcessInstanceByKey("process").executeWithVariablesInReturn();
        this.repositoryService.deleteProcessDefinition(processDefinition.getId(), true);
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
        Assert.assertEquals((long)0L, (long)this.repositoryService.createProcessDefinitionQuery().count());
        if (this.processEngineConfiguration.getHistoryLevel().getId() >= HistoryLevel.HISTORY_LEVEL_ACTIVITY.getId()) {
            Assert.assertEquals((long)0L, (long)this.engineRule.getHistoryService().createHistoricActivityInstanceQuery().count());
        }
    }

    @Test
    public void testDeleteProcessDefinitionClearsCache() {
        BpmnModelInstance bpmnModel = Bpmn.createExecutableProcess((String)"process").startEvent().userTask().endEvent().done();
        this.deployment = this.repositoryService.createDeployment().addModelInstance("process.bpmn", bpmnModel).deploy();
        String processDefinitionId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("process").singleResult()).getId();
        DeploymentCache deploymentCache = this.processEngineConfiguration.getDeploymentCache();
        TestCase.assertTrue((boolean)deploymentCache.getProcessDefinitionCache().containsKey(processDefinitionId));
        TestCase.assertTrue((boolean)deploymentCache.getBpmnModelInstanceCache().containsKey(processDefinitionId));
        this.repositoryService.deleteProcessDefinition(processDefinitionId, true);
        TestCase.assertFalse((boolean)deploymentCache.getProcessDefinitionCache().containsKey(processDefinitionId));
        TestCase.assertFalse((boolean)deploymentCache.getBpmnModelInstanceCache().containsKey(processDefinitionId));
    }

    @Test
    public void testDeleteProcessDefinitionAndRefillDeploymentCache() {
        this.deployment = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/repository/twoProcesses.bpmn20.xml").deploy();
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().list();
        this.repositoryService.deleteProcessDefinition(((ProcessDefinition)processDefinitions.get(0)).getId());
        this.processEngineConfiguration.getDeploymentCache().discardProcessDefinitionCache();
        ProcessInstanceWithVariables procInst = this.runtimeService.createProcessInstanceByKey("two").executeWithVariablesInReturn();
        TestCase.assertNotNull((Object)procInst);
        TestCase.assertTrue((boolean)procInst.getProcessDefinitionId().contains("two"));
        Assert.assertEquals((long)1L, (long)this.processEngineConfiguration.getDeploymentCache().getProcessDefinitionCache().size());
        Assert.assertEquals((long)1L, (long)this.repositoryService.createProcessDefinitionQuery().count());
        TestCase.assertNull((Object)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("one").singleResult());
    }

    @Test
    public void testDeleteProcessDefinitionAndRedeploy() {
        this.deployment = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/repository/twoProcesses.bpmn20.xml").deploy();
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().list();
        this.repositoryService.deleteProcessDefinition(((ProcessDefinition)processDefinitions.get(0)).getId());
        Deployment deployment2 = this.repositoryService.createDeployment().name("my-deployment").addDeploymentResources(this.deployment.getId()).deploy();
        Assert.assertEquals((long)3L, (long)this.repositoryService.createProcessDefinitionQuery().count());
        this.repositoryService.deleteDeployment(deployment2.getId(), true);
    }
}

