/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime.migration;

import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.JavaDelegate;
import org.camunda.bpm.engine.externaltask.LockedExternalTask;
import org.camunda.bpm.engine.migration.MigrationPlan;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.Incident;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.runtime.FailingDelegate;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.CallActivityBuilder;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MigrationIncidentTest {
    public static final String FAIL_CALLED_PROC_KEY = "calledProc";
    public static final BpmnModelInstance FAIL_CALLED_PROC = ((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"calledProc").startEvent("start").serviceTask("task").camundaAsyncBefore()).camundaClass(FailingDelegate.class.getName())).endEvent("end").done();
    public static final String FAIL_CALL_PROC_KEY = "oneFailingServiceTaskProcess";
    public static final BpmnModelInstance FAIL_CALL_ACT_JOB_PROC = ((CallActivityBuilder)Bpmn.createExecutableProcess((String)"oneFailingServiceTaskProcess").startEvent("start").callActivity("calling").calledElement("calledProc")).endEvent("end").done();
    public static final String NEW_CALLED_PROC_KEY = "newCalledProc";
    public static final BpmnModelInstance NEW_CALLED_PROC = ((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"newCalledProc").startEvent("start").serviceTask("taskV2").camundaAsyncBefore()).camundaClass(NewDelegate.class.getName())).endEvent("end").done();
    public static final String NEW_CALL_PROC_KEY = "newServiceTaskProcess";
    public static final BpmnModelInstance NEW_CALL_ACT_PROC = ((CallActivityBuilder)Bpmn.createExecutableProcess((String)"newServiceTaskProcess").startEvent("start").callActivity("callingV2").calledElement("newCalledProc")).endEvent("end").done();
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    public ProcessEngineTestRule testHelper = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain chain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testHelper);

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/migration/calledProcess.bpmn", "org/camunda/bpm/engine/test/api/runtime/migration/callingProcess.bpmn", "org/camunda/bpm/engine/test/api/runtime/migration/callingProcess_v2.bpmn"})
    public void testCallActivityExternalTaskIncidentMigration() throws Exception {
        ProcessDefinition callingProcess = (ProcessDefinition)this.engineRule.getRepositoryService().createProcessDefinitionQuery().processDefinitionKey("callingProcess").singleResult();
        ProcessInstance processInstance = this.engineRule.getRuntimeService().startProcessInstanceById(callingProcess.getId());
        LockedExternalTask task = (LockedExternalTask)this.engineRule.getExternalTaskService().fetchAndLock(1, "foo").topic("foo", 1000L).execute().get(0);
        this.engineRule.getExternalTaskService().handleFailure(task.getId(), "foo", "error", 0, 1000L);
        Incident incidentInCallingProcess = (Incident)this.engineRule.getRuntimeService().createIncidentQuery().processDefinitionId(callingProcess.getId()).singleResult();
        ProcessDefinition callingProcessV2 = (ProcessDefinition)this.engineRule.getRepositoryService().createProcessDefinitionQuery().processDefinitionKey("callingProcessV2").singleResult();
        MigrationPlan migrationPlan = this.engineRule.getRuntimeService().createMigrationPlan(callingProcess.getId(), callingProcessV2.getId()).mapEqualActivities().mapActivities("CallActivity", "CallActivityV2").build();
        this.engineRule.getRuntimeService().newMigration(migrationPlan).processInstanceIds(new String[]{processInstance.getId()}).execute();
        Incident incidentAfterMigration = (Incident)this.engineRule.getRuntimeService().createIncidentQuery().incidentId(incidentInCallingProcess.getId()).singleResult();
        Assert.assertEquals((Object)callingProcessV2.getId(), (Object)incidentAfterMigration.getProcessDefinitionId());
        Assert.assertEquals((Object)"CallActivityV2", (Object)incidentAfterMigration.getActivityId());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/migration/calledProcess.bpmn", "org/camunda/bpm/engine/test/api/runtime/migration/calledProcess_v2.bpmn"})
    public void testExternalTaskIncidentMigration() throws Exception {
        ProcessDefinition callingProcess = (ProcessDefinition)this.engineRule.getRepositoryService().createProcessDefinitionQuery().processDefinitionKey("calledProcess").singleResult();
        ProcessInstance processInstance = this.engineRule.getRuntimeService().startProcessInstanceById(callingProcess.getId());
        LockedExternalTask task = (LockedExternalTask)this.engineRule.getExternalTaskService().fetchAndLock(1, "foo").topic("foo", 1000L).execute().get(0);
        this.engineRule.getExternalTaskService().handleFailure(task.getId(), "foo", "error", 0, 1000L);
        Incident incidentInCallingProcess = (Incident)this.engineRule.getRuntimeService().createIncidentQuery().processDefinitionId(callingProcess.getId()).singleResult();
        ProcessDefinition callingProcessV2 = (ProcessDefinition)this.engineRule.getRepositoryService().createProcessDefinitionQuery().processDefinitionKey("calledProcessV2").singleResult();
        MigrationPlan migrationPlan = this.engineRule.getRuntimeService().createMigrationPlan(callingProcess.getId(), callingProcessV2.getId()).mapEqualActivities().mapActivities("ServiceTask_1p58ywb", "ServiceTask_V2").build();
        this.engineRule.getRuntimeService().newMigration(migrationPlan).processInstanceIds(new String[]{processInstance.getId()}).execute();
        Incident incidentAfterMigration = (Incident)this.engineRule.getRuntimeService().createIncidentQuery().incidentId(incidentInCallingProcess.getId()).singleResult();
        Assert.assertEquals((Object)callingProcessV2.getId(), (Object)incidentAfterMigration.getProcessDefinitionId());
        Assert.assertEquals((Object)"ServiceTask_V2", (Object)incidentAfterMigration.getActivityId());
    }

    @Test
    public void testCallActivityJobIncidentMigration() {
        this.testHelper.deploy(FAIL_CALLED_PROC, FAIL_CALL_ACT_JOB_PROC, NEW_CALLED_PROC, NEW_CALL_ACT_PROC);
        ProcessDefinition failingProcess = (ProcessDefinition)this.engineRule.getRepositoryService().createProcessDefinitionQuery().processDefinitionKey(FAIL_CALL_PROC_KEY).singleResult();
        ProcessDefinition newProcess = (ProcessDefinition)this.engineRule.getRepositoryService().createProcessDefinitionQuery().processDefinitionKey(NEW_CALL_PROC_KEY).singleResult();
        ProcessInstance processInstance = this.engineRule.getRuntimeService().startProcessInstanceByKey(FAIL_CALL_PROC_KEY);
        this.testHelper.executeAvailableJobs();
        Incident incidentInCallingProcess = (Incident)this.engineRule.getRuntimeService().createIncidentQuery().processDefinitionId(failingProcess.getId()).singleResult();
        MigrationPlan migrationPlan = this.engineRule.getRuntimeService().createMigrationPlan(failingProcess.getId(), newProcess.getId()).mapEqualActivities().mapActivities("calling", "callingV2").build();
        this.engineRule.getRuntimeService().newMigration(migrationPlan).processInstanceIds(new String[]{processInstance.getId()}).execute();
        Incident incidentAfterMigration = (Incident)this.engineRule.getRuntimeService().createIncidentQuery().incidentId(incidentInCallingProcess.getId()).singleResult();
        Assert.assertEquals((Object)newProcess.getId(), (Object)incidentAfterMigration.getProcessDefinitionId());
        Assert.assertEquals((Object)"callingV2", (Object)incidentAfterMigration.getActivityId());
    }

    @Test
    public void testJobIncidentMigration() {
        this.testHelper.deploy(FAIL_CALLED_PROC, NEW_CALLED_PROC);
        ProcessDefinition failingProcess = (ProcessDefinition)this.engineRule.getRepositoryService().createProcessDefinitionQuery().processDefinitionKey(FAIL_CALLED_PROC_KEY).singleResult();
        ProcessDefinition newProcess = (ProcessDefinition)this.engineRule.getRepositoryService().createProcessDefinitionQuery().processDefinitionKey(NEW_CALLED_PROC_KEY).singleResult();
        ProcessInstance processInstance = this.engineRule.getRuntimeService().startProcessInstanceByKey(FAIL_CALLED_PROC_KEY);
        this.testHelper.executeAvailableJobs();
        Incident incidentInCallingProcess = (Incident)this.engineRule.getRuntimeService().createIncidentQuery().processDefinitionId(failingProcess.getId()).singleResult();
        MigrationPlan migrationPlan = this.engineRule.getRuntimeService().createMigrationPlan(failingProcess.getId(), newProcess.getId()).mapEqualActivities().mapActivities("task", "taskV2").build();
        this.engineRule.getRuntimeService().newMigration(migrationPlan).processInstanceIds(new String[]{processInstance.getId()}).execute();
        Incident incidentAfterMigration = (Incident)this.engineRule.getRuntimeService().createIncidentQuery().incidentId(incidentInCallingProcess.getId()).singleResult();
        Assert.assertEquals((Object)newProcess.getId(), (Object)incidentAfterMigration.getProcessDefinitionId());
        Assert.assertEquals((Object)"taskV2", (Object)incidentAfterMigration.getActivityId());
    }

    public static class NewDelegate
    implements JavaDelegate {
        public void execute(DelegateExecution execution) throws Exception {
        }
    }
}

