/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.variables.scope;

import java.util.Arrays;
import java.util.Map;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.ScriptEvaluationException;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessInstanceWithVariablesImpl;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.runtime.migration.ModifiableBpmnModelInstance;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.CallActivityBuilder;
import org.camunda.bpm.model.bpmn.builder.MultiInstanceLoopCharacteristicsBuilder;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TargetVariableScopeTest {
    @Rule
    public ProcessEngineRule engineRule = new ProcessEngineRule();
    @Rule
    public ProcessEngineTestRule testHelper = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/variables/scope/TargetVariableScopeTest.testExecutionWithDelegateProcess.bpmn", "org/camunda/bpm/engine/test/api/variables/scope/doer.bpmn"})
    public void testExecutionWithDelegateProcess() {
        VariableMap variables = Variables.createVariables().putValue("orderIds", Arrays.asList(new int[][]{{1, 2, 3}}));
        ProcessInstance processInstance = this.engineRule.getRuntimeService().startProcessInstanceByKey("Process_MultiInstanceCallAcitivity", (Map)variables);
        Assert.assertThat((Object)processInstance.isEnded(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)((ProcessInstanceWithVariablesImpl)processInstance).getVariables().containsKey((Object)"targetOrderId"), (Matcher)Is.is((Object)false));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/variables/scope/TargetVariableScopeTest.testExecutionWithScriptTargetScope.bpmn", "org/camunda/bpm/engine/test/api/variables/scope/doer.bpmn"})
    public void testExecutionWithScriptTargetScope() {
        VariableMap variables = Variables.createVariables().putValue("orderIds", Arrays.asList(new int[][]{{1, 2, 3}}));
        ProcessInstance processInstance = this.engineRule.getRuntimeService().startProcessInstanceByKey("Process_MultiInstanceCallAcitivity", (Map)variables);
        Assert.assertThat((Object)processInstance.isEnded(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)((ProcessInstanceWithVariablesImpl)processInstance).getVariables().containsKey((Object)"targetOrderId"), (Matcher)Is.is((Object)false));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/variables/scope/TargetVariableScopeTest.testExecutionWithoutProperTargetScope.bpmn", "org/camunda/bpm/engine/test/api/variables/scope/doer.bpmn"})
    public void testExecutionWithoutProperTargetScope() {
        VariableMap variables = Variables.createVariables().putValue("orderIds", Arrays.asList(new int[][]{{1, 2, 3}}));
        this.thrown.expect(ScriptEvaluationException.class);
        this.thrown.expectMessage(CoreMatchers.startsWith((String)"Unable to evaluate script: org.camunda.bpm.engine.ProcessEngineException: ENGINE-20011 Scope with specified activity Id NOT_EXISTING and execution"));
        this.engineRule.getRuntimeService().startProcessInstanceByKey("Process_MultiInstanceCallAcitivity", (Map)variables);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/variables/scope/doer.bpmn"})
    public void testWithDelegateVariableMapping() {
        BpmnModelInstance instance = ((ServiceTaskBuilder)((CallActivityBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"process1").startEvent().subProcess("SubProcess_1").embeddedSubProcess().startEvent().callActivity().calledElement("Process_StuffDoer")).camundaVariableMappingClass("org.camunda.bpm.engine.test.api.variables.scope.SetVariableMappingDelegate")).serviceTask().camundaClass("org.camunda.bpm.engine.test.api.variables.scope.AssertVariableScopeDelegate")).endEvent().subProcessDone().endEvent().done();
        instance = ((MultiInstanceLoopCharacteristicsBuilder)((MultiInstanceLoopCharacteristicsBuilder)((MultiInstanceLoopCharacteristicsBuilder)ModifiableBpmnModelInstance.modify(instance).activityBuilder("SubProcess_1").multiInstance().parallel()).camundaCollection("orderIds")).camundaElementVariable("orderId")).done();
        ProcessDefinition processDefinition = this.testHelper.deployAndGetDefinition(instance);
        VariableMap variables = Variables.createVariables().putValue("orderIds", Arrays.asList(new int[][]{{1, 2, 3}}));
        this.engineRule.getRuntimeService().startProcessInstanceById(processDefinition.getId(), (Map)variables);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/variables/scope/doer.bpmn"})
    public void testWithDelegateVariableMappingAndChildScope() {
        BpmnModelInstance instance = ((ServiceTaskBuilder)((CallActivityBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"process1").startEvent().parallelGateway().subProcess("SubProcess_1").embeddedSubProcess().startEvent().callActivity().calledElement("Process_StuffDoer")).camundaVariableMappingClass("org.camunda.bpm.engine.test.api.variables.scope.SetVariableToChildMappingDelegate")).serviceTask().camundaClass("org.camunda.bpm.engine.test.api.variables.scope.AssertVariableScopeDelegate")).endEvent().subProcessDone().moveToLastGateway().subProcess("SubProcess_2").embeddedSubProcess().startEvent().userTask("ut").endEvent().subProcessDone().endEvent().done();
        instance = ((MultiInstanceLoopCharacteristicsBuilder)((MultiInstanceLoopCharacteristicsBuilder)((MultiInstanceLoopCharacteristicsBuilder)ModifiableBpmnModelInstance.modify(instance).activityBuilder("SubProcess_1").multiInstance().parallel()).camundaCollection("orderIds")).camundaElementVariable("orderId")).done();
        ProcessDefinition processDefinition = this.testHelper.deployAndGetDefinition(instance);
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage(CoreMatchers.startsWith((String)"org.camunda.bpm.engine.ProcessEngineException: ENGINE-20011 Scope with specified activity Id SubProcess_2 and execution"));
        VariableMap variables = Variables.createVariables().putValue("orderIds", Arrays.asList(new int[][]{{1, 2, 3}}));
        this.engineRule.getRuntimeService().startProcessInstanceById(processDefinition.getId(), (Map)variables);
    }
}

