/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.async;

import java.util.List;
import org.camunda.bpm.engine.history.HistoricVariableInstance;
import org.camunda.bpm.engine.history.HistoricVariableInstanceQuery;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.junit.Assert;

public class AsyncEndEventTest
extends PluggableProcessEngineTestCase {
    @Deployment
    public void testAsyncEndEvent() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("asyncEndEvent");
        long count = this.runtimeService.createProcessInstanceQuery().processInstanceId(pi.getId()).active().count();
        Assert.assertEquals((long)1L, (long)this.runtimeService.createExecutionQuery().activityId("endEvent").count());
        Assert.assertEquals((long)1L, (long)count);
        this.executeAvailableJobs();
        count = this.runtimeService.createProcessInstanceQuery().processInstanceId(pi.getId()).count();
        Assert.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().activityId("endEvent").active().count());
        Assert.assertEquals((long)0L, (long)count);
    }

    @Deployment
    public void testAsyncEndEventListeners() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("asyncEndEvent");
        long count = this.runtimeService.createProcessInstanceQuery().processInstanceId(pi.getId()).active().count();
        Assert.assertNull((Object)this.runtimeService.getVariable(pi.getId(), "listener"));
        Assert.assertEquals((long)1L, (long)this.runtimeService.createExecutionQuery().activityId("endEvent").count());
        Assert.assertEquals((long)1L, (long)count);
        this.executeAvailableJobs();
        count = this.runtimeService.createProcessInstanceQuery().processInstanceId(pi.getId()).active().count();
        Assert.assertEquals((long)0L, (long)count);
        if (this.processEngineConfiguration.getHistoryLevel().getId() > ProcessEngineConfigurationImpl.HISTORYLEVEL_ACTIVITY) {
            HistoricVariableInstanceQuery name = this.historyService.createHistoricVariableInstanceQuery().processInstanceId(pi.getId()).variableName("listener");
            Assert.assertNotNull((Object)name);
            Assert.assertEquals((Object)"listener invoked", (Object)((HistoricVariableInstance)name.singleResult()).getValue());
        }
    }

    @Deployment
    public void testMultipleAsyncEndEvents() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("multipleAsyncEndEvent");
        AsyncEndEventTest.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
        List jobs = this.managementService.createJobQuery().withRetriesLeft().list();
        AsyncEndEventTest.assertEquals((int)2, (int)jobs.size());
        this.managementService.executeJob(((Job)jobs.get(0)).getId());
        jobs = this.managementService.createJobQuery().withRetriesLeft().list();
        AsyncEndEventTest.assertEquals((int)1, (int)jobs.size());
        this.managementService.executeJob(((Job)jobs.get(0)).getId());
        AsyncEndEventTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
        if (this.processEngineConfiguration.getHistoryLevel().getId() > ProcessEngineConfigurationImpl.HISTORYLEVEL_ACTIVITY) {
            HistoricVariableInstanceQuery name = this.historyService.createHistoricVariableInstanceQuery().processInstanceId(pi.getId()).variableName("message");
            Assert.assertNotNull((Object)name);
            Assert.assertEquals((Object)true, (Object)((HistoricVariableInstance)name.singleResult()).getValue());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/async/AsyncEndEventTest.testCallActivity-super.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/async/AsyncEndEventTest.testCallActivity-sub.bpmn20.xml"})
    public void testCallActivity() {
        this.runtimeService.startProcessInstanceByKey("super");
        ProcessInstance pi = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("sub").singleResult();
        AsyncEndEventTest.assertTrue((boolean)(pi instanceof ExecutionEntity));
        AsyncEndEventTest.assertEquals((String)"theSubEnd", (String)((ExecutionEntity)pi).getActivityId());
    }
}

