/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.cmmn.repetition;

import org.camunda.bpm.engine.impl.test.CmmnProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.CaseExecutionQuery;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;

public class RepetitionRuleTest
extends CmmnProcessEngineTestCase {
    private static final String CASE_ID = "case";

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/repetition/RepetitionRuleTest.testVariableBasedRule.cmmn"})
    public void testVariableBasedRepetitionRuleEvaluatesToTrue() {
        VariableMap variables = Variables.createVariables().putValue("repeat", (Object)true);
        this.createCaseInstanceByKey(CASE_ID, variables);
        String humanTask1 = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        this.complete(humanTask1);
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_2");
        RepetitionRuleTest.assertEquals((long)2L, (long)query.count());
        RepetitionRuleTest.assertEquals((long)1L, (long)query.available().count());
        RepetitionRuleTest.assertEquals((long)1L, (long)query.active().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/repetition/RepetitionRuleTest.testVariableBasedRule.cmmn"})
    public void testVariableBasedRepetitionRuleEvaluatesToFalse() {
        VariableMap variables = Variables.createVariables().putValue("repeat", (Object)false);
        this.createCaseInstanceByKey(CASE_ID, variables);
        String humanTask1 = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        this.complete(humanTask1);
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_2");
        RepetitionRuleTest.assertEquals((long)1L, (long)query.count());
        RepetitionRuleTest.assertEquals((long)1L, (long)query.active().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/repetition/RepetitionRuleTest.testDefaultVariableBasedRule.cmmn"})
    public void testDefaultVariableBasedRepetitionRuleEvaluatesToTrue() {
        VariableMap variables = Variables.createVariables().putValue("repeat", (Object)true);
        this.createCaseInstanceByKey(CASE_ID, variables);
        String humanTask1 = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        this.complete(humanTask1);
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_2");
        RepetitionRuleTest.assertEquals((long)2L, (long)query.count());
        RepetitionRuleTest.assertEquals((long)1L, (long)query.available().count());
        RepetitionRuleTest.assertEquals((long)1L, (long)query.active().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/repetition/RepetitionRuleTest.testDefaultVariableBasedRule.cmmn"})
    public void testDefaultVariableBasedRepetitionRuleEvaluatesToFalse() {
        VariableMap variables = Variables.createVariables().putValue("repeat", (Object)false);
        this.createCaseInstanceByKey(CASE_ID, variables);
        String humanTask1 = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        this.complete(humanTask1);
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_2");
        RepetitionRuleTest.assertEquals((long)1L, (long)query.count());
        RepetitionRuleTest.assertEquals((long)1L, (long)query.active().count());
    }

    @Deployment
    public void testRepeatTask() {
        this.createCaseInstance();
        String firstHumanTaskId = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        this.complete(firstHumanTaskId);
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_2");
        RepetitionRuleTest.assertEquals((long)2L, (long)query.count());
        CaseExecution originInstance = (CaseExecution)query.active().singleResult();
        RepetitionRuleTest.assertNotNull((Object)originInstance);
        CaseExecution repetitionInstance = (CaseExecution)query.available().singleResult();
        RepetitionRuleTest.assertNotNull((Object)repetitionInstance);
    }

    @Deployment
    public void testRepeatStage() {
        this.createCaseInstance();
        String firstHumanTaskId = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        this.complete(firstHumanTaskId);
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery().activityId("PI_Stage_1");
        RepetitionRuleTest.assertEquals((long)2L, (long)query.count());
        CaseExecution originInstance = (CaseExecution)query.active().singleResult();
        RepetitionRuleTest.assertNotNull((Object)originInstance);
        CaseExecution repetitionInstance = (CaseExecution)query.available().singleResult();
        RepetitionRuleTest.assertNotNull((Object)repetitionInstance);
    }

    @Deployment
    public void testRepeatMilestone() {
        this.createCaseInstance();
        String firstHumanTaskId = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        String milestoneId = this.queryCaseExecutionByActivityId("PI_Milestone_1").getId();
        this.complete(firstHumanTaskId);
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery().activityId("PI_Milestone_1");
        RepetitionRuleTest.assertEquals((long)1L, (long)query.count());
        RepetitionRuleTest.assertTrue((boolean)((CaseExecution)query.singleResult()).isAvailable());
        RepetitionRuleTest.assertFalse((boolean)milestoneId.equals(((CaseExecution)query.singleResult()).getId()));
    }

    @Deployment
    public void testRepeatTaskMultipleTimes() {
        this.createCaseInstance();
        String firstHumanTaskId = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        this.disable(firstHumanTaskId);
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_2");
        RepetitionRuleTest.assertEquals((long)2L, (long)query.count());
        CaseExecution originInstance = (CaseExecution)query.active().singleResult();
        RepetitionRuleTest.assertNotNull((Object)originInstance);
        CaseExecution repetitionInstance = (CaseExecution)query.available().singleResult();
        RepetitionRuleTest.assertNotNull((Object)repetitionInstance);
        this.reenable(firstHumanTaskId);
        this.disable(firstHumanTaskId);
        query = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_2");
        RepetitionRuleTest.assertEquals((long)3L, (long)query.count());
        RepetitionRuleTest.assertEquals((long)2L, (long)query.active().count());
        RepetitionRuleTest.assertEquals((long)1L, (long)query.available().count());
    }

    @Deployment
    public void testRepeatStageMultipleTimes() {
        this.createCaseInstance();
        String firstHumanTaskId = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        this.disable(firstHumanTaskId);
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery().activityId("PI_Stage_1");
        RepetitionRuleTest.assertEquals((long)2L, (long)query.count());
        CaseExecution originInstance = (CaseExecution)query.active().singleResult();
        RepetitionRuleTest.assertNotNull((Object)originInstance);
        CaseExecution repetitionInstance = (CaseExecution)query.available().singleResult();
        RepetitionRuleTest.assertNotNull((Object)repetitionInstance);
        this.reenable(firstHumanTaskId);
        this.disable(firstHumanTaskId);
        query = this.caseService.createCaseExecutionQuery().activityId("PI_Stage_1");
        RepetitionRuleTest.assertEquals((long)3L, (long)query.count());
        RepetitionRuleTest.assertEquals((long)2L, (long)query.active().count());
        RepetitionRuleTest.assertEquals((long)1L, (long)query.available().count());
    }

    @Deployment
    public void testRepeatMilestoneMultipleTimes() {
        this.createCaseInstance();
        String firstHumanTaskId = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        String milestoneId = this.queryCaseExecutionByActivityId("PI_Milestone_1").getId();
        this.disable(firstHumanTaskId);
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery().activityId("PI_Milestone_1");
        RepetitionRuleTest.assertEquals((long)1L, (long)query.count());
        RepetitionRuleTest.assertTrue((boolean)((CaseExecution)query.singleResult()).isAvailable());
        RepetitionRuleTest.assertFalse((boolean)milestoneId.equals(((CaseExecution)query.singleResult()).getId()));
        this.reenable(firstHumanTaskId);
        this.disable(firstHumanTaskId);
        query = this.caseService.createCaseExecutionQuery().activityId("PI_Milestone_1");
        RepetitionRuleTest.assertEquals((long)1L, (long)query.count());
        RepetitionRuleTest.assertTrue((boolean)((CaseExecution)query.singleResult()).isAvailable());
        RepetitionRuleTest.assertFalse((boolean)milestoneId.equals(((CaseExecution)query.singleResult()).getId()));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/repetition/RepetitionRuleTest.testRepeatTaskWithoutEntryCriteria.cmmn"})
    public void testRepeatTaskWithoutEntryCriteriaWhenCompleting() {
        String caseInstanceId = this.createCaseInstanceByKey(CASE_ID, Variables.createVariables().putValue("repeating", (Object)true)).getId();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1");
        RepetitionRuleTest.assertEquals((long)1L, (long)query.count());
        CaseExecution activeCaseExecution = (CaseExecution)query.active().singleResult();
        RepetitionRuleTest.assertNotNull((Object)activeCaseExecution);
        this.complete(activeCaseExecution.getId());
        query = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1");
        RepetitionRuleTest.assertEquals((long)1L, (long)query.count());
        activeCaseExecution = (CaseExecution)query.active().singleResult();
        RepetitionRuleTest.assertNotNull((Object)activeCaseExecution);
        this.caseService.setVariable(caseInstanceId, "repeating", (Object)false);
        this.complete(activeCaseExecution.getId());
        query = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1");
        RepetitionRuleTest.assertEquals((long)0L, (long)query.count());
        query = this.caseService.createCaseExecutionQuery();
        RepetitionRuleTest.assertEquals((long)1L, (long)query.count());
        RepetitionRuleTest.assertEquals((String)caseInstanceId, (String)((CaseExecution)query.singleResult()).getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/repetition/RepetitionRuleTest.testRepeatStageWithoutEntryCriteria.cmmn"})
    public void testRepeatStageWithoutEntryCriteriaWhenCompleting() {
        String caseInstanceId = this.createCaseInstanceByKey(CASE_ID, Variables.createVariables().putValue("repeating", (Object)true)).getId();
        CaseExecutionQuery stageQuery = this.caseService.createCaseExecutionQuery().activityId("PI_Stage_1");
        RepetitionRuleTest.assertEquals((long)1L, (long)stageQuery.count());
        CaseExecution activeStageCaseExecution = (CaseExecution)stageQuery.active().singleResult();
        RepetitionRuleTest.assertNotNull((Object)activeStageCaseExecution);
        CaseExecution humanTaskCaseExecution = this.queryCaseExecutionByActivityId("PI_HumanTask_1");
        this.complete(humanTaskCaseExecution.getId());
        stageQuery = this.caseService.createCaseExecutionQuery().activityId("PI_Stage_1");
        RepetitionRuleTest.assertEquals((long)1L, (long)stageQuery.count());
        activeStageCaseExecution = (CaseExecution)stageQuery.active().singleResult();
        RepetitionRuleTest.assertNotNull((Object)activeStageCaseExecution);
        humanTaskCaseExecution = this.queryCaseExecutionByActivityId("PI_HumanTask_1");
        this.caseService.setVariable(caseInstanceId, "repeating", (Object)false);
        this.complete(humanTaskCaseExecution.getId());
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        RepetitionRuleTest.assertEquals((long)1L, (long)query.count());
        RepetitionRuleTest.assertEquals((String)caseInstanceId, (String)((CaseExecution)query.singleResult()).getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/repetition/RepetitionRuleTest.testRepeatTaskWithoutEntryCriteria.cmmn"})
    public void testRepeatTaskWithoutEntryCriteriaWhenTerminating() {
        String caseInstanceId = this.createCaseInstanceByKey(CASE_ID, Variables.createVariables().putValue("repeating", (Object)true)).getId();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1");
        RepetitionRuleTest.assertEquals((long)1L, (long)query.count());
        CaseExecution activeCaseExecution = (CaseExecution)query.active().singleResult();
        RepetitionRuleTest.assertNotNull((Object)activeCaseExecution);
        this.terminate(activeCaseExecution.getId());
        query = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1");
        RepetitionRuleTest.assertEquals((long)1L, (long)query.count());
        activeCaseExecution = (CaseExecution)query.active().singleResult();
        RepetitionRuleTest.assertNotNull((Object)activeCaseExecution);
        this.caseService.setVariable(caseInstanceId, "repeating", (Object)false);
        this.terminate(activeCaseExecution.getId());
        query = this.caseService.createCaseExecutionQuery();
        RepetitionRuleTest.assertEquals((long)1L, (long)query.count());
        RepetitionRuleTest.assertEquals((String)caseInstanceId, (String)((CaseExecution)query.singleResult()).getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/repetition/RepetitionRuleTest.testRepeatStageWithoutEntryCriteria.cmmn"})
    public void testRepeatStageWithoutEntryCriteriaWhenTerminating() {
        String caseInstanceId = this.createCaseInstanceByKey(CASE_ID, Variables.createVariables().putValue("repeating", (Object)true)).getId();
        CaseExecutionQuery stageQuery = this.caseService.createCaseExecutionQuery().activityId("PI_Stage_1");
        RepetitionRuleTest.assertEquals((long)1L, (long)stageQuery.count());
        CaseExecution activeStageCaseExecution = (CaseExecution)stageQuery.active().singleResult();
        RepetitionRuleTest.assertNotNull((Object)activeStageCaseExecution);
        CaseExecution humanTaskCaseExecution = this.queryCaseExecutionByActivityId("PI_HumanTask_1");
        this.terminate(humanTaskCaseExecution.getId());
        stageQuery = this.caseService.createCaseExecutionQuery().activityId("PI_Stage_1");
        RepetitionRuleTest.assertEquals((long)1L, (long)stageQuery.count());
        activeStageCaseExecution = (CaseExecution)stageQuery.active().singleResult();
        RepetitionRuleTest.assertNotNull((Object)activeStageCaseExecution);
        humanTaskCaseExecution = this.queryCaseExecutionByActivityId("PI_HumanTask_1");
        this.caseService.setVariable(caseInstanceId, "repeating", (Object)false);
        this.terminate(humanTaskCaseExecution.getId());
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        RepetitionRuleTest.assertEquals((long)1L, (long)query.count());
        RepetitionRuleTest.assertEquals((String)caseInstanceId, (String)((CaseExecution)query.singleResult()).getId());
    }

    @Deployment
    public void testRepeatTaskWithoutEntryCriteriaOnCustomStandardEvent() {
        String caseInstanceId = this.createCaseInstance().getId();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1");
        RepetitionRuleTest.assertEquals((long)1L, (long)query.count());
        CaseExecution enabledCaseExecution = (CaseExecution)query.enabled().singleResult();
        RepetitionRuleTest.assertNotNull((Object)enabledCaseExecution);
        this.disable(enabledCaseExecution.getId());
        query = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1");
        RepetitionRuleTest.assertEquals((long)2L, (long)query.count());
        enabledCaseExecution = (CaseExecution)query.enabled().singleResult();
        RepetitionRuleTest.assertNotNull((Object)enabledCaseExecution);
        this.disable(enabledCaseExecution.getId());
        query = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1");
        RepetitionRuleTest.assertEquals((long)3L, (long)query.count());
        enabledCaseExecution = (CaseExecution)query.enabled().singleResult();
        RepetitionRuleTest.assertNotNull((Object)enabledCaseExecution);
        this.complete(caseInstanceId);
        query = this.caseService.createCaseExecutionQuery();
        RepetitionRuleTest.assertEquals((long)1L, (long)query.count());
        RepetitionRuleTest.assertEquals((String)caseInstanceId, (String)((CaseExecution)query.singleResult()).getId());
    }

    @Deployment
    public void testRepeatStageWithoutEntryCriteriaOnCustomStandardEvent() {
        String caseInstanceId = this.createCaseInstance().getId();
        CaseExecutionQuery stageQuery = this.caseService.createCaseExecutionQuery().activityId("PI_Stage_1");
        RepetitionRuleTest.assertEquals((long)1L, (long)stageQuery.count());
        CaseExecution enabledStageCaseExecution = (CaseExecution)stageQuery.enabled().singleResult();
        RepetitionRuleTest.assertNotNull((Object)enabledStageCaseExecution);
        this.disable(enabledStageCaseExecution.getId());
        stageQuery = this.caseService.createCaseExecutionQuery().activityId("PI_Stage_1");
        RepetitionRuleTest.assertEquals((long)2L, (long)stageQuery.count());
        enabledStageCaseExecution = (CaseExecution)stageQuery.enabled().singleResult();
        RepetitionRuleTest.assertNotNull((Object)enabledStageCaseExecution);
        this.disable(enabledStageCaseExecution.getId());
        stageQuery = this.caseService.createCaseExecutionQuery().activityId("PI_Stage_1");
        RepetitionRuleTest.assertEquals((long)3L, (long)stageQuery.count());
        enabledStageCaseExecution = (CaseExecution)stageQuery.enabled().singleResult();
        RepetitionRuleTest.assertNotNull((Object)enabledStageCaseExecution);
        this.complete(caseInstanceId);
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery();
        RepetitionRuleTest.assertEquals((long)1L, (long)query.count());
        RepetitionRuleTest.assertEquals((String)caseInstanceId, (String)((CaseExecution)query.singleResult()).getId());
    }

    @Deployment
    public void testNonRepeatableTaskDependsOnRepeatableTask() {
        this.createCaseInstance();
        CaseExecutionQuery availableQuery = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").available();
        this.fireEntryCriteria(((CaseExecution)availableQuery.singleResult()).getId());
        this.fireEntryCriteria(((CaseExecution)availableQuery.singleResult()).getId());
        this.fireEntryCriteria(((CaseExecution)availableQuery.singleResult()).getId());
        CaseExecutionQuery enabledQuery = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").active();
        String enabledTaskId = ((CaseExecution)enabledQuery.listPage(0, 1).get(0)).getId();
        CaseExecution secondHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_2");
        RepetitionRuleTest.assertNotNull((Object)secondHumanTask);
        RepetitionRuleTest.assertTrue((boolean)secondHumanTask.isAvailable());
        this.complete(enabledTaskId);
        secondHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_2");
        RepetitionRuleTest.assertNotNull((Object)secondHumanTask);
        RepetitionRuleTest.assertTrue((boolean)secondHumanTask.isActive());
    }

    @Deployment
    public void testRepeatableTaskDependsOnAnotherRepeatableTask() {
        this.createCaseInstance();
        CaseExecutionQuery availableQuery = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").available();
        this.fireEntryCriteria(((CaseExecution)availableQuery.singleResult()).getId());
        this.fireEntryCriteria(((CaseExecution)availableQuery.singleResult()).getId());
        this.fireEntryCriteria(((CaseExecution)availableQuery.singleResult()).getId());
        CaseExecutionQuery activeQuery = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").active();
        String activeTaskId = ((CaseExecution)activeQuery.listPage(0, 1).get(0)).getId();
        this.complete(activeTaskId);
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_2");
        RepetitionRuleTest.assertEquals((long)2L, (long)query.count());
        RepetitionRuleTest.assertEquals((long)1L, (long)query.active().count());
        RepetitionRuleTest.assertEquals((long)1L, (long)query.available().count());
        activeTaskId = ((CaseExecution)activeQuery.listPage(0, 1).get(0)).getId();
        this.complete(activeTaskId);
        query = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_2");
        RepetitionRuleTest.assertEquals((long)3L, (long)query.count());
        RepetitionRuleTest.assertEquals((long)2L, (long)query.active().count());
        RepetitionRuleTest.assertEquals((long)1L, (long)query.available().count());
    }

    @Deployment
    public void testLimitedRepetitions() {
        VariableMap variables = Variables.createVariables().putValue("repetition", (Object)0);
        this.createCaseInstanceByKey(CASE_ID, variables);
        CaseExecutionQuery availableQuery = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").available();
        this.fireEntryCriteria(((CaseExecution)availableQuery.singleResult()).getId());
        this.fireEntryCriteria(((CaseExecution)availableQuery.singleResult()).getId());
        this.fireEntryCriteria(((CaseExecution)availableQuery.singleResult()).getId());
        CaseExecutionQuery activeQuery = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").active();
        String activeTaskId = ((CaseExecution)activeQuery.listPage(0, 1).get(0)).getId();
        this.complete(activeTaskId);
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_2");
        RepetitionRuleTest.assertEquals((long)2L, (long)query.count());
        RepetitionRuleTest.assertEquals((long)1L, (long)query.active().count());
        RepetitionRuleTest.assertEquals((long)1L, (long)query.available().count());
        activeTaskId = ((CaseExecution)activeQuery.listPage(0, 1).get(0)).getId();
        this.complete(activeTaskId);
        query = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_2");
        RepetitionRuleTest.assertEquals((long)3L, (long)query.count());
        RepetitionRuleTest.assertEquals((long)2L, (long)query.active().count());
        RepetitionRuleTest.assertEquals((long)1L, (long)query.available().count());
        activeTaskId = ((CaseExecution)activeQuery.listPage(0, 1).get(0)).getId();
        this.complete(activeTaskId);
        query = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_2");
        RepetitionRuleTest.assertEquals((long)3L, (long)query.count());
        RepetitionRuleTest.assertEquals((long)3L, (long)query.active().count());
        RepetitionRuleTest.assertEquals((long)0L, (long)query.available().count());
    }

    @Deployment
    public void testLimitedSequentialRepetitions() {
        VariableMap variables = Variables.createVariables().putValue("repetition", (Object)0);
        this.createCaseInstanceByKey(CASE_ID, variables);
        CaseExecutionQuery activeQuery = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").active();
        String enabledCaseExecutionId = ((CaseExecution)activeQuery.singleResult()).getId();
        this.complete(enabledCaseExecutionId);
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1");
        RepetitionRuleTest.assertEquals((long)1L, (long)query.count());
        RepetitionRuleTest.assertEquals((long)1L, (long)query.active().count());
        enabledCaseExecutionId = ((CaseExecution)activeQuery.singleResult()).getId();
        this.complete(enabledCaseExecutionId);
        query = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1");
        RepetitionRuleTest.assertEquals((long)1L, (long)query.count());
        RepetitionRuleTest.assertEquals((long)1L, (long)query.active().count());
        enabledCaseExecutionId = ((CaseExecution)activeQuery.singleResult()).getId();
        this.complete(enabledCaseExecutionId);
        query = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1");
        RepetitionRuleTest.assertEquals((long)0L, (long)query.count());
    }

    @Deployment
    public void testLimitedParallelRepetitions() {
        VariableMap variables = Variables.createVariables().putValue("repetition", (Object)0);
        this.createCaseInstanceByKey(CASE_ID, variables);
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1");
        RepetitionRuleTest.assertEquals((long)3L, (long)query.count());
        String caseExecutionId = ((CaseExecution)query.listPage(0, 1).get(0)).getId();
        this.complete(caseExecutionId);
        RepetitionRuleTest.assertEquals((long)2L, (long)query.count());
    }

    @Deployment
    public void testAutoCompleteStage() {
        String caseInstanceId = this.createCaseInstance().getId();
        String humanTask1 = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        this.complete(humanTask1);
        CaseExecution stage = this.queryCaseExecutionByActivityId("PI_Stage_1");
        RepetitionRuleTest.assertNull((Object)stage);
        CaseInstance caseInstance = (CaseInstance)this.queryCaseExecutionById(caseInstanceId);
        RepetitionRuleTest.assertTrue((boolean)caseInstance.isCompleted());
    }

    @Deployment
    public void testAutoCompleteStageWithoutEntryCriteria() {
        VariableMap variables = Variables.createVariables().putValue("manualActivation", (Object)false);
        String caseInstanceId = this.createCaseInstanceByKey(CASE_ID, variables).getId();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1");
        RepetitionRuleTest.assertEquals((long)1L, (long)query.count());
        RepetitionRuleTest.assertEquals((long)1L, (long)query.active().count());
        String activeTaskId = ((CaseExecution)query.singleResult()).getId();
        this.complete(activeTaskId);
        CaseExecution stage = this.queryCaseExecutionByActivityId("PI_Stage_1");
        RepetitionRuleTest.assertNull((Object)stage);
        CaseInstance caseInstance = (CaseInstance)this.queryCaseExecutionById(caseInstanceId);
        RepetitionRuleTest.assertTrue((boolean)caseInstance.isCompleted());
    }

    @Deployment
    public void testAutoCompleteStageAutoActivationRepeatableTask() {
        String caseInstanceId = this.createCaseInstance().getId();
        String stageId = this.queryCaseExecutionByActivityId("PI_Stage_1").getId();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1");
        RepetitionRuleTest.assertEquals((long)1L, (long)query.count());
        RepetitionRuleTest.assertEquals((long)1L, (long)query.active().count());
        String activeTaskId = ((CaseExecution)query.singleResult()).getId();
        this.complete(activeTaskId);
        query = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1");
        RepetitionRuleTest.assertEquals((long)1L, (long)query.count());
        RepetitionRuleTest.assertEquals((long)1L, (long)query.active().count());
        CaseExecution stage = this.queryCaseExecutionByActivityId("PI_Stage_1");
        RepetitionRuleTest.assertNotNull((Object)stage);
        RepetitionRuleTest.assertTrue((boolean)stage.isActive());
        CaseInstance caseInstance = (CaseInstance)this.queryCaseExecutionById(caseInstanceId);
        RepetitionRuleTest.assertTrue((boolean)caseInstance.isActive());
    }

    @Deployment
    public void testAutoCompleteStageRequiredRepeatableTask() {
        String caseInstanceId = this.createCaseInstance().getId();
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1");
        RepetitionRuleTest.assertEquals((long)1L, (long)query.count());
        RepetitionRuleTest.assertEquals((long)1L, (long)query.active().count());
        String activeTaskId = ((CaseExecution)query.singleResult()).getId();
        this.complete(activeTaskId);
        query = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1");
        RepetitionRuleTest.assertEquals((long)1L, (long)query.count());
        RepetitionRuleTest.assertEquals((long)1L, (long)query.active().count());
        CaseExecution stage = this.queryCaseExecutionByActivityId("PI_Stage_1");
        RepetitionRuleTest.assertNotNull((Object)stage);
        RepetitionRuleTest.assertTrue((boolean)stage.isActive());
        CaseInstance caseInstance = (CaseInstance)this.queryCaseExecutionById(caseInstanceId);
        RepetitionRuleTest.assertTrue((boolean)caseInstance.isActive());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/repetition/RepetitionRuleTest.testRepeatTask.cmmn"})
    public void testShouldNotRepeatTaskAfterCompletion() {
        this.createCaseInstance();
        String humanTask1 = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        this.complete(humanTask1);
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_2");
        RepetitionRuleTest.assertEquals((long)2L, (long)query.count());
        RepetitionRuleTest.assertEquals((long)1L, (long)query.available().count());
        RepetitionRuleTest.assertEquals((long)1L, (long)query.active().count());
        String humanTask2 = ((CaseExecution)query.active().singleResult()).getId();
        this.complete(humanTask2);
        query = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_2");
        RepetitionRuleTest.assertEquals((long)1L, (long)query.count());
        RepetitionRuleTest.assertEquals((long)1L, (long)query.available().count());
    }

    @Deployment
    public void testIgnoreRepeatOnStandardEvent() {
        this.createCaseInstance();
        String humanTask1 = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        this.complete(humanTask1);
        CaseExecutionQuery query = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_2");
        RepetitionRuleTest.assertEquals((long)2L, (long)query.count());
        String humanTask2 = ((CaseExecution)query.enabled().singleResult()).getId();
        this.disable(humanTask2);
        query = this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_2");
        RepetitionRuleTest.assertEquals((long)2L, (long)query.count());
    }

    protected void fireEntryCriteria(final String caseExecutionId) {
        this.executeHelperCaseCommand(new CmmnProcessEngineTestCase.HelperCaseCommand(){

            public void execute() {
                this.getExecution(caseExecutionId).fireEntryCriteria();
            }
        });
    }
}

