/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history.useroperationlog;

import org.camunda.bpm.engine.history.UserOperationLogQuery;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.history.useroperationlog.AbstractUserOperationLogTest;

public class UserOperationLogDeletionTest
extends AbstractUserOperationLogTest {
    protected static final String PROCESS_PATH = "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml";
    protected static final String PROCESS_KEY = "oneTaskProcess";

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testDeleteProcessTaskKeepTaskOperationLog() {
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.setAssignee(taskId, "demo");
        this.taskService.complete(taskId);
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery().taskId(taskId);
        UserOperationLogDeletionTest.assertEquals((long)2L, (long)query.count());
        this.historyService.deleteHistoricTaskInstance(taskId);
        UserOperationLogDeletionTest.assertEquals((long)2L, (long)query.count());
    }

    public void testDeleteStandaloneTaskKeepUserOperationLog() {
        String taskId = "my-task";
        Task task = this.taskService.newTask(taskId);
        this.taskService.saveTask(task);
        this.taskService.setAssignee(taskId, "demo");
        this.taskService.complete(taskId);
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery().taskId(taskId);
        UserOperationLogDeletionTest.assertEquals((long)3L, (long)query.count());
        this.historyService.deleteHistoricTaskInstance(taskId);
        UserOperationLogDeletionTest.assertEquals((long)3L, (long)query.count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testDeleteCaseTaskKeepUserOperationLog() {
        this.caseService.withCaseDefinitionByKey("oneTaskCase").create();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.setAssignee(taskId, "demo");
        this.taskService.complete(taskId);
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery().taskId(taskId);
        UserOperationLogDeletionTest.assertEquals((long)2L, (long)query.count());
        this.historyService.deleteHistoricTaskInstance(taskId);
        UserOperationLogDeletionTest.assertEquals((long)2L, (long)query.count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testDeleteProcessInstanceKeepUserOperationLog() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.runtimeService.suspendProcessInstanceById(processInstanceId);
        this.runtimeService.activateProcessInstanceById(processInstanceId);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery().processInstanceId(processInstanceId);
        UserOperationLogDeletionTest.assertEquals((long)3L, (long)query.count());
        this.historyService.deleteHistoricProcessInstance(processInstanceId);
        UserOperationLogDeletionTest.assertEquals((long)3L, (long)query.count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testDeleteCaseInstanceKeepUserOperationLog() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("oneTaskCase").create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        this.caseService.closeCaseInstance(caseInstanceId);
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery().caseInstanceId(caseInstanceId);
        UserOperationLogDeletionTest.assertEquals((long)1L, (long)query.count());
        this.historyService.deleteHistoricCaseInstance(caseInstanceId);
        UserOperationLogDeletionTest.assertEquals((long)1L, (long)query.count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testDeleteDeploymentKeepUserOperationLog() {
        String deploymentId = ((org.camunda.bpm.engine.repository.Deployment)this.repositoryService.createDeploymentQuery().singleResult()).getId();
        String processDefinitionId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId();
        this.repositoryService.suspendProcessDefinitionById(processDefinitionId);
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery().processDefinitionId(processDefinitionId);
        UserOperationLogDeletionTest.assertEquals((long)1L, (long)query.count());
        this.repositoryService.deleteDeployment(deploymentId, true);
        UserOperationLogDeletionTest.assertEquals((long)1L, (long)query.count());
    }
}

