/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cfg.multitenancy;

import org.camunda.bpm.engine.history.HistoricCaseInstance;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.history.UserOperationLogEntry;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.batch.BatchEntity;
import org.camunda.bpm.engine.impl.batch.history.HistoricBatchEntity;
import org.camunda.bpm.engine.impl.cfg.CommandChecker;
import org.camunda.bpm.engine.impl.cmd.CommandLogger;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.dmn.entity.repository.DecisionDefinitionEntity;
import org.camunda.bpm.engine.impl.dmn.entity.repository.DecisionRequirementsDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.DeploymentEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricJobLogEventEntity;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricTaskInstanceEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;
import org.camunda.bpm.engine.impl.persistence.entity.TenantManager;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.CaseExecution;

public class TenantCommandChecker
implements CommandChecker {
    protected static final CommandLogger LOG = ProcessEngineLogger.CMD_LOGGER;

    @Override
    public void checkEvaluateDecision(DecisionDefinition decisionDefinition) {
        if (!this.getTenantManager().isAuthenticatedTenant(decisionDefinition.getTenantId())) {
            throw LOG.exceptionCommandWithUnauthorizedTenant("evaluate the decision '" + decisionDefinition.getId() + "'");
        }
    }

    @Override
    public void checkCreateProcessInstance(ProcessDefinition processDefinition) {
        if (!this.getTenantManager().isAuthenticatedTenant(processDefinition.getTenantId())) {
            throw LOG.exceptionCommandWithUnauthorizedTenant("create an instance of the process definition '" + processDefinition.getId() + "'");
        }
    }

    @Override
    public void checkReadProcessDefinition(ProcessDefinition processDefinition) {
        if (!this.getTenantManager().isAuthenticatedTenant(processDefinition.getTenantId())) {
            throw LOG.exceptionCommandWithUnauthorizedTenant("get the process definition '" + processDefinition.getId() + "'");
        }
    }

    @Override
    public void checkCreateCaseInstance(CaseDefinition caseDefinition) {
        if (!this.getTenantManager().isAuthenticatedTenant(caseDefinition.getTenantId())) {
            throw LOG.exceptionCommandWithUnauthorizedTenant("create an instance of the case definition '" + caseDefinition.getId() + "'");
        }
    }

    @Override
    public void checkUpdateProcessDefinitionById(String processDefinitionId) {
        ProcessDefinitionEntity processDefinition;
        if (this.getTenantManager().isTenantCheckEnabled() && (processDefinition = this.findLatestProcessDefinitionById(processDefinitionId)) != null && !this.getTenantManager().isAuthenticatedTenant(processDefinition.getTenantId())) {
            throw LOG.exceptionCommandWithUnauthorizedTenant("update the process definition '" + processDefinitionId + "'");
        }
    }

    @Override
    public void checkUpdateProcessDefinitionByKey(String processDefinitionKey) {
    }

    @Override
    public void checkDeleteProcessDefinitionById(String processDefinitionId) {
        ProcessDefinitionEntity processDefinition;
        if (this.getTenantManager().isTenantCheckEnabled() && (processDefinition = this.findLatestProcessDefinitionById(processDefinitionId)) != null && !this.getTenantManager().isAuthenticatedTenant(processDefinition.getTenantId())) {
            throw LOG.exceptionCommandWithUnauthorizedTenant("delete the process definition '" + processDefinitionId + "'");
        }
    }

    @Override
    public void checkDeleteProcessDefinitionByKey(String processDefinitionKey) {
    }

    @Override
    public void checkUpdateProcessInstanceByProcessDefinitionId(String processDefinitionId) {
        ProcessDefinitionEntity processDefinition;
        if (this.getTenantManager().isTenantCheckEnabled() && (processDefinition = this.findLatestProcessDefinitionById(processDefinitionId)) != null && !this.getTenantManager().isAuthenticatedTenant(processDefinition.getTenantId())) {
            throw LOG.exceptionCommandWithUnauthorizedTenant("update the process definition '" + processDefinitionId + "'");
        }
    }

    @Override
    public void checkUpdateProcessInstance(ExecutionEntity execution) {
        if (execution != null && !this.getTenantManager().isAuthenticatedTenant(execution.getTenantId())) {
            throw LOG.exceptionCommandWithUnauthorizedTenant("update the process instance '" + execution.getId() + "'");
        }
    }

    @Override
    public void checkUpdateJob(JobEntity job) {
        if (job != null && !this.getTenantManager().isAuthenticatedTenant(job.getTenantId())) {
            throw LOG.exceptionCommandWithUnauthorizedTenant("update the job '" + job.getId() + "'");
        }
    }

    @Override
    public void checkUpdateProcessInstanceByProcessDefinitionKey(String processDefinitionKey) {
    }

    @Override
    public void checkUpdateProcessInstanceById(String processInstanceId) {
        ExecutionEntity execution;
        if (this.getTenantManager().isTenantCheckEnabled() && (execution = this.findExecutionById(processInstanceId)) != null && !this.getTenantManager().isAuthenticatedTenant(execution.getTenantId())) {
            throw LOG.exceptionCommandWithUnauthorizedTenant("update the process instance '" + processInstanceId + "'");
        }
    }

    @Override
    public void checkCreateMigrationPlan(ProcessDefinition sourceProcessDefinition, ProcessDefinition targetProcessDefinition) {
        String sourceTenant = sourceProcessDefinition.getTenantId();
        String targetTenant = targetProcessDefinition.getTenantId();
        if (!this.getTenantManager().isAuthenticatedTenant(sourceTenant)) {
            throw LOG.exceptionCommandWithUnauthorizedTenant("get process definition '" + sourceProcessDefinition.getId() + "'");
        }
        if (!this.getTenantManager().isAuthenticatedTenant(targetTenant)) {
            throw LOG.exceptionCommandWithUnauthorizedTenant("get process definition '" + targetProcessDefinition.getId() + "'");
        }
        if (sourceTenant != null && targetTenant != null && !sourceTenant.equals(targetTenant)) {
            throw ProcessEngineLogger.MIGRATION_LOGGER.cannotMigrateBetweenTenants(sourceTenant, targetTenant);
        }
    }

    @Override
    public void checkReadProcessInstance(String processInstanceId) {
        ExecutionEntity execution;
        if (this.getTenantManager().isTenantCheckEnabled() && (execution = this.findExecutionById(processInstanceId)) != null && !this.getTenantManager().isAuthenticatedTenant(execution.getTenantId())) {
            throw LOG.exceptionCommandWithUnauthorizedTenant("read the process instance '" + processInstanceId + "'");
        }
    }

    @Override
    public void checkReadJob(JobEntity job) {
        if (job != null && !this.getTenantManager().isAuthenticatedTenant(job.getTenantId())) {
            throw LOG.exceptionCommandWithUnauthorizedTenant("read the job '" + job.getId() + "'");
        }
    }

    @Override
    public void checkReadProcessInstance(ExecutionEntity execution) {
        if (execution != null && !this.getTenantManager().isAuthenticatedTenant(execution.getTenantId())) {
            throw LOG.exceptionCommandWithUnauthorizedTenant("read the process instance '" + execution.getId() + "'");
        }
    }

    @Override
    public void checkDeleteProcessInstance(ExecutionEntity execution) {
        if (execution != null && !this.getTenantManager().isAuthenticatedTenant(execution.getTenantId())) {
            throw LOG.exceptionCommandWithUnauthorizedTenant("delete the process instance '" + execution.getId() + "'");
        }
    }

    @Override
    public void checkMigrateProcessInstance(ExecutionEntity processInstance, ProcessDefinition targetProcessDefinition) {
        String sourceTenant = processInstance.getTenantId();
        String targetTenant = targetProcessDefinition.getTenantId();
        if (this.getTenantManager().isTenantCheckEnabled() && processInstance != null && !this.getTenantManager().isAuthenticatedTenant(processInstance.getTenantId())) {
            throw LOG.exceptionCommandWithUnauthorizedTenant("migrate process instance '" + processInstance.getId() + "'");
        }
        if (!(targetTenant == null || sourceTenant != null && sourceTenant.equals(targetTenant))) {
            throw ProcessEngineLogger.MIGRATION_LOGGER.cannotMigrateInstanceBetweenTenants(processInstance.getId(), sourceTenant, targetTenant);
        }
    }

    @Override
    public void checkReadTask(TaskEntity task) {
        if (task != null && !this.getTenantManager().isAuthenticatedTenant(task.getTenantId())) {
            throw LOG.exceptionCommandWithUnauthorizedTenant("read the task '" + task.getId() + "'");
        }
    }

    @Override
    public void checkUpdateTask(TaskEntity task) {
        if (task != null && !this.getTenantManager().isAuthenticatedTenant(task.getTenantId())) {
            throw LOG.exceptionCommandWithUnauthorizedTenant("update the task '" + task.getId() + "'");
        }
    }

    @Override
    public void checkDeleteBatch(BatchEntity batch) {
        if (batch != null && !this.getTenantManager().isAuthenticatedTenant(batch.getTenantId())) {
            throw LOG.exceptionCommandWithUnauthorizedTenant("delete batch '" + batch.getId() + "'");
        }
    }

    @Override
    public void checkDeleteHistoricBatch(HistoricBatchEntity batch) {
        if (batch != null && !this.getTenantManager().isAuthenticatedTenant(batch.getTenantId())) {
            throw LOG.exceptionCommandWithUnauthorizedTenant("delete historic batch '" + batch.getId() + "'");
        }
    }

    @Override
    public void checkSuspendBatch(BatchEntity batch) {
        if (batch != null && !this.getTenantManager().isAuthenticatedTenant(batch.getTenantId())) {
            throw LOG.exceptionCommandWithUnauthorizedTenant("suspend batch '" + batch.getId() + "'");
        }
    }

    @Override
    public void checkActivateBatch(BatchEntity batch) {
        if (batch != null && !this.getTenantManager().isAuthenticatedTenant(batch.getTenantId())) {
            throw LOG.exceptionCommandWithUnauthorizedTenant("activate batch '" + batch.getId() + "'");
        }
    }

    @Override
    public void checkCreateDeployment() {
    }

    @Override
    public void checkReadDeployment(String deploymentId) {
        DeploymentEntity deployment;
        if (this.getTenantManager().isTenantCheckEnabled() && (deployment = this.findDeploymentById(deploymentId)) != null && !this.getTenantManager().isAuthenticatedTenant(deployment.getTenantId())) {
            throw LOG.exceptionCommandWithUnauthorizedTenant("get the deployment '" + deploymentId + "'");
        }
    }

    @Override
    public void checkDeleteDeployment(String deploymentId) {
        DeploymentEntity deployment;
        if (this.getTenantManager().isTenantCheckEnabled() && (deployment = this.findDeploymentById(deploymentId)) != null && !this.getTenantManager().isAuthenticatedTenant(deployment.getTenantId())) {
            throw LOG.exceptionCommandWithUnauthorizedTenant("delete the deployment '" + deploymentId + "'");
        }
    }

    @Override
    public void checkDeleteTask(TaskEntity task) {
        if (task != null && !this.getTenantManager().isAuthenticatedTenant(task.getTenantId())) {
            throw LOG.exceptionCommandWithUnauthorizedTenant("delete the task '" + task.getId() + "'");
        }
    }

    @Override
    public void checkTaskAssign(TaskEntity task) {
        if (task != null && !this.getTenantManager().isAuthenticatedTenant(task.getTenantId())) {
            throw LOG.exceptionCommandWithUnauthorizedTenant("assign the task '" + task.getId() + "'");
        }
    }

    @Override
    public void checkCreateTask(TaskEntity task) {
        if (task != null && !this.getTenantManager().isAuthenticatedTenant(task.getTenantId())) {
            throw LOG.exceptionCommandWithUnauthorizedTenant("create the task '" + task.getId() + "'");
        }
    }

    @Override
    public void checkCreateTask() {
    }

    @Override
    public void checkTaskWork(TaskEntity task) {
        if (task != null && !this.getTenantManager().isAuthenticatedTenant(task.getTenantId())) {
            throw LOG.exceptionCommandWithUnauthorizedTenant("work on task '" + task.getId() + "'");
        }
    }

    @Override
    public void checkReadDecisionDefinition(DecisionDefinitionEntity decisionDefinition) {
        if (decisionDefinition != null && !this.getTenantManager().isAuthenticatedTenant(decisionDefinition.getTenantId())) {
            throw LOG.exceptionCommandWithUnauthorizedTenant("get the decision definition '" + decisionDefinition.getId() + "'");
        }
    }

    @Override
    public void checkReadDecisionRequirementsDefinition(DecisionRequirementsDefinitionEntity decisionRequirementsDefinition) {
        if (decisionRequirementsDefinition != null && !this.getTenantManager().isAuthenticatedTenant(decisionRequirementsDefinition.getTenantId())) {
            throw LOG.exceptionCommandWithUnauthorizedTenant("get the decision requirements definition '" + decisionRequirementsDefinition.getId() + "'");
        }
    }

    @Override
    public void checkReadCaseDefinition(CaseDefinition caseDefinition) {
        if (caseDefinition != null && !this.getTenantManager().isAuthenticatedTenant(caseDefinition.getTenantId())) {
            throw LOG.exceptionCommandWithUnauthorizedTenant("get the case definition '" + caseDefinition.getId() + "'");
        }
    }

    @Override
    public void checkDeleteHistoricTaskInstance(HistoricTaskInstanceEntity task) {
        if (task != null && !this.getTenantManager().isAuthenticatedTenant(task.getTenantId())) {
            throw LOG.exceptionCommandWithUnauthorizedTenant("delete the historic task instance '" + task.getId() + "'");
        }
    }

    @Override
    public void checkDeleteHistoricProcessInstance(HistoricProcessInstance instance) {
        if (instance != null && !this.getTenantManager().isAuthenticatedTenant(instance.getTenantId())) {
            throw LOG.exceptionCommandWithUnauthorizedTenant("delete the historic process instance '" + instance.getId() + "'");
        }
    }

    @Override
    public void checkDeleteHistoricCaseInstance(HistoricCaseInstance instance) {
        if (instance != null && !this.getTenantManager().isAuthenticatedTenant(instance.getTenantId())) {
            throw LOG.exceptionCommandWithUnauthorizedTenant("delete the historic case instance '" + instance.getId() + "'");
        }
    }

    @Override
    public void checkDeleteHistoricDecisionInstance(String decisionDefinitionKey) {
    }

    @Override
    public void checkReadHistoricJobLog(HistoricJobLogEventEntity historicJobLog) {
        if (historicJobLog != null && !this.getTenantManager().isAuthenticatedTenant(historicJobLog.getTenantId())) {
            throw LOG.exceptionCommandWithUnauthorizedTenant("get the historic job log '" + historicJobLog.getId() + "'");
        }
    }

    @Override
    public void checkReadHistoryAnyProcessDefinition() {
    }

    @Override
    public void checkReadHistoryAnyTaskInstance() {
    }

    @Override
    public void checkUpdateCaseInstance(CaseExecution caseExecution) {
        if (caseExecution != null && !this.getTenantManager().isAuthenticatedTenant(caseExecution.getTenantId())) {
            throw LOG.exceptionCommandWithUnauthorizedTenant("update the case execution '" + caseExecution.getId() + "'");
        }
    }

    @Override
    public void checkReadCaseInstance(CaseExecution caseExecution) {
        if (caseExecution != null && !this.getTenantManager().isAuthenticatedTenant(caseExecution.getTenantId())) {
            throw LOG.exceptionCommandWithUnauthorizedTenant("get the case execution '" + caseExecution.getId() + "'");
        }
    }

    protected TenantManager getTenantManager() {
        return Context.getCommandContext().getTenantManager();
    }

    protected ProcessDefinitionEntity findLatestProcessDefinitionById(String processDefinitionId) {
        return Context.getCommandContext().getProcessDefinitionManager().findLatestProcessDefinitionById(processDefinitionId);
    }

    protected ExecutionEntity findExecutionById(String processInstanceId) {
        return Context.getCommandContext().getExecutionManager().findExecutionById(processInstanceId);
    }

    protected DeploymentEntity findDeploymentById(String deploymentId) {
        return Context.getCommandContext().getDeploymentManager().findDeploymentById(deploymentId);
    }

    @Override
    public void checkDeleteUserOperationLog(UserOperationLogEntry entry) {
    }
}

