/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.impl.ProcessInstanceQueryImpl;
import org.camunda.bpm.engine.impl.cfg.CommandChecker;
import org.camunda.bpm.engine.impl.cmd.AbstractSetJobStateCmd;
import org.camunda.bpm.engine.impl.cmd.AbstractSetStateCmd;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.impl.history.event.HistoricProcessInstanceEventEntity;
import org.camunda.bpm.engine.impl.history.event.HistoryEvent;
import org.camunda.bpm.engine.impl.history.event.HistoryEventProcessor;
import org.camunda.bpm.engine.impl.history.event.HistoryEventTypes;
import org.camunda.bpm.engine.impl.history.producer.HistoryEventProducer;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.management.UpdateJobSuspensionStateBuilderImpl;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionManager;
import org.camunda.bpm.engine.impl.persistence.entity.ExternalTaskManager;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyChange;
import org.camunda.bpm.engine.impl.persistence.entity.SuspensionState;
import org.camunda.bpm.engine.impl.persistence.entity.TaskManager;
import org.camunda.bpm.engine.impl.runtime.UpdateProcessInstanceSuspensionStateBuilderImpl;
import org.camunda.bpm.engine.runtime.ProcessInstance;

public abstract class AbstractSetProcessInstanceStateCmd
extends AbstractSetStateCmd {
    protected final String processInstanceId;
    protected String processDefinitionId;
    protected String processDefinitionKey;
    protected String processDefinitionTenantId;
    protected boolean isProcessDefinitionTenantIdSet = false;

    public AbstractSetProcessInstanceStateCmd(UpdateProcessInstanceSuspensionStateBuilderImpl builder) {
        super(true, null);
        this.processInstanceId = builder.getProcessInstanceId();
        this.processDefinitionId = builder.getProcessDefinitionId();
        this.processDefinitionKey = builder.getProcessDefinitionKey();
        this.processDefinitionTenantId = builder.getProcessDefinitionTenantId();
        this.isProcessDefinitionTenantIdSet = builder.isProcessDefinitionTenantIdSet();
    }

    @Override
    protected void checkParameters(CommandContext commandContext) {
        if (this.processInstanceId == null && this.processDefinitionId == null && this.processDefinitionKey == null) {
            throw new ProcessEngineException("ProcessInstanceId, ProcessDefinitionId nor ProcessDefinitionKey cannot be null.");
        }
    }

    @Override
    protected void checkAuthorization(CommandContext commandContext) {
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            if (this.processInstanceId != null) {
                checker.checkUpdateProcessInstanceById(this.processInstanceId);
                continue;
            }
            if (this.processDefinitionId != null) {
                checker.checkUpdateProcessInstanceByProcessDefinitionId(this.processDefinitionId);
                continue;
            }
            if (this.processDefinitionKey == null) continue;
            checker.checkUpdateProcessInstanceByProcessDefinitionKey(this.processDefinitionKey);
        }
    }

    @Override
    protected void updateSuspensionState(CommandContext commandContext, SuspensionState suspensionState) {
        ExecutionManager executionManager = commandContext.getExecutionManager();
        TaskManager taskManager = commandContext.getTaskManager();
        ExternalTaskManager externalTaskManager = commandContext.getExternalTaskManager();
        if (this.processInstanceId != null) {
            executionManager.updateExecutionSuspensionStateByProcessInstanceId(this.processInstanceId, suspensionState);
            taskManager.updateTaskSuspensionStateByProcessInstanceId(this.processInstanceId, suspensionState);
            externalTaskManager.updateExternalTaskSuspensionStateByProcessInstanceId(this.processInstanceId, suspensionState);
        } else if (this.processDefinitionId != null) {
            executionManager.updateExecutionSuspensionStateByProcessDefinitionId(this.processDefinitionId, suspensionState);
            taskManager.updateTaskSuspensionStateByProcessDefinitionId(this.processDefinitionId, suspensionState);
            externalTaskManager.updateExternalTaskSuspensionStateByProcessDefinitionId(this.processDefinitionId, suspensionState);
        } else if (this.isProcessDefinitionTenantIdSet) {
            executionManager.updateExecutionSuspensionStateByProcessDefinitionKeyAndTenantId(this.processDefinitionKey, this.processDefinitionTenantId, suspensionState);
            taskManager.updateTaskSuspensionStateByProcessDefinitionKeyAndTenantId(this.processDefinitionKey, this.processDefinitionTenantId, suspensionState);
            externalTaskManager.updateExternalTaskSuspensionStateByProcessDefinitionKeyAndTenantId(this.processDefinitionKey, this.processDefinitionTenantId, suspensionState);
        } else {
            executionManager.updateExecutionSuspensionStateByProcessDefinitionKey(this.processDefinitionKey, suspensionState);
            taskManager.updateTaskSuspensionStateByProcessDefinitionKey(this.processDefinitionKey, suspensionState);
            externalTaskManager.updateExternalTaskSuspensionStateByProcessDefinitionKey(this.processDefinitionKey, suspensionState);
        }
    }

    @Override
    protected void triggerHistoryEvent(CommandContext commandContext) {
        HistoryLevel historyLevel = commandContext.getProcessEngineConfiguration().getHistoryLevel();
        List<ProcessInstance> updatedProcessInstances = this.obtainProcessInstances(commandContext);
        if (this.getNewSuspensionState() != null && updatedProcessInstances != null) {
            for (final ProcessInstance processInstance : updatedProcessInstances) {
                if (!historyLevel.isHistoryEventProduced(HistoryEventTypes.PROCESS_INSTANCE_UPDATE, processInstance)) continue;
                HistoryEventProcessor.processHistoryEvents(new HistoryEventProcessor.HistoryEventCreator(){

                    @Override
                    public HistoryEvent createHistoryEvent(HistoryEventProducer producer) {
                        HistoricProcessInstanceEventEntity processInstanceUpdateEvt = (HistoricProcessInstanceEventEntity)producer.createProcessInstanceUpdateEvt((DelegateExecution)((Object)processInstance));
                        if (SuspensionState.SUSPENDED.getStateCode() == AbstractSetProcessInstanceStateCmd.this.getNewSuspensionState().getStateCode()) {
                            processInstanceUpdateEvt.setState("SUSPENDED");
                        } else {
                            processInstanceUpdateEvt.setState("ACTIVE");
                        }
                        return processInstanceUpdateEvt;
                    }
                });
            }
        }
    }

    protected List<ProcessInstance> obtainProcessInstances(CommandContext commandContext) {
        ProcessInstanceQueryImpl query = new ProcessInstanceQueryImpl();
        if (this.processInstanceId != null) {
            query.processInstanceId(this.processInstanceId);
        } else if (this.processDefinitionId != null) {
            query.processDefinitionId(this.processDefinitionId);
        } else if (this.isProcessDefinitionTenantIdSet) {
            query.processDefinitionKey(this.processDefinitionKey);
            if (this.processDefinitionTenantId != null) {
                query.tenantIdIn(this.processDefinitionTenantId);
            } else {
                query.withoutTenantId();
            }
        } else {
            query.processDefinitionKey(this.processDefinitionKey);
        }
        ArrayList<ProcessInstance> result = new ArrayList<ProcessInstance>();
        result.addAll(commandContext.getExecutionManager().findProcessInstancesByQueryCriteria(query, null));
        return result;
    }

    @Override
    protected void logUserOperation(CommandContext commandContext) {
        PropertyChange propertyChange = new PropertyChange("suspensionState", null, this.getNewSuspensionState().getName());
        commandContext.getOperationLogManager().logProcessInstanceOperation(this.getLogEntryOperation(), this.processInstanceId, this.processDefinitionId, this.processDefinitionKey, Collections.singletonList(propertyChange));
    }

    protected UpdateJobSuspensionStateBuilderImpl createJobCommandBuilder() {
        UpdateJobSuspensionStateBuilderImpl builder = new UpdateJobSuspensionStateBuilderImpl();
        if (this.processInstanceId != null) {
            builder.byProcessDefinitionId(this.processInstanceId);
        } else if (this.processDefinitionId != null) {
            builder.byProcessDefinitionId(this.processDefinitionId);
        } else if (this.processDefinitionKey != null) {
            builder.byProcessDefinitionKey(this.processDefinitionKey);
            if (this.isProcessDefinitionTenantIdSet && this.processDefinitionTenantId != null) {
                return builder.processDefinitionTenantId(this.processDefinitionTenantId);
            }
            if (this.isProcessDefinitionTenantIdSet) {
                return builder.processDefinitionWithoutTenantId();
            }
        }
        return builder;
    }

    @Override
    protected AbstractSetJobStateCmd getNextCommand() {
        UpdateJobSuspensionStateBuilderImpl jobCommandBuilder = this.createJobCommandBuilder();
        return this.getNextCommand(jobCommandBuilder);
    }

    protected abstract AbstractSetJobStateCmd getNextCommand(UpdateJobSuspensionStateBuilderImpl var1);
}

