/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.io.Serializable;
import java.util.Collections;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.impl.cfg.CommandChecker;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionManager;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyChange;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class DeleteProcessInstanceCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected boolean externallyTerminated;
    protected String processInstanceId;
    protected String deleteReason;
    protected boolean skipCustomListeners;

    public DeleteProcessInstanceCmd(String processInstanceId, String deleteReason, boolean skipCustomListeners) {
        this(processInstanceId, deleteReason, skipCustomListeners, false);
    }

    public DeleteProcessInstanceCmd(String processInstanceId, String deleteReason, boolean skipCustomListeners, boolean externallyTerminated) {
        this.processInstanceId = processInstanceId;
        this.deleteReason = deleteReason;
        this.skipCustomListeners = skipCustomListeners;
        this.externallyTerminated = externallyTerminated;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull(BadUserRequestException.class, "processInstanceId is null", "processInstanceId", (Object)this.processInstanceId);
        ExecutionManager executionManager = commandContext.getExecutionManager();
        ExecutionEntity execution = executionManager.findExecutionById(this.processInstanceId);
        EnsureUtil.ensureNotNull(BadUserRequestException.class, "No process instance found for id '" + this.processInstanceId + "'", "processInstance", (Object)execution);
        this.checkDeleteProcessInstance(execution, commandContext);
        commandContext.getExecutionManager().deleteProcessInstance(this.processInstanceId, this.deleteReason, false, this.skipCustomListeners, this.externallyTerminated);
        commandContext.getOperationLogManager().logProcessInstanceOperation("Delete", this.processInstanceId, null, null, Collections.singletonList(PropertyChange.EMPTY_CHANGE));
        return null;
    }

    protected void checkDeleteProcessInstance(ExecutionEntity execution, CommandContext commandContext) {
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkDeleteProcessInstance(execution);
        }
    }
}

