/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.dmn.deployer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.camunda.bpm.dmn.engine.DmnDecision;
import org.camunda.bpm.dmn.engine.impl.spi.transform.DmnTransformer;
import org.camunda.bpm.engine.impl.AbstractDefinitionDeployer;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.core.model.Properties;
import org.camunda.bpm.engine.impl.dmn.DecisionLogger;
import org.camunda.bpm.engine.impl.dmn.deployer.DecisionRequirementsDefinitionDeployer;
import org.camunda.bpm.engine.impl.dmn.entity.repository.DecisionDefinitionEntity;
import org.camunda.bpm.engine.impl.dmn.entity.repository.DecisionDefinitionManager;
import org.camunda.bpm.engine.impl.dmn.entity.repository.DecisionRequirementsDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.deploy.DeploymentCache;
import org.camunda.bpm.engine.impl.persistence.entity.DeploymentEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ResourceEntity;

public class DecisionDefinitionDeployer
extends AbstractDefinitionDeployer<DecisionDefinitionEntity> {
    protected static final DecisionLogger LOG = ProcessEngineLogger.DECISION_LOGGER;
    public static final String[] DMN_RESOURCE_SUFFIXES = new String[]{"dmn11.xml", "dmn"};
    protected DmnTransformer transformer;

    @Override
    protected String[] getResourcesSuffixes() {
        return DMN_RESOURCE_SUFFIXES;
    }

    @Override
    protected List<DecisionDefinitionEntity> transformDefinitions(DeploymentEntity deployment, ResourceEntity resource, Properties properties) {
        ArrayList<DecisionDefinitionEntity> decisions = new ArrayList<DecisionDefinitionEntity>();
        DecisionRequirementsDefinitionEntity deployedDrd = this.findDeployedDrdForResource(deployment, resource.getName());
        if (deployedDrd == null) {
            throw LOG.exceptionNoDrdForResource(resource.getName());
        }
        Collection decisionsOfDrd = deployedDrd.getDecisions();
        for (DmnDecision decisionOfDrd : decisionsOfDrd) {
            DecisionDefinitionEntity decisionEntity = (DecisionDefinitionEntity)decisionOfDrd;
            if (DecisionRequirementsDefinitionDeployer.isDecisionRequirementsDefinitionPersistable(deployedDrd)) {
                decisionEntity.setDecisionRequirementsDefinitionId(deployedDrd.getId());
                decisionEntity.setDecisionRequirementsDefinitionKey(deployedDrd.getKey());
            }
            decisions.add(decisionEntity);
        }
        return decisions;
    }

    protected DecisionRequirementsDefinitionEntity findDeployedDrdForResource(DeploymentEntity deployment, String resourceName) {
        List<DecisionRequirementsDefinitionEntity> deployedDrds = deployment.getDeployedArtifacts(DecisionRequirementsDefinitionEntity.class);
        if (deployedDrds != null) {
            for (DecisionRequirementsDefinitionEntity deployedDrd : deployedDrds) {
                if (!deployedDrd.getResourceName().equals(resourceName)) continue;
                return deployedDrd;
            }
        }
        return null;
    }

    @Override
    protected DecisionDefinitionEntity findDefinitionByDeploymentAndKey(String deploymentId, String definitionKey) {
        return this.getDecisionDefinitionManager().findDecisionDefinitionByDeploymentAndKey(deploymentId, definitionKey);
    }

    @Override
    protected DecisionDefinitionEntity findLatestDefinitionByKeyAndTenantId(String definitionKey, String tenantId) {
        return this.getDecisionDefinitionManager().findLatestDecisionDefinitionByKeyAndTenantId(definitionKey, tenantId);
    }

    @Override
    protected void persistDefinition(DecisionDefinitionEntity definition) {
        this.getDecisionDefinitionManager().insertDecisionDefinition(definition);
    }

    @Override
    protected void addDefinitionToDeploymentCache(DeploymentCache deploymentCache, DecisionDefinitionEntity definition) {
        deploymentCache.addDecisionDefinition(definition);
    }

    protected DecisionDefinitionManager getDecisionDefinitionManager() {
        return this.getCommandContext().getDecisionDefinitionManager();
    }

    public DmnTransformer getTransformer() {
        return this.transformer;
    }

    public void setTransformer(DmnTransformer transformer) {
        this.transformer = transformer;
    }
}

