/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.jobexecutor;

import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.cfg.TransactionListener;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandContextListener;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.jobexecutor.FailedJobCommandFactory;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutorLogger;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;

public class FailedJobListener
implements TransactionListener,
CommandContextListener {
    protected CommandExecutor commandExecutor;
    protected String jobId;
    protected Throwable exception;
    private static final JobExecutorLogger LOG = ProcessEngineLogger.JOB_EXECUTOR_LOGGER;

    public FailedJobListener(CommandExecutor commandExecutor, String jobId, Throwable exception) {
        this(commandExecutor, jobId);
        this.exception = exception;
    }

    public FailedJobListener(CommandExecutor commandExecutor, String jobId) {
        this.commandExecutor = commandExecutor;
        this.jobId = jobId;
    }

    @Override
    public void execute(CommandContext commandContext) {
        this.logJobFailure(commandContext);
        FailedJobCommandFactory failedJobCommandFactory = commandContext.getFailedJobCommandFactory();
        final Command<Object> cmd = failedJobCommandFactory.getCommand(this.jobId, this.exception);
        this.commandExecutor.execute(new Command<Void>(){

            @Override
            public Void execute(CommandContext commandContext) {
                JobEntity job = commandContext.getJobManager().findJobById(FailedJobListener.this.jobId);
                if (job != null) {
                    FailedJobListener.this.fireHistoricJobFailedEvt(job);
                    cmd.execute(commandContext);
                } else {
                    LOG.debugFailedJobNotFound(FailedJobListener.this.jobId);
                }
                return null;
            }
        });
    }

    protected void fireHistoricJobFailedEvt(JobEntity job) {
        CommandContext commandContext = Context.getCommandContext();
        job.incrementSequenceCounter();
        commandContext.getHistoricJobLogManager().fireJobFailedEvent(job, this.exception);
    }

    protected void logJobFailure(CommandContext commandContext) {
        if (commandContext.getProcessEngineConfiguration().isMetricsEnabled()) {
            commandContext.getProcessEngineConfiguration().getMetricsRegistry().markOccurrence("job-failed");
        }
    }

    public void setException(Throwable exception) {
        this.exception = exception;
    }

    public Throwable getException() {
        return this.exception;
    }

    @Override
    public void onCommandContextClose(CommandContext commandContext) {
    }

    @Override
    public void onCommandFailed(CommandContext commandContext, Throwable t) {
        if (this.exception == null) {
            this.exception = t;
        }
    }
}

