/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization.batch;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.batch.history.HistoricBatch;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationScenario;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationSpec;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationTestRule;
import org.camunda.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class DeleteProcessInstancesBatchAuthorizationTest {
    protected static final String TEST_REASON = "test reason";
    protected static final long BATCH_OPERATIONS = 3L;
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected AuthorizationTestRule authRule = new AuthorizationTestRule(this.engineRule);
    protected ProcessEngineTestRule testHelper = new ProcessEngineTestRule(this.engineRule);
    protected ProcessInstance processInstance;
    protected ProcessInstance processInstance2;
    protected Batch batch;
    protected RuntimeService runtimeService;
    protected ManagementService managementService;
    protected int invocationsPerBatchJob;
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.authRule).around((TestRule)this.testHelper);
    @Parameterized.Parameter
    public AuthorizationScenario scenario;

    @Parameterized.Parameters(name="Scenario {index}")
    public static Collection<AuthorizationScenario[]> scenarios() {
        return AuthorizationTestRule.asParameters(AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.BATCH, "*", "userId", new Permission[]{Permissions.CREATE}), AuthorizationSpec.grant((Resource)Resources.PROCESS_INSTANCE, "processInstance1", "userId", new Permission[]{Permissions.READ, Permissions.DELETE}), AuthorizationSpec.grant((Resource)Resources.PROCESS_INSTANCE, "processInstance2", "userId", new Permission[]{Permissions.READ})).failsDueToRequired(AuthorizationSpec.grant((Resource)Resources.PROCESS_INSTANCE, "processInstance2", "userId", new Permission[]{Permissions.DELETE}), AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, "Process", "userId", new Permission[]{Permissions.DELETE_INSTANCE})), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.BATCH, "*", "userId", new Permission[]{Permissions.CREATE}), AuthorizationSpec.grant((Resource)Resources.PROCESS_INSTANCE, "processInstance1", "userId", new Permission[]{Permissions.ALL}), AuthorizationSpec.grant((Resource)Resources.PROCESS_INSTANCE, "processInstance2", "userId", new Permission[]{Permissions.ALL})).succeeds(), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.BATCH, "*", "userId", new Permission[]{Permissions.CREATE}), AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, "Process", "userId", new Permission[]{Permissions.READ_INSTANCE, Permissions.DELETE_INSTANCE})).succeeds());
    }

    @Before
    public void setUp() {
        this.authRule.createUserAndGroup("userId", "groupId");
        this.runtimeService = this.engineRule.getRuntimeService();
        this.managementService = this.engineRule.getManagementService();
        this.invocationsPerBatchJob = this.engineRule.getProcessEngineConfiguration().getInvocationsPerBatchJob();
    }

    @Before
    public void deployProcesses() {
        ProcessDefinition sourceDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        this.processInstance = this.engineRule.getRuntimeService().startProcessInstanceById(sourceDefinition.getId());
        this.processInstance2 = this.engineRule.getRuntimeService().startProcessInstanceById(sourceDefinition.getId());
    }

    @After
    public void tearDown() {
        this.authRule.deleteUsersAndGroups();
        this.engineRule.getProcessEngineConfiguration().setInvocationsPerBatchJob(this.invocationsPerBatchJob);
    }

    @After
    public void cleanBatch() {
        HistoricBatch historicBatch;
        Batch batch = (Batch)this.engineRule.getManagementService().createBatchQuery().singleResult();
        if (batch != null) {
            this.engineRule.getManagementService().deleteBatch(batch.getId(), true);
        }
        if ((historicBatch = (HistoricBatch)this.engineRule.getHistoryService().createHistoricBatchQuery().singleResult()) != null) {
            this.engineRule.getHistoryService().deleteHistoricBatch(historicBatch.getId());
        }
    }

    @Test
    public void testWithTwoInvocationsProcessInstancesList() {
        this.engineRule.getProcessEngineConfiguration().setInvocationsPerBatchJob(2);
        this.setupAndExecuteProcessInstancesListTest();
        if (this.authRule.assertScenario(this.scenario)) {
            if (this.testHelper.isHistoryLevelFull()) {
                Assert.assertThat((Object)this.engineRule.getHistoryService().createUserOperationLogQuery().count(), (Matcher)Is.is((Object)3L));
            }
            if (this.authRule.scenarioSucceeded()) {
                Assert.assertThat((Object)this.runtimeService.createProcessInstanceQuery().count(), (Matcher)Is.is((Object)0L));
            } else {
                Assert.assertThat((Object)this.runtimeService.createProcessInstanceQuery().count(), (Matcher)Is.is((Object)2L));
            }
        }
    }

    @Test
    public void testProcessInstancesList() {
        this.setupAndExecuteProcessInstancesListTest();
        if (this.authRule.assertScenario(this.scenario)) {
            if (this.testHelper.isHistoryLevelFull()) {
                Assert.assertThat((Object)this.engineRule.getHistoryService().createUserOperationLogQuery().count(), (Matcher)Is.is((Object)3L));
            }
            if (this.authRule.scenarioSucceeded()) {
                Assert.assertThat((Object)this.runtimeService.createProcessInstanceQuery().count(), (Matcher)Is.is((Object)0L));
            } else {
                Assert.assertThat((Object)this.runtimeService.createProcessInstanceQuery().count(), (Matcher)Is.is((Object)1L));
            }
        }
    }

    protected void setupAndExecuteProcessInstancesListTest() {
        List<String> processInstanceIds = Arrays.asList(this.processInstance.getId(), this.processInstance2.getId());
        this.authRule.init(this.scenario).withUser("userId").bindResource("processInstance1", this.processInstance.getId()).bindResource("processInstance2", this.processInstance2.getId()).start();
        this.batch = this.runtimeService.deleteProcessInstancesAsync(processInstanceIds, null, TEST_REASON);
        this.executeSeedAndBatchJobs();
    }

    @Test
    public void testWithQuery() {
        ProcessInstanceQuery processInstanceQuery = this.runtimeService.createProcessInstanceQuery().processInstanceIds(new HashSet<String>(Arrays.asList(this.processInstance.getId(), this.processInstance2.getId())));
        this.authRule.init(this.scenario).withUser("userId").bindResource("processInstance1", this.processInstance.getId()).bindResource("processInstance2", this.processInstance2.getId()).start();
        this.batch = this.runtimeService.deleteProcessInstancesAsync(null, processInstanceQuery, TEST_REASON);
        this.executeSeedAndBatchJobs();
        if (this.authRule.assertScenario(this.scenario) && this.testHelper.isHistoryLevelFull()) {
            Assert.assertThat((Object)this.engineRule.getHistoryService().createUserOperationLogQuery().count(), (Matcher)Is.is((Object)3L));
        }
    }

    protected void executeSeedAndBatchJobs() {
        this.engineRule.getManagementService().executeJob(((Job)this.engineRule.getManagementService().createJobQuery().singleResult()).getId());
        for (Job pending : this.engineRule.getManagementService().createJobQuery().list()) {
            this.engineRule.getManagementService().executeJob(pending.getId());
        }
    }
}

