/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.cfg;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.ProcessEngineImpl;
import org.camunda.bpm.engine.impl.SchemaOperationsProcessEngineBuild;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cfg.StandaloneInMemProcessEngineConfiguration;
import org.camunda.bpm.engine.impl.db.entitymanager.DbEntityManager;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class DatabaseHistoryPropertyAutoTest {
    protected List<ProcessEngineImpl> processEngines = new ArrayList<ProcessEngineImpl>();
    @Rule
    public final ExpectedException thrown = ExpectedException.none();

    private static ProcessEngineConfigurationImpl config(String historyLevel) {
        return DatabaseHistoryPropertyAutoTest.config("false", historyLevel);
    }

    private static ProcessEngineConfigurationImpl config(String schemaUpdate, String historyLevel) {
        StandaloneInMemProcessEngineConfiguration engineConfiguration = new StandaloneInMemProcessEngineConfiguration();
        engineConfiguration.setProcessEngineName(UUID.randomUUID().toString());
        engineConfiguration.setDatabaseSchemaUpdate(schemaUpdate);
        engineConfiguration.setHistory(historyLevel);
        engineConfiguration.setDbMetricsReporterActivate(false);
        engineConfiguration.setJdbcUrl("jdbc:h2:mem:DatabaseHistoryPropertyAutoTest");
        return engineConfiguration;
    }

    @Test
    public void failWhenSecondEngineDoesNotHaveTheSameHistoryLevel() {
        this.buildEngine(DatabaseHistoryPropertyAutoTest.config("true", "full"));
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("historyLevel mismatch: configuration says HistoryLevelAudit(name=audit, id=2) and database says HistoryLevelFull(name=full, id=3)");
        this.buildEngine(DatabaseHistoryPropertyAutoTest.config("audit"));
    }

    @Test
    public void secondEngineCopiesHistoryLevelFromFirst() {
        this.buildEngine(DatabaseHistoryPropertyAutoTest.config("true", "full"));
        ProcessEngineImpl processEngineTwo = this.buildEngine(DatabaseHistoryPropertyAutoTest.config("true", "auto"));
        Assert.assertThat((Object)processEngineTwo.getProcessEngineConfiguration().getHistory(), (Matcher)CoreMatchers.is((Object)"auto"));
        Assert.assertThat((Object)processEngineTwo.getProcessEngineConfiguration().getHistoryLevel(), (Matcher)CoreMatchers.is((Object)HistoryLevel.HISTORY_LEVEL_FULL));
    }

    @Test
    public void usesDefaultValueAuditWhenNoValueIsConfigured() {
        ProcessEngineConfigurationImpl config = DatabaseHistoryPropertyAutoTest.config("true", "auto");
        ProcessEngineImpl processEngine = this.buildEngine(config);
        Integer level = (Integer)config.getCommandExecutorSchemaOperations().execute((Command)new Command<Integer>(){

            public Integer execute(CommandContext commandContext) {
                return SchemaOperationsProcessEngineBuild.databaseHistoryLevel((DbEntityManager)((DbEntityManager)commandContext.getSession(DbEntityManager.class)));
            }
        });
        Assert.assertThat((Object)level, (Matcher)CoreMatchers.equalTo((Object)HistoryLevel.HISTORY_LEVEL_AUDIT.getId()));
        Assert.assertThat((Object)processEngine.getProcessEngineConfiguration().getHistoryLevel(), (Matcher)CoreMatchers.equalTo((Object)HistoryLevel.HISTORY_LEVEL_AUDIT));
    }

    @After
    public void after() {
        for (ProcessEngineImpl engine : this.processEngines) {
            engine.close();
        }
        this.processEngines.clear();
    }

    protected ProcessEngineImpl buildEngine(ProcessEngineConfigurationImpl engineConfiguration) {
        ProcessEngineImpl engine = (ProcessEngineImpl)engineConfiguration.buildProcessEngine();
        this.processEngines.add(engine);
        return engine;
    }
}

