/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.mgmt.metrics;

import java.util.Collection;
import java.util.Date;
import java.util.Random;
import java.util.Set;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.metrics.Meter;
import org.camunda.bpm.engine.impl.metrics.MetricsRegistry;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.joda.time.DateTime;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public abstract class AbstractMetricsIntervalTest {
    protected static final ProcessEngineRule ENGINE_RULE = new ProvidedProcessEngineRule();
    protected static final ProcessEngineTestRule TEST_RULE = new ProcessEngineTestRule(ENGINE_RULE);
    protected static final String REPORTER_ID = "REPORTER_ID";
    protected static final int DEFAULT_INTERVAL = 15;
    protected static final int DEFAULT_INTERVAL_MILLIS = 900000;
    @ClassRule
    public static RuleChain RULE_CHAIN = RuleChain.outerRule((TestRule)ENGINE_RULE).around((TestRule)TEST_RULE);
    @Rule
    public final ExpectedException exception = ExpectedException.none();
    protected static RuntimeService runtimeService;
    protected static ProcessEngineConfigurationImpl processEngineConfiguration;
    protected static ManagementService managementService;
    protected static String lastReporterId;
    protected static DateTime firstInterval;
    protected static int metricsCount;

    private static void generateMeterData(long dataCount, long interval) {
        boolean MIN_OCCURENCE = true;
        int MAX_OCCURENCE = 250;
        MetricsRegistry metricsRegistry = processEngineConfiguration.getMetricsRegistry();
        Set metricNames = metricsRegistry.getMeters().keySet();
        metricsCount = metricNames.size();
        Random rand = new Random(new Date().getTime());
        long startDate = 900000L;
        firstInterval = new DateTime(startDate);
        int dataPerInterval = 5;
        int i = 0;
        while ((long)i < dataCount) {
            long diff = interval / (long)dataPerInterval;
            for (int j = 0; j < dataPerInterval; ++j) {
                ClockUtil.setCurrentTime((Date)new Date(startDate));
                for (String metricName : metricNames) {
                    long occurence = rand.nextInt(250) + 1;
                    metricsRegistry.markOccurrence(metricName, occurence);
                }
                processEngineConfiguration.getDbMetricsReporter().reportNow();
                startDate += diff;
            }
            ++i;
        }
    }

    protected static void clearMetrics() {
        AbstractMetricsIntervalTest.clearLocalMetrics();
        managementService.deleteMetrics(null);
    }

    protected static void clearLocalMetrics() {
        Collection meters = processEngineConfiguration.getMetricsRegistry().getMeters().values();
        for (Meter meter : meters) {
            meter.getAndClear();
        }
    }

    @BeforeClass
    public static void initMetrics() throws Exception {
        runtimeService = ENGINE_RULE.getRuntimeService();
        processEngineConfiguration = ENGINE_RULE.getProcessEngineConfiguration();
        managementService = ENGINE_RULE.getManagementService();
        AbstractMetricsIntervalTest.clearMetrics();
        processEngineConfiguration.setDbMetricsReporterActivate(true);
        lastReporterId = processEngineConfiguration.getDbMetricsReporter().getMetricsCollectionTask().getReporter();
        processEngineConfiguration.getDbMetricsReporter().setReporterId(REPORTER_ID);
        AbstractMetricsIntervalTest.generateMeterData(3L, 900000L);
    }

    @AfterClass
    public static void cleanUp() {
        ClockUtil.reset();
        processEngineConfiguration.setDbMetricsReporterActivate(false);
        processEngineConfiguration.getDbMetricsReporter().setReporterId(lastReporterId);
        AbstractMetricsIntervalTest.clearMetrics();
    }
}

