/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy;

import org.camunda.bpm.engine.delegate.DelegateTask;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.test.api.delegate.AssertingTaskListener;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class MultiTenancyDelegateTaskTest
extends PluggableProcessEngineTestCase {
    protected static final String BPMN = "org/camunda/bpm/engine/test/api/multitenancy/taskListener.bpmn";

    public void testSingleExecutionWithUserTask() {
        this.deploymentForTenant("tenant1", new String[]{BPMN});
        AssertingTaskListener.addAsserts(MultiTenancyDelegateTaskTest.hasTenantId("tenant1"));
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        this.runtimeService.startProcessInstanceById(processDefinition.getId());
    }

    protected static AssertingTaskListener.DelegateTaskAsserter hasTenantId(final String expectedTenantId) {
        return new AssertingTaskListener.DelegateTaskAsserter(){

            @Override
            public void doAssert(DelegateTask task) {
                Assert.assertThat((Object)task.getTenantId(), (Matcher)CoreMatchers.is((Object)expectedTenantId));
            }
        };
    }

    protected void tearDown() throws Exception {
        AssertingTaskListener.clear();
        super.tearDown();
    }
}

