/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.query;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.management.ActivityStatisticsQuery;
import org.camunda.bpm.engine.management.DeploymentStatistics;
import org.camunda.bpm.engine.management.DeploymentStatisticsQuery;
import org.camunda.bpm.engine.management.ProcessDefinitionStatistics;
import org.camunda.bpm.engine.management.ProcessDefinitionStatisticsQuery;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class MultiTenancyStatisticsQueryTest
extends PluggableProcessEngineTestCase {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";

    protected void setUp() {
        BpmnModelInstance process = Bpmn.createExecutableProcess((String)"EmptyProcess").startEvent().done();
        BpmnModelInstance singleTaskProcess = Bpmn.createExecutableProcess((String)"SingleTaskProcess").startEvent().userTask().done();
        this.deployment(new BpmnModelInstance[]{process});
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{singleTaskProcess});
        this.deploymentForTenant(TENANT_TWO, new BpmnModelInstance[]{process});
    }

    public void testDeploymentStatistics() {
        List deploymentStatistics = this.managementService.createDeploymentStatisticsQuery().list();
        Assert.assertThat((Object)deploymentStatistics.size(), (Matcher)CoreMatchers.is((Object)3));
        Set<String> tenantIds = this.collectDeploymentTenantIds(deploymentStatistics);
        Assert.assertThat(tenantIds, (Matcher)CoreMatchers.hasItems((Object[])new String[]{null, TENANT_ONE, TENANT_TWO}));
    }

    public void testProcessDefinitionStatistics() {
        List processDefinitionStatistics = this.managementService.createProcessDefinitionStatisticsQuery().list();
        Assert.assertThat((Object)processDefinitionStatistics.size(), (Matcher)CoreMatchers.is((Object)3));
        Set<String> tenantIds = this.collectDefinitionTenantIds(processDefinitionStatistics);
        Assert.assertThat(tenantIds, (Matcher)CoreMatchers.hasItems((Object[])new String[]{null, TENANT_ONE, TENANT_TWO}));
    }

    public void testQueryNoAuthenticatedTenantsForDeploymentStatistics() {
        this.identityService.setAuthentication("user", null, null);
        DeploymentStatisticsQuery query = this.managementService.createDeploymentStatisticsQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        Set<String> tenantIds = this.collectDeploymentTenantIds(query.list());
        Assert.assertThat((Object)tenantIds.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)tenantIds.iterator().next(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    public void testQueryAuthenticatedTenantForDeploymentStatistics() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        DeploymentStatisticsQuery query = this.managementService.createDeploymentStatisticsQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
        Set<String> tenantIds = this.collectDeploymentTenantIds(query.list());
        Assert.assertThat((Object)tenantIds.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat(tenantIds, (Matcher)CoreMatchers.hasItems((Object[])new String[]{null, TENANT_ONE}));
    }

    public void testQueryAuthenticatedTenantsForDeploymentStatistics() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE, TENANT_TWO));
        DeploymentStatisticsQuery query = this.managementService.createDeploymentStatisticsQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)3L));
        Set<String> tenantIds = this.collectDeploymentTenantIds(query.list());
        Assert.assertThat((Object)tenantIds.size(), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat(tenantIds, (Matcher)CoreMatchers.hasItems((Object[])new String[]{null, TENANT_ONE, TENANT_TWO}));
    }

    public void testQueryDisabledTenantCheckForDeploymentStatistics() {
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        DeploymentStatisticsQuery query = this.managementService.createDeploymentStatisticsQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)3L));
        Set<String> tenantIds = this.collectDeploymentTenantIds(query.list());
        Assert.assertThat((Object)tenantIds.size(), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat(tenantIds, (Matcher)CoreMatchers.hasItems((Object[])new String[]{null, TENANT_ONE, TENANT_TWO}));
    }

    public void testQueryNoAuthenticatedTenantsForProcessDefinitionStatistics() {
        this.identityService.setAuthentication("user", null, null);
        ProcessDefinitionStatisticsQuery query = this.managementService.createProcessDefinitionStatisticsQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        Set<String> tenantIds = this.collectDefinitionTenantIds(query.list());
        Assert.assertThat((Object)tenantIds.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)tenantIds.iterator().next(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    public void testQueryAuthenticatedTenantForProcessDefinitionStatistics() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        ProcessDefinitionStatisticsQuery query = this.managementService.createProcessDefinitionStatisticsQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
        Set<String> tenantIds = this.collectDefinitionTenantIds(query.list());
        Assert.assertThat((Object)tenantIds.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat(tenantIds, (Matcher)CoreMatchers.hasItems((Object[])new String[]{null, TENANT_ONE}));
    }

    public void testQueryAuthenticatedTenantsForProcessDefinitionStatistics() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE, TENANT_TWO));
        ProcessDefinitionStatisticsQuery query = this.managementService.createProcessDefinitionStatisticsQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)3L));
        Set<String> tenantIds = this.collectDefinitionTenantIds(query.list());
        Assert.assertThat((Object)tenantIds.size(), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat(tenantIds, (Matcher)CoreMatchers.hasItems((Object[])new String[]{null, TENANT_ONE, TENANT_TWO}));
    }

    public void testQueryDisabledTenantCheckForProcessDefinitionStatistics() {
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        ProcessDefinitionStatisticsQuery query = this.managementService.createProcessDefinitionStatisticsQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)3L));
        Set<String> tenantIds = this.collectDefinitionTenantIds(query.list());
        Assert.assertThat((Object)tenantIds.size(), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat(tenantIds, (Matcher)CoreMatchers.hasItems((Object[])new String[]{null, TENANT_ONE, TENANT_TWO}));
    }

    public void testActivityStatistics() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("SingleTaskProcess");
        ActivityStatisticsQuery query = this.managementService.createActivityStatisticsQuery(processInstance.getProcessDefinitionId());
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testQueryAuthenticatedTenantForActivityStatistics() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("SingleTaskProcess");
        ActivityStatisticsQuery query = this.managementService.createActivityStatisticsQuery(processInstance.getProcessDefinitionId());
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testQueryNoAuthenticatedTenantForActivityStatistics() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("SingleTaskProcess");
        this.identityService.setAuthentication("user", null);
        ActivityStatisticsQuery query = this.managementService.createActivityStatisticsQuery(processInstance.getProcessDefinitionId());
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    public void testQueryDisabledTenantCheckForActivityStatistics() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("SingleTaskProcess");
        this.identityService.setAuthentication("user", null);
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        ActivityStatisticsQuery query = this.managementService.createActivityStatisticsQuery(processInstance.getProcessDefinitionId());
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    protected Set<String> collectDeploymentTenantIds(List<DeploymentStatistics> deploymentStatistics) {
        HashSet<String> tenantIds = new HashSet<String>();
        for (DeploymentStatistics statistics : deploymentStatistics) {
            tenantIds.add(statistics.getTenantId());
        }
        return tenantIds;
    }

    protected Set<String> collectDefinitionTenantIds(List<ProcessDefinitionStatistics> processDefinitionStatistics) {
        HashSet<String> tenantIds = new HashSet<String>();
        for (ProcessDefinitionStatistics statistics : processDefinitionStatistics) {
            tenantIds.add(statistics.getTenantId());
        }
        return tenantIds;
    }
}

