/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.repository;

import java.util.Date;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.impl.calendar.DateTimeUtil;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.repository.DeploymentQuery;

public class DeploymentQueryTest
extends PluggableProcessEngineTestCase {
    private String deploymentOneId;
    private String deploymentTwoId;

    protected void setUp() throws Exception {
        this.deploymentOneId = this.repositoryService.createDeployment().name("org/camunda/bpm/engine/test/repository/one.bpmn20.xml").addClasspathResource("org/camunda/bpm/engine/test/repository/one.bpmn20.xml").source("process application").deploy().getId();
        this.deploymentTwoId = this.repositoryService.createDeployment().name("org/camunda/bpm/engine/test/repository/two.bpmn20.xml").addClasspathResource("org/camunda/bpm/engine/test/repository/two.bpmn20.xml").deploy().getId();
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.repositoryService.deleteDeployment(this.deploymentOneId, true);
        this.repositoryService.deleteDeployment(this.deploymentTwoId, true);
    }

    public void testQueryNoCriteria() {
        DeploymentQuery query = this.repositoryService.createDeploymentQuery();
        DeploymentQueryTest.assertEquals((int)2, (int)query.list().size());
        DeploymentQueryTest.assertEquals((long)2L, (long)query.count());
        try {
            query.singleResult();
            DeploymentQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByDeploymentId() {
        DeploymentQuery query = this.repositoryService.createDeploymentQuery().deploymentId(this.deploymentOneId);
        DeploymentQueryTest.assertNotNull((Object)query.singleResult());
        DeploymentQueryTest.assertEquals((int)1, (int)query.list().size());
        DeploymentQueryTest.assertEquals((long)1L, (long)query.count());
    }

    public void testQueryByInvalidDeploymentId() {
        DeploymentQuery query = this.repositoryService.createDeploymentQuery().deploymentId("invalid");
        DeploymentQueryTest.assertNull((Object)query.singleResult());
        DeploymentQueryTest.assertEquals((int)0, (int)query.list().size());
        DeploymentQueryTest.assertEquals((long)0L, (long)query.count());
        try {
            this.repositoryService.createDeploymentQuery().deploymentId(null);
            DeploymentQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByName() {
        DeploymentQuery query = this.repositoryService.createDeploymentQuery().deploymentName("org/camunda/bpm/engine/test/repository/two.bpmn20.xml");
        DeploymentQueryTest.assertNotNull((Object)query.singleResult());
        DeploymentQueryTest.assertEquals((int)1, (int)query.list().size());
        DeploymentQueryTest.assertEquals((long)1L, (long)query.count());
    }

    public void testQueryByInvalidName() {
        DeploymentQuery query = this.repositoryService.createDeploymentQuery().deploymentName("invalid");
        DeploymentQueryTest.assertNull((Object)query.singleResult());
        DeploymentQueryTest.assertEquals((int)0, (int)query.list().size());
        DeploymentQueryTest.assertEquals((long)0L, (long)query.count());
        try {
            this.repositoryService.createDeploymentQuery().deploymentName(null);
            DeploymentQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByNameLike() {
        DeploymentQuery query = this.repositoryService.createDeploymentQuery().deploymentNameLike("%camunda%");
        DeploymentQueryTest.assertEquals((int)2, (int)query.list().size());
        DeploymentQueryTest.assertEquals((long)2L, (long)query.count());
        query = this.repositoryService.createDeploymentQuery().deploymentNameLike("%one%");
        DeploymentQueryTest.assertEquals((int)1, (int)query.list().size());
        DeploymentQueryTest.assertEquals((long)1L, (long)query.count());
        DeploymentQueryTest.assertEquals((String)"org/camunda/bpm/engine/test/repository/one.bpmn20.xml", (String)((Deployment)query.singleResult()).getName());
    }

    public void testQueryByInvalidNameLike() {
        DeploymentQuery query = this.repositoryService.createDeploymentQuery().deploymentNameLike("invalid");
        DeploymentQueryTest.assertNull((Object)query.singleResult());
        DeploymentQueryTest.assertEquals((int)0, (int)query.list().size());
        DeploymentQueryTest.assertEquals((long)0L, (long)query.count());
        try {
            this.repositoryService.createDeploymentQuery().deploymentNameLike(null);
            DeploymentQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByDeploymentBefore() throws Exception {
        Date later = DateTimeUtil.now().plus(36000L).toDate();
        Date earlier = DateTimeUtil.now().minus(36000L).toDate();
        long count = this.repositoryService.createDeploymentQuery().deploymentBefore(later).count();
        DeploymentQueryTest.assertEquals((long)2L, (long)count);
        count = this.repositoryService.createDeploymentQuery().deploymentBefore(earlier).count();
        DeploymentQueryTest.assertEquals((long)0L, (long)count);
        try {
            this.repositoryService.createDeploymentQuery().deploymentBefore(null);
            DeploymentQueryTest.fail((String)"Exception expected");
        }
        catch (NullValueException e) {
            // empty catch block
        }
    }

    public void testQueryDeploymentAfter() throws Exception {
        Date later = DateTimeUtil.now().plus(36000L).toDate();
        Date earlier = DateTimeUtil.now().minus(36000L).toDate();
        long count = this.repositoryService.createDeploymentQuery().deploymentAfter(later).count();
        DeploymentQueryTest.assertEquals((long)0L, (long)count);
        count = this.repositoryService.createDeploymentQuery().deploymentAfter(earlier).count();
        DeploymentQueryTest.assertEquals((long)2L, (long)count);
        try {
            this.repositoryService.createDeploymentQuery().deploymentAfter(null);
            DeploymentQueryTest.fail((String)"Exception expected");
        }
        catch (NullValueException e) {
            // empty catch block
        }
    }

    public void testQueryBySource() {
        DeploymentQuery query = this.repositoryService.createDeploymentQuery().deploymentSource("process application");
        DeploymentQueryTest.assertEquals((int)1, (int)query.list().size());
        DeploymentQueryTest.assertEquals((long)1L, (long)query.count());
    }

    public void testQueryByNullSource() {
        DeploymentQuery query = this.repositoryService.createDeploymentQuery().deploymentSource(null);
        DeploymentQueryTest.assertEquals((int)1, (int)query.list().size());
        DeploymentQueryTest.assertEquals((long)1L, (long)query.count());
    }

    public void testQueryByInvalidSource() {
        DeploymentQuery query = this.repositoryService.createDeploymentQuery().deploymentSource("invalid");
        DeploymentQueryTest.assertEquals((int)0, (int)query.list().size());
        DeploymentQueryTest.assertEquals((long)0L, (long)query.count());
    }

    public void testQueryDeploymentBetween() throws Exception {
        Date later = DateTimeUtil.now().plus(36000L).toDate();
        Date earlier = DateTimeUtil.now().minus(36000L).toDate();
        long count = this.repositoryService.createDeploymentQuery().deploymentAfter(earlier).deploymentBefore(later).count();
        DeploymentQueryTest.assertEquals((long)2L, (long)count);
        count = this.repositoryService.createDeploymentQuery().deploymentAfter(later).deploymentBefore(later).count();
        DeploymentQueryTest.assertEquals((long)0L, (long)count);
        count = this.repositoryService.createDeploymentQuery().deploymentAfter(earlier).deploymentBefore(earlier).count();
        DeploymentQueryTest.assertEquals((long)0L, (long)count);
        count = this.repositoryService.createDeploymentQuery().deploymentAfter(later).deploymentBefore(earlier).count();
        DeploymentQueryTest.assertEquals((long)0L, (long)count);
    }

    public void testVerifyDeploymentProperties() {
        List deployments = ((DeploymentQuery)this.repositoryService.createDeploymentQuery().orderByDeploymentName().asc()).list();
        Deployment deploymentOne = (Deployment)deployments.get(0);
        DeploymentQueryTest.assertEquals((String)"org/camunda/bpm/engine/test/repository/one.bpmn20.xml", (String)deploymentOne.getName());
        DeploymentQueryTest.assertEquals((String)this.deploymentOneId, (String)deploymentOne.getId());
        DeploymentQueryTest.assertEquals((String)"process application", (String)deploymentOne.getSource());
        DeploymentQueryTest.assertNull((Object)deploymentOne.getTenantId());
        Deployment deploymentTwo = (Deployment)deployments.get(1);
        DeploymentQueryTest.assertEquals((String)"org/camunda/bpm/engine/test/repository/two.bpmn20.xml", (String)deploymentTwo.getName());
        DeploymentQueryTest.assertEquals((String)this.deploymentTwoId, (String)deploymentTwo.getId());
        DeploymentQueryTest.assertNull((Object)deploymentTwo.getSource());
        DeploymentQueryTest.assertNull((Object)deploymentTwo.getTenantId());
    }

    public void testQuerySorting() {
        DeploymentQueryTest.assertEquals((int)2, (int)((DeploymentQuery)this.repositoryService.createDeploymentQuery().orderByDeploymentName().asc()).list().size());
        DeploymentQueryTest.assertEquals((int)2, (int)((DeploymentQuery)this.repositoryService.createDeploymentQuery().orderByDeploymentId().asc()).list().size());
        DeploymentQueryTest.assertEquals((int)2, (int)((DeploymentQuery)this.repositoryService.createDeploymentQuery().orderByDeploymenTime().asc()).list().size());
    }
}

