/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.batch.history.HistoricBatch;
import org.camunda.bpm.engine.history.HistoricTaskInstance;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class RuntimeServiceAsyncOperationsTest {
    public static final String TESTING_INSTANCE_DELETE = "testing instance delete";
    public static final String ONE_TASK_PROCESS = "oneTaskProcess";
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    public ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    private RuntimeService runtimeService;
    private ManagementService managementService;
    private HistoryService historyService;

    @Before
    public void initServices() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.managementService = this.engineRule.getManagementService();
        this.historyService = this.engineRule.getHistoryService();
    }

    @After
    public void cleanBatch() {
        HistoricBatch historicBatch;
        Batch batch = (Batch)this.managementService.createBatchQuery().singleResult();
        if (batch != null) {
            this.managementService.deleteBatch(batch.getId(), true);
        }
        if ((historicBatch = (HistoricBatch)this.historyService.createHistoricBatchQuery().singleResult()) != null) {
            this.historyService.deleteHistoricBatch(historicBatch.getId());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testDeleteProcessInstancesAsyncWithList() throws Exception {
        List<String> processIds = this.startTestProcesses(2);
        Batch batch = this.runtimeService.deleteProcessInstancesAsync(processIds, null, TESTING_INSTANCE_DELETE);
        this.executeSeedJob(batch);
        this.executeBatchJobs(batch);
        this.assertTasksAreDeleted(processIds, TESTING_INSTANCE_DELETE);
        this.assertHistoricBatchExists();
        this.assertProcessInstancesAreDeleted();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testDeleteProcessInstancesAsyncWithListOnly() throws Exception {
        List<String> processIds = this.startTestProcesses(2);
        Batch batch = this.runtimeService.deleteProcessInstancesAsync(processIds, TESTING_INSTANCE_DELETE);
        this.executeSeedJob(batch);
        this.executeBatchJobs(batch);
        this.assertTasksAreDeleted(processIds, TESTING_INSTANCE_DELETE);
        this.assertHistoricBatchExists();
        this.assertProcessInstancesAreDeleted();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testDeleteProcessInstancesAsyncWithNonExistingId() throws Exception {
        List<String> processIds = this.startTestProcesses(2);
        processIds.add("unknown");
        Batch batch = this.runtimeService.deleteProcessInstancesAsync(processIds, null, TESTING_INSTANCE_DELETE);
        this.executeSeedJob(batch);
        List<Exception> exceptions = this.executeBatchJobs(batch);
        Assert.assertEquals((long)1L, (long)exceptions.size());
        Exception e = exceptions.get(0);
        Assert.assertTrue((boolean)e.getMessage().startsWith("No process instance found for id 'unknown'"));
        Assert.assertThat((Object)this.managementService.createJobQuery().withException().list().size(), (Matcher)CoreMatchers.is((Object)1));
        processIds.remove("unknown");
        this.assertTasksAreDeleted(processIds, TESTING_INSTANCE_DELETE);
        this.assertHistoricBatchExists();
        this.assertProcessInstancesAreDeleted();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testDeleteProcessInstancesAsyncWithNullList() throws Exception {
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("processInstanceIds is empty");
        this.runtimeService.deleteProcessInstancesAsync(null, null, TESTING_INSTANCE_DELETE);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testDeleteProcessInstancesAsyncWithEmptyList() throws Exception {
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("processInstanceIds is empty");
        this.runtimeService.deleteProcessInstancesAsync(new ArrayList(), null, TESTING_INSTANCE_DELETE);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testDeleteProcessInstancesAsyncWithQuery() throws Exception {
        List<String> processIds = this.startTestProcesses(2);
        ProcessInstanceQuery processInstanceQuery = this.runtimeService.createProcessInstanceQuery().processInstanceIds(new HashSet<String>(processIds));
        Batch batch = this.runtimeService.deleteProcessInstancesAsync(null, processInstanceQuery, TESTING_INSTANCE_DELETE);
        this.executeSeedJob(batch);
        this.executeBatchJobs(batch);
        this.assertTasksAreDeleted(processIds, TESTING_INSTANCE_DELETE);
        this.assertHistoricBatchExists();
        this.assertProcessInstancesAreDeleted();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testDeleteProcessInstancesAsyncWithQueryOnly() throws Exception {
        List<String> processIds = this.startTestProcesses(2);
        ProcessInstanceQuery processInstanceQuery = this.runtimeService.createProcessInstanceQuery().processInstanceIds(new HashSet<String>(processIds));
        Batch batch = this.runtimeService.deleteProcessInstancesAsync(processInstanceQuery, TESTING_INSTANCE_DELETE);
        this.executeSeedJob(batch);
        this.executeBatchJobs(batch);
        this.assertTasksAreDeleted(processIds, TESTING_INSTANCE_DELETE);
        this.assertHistoricBatchExists();
        this.assertProcessInstancesAreDeleted();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testDeleteProcessInstancesAsyncWithQueryWithoutDeleteReason() throws Exception {
        List<String> processIds = this.startTestProcesses(2);
        ProcessInstanceQuery processInstanceQuery = this.runtimeService.createProcessInstanceQuery().processInstanceIds(new HashSet<String>(processIds));
        Batch batch = this.runtimeService.deleteProcessInstancesAsync(null, processInstanceQuery, null);
        this.executeSeedJob(batch);
        this.executeBatchJobs(batch);
        this.assertTasksAreDeleted(processIds, "deleted");
        this.assertHistoricBatchExists();
        this.assertProcessInstancesAreDeleted();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testDeleteProcessInstancesAsyncWithNullQueryParameter() throws Exception {
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("processInstanceIds is empty");
        this.runtimeService.deleteProcessInstancesAsync(null, null, TESTING_INSTANCE_DELETE);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testDeleteProcessInstancesAsyncWithInvalidQueryParameter() throws Exception {
        this.startTestProcesses(2);
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().processInstanceBusinessKey("invalid");
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("processInstanceIds is empty");
        this.runtimeService.deleteProcessInstancesAsync(null, query, TESTING_INSTANCE_DELETE);
    }

    private void executeSeedJob(Batch batch) {
        String seedJobDefinitionId = batch.getSeedJobDefinitionId();
        Job seedJob = (Job)this.managementService.createJobQuery().jobDefinitionId(seedJobDefinitionId).singleResult();
        Assert.assertNotNull((Object)seedJob);
        this.managementService.executeJob(seedJob.getId());
    }

    private List<Exception> executeBatchJobs(Batch batch) {
        String batchJobDefinitionId = batch.getBatchJobDefinitionId();
        List batchJobs = this.managementService.createJobQuery().jobDefinitionId(batchJobDefinitionId).list();
        Assert.assertFalse((boolean)batchJobs.isEmpty());
        ArrayList<Exception> catchedExceptions = new ArrayList<Exception>();
        for (Job batchJob : batchJobs) {
            try {
                this.managementService.executeJob(batchJob.getId());
            }
            catch (Exception e) {
                catchedExceptions.add(e);
            }
        }
        return catchedExceptions;
    }

    protected List<String> startTestProcesses(int numberOfProcesses) {
        ArrayList<String> ids = new ArrayList<String>();
        for (int i = 0; i < numberOfProcesses; ++i) {
            ids.add(this.runtimeService.startProcessInstanceByKey(ONE_TASK_PROCESS).getProcessInstanceId());
        }
        return ids;
    }

    protected void assertTasksAreDeleted(List<String> processIds, String deleteReason) {
        if (!this.testRule.isHistoryLevelNone()) {
            for (String processId : processIds) {
                HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processId).singleResult();
                Assert.assertThat((Object)historicTaskInstance.getDeleteReason(), (Matcher)CoreMatchers.is((Object)deleteReason));
            }
        }
    }

    protected void assertHistoricBatchExists() {
        if (this.testRule.isHistoryLevelFull()) {
            Assert.assertThat((Object)this.historyService.createHistoricBatchQuery().count(), (Matcher)CoreMatchers.is((Object)1L));
        }
    }

    protected void assertProcessInstancesAreDeleted() {
        Assert.assertThat((Object)this.runtimeService.createProcessInstanceQuery().list().size(), (Matcher)CoreMatchers.is((Object)0));
    }
}

