/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.callactivity;

import java.util.Map;
import junit.framework.TestCase;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.bpmn.callactivity.DelegateVarMappingThrowBpmnError;
import org.camunda.bpm.engine.test.bpmn.callactivity.DelegateVarMappingThrowBpmnErrorOutput;
import org.camunda.bpm.engine.test.bpmn.callactivity.DelegateVarMappingThrowException;
import org.camunda.bpm.engine.test.bpmn.callactivity.DelegateVarMappingThrowExceptionOutput;
import org.camunda.bpm.engine.test.bpmn.callactivity.DelegatedVarMapping;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class CallActivityDelegateMappingTest {
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    public ProcessEngineTestRule testHelper = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain chain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testHelper);

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CallActivityDelegateMappingTest.testCallSimpleSubProcessDelegateVarMapping.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/callactivity/simpleSubProcess.bpmn20.xml"})
    public void testCallSubProcessWithDelegatedVariableMapping() {
        this.engineRule.getRuntimeService().startProcessInstanceByKey("callSimpleSubProcess");
        TaskQuery taskQuery = this.engineRule.getTaskService().createTaskQuery();
        Task taskInSubProcess = (Task)taskQuery.singleResult();
        TestCase.assertEquals((String)"Task in subprocess", (String)taskInSubProcess.getName());
        Object inputVar = this.engineRule.getRuntimeService().getVariable(taskInSubProcess.getProcessInstanceId(), "TestInputVar");
        TestCase.assertEquals((Object)"inValue", (Object)inputVar);
        this.engineRule.getTaskService().complete(taskInSubProcess.getId());
        Task taskAfterSubProcess = (Task)taskQuery.singleResult();
        TestCase.assertEquals((String)"Task after subprocess", (String)taskAfterSubProcess.getName());
        ProcessInstance processInstance = (ProcessInstance)this.engineRule.getRuntimeService().createProcessInstanceQuery().singleResult();
        Object outputVar = this.engineRule.getRuntimeService().getVariable(processInstance.getId(), "TestOutputVar");
        TestCase.assertEquals((Object)"outValue", (Object)outputVar);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CallActivityDelegateMappingTest.testCallSimpleSubProcessDelegateVarMappingExpression.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/callactivity/simpleSubProcess.bpmn20.xml"})
    public void testCallSubProcessWithDelegatedVariableMappingeExpression() {
        Map vars = this.engineRule.getProcessEngineConfiguration().getBeans();
        vars.put("expr", new DelegatedVarMapping());
        this.engineRule.getProcessEngineConfiguration().setBeans(vars);
        this.engineRule.getRuntimeService().startProcessInstanceByKey("callSimpleSubProcess");
        TaskQuery taskQuery = this.engineRule.getTaskService().createTaskQuery();
        Task taskInSubProcess = (Task)taskQuery.singleResult();
        TestCase.assertEquals((String)"Task in subprocess", (String)taskInSubProcess.getName());
        Object inputVar = this.engineRule.getRuntimeService().getVariable(taskInSubProcess.getProcessInstanceId(), "TestInputVar");
        TestCase.assertEquals((Object)"inValue", (Object)inputVar);
        this.engineRule.getTaskService().complete(taskInSubProcess.getId());
        Task taskAfterSubProcess = (Task)taskQuery.singleResult();
        TestCase.assertEquals((String)"Task after subprocess", (String)taskAfterSubProcess.getName());
        ProcessInstance processInstance = (ProcessInstance)this.engineRule.getRuntimeService().createProcessInstanceQuery().singleResult();
        Object outputVar = this.engineRule.getRuntimeService().getVariable(processInstance.getId(), "TestOutputVar");
        TestCase.assertEquals((Object)"outValue", (Object)outputVar);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CallActivityDelegateMappingTest.testCallSimpleSubProcessDelegateVarMappingNotFound.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/callactivity/simpleSubProcess.bpmn20.xml"})
    public void testCallSubProcessWithDelegatedVariableMappingNotFound() {
        try {
            this.engineRule.getRuntimeService().startProcessInstanceByKey("callSimpleSubProcess");
            TestCase.fail((String)"Execption expected!");
        }
        catch (ProcessEngineException e) {
            TestCase.assertEquals((String)"ENGINE-09008 Exception while instantiating class 'org.camunda.bpm.engine.test.bpmn.callactivity.NotFoundMapping': ENGINE-09017 Cannot load class 'org.camunda.bpm.engine.test.bpmn.callactivity.NotFoundMapping': org.camunda.bpm.engine.test.bpmn.callactivity.NotFoundMapping", (String)e.getMessage());
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CallActivityDelegateMappingTest.testCallSimpleSubProcessDelegateVarMappingExpressionNotFound.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/callactivity/simpleSubProcess.bpmn20.xml"})
    public void testCallSubProcessWithDelegatedVariableMappingeExpressionNotFound() {
        try {
            this.engineRule.getRuntimeService().startProcessInstanceByKey("callSimpleSubProcess");
            TestCase.fail((String)"Exception expected!");
        }
        catch (ProcessEngineException pee) {
            TestCase.assertEquals((String)"Unknown property used in expression: ${notFound}. Cause: Cannot resolve identifier 'notFound'", (String)pee.getMessage());
        }
    }

    private void delegateVariableMappingThrowException() {
        this.engineRule.getRuntimeService().startProcessInstanceByKey("callSimpleSubProcess");
        TaskQuery taskQuery = this.engineRule.getTaskService().createTaskQuery();
        Task taskBeforeSubProcess = (Task)taskQuery.singleResult();
        TestCase.assertEquals((String)"Task before subprocess", (String)taskBeforeSubProcess.getName());
        try {
            this.engineRule.getTaskService().complete(taskBeforeSubProcess.getId());
            TestCase.fail((String)"Exeption expected!");
        }
        catch (ProcessEngineException pee) {
            Assert.assertTrue((pee.getMessage().equalsIgnoreCase("org.camunda.bpm.engine.ProcessEngineException: New process engine exception.") || pee.getMessage().contains("1234") ? 1 : 0) != 0);
        }
        taskBeforeSubProcess = (Task)taskQuery.singleResult();
        TestCase.assertEquals((String)"Task before subprocess", (String)taskBeforeSubProcess.getName());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CallActivityDelegateMappingTest.testCallSimpleSubProcessDelegateVarMappingThrowException.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/callactivity/simpleSubProcess.bpmn20.xml"})
    public void testCallSubProcessWithDelegatedVariableMappingThrowException() {
        this.delegateVariableMappingThrowException();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CallActivityDelegateMappingTest.testCallSimpleSubProcessDelegateVarMappingExpressionThrowException.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/callactivity/simpleSubProcess.bpmn20.xml"})
    public void testCallSubProcessWithDelegatedVariableMappingeExpressionThrowException() {
        Map vars = this.engineRule.getProcessEngineConfiguration().getBeans();
        vars.put("expr", new DelegateVarMappingThrowException());
        this.engineRule.getProcessEngineConfiguration().setBeans(vars);
        this.delegateVariableMappingThrowException();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CallActivityDelegateMappingTest.testCallSimpleSubProcessDelegateVarMappingThrowBpmnError.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/callactivity/simpleSubProcess.bpmn20.xml"})
    public void testCallSubProcessWithDelegatedVariableMappingThrowBpmnError() {
        this.delegateVariableMappingThrowException();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CallActivityDelegateMappingTest.testCallSimpleSubProcessDelegateVarMappingExpressionThrowException.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/callactivity/simpleSubProcess.bpmn20.xml"})
    public void testCallSubProcessWithDelegatedVariableMappingeExpressionThrowBpmnError() {
        Map vars = this.engineRule.getProcessEngineConfiguration().getBeans();
        vars.put("expr", new DelegateVarMappingThrowBpmnError());
        this.engineRule.getProcessEngineConfiguration().setBeans(vars);
        this.delegateVariableMappingThrowException();
    }

    private void delegateVariableMappingThrowExceptionOutput() {
        this.engineRule.getRuntimeService().startProcessInstanceByKey("callSimpleSubProcess");
        TaskQuery taskQuery = this.engineRule.getTaskService().createTaskQuery();
        Task taskBeforeSubProcess = (Task)taskQuery.singleResult();
        TestCase.assertEquals((String)"Task before subprocess", (String)taskBeforeSubProcess.getName());
        this.engineRule.getTaskService().complete(taskBeforeSubProcess.getId());
        Task taskInSubProcess = (Task)taskQuery.singleResult();
        try {
            this.engineRule.getTaskService().complete(taskInSubProcess.getId());
            TestCase.fail((String)"Exeption expected!");
        }
        catch (ProcessEngineException pee) {
            Assert.assertTrue((pee.getMessage().equalsIgnoreCase("org.camunda.bpm.engine.ProcessEngineException: New process engine exception.") || pee.getMessage().contains("1234") ? 1 : 0) != 0);
        }
        taskInSubProcess = (Task)taskQuery.singleResult();
        TestCase.assertEquals((String)"Task in subprocess", (String)taskInSubProcess.getName());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CallActivityDelegateMappingTest.testCallSimpleSubProcessDelegateVarMappingThrowExceptionOutput.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/callactivity/simpleSubProcess.bpmn20.xml"})
    public void testCallSubProcessWithDelegatedVariableMappingThrowExceptionOutput() {
        this.delegateVariableMappingThrowExceptionOutput();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CallActivityDelegateMappingTest.testCallSimpleSubProcessDelegateVarMappingExpressionThrowException.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/callactivity/simpleSubProcess.bpmn20.xml"})
    public void testCallSubProcessWithDelegatedVariableMappingeExpressionThrowExceptionOutput() {
        Map vars = this.engineRule.getProcessEngineConfiguration().getBeans();
        vars.put("expr", new DelegateVarMappingThrowExceptionOutput());
        this.engineRule.getProcessEngineConfiguration().setBeans(vars);
        this.delegateVariableMappingThrowExceptionOutput();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CallActivityDelegateMappingTest.testCallSimpleSubProcessDelegateVarMappingThrowBpmnErrorOutput.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/callactivity/simpleSubProcess.bpmn20.xml"})
    public void testCallSubProcessWithDelegatedVariableMappingThrowBpmnErrorOutput() {
        this.delegateVariableMappingThrowExceptionOutput();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CallActivityDelegateMappingTest.testCallSimpleSubProcessDelegateVarMappingExpressionThrowException.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/callactivity/simpleSubProcess.bpmn20.xml"})
    public void testCallSubProcessWithDelegatedVariableMappingeExpressionThrowBpmnErrorOutput() {
        Map vars = this.engineRule.getProcessEngineConfiguration().getBeans();
        vars.put("expr", new DelegateVarMappingThrowBpmnErrorOutput());
        this.engineRule.getProcessEngineConfiguration().setBeans(vars);
        this.delegateVariableMappingThrowExceptionOutput();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CallActivityDelegateMappingTest.testCallFailingSubProcessWithDelegatedVariableMapping.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/callactivity/failingSubProcess.bpmn20.xml"})
    public void testCallFailingSubProcessWithDelegatedVariableMapping() {
        ProcessInstance procInst = this.engineRule.getRuntimeService().startProcessInstanceByKey("callSimpleSubProcess");
        Object outputVar = this.engineRule.getRuntimeService().getVariable(procInst.getId(), "TestOutputVar");
        TestCase.assertEquals((Object)"outValue", (Object)outputVar);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CallActivityDelegateMappingTest.testCallSubProcessWithDelegatedVariableMappingAndAsyncServiceTask.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/callactivity/simpleSubProcessWithAsyncService.bpmn20.xml"})
    public void testCallSubProcessWithDelegatedVariableMappingAndAsyncServiceTask() {
        ProcessInstance superProcInst = this.engineRule.getRuntimeService().startProcessInstanceByKey("callSimpleSubProcess");
        ProcessInstance subProcInst = (ProcessInstance)this.engineRule.getRuntimeService().createProcessInstanceQuery().processDefinitionKey("simpleSubProcessWithAsyncService").singleResult();
        Object inVar = this.engineRule.getRuntimeService().getVariable(subProcInst.getId(), "TestInputVar");
        TestCase.assertEquals((Object)"inValue", (Object)inVar);
        this.testHelper.executeAvailableJobs();
        Object outputVar = this.engineRule.getRuntimeService().getVariable(superProcInst.getId(), "TestOutputVar");
        TestCase.assertEquals((Object)"outValue", (Object)outputVar);
    }
}

