/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.sequenceflow;

import java.util.HashMap;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;

public class ConditionalScriptSequenceFlowTest
extends PluggableProcessEngineTestCase {
    @Deployment
    public void testScriptExpression() {
        String[] directions = new String[]{"left", "right"};
        HashMap<String, String> variables = new HashMap<String, String>();
        for (String direction : directions) {
            variables.put("foo", direction);
            this.runtimeService.startProcessInstanceByKey("process", variables);
            Task task = (Task)this.taskService.createTaskQuery().singleResult();
            ConditionalScriptSequenceFlowTest.assertEquals((String)direction, (String)task.getTaskDefinitionKey());
            this.taskService.complete(task.getId());
        }
    }

    @Deployment
    public void testScriptExpressionWithNonBooleanResult() {
        try {
            this.runtimeService.startProcessInstanceByKey("process");
            ConditionalScriptSequenceFlowTest.fail((String)"expected exception: invalid return value in script");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("condition script returns non-Boolean", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/sequenceflow/ConditionalScriptSequenceFlowTest.testScriptResourceExpression.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/sequenceflow/condition-left.groovy"})
    public void testScriptResourceExpression() {
        String[] directions = new String[]{"left", "right"};
        HashMap<String, String> variables = new HashMap<String, String>();
        for (String direction : directions) {
            variables.put("foo", direction);
            this.runtimeService.startProcessInstanceByKey("process", variables);
            Task task = (Task)this.taskService.createTaskQuery().singleResult();
            ConditionalScriptSequenceFlowTest.assertEquals((String)direction, (String)task.getTaskDefinitionKey());
            this.taskService.complete(task.getId());
        }
    }
}

