/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.history.HistoricCaseActivityInstance;
import org.camunda.bpm.engine.history.HistoricCaseActivityInstanceQuery;
import org.camunda.bpm.engine.history.HistoricCaseInstance;
import org.camunda.bpm.engine.history.NativeHistoricCaseActivityInstanceQuery;
import org.camunda.bpm.engine.impl.AbstractQuery;
import org.camunda.bpm.engine.impl.Direction;
import org.camunda.bpm.engine.impl.QueryOrderingProperty;
import org.camunda.bpm.engine.impl.cmmn.execution.CaseExecutionState;
import org.camunda.bpm.engine.impl.history.event.HistoricCaseActivityInstanceEventEntity;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricCaseActivityInstanceEntity;
import org.camunda.bpm.engine.impl.test.CmmnProcessEngineTestCase;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.query.Query;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.variable.Variables;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsIterableContainingInOrder;
import org.junit.Assert;

@RequiredHistoryLevel(value="audit")
public class HistoricCaseActivityInstanceTest
extends CmmnProcessEngineTestCase {
    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/emptyStageWithManualActivationCase.cmmn"})
    public void testHistoricCaseActivityInstanceProperties() {
        String activityId = "PI_Stage_1";
        this.createCaseInstance();
        CaseExecution stage = this.queryCaseExecutionByActivityId(activityId);
        HistoricCaseActivityInstance historicStage = this.queryHistoricActivityCaseInstance(activityId);
        HistoricCaseActivityInstanceTest.assertEquals((String)stage.getId(), (String)historicStage.getId());
        HistoricCaseActivityInstanceTest.assertEquals((String)stage.getParentId(), (String)historicStage.getParentCaseActivityInstanceId());
        HistoricCaseActivityInstanceTest.assertEquals((String)stage.getCaseDefinitionId(), (String)historicStage.getCaseDefinitionId());
        HistoricCaseActivityInstanceTest.assertEquals((String)stage.getCaseInstanceId(), (String)historicStage.getCaseInstanceId());
        HistoricCaseActivityInstanceTest.assertEquals((String)stage.getActivityId(), (String)historicStage.getCaseActivityId());
        HistoricCaseActivityInstanceTest.assertEquals((String)stage.getActivityName(), (String)historicStage.getCaseActivityName());
        HistoricCaseActivityInstanceTest.assertEquals((String)stage.getActivityType(), (String)historicStage.getCaseActivityType());
        this.manualStart(stage.getId());
        historicStage = this.queryHistoricActivityCaseInstance(activityId);
        HistoricCaseActivityInstanceTest.assertNotNull((Object)historicStage.getEndTime());
    }

    @Deployment
    public void testHistoricCaseActivityTaskStates() {
        String humanTaskId1 = "PI_HumanTask_1";
        String humanTaskId2 = "PI_HumanTask_2";
        String humanTaskId3 = "PI_HumanTask_3";
        String caseInstanceId = this.createCaseInstance().getId();
        String taskInstanceId1 = this.queryCaseExecutionByActivityId(humanTaskId1).getId();
        String taskInstanceId2 = this.queryCaseExecutionByActivityId(humanTaskId2).getId();
        String taskInstanceId3 = this.queryCaseExecutionByActivityId(humanTaskId3).getId();
        this.assertHistoricState(humanTaskId1, CaseExecutionState.ENABLED);
        this.assertHistoricState(humanTaskId2, CaseExecutionState.AVAILABLE);
        this.assertHistoricState(humanTaskId3, CaseExecutionState.AVAILABLE);
        this.assertStateQuery(CaseExecutionState.ENABLED, CaseExecutionState.AVAILABLE, CaseExecutionState.AVAILABLE);
        this.manualStart(taskInstanceId1);
        this.assertHistoricState(humanTaskId1, CaseExecutionState.ACTIVE);
        this.assertHistoricState(humanTaskId2, CaseExecutionState.AVAILABLE);
        this.assertHistoricState(humanTaskId3, CaseExecutionState.AVAILABLE);
        this.assertStateQuery(CaseExecutionState.ACTIVE, CaseExecutionState.AVAILABLE, CaseExecutionState.AVAILABLE);
        this.complete(taskInstanceId1);
        this.assertHistoricState(humanTaskId1, CaseExecutionState.COMPLETED);
        this.assertHistoricState(humanTaskId2, CaseExecutionState.ENABLED);
        this.assertHistoricState(humanTaskId3, CaseExecutionState.ACTIVE);
        this.assertStateQuery(CaseExecutionState.COMPLETED, CaseExecutionState.ENABLED, CaseExecutionState.ACTIVE);
        this.disable(taskInstanceId2);
        this.assertHistoricState(humanTaskId1, CaseExecutionState.COMPLETED);
        this.assertHistoricState(humanTaskId2, CaseExecutionState.DISABLED);
        this.assertHistoricState(humanTaskId3, CaseExecutionState.ACTIVE);
        this.assertStateQuery(CaseExecutionState.COMPLETED, CaseExecutionState.DISABLED, CaseExecutionState.ACTIVE);
        this.reenable(taskInstanceId2);
        this.assertHistoricState(humanTaskId1, CaseExecutionState.COMPLETED);
        this.assertHistoricState(humanTaskId2, CaseExecutionState.ENABLED);
        this.assertHistoricState(humanTaskId3, CaseExecutionState.ACTIVE);
        this.assertStateQuery(CaseExecutionState.COMPLETED, CaseExecutionState.ENABLED, CaseExecutionState.ACTIVE);
        this.suspend(taskInstanceId3);
        this.assertHistoricState(humanTaskId1, CaseExecutionState.COMPLETED);
        this.assertHistoricState(humanTaskId2, CaseExecutionState.ENABLED);
        this.assertHistoricState(humanTaskId3, CaseExecutionState.SUSPENDED);
        this.assertStateQuery(CaseExecutionState.COMPLETED, CaseExecutionState.ENABLED, CaseExecutionState.SUSPENDED);
        this.resume(taskInstanceId3);
        this.assertHistoricState(humanTaskId1, CaseExecutionState.COMPLETED);
        this.assertHistoricState(humanTaskId2, CaseExecutionState.ENABLED);
        this.assertHistoricState(humanTaskId3, CaseExecutionState.ACTIVE);
        this.assertStateQuery(CaseExecutionState.COMPLETED, CaseExecutionState.ENABLED, CaseExecutionState.ACTIVE);
        this.suspend(caseInstanceId);
        this.assertHistoricState(humanTaskId1, CaseExecutionState.COMPLETED);
        this.assertHistoricState(humanTaskId2, CaseExecutionState.SUSPENDED);
        this.assertHistoricState(humanTaskId3, CaseExecutionState.SUSPENDED);
        this.assertStateQuery(CaseExecutionState.COMPLETED, CaseExecutionState.SUSPENDED, CaseExecutionState.SUSPENDED);
        this.reactivate(caseInstanceId);
        this.assertHistoricState(humanTaskId1, CaseExecutionState.COMPLETED);
        this.assertHistoricState(humanTaskId2, CaseExecutionState.ENABLED);
        this.assertHistoricState(humanTaskId3, CaseExecutionState.ACTIVE);
        this.assertStateQuery(CaseExecutionState.COMPLETED, CaseExecutionState.ENABLED, CaseExecutionState.ACTIVE);
        this.manualStart(taskInstanceId2);
        this.terminate(taskInstanceId3);
        this.assertHistoricState(humanTaskId1, CaseExecutionState.COMPLETED);
        this.assertHistoricState(humanTaskId2, CaseExecutionState.TERMINATED);
        this.assertHistoricState(humanTaskId3, CaseExecutionState.TERMINATED);
        this.assertStateQuery(CaseExecutionState.COMPLETED, CaseExecutionState.TERMINATED, CaseExecutionState.TERMINATED);
    }

    @Deployment
    public void testHistoricCaseActivityMilestoneStates() {
        String milestoneId1 = "PI_Milestone_1";
        String milestoneId2 = "PI_Milestone_2";
        String humanTaskId1 = "PI_HumanTask_1";
        String humanTaskId2 = "PI_HumanTask_2";
        String caseInstanceId = this.createCaseInstance().getId();
        String milestoneInstance1 = this.queryCaseExecutionByActivityId(milestoneId1).getId();
        String milestoneInstance2 = this.queryCaseExecutionByActivityId(milestoneId2).getId();
        String humanTaskInstance1 = this.queryCaseExecutionByActivityId(humanTaskId1).getId();
        this.assertHistoricState(milestoneId1, CaseExecutionState.AVAILABLE);
        this.assertHistoricState(milestoneId2, CaseExecutionState.AVAILABLE);
        this.assertHistoricState(humanTaskId1, CaseExecutionState.ENABLED);
        this.assertHistoricState(humanTaskId2, CaseExecutionState.ENABLED);
        this.assertStateQuery(CaseExecutionState.AVAILABLE, CaseExecutionState.AVAILABLE, CaseExecutionState.ENABLED, CaseExecutionState.ENABLED);
        this.suspend(milestoneInstance1);
        this.suspend(milestoneInstance2);
        this.assertHistoricState(milestoneId1, CaseExecutionState.SUSPENDED);
        this.assertHistoricState(milestoneId2, CaseExecutionState.SUSPENDED);
        this.assertHistoricState(humanTaskId1, CaseExecutionState.ENABLED);
        this.assertHistoricState(humanTaskId2, CaseExecutionState.ENABLED);
        this.assertStateQuery(CaseExecutionState.SUSPENDED, CaseExecutionState.SUSPENDED, CaseExecutionState.ENABLED, CaseExecutionState.ENABLED);
        this.resume(milestoneInstance1);
        this.assertHistoricState(milestoneId1, CaseExecutionState.AVAILABLE);
        this.assertHistoricState(milestoneId2, CaseExecutionState.SUSPENDED);
        this.assertHistoricState(humanTaskId1, CaseExecutionState.ENABLED);
        this.assertHistoricState(humanTaskId2, CaseExecutionState.ENABLED);
        this.assertStateQuery(CaseExecutionState.AVAILABLE, CaseExecutionState.SUSPENDED, CaseExecutionState.ENABLED, CaseExecutionState.ENABLED);
        this.manualStart(humanTaskInstance1);
        this.terminate(humanTaskInstance1);
        this.assertHistoricState(milestoneId1, CaseExecutionState.COMPLETED);
        this.assertHistoricState(milestoneId2, CaseExecutionState.SUSPENDED);
        this.assertHistoricState(humanTaskId1, CaseExecutionState.TERMINATED);
        this.assertHistoricState(humanTaskId2, CaseExecutionState.ENABLED);
        this.assertStateQuery(CaseExecutionState.COMPLETED, CaseExecutionState.SUSPENDED, CaseExecutionState.TERMINATED, CaseExecutionState.ENABLED);
        this.terminate(caseInstanceId);
        this.assertHistoricState(milestoneId1, CaseExecutionState.COMPLETED);
        this.assertHistoricState(milestoneId2, CaseExecutionState.TERMINATED);
        this.assertHistoricState(humanTaskId1, CaseExecutionState.TERMINATED);
        this.assertHistoricState(humanTaskId2, CaseExecutionState.TERMINATED);
        this.assertStateQuery(CaseExecutionState.COMPLETED, CaseExecutionState.TERMINATED, CaseExecutionState.TERMINATED, CaseExecutionState.TERMINATED);
    }

    @Deployment
    public void testHistoricCaseActivityInstanceDates() {
        String taskId1 = "PI_HumanTask_1";
        String taskId2 = "PI_HumanTask_2";
        String taskId3 = "PI_HumanTask_3";
        String milestoneId1 = "PI_Milestone_1";
        String milestoneId2 = "PI_Milestone_2";
        String milestoneId3 = "PI_Milestone_3";
        long duration = 259200000L;
        Date created = ClockUtil.getCurrentTime();
        Date ended = new Date(created.getTime() + duration);
        ClockUtil.setCurrentTime((Date)created);
        String caseInstanceId = this.createCaseInstance().getId();
        String taskInstance1 = this.queryCaseExecutionByActivityId(taskId1).getId();
        String taskInstance2 = this.queryCaseExecutionByActivityId(taskId2).getId();
        String taskInstance3 = this.queryCaseExecutionByActivityId(taskId3).getId();
        String milestoneInstance1 = this.queryCaseExecutionByActivityId(milestoneId1).getId();
        String milestoneInstance2 = this.queryCaseExecutionByActivityId(milestoneId2).getId();
        String milestoneInstance3 = this.queryCaseExecutionByActivityId(milestoneId3).getId();
        this.assertHistoricCreateTime(taskId1, created);
        this.assertHistoricCreateTime(taskId2, created);
        this.assertHistoricCreateTime(milestoneId1, created);
        this.assertHistoricCreateTime(milestoneId2, created);
        ClockUtil.setCurrentTime((Date)ended);
        this.complete(taskInstance1);
        this.assertHistoricEndTime(taskId1, ended);
        this.assertHistoricDuration(taskId1, duration);
        ClockUtil.setCurrentTime((Date)ended);
        this.occur(milestoneInstance1);
        this.assertHistoricEndTime(milestoneId1, ended);
        this.assertHistoricDuration(milestoneId1, duration);
        ClockUtil.setCurrentTime((Date)ended);
        this.terminate(taskInstance2);
        this.assertHistoricEndTime(taskId2, ended);
        this.assertHistoricDuration(taskId2, duration);
        ClockUtil.setCurrentTime((Date)ended);
        this.terminate(milestoneInstance2);
        this.assertHistoricEndTime(milestoneId2, ended);
        this.assertHistoricDuration(milestoneId2, duration);
        this.disable(taskInstance3);
        this.suspend(milestoneInstance3);
        ClockUtil.setCurrentTime((Date)ended);
        this.terminate(caseInstanceId);
        this.assertHistoricEndTime(taskId3, ended);
        this.assertHistoricEndTime(milestoneId3, ended);
        this.assertHistoricDuration(taskId3, duration);
        this.assertHistoricDuration(milestoneId3, duration);
        Date beforeCreate = new Date(created.getTime() - 3600000L);
        Date afterEnd = new Date(ended.getTime() + 3600000L);
        this.assertCount(6L, (Query<?, ?>)this.historicQuery().createdAfter(beforeCreate));
        this.assertCount(0L, (Query<?, ?>)this.historicQuery().createdAfter(ended));
        this.assertCount(0L, (Query<?, ?>)this.historicQuery().createdBefore(beforeCreate));
        this.assertCount(6L, (Query<?, ?>)this.historicQuery().createdBefore(ended));
        this.assertCount(0L, (Query<?, ?>)this.historicQuery().createdBefore(beforeCreate).createdAfter(ended));
        this.assertCount(6L, (Query<?, ?>)this.historicQuery().endedAfter(created));
        this.assertCount(0L, (Query<?, ?>)this.historicQuery().endedAfter(afterEnd));
        this.assertCount(0L, (Query<?, ?>)this.historicQuery().endedBefore(created));
        this.assertCount(6L, (Query<?, ?>)this.historicQuery().endedBefore(afterEnd));
        this.assertCount(0L, (Query<?, ?>)this.historicQuery().endedBefore(created).endedAfter(afterEnd));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCaseWithManualActivation.cmmn"})
    public void testHistoricCaseActivityTaskId() {
        String taskId = "PI_HumanTask_1";
        this.createCaseInstance();
        this.assertCount(0L, (Query<?, ?>)this.taskService.createTaskQuery());
        HistoricCaseActivityInstance historicInstance = this.queryHistoricActivityCaseInstance(taskId);
        HistoricCaseActivityInstanceTest.assertNull((Object)historicInstance.getTaskId());
        CaseExecution humanTask = this.queryCaseExecutionByActivityId(taskId);
        this.manualStart(humanTask.getId());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        HistoricCaseActivityInstanceTest.assertNotNull((Object)task);
        historicInstance = this.queryHistoricActivityCaseInstance(taskId);
        HistoricCaseActivityInstanceTest.assertEquals((String)task.getId(), (String)historicInstance.getTaskId());
        this.taskService.complete(task.getId());
        this.assertCount(0L, (Query<?, ?>)this.taskService.createTaskQuery());
        historicInstance = this.queryHistoricActivityCaseInstance(taskId);
        HistoricCaseActivityInstanceTest.assertEquals((String)task.getId(), (String)historicInstance.getTaskId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneProcessTaskCaseWithManualActivation.cmmn", "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testHistoricCaseActivityCalledProcessInstanceId() {
        String taskId = "PI_ProcessTask_1";
        this.createCaseInstanceByKey("oneProcessTaskCase").getId();
        this.assertCount(0L, (Query<?, ?>)this.runtimeService.createProcessInstanceQuery());
        HistoricCaseActivityInstance historicInstance = this.queryHistoricActivityCaseInstance(taskId);
        HistoricCaseActivityInstanceTest.assertNull((Object)historicInstance.getCalledProcessInstanceId());
        CaseExecution processTask = this.queryCaseExecutionByActivityId(taskId);
        this.manualStart(processTask.getId());
        ProcessInstance calledProcessInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        HistoricCaseActivityInstanceTest.assertNotNull((Object)calledProcessInstance);
        historicInstance = this.queryHistoricActivityCaseInstance(taskId);
        HistoricCaseActivityInstanceTest.assertEquals((String)calledProcessInstance.getId(), (String)historicInstance.getCalledProcessInstanceId());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        this.assertCount(0L, (Query<?, ?>)this.runtimeService.createProcessInstanceQuery());
        historicInstance = this.queryHistoricActivityCaseInstance(taskId);
        HistoricCaseActivityInstanceTest.assertEquals((String)calledProcessInstance.getId(), (String)historicInstance.getCalledProcessInstanceId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneCaseTaskCaseWithManualActivation.cmmn", "org/camunda/bpm/engine/test/api/cmmn/oneTaskCaseWithManualActivation.cmmn"})
    public void testHistoricCaseActivityCalledCaseInstanceId() {
        String taskId = "PI_CaseTask_1";
        String calledCaseId = "oneTaskCase";
        String calledTaskId = "PI_HumanTask_1";
        this.createCaseInstanceByKey("oneCaseTaskCase").getId();
        this.assertCount(0L, (Query<?, ?>)this.caseService.createCaseInstanceQuery().caseDefinitionKey(calledCaseId));
        HistoricCaseActivityInstance historicInstance = this.queryHistoricActivityCaseInstance(taskId);
        HistoricCaseActivityInstanceTest.assertNull((Object)historicInstance.getCalledCaseInstanceId());
        CaseExecution caseTask = this.queryCaseExecutionByActivityId(taskId);
        this.manualStart(caseTask.getId());
        CaseInstance calledCaseInstance = (CaseInstance)this.caseService.createCaseInstanceQuery().caseDefinitionKey(calledCaseId).singleResult();
        HistoricCaseActivityInstanceTest.assertNotNull((Object)calledCaseInstance);
        historicInstance = this.queryHistoricActivityCaseInstance(taskId);
        HistoricCaseActivityInstanceTest.assertEquals((String)calledCaseInstance.getId(), (String)historicInstance.getCalledCaseInstanceId());
        CaseExecution calledTask = this.queryCaseExecutionByActivityId(calledTaskId);
        this.disable(calledTask.getId());
        this.close(calledCaseInstance.getId());
        this.assertCount(0L, (Query<?, ?>)this.caseService.createCaseInstanceQuery().caseDefinitionKey(calledCaseId));
        historicInstance = this.queryHistoricActivityCaseInstance(taskId);
        HistoricCaseActivityInstanceTest.assertEquals((String)calledCaseInstance.getId(), (String)historicInstance.getCalledCaseInstanceId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskAndOneStageWithManualActivationCase.cmmn"})
    public void testHistoricCaseActivityQuery() {
        String stageId = "PI_Stage_1";
        String stageName = "A HumanTask";
        String taskId = "PI_HumanTask_1";
        String taskName = "A HumanTask";
        String caseInstanceId = this.createCaseInstance().getId();
        CaseExecution stageExecution = this.queryCaseExecutionByActivityId(stageId);
        CaseExecution taskExecution = this.queryCaseExecutionByActivityId(taskId);
        this.assertCount(1L, (Query<?, ?>)this.historicQuery().caseActivityInstanceId(stageExecution.getId()));
        this.assertCount(1L, (Query<?, ?>)this.historicQuery().caseActivityInstanceId(taskExecution.getId()));
        this.assertCount(2L, (Query<?, ?>)this.historicQuery().caseInstanceId(caseInstanceId));
        this.assertCount(2L, (Query<?, ?>)this.historicQuery().caseDefinitionId(stageExecution.getCaseDefinitionId()));
        this.assertCount(1L, (Query<?, ?>)this.historicQuery().caseExecutionId(stageExecution.getId()));
        this.assertCount(1L, (Query<?, ?>)this.historicQuery().caseExecutionId(taskExecution.getId()));
        this.assertCount(1L, (Query<?, ?>)this.historicQuery().caseActivityId(stageId));
        this.assertCount(1L, (Query<?, ?>)this.historicQuery().caseActivityId(taskId));
        this.assertCount(1L, (Query<?, ?>)this.historicQuery().caseActivityName(stageName));
        this.assertCount(1L, (Query<?, ?>)this.historicQuery().caseActivityName(taskName));
        this.assertCount(1L, (Query<?, ?>)this.historicQuery().caseActivityType("stage"));
        this.assertCount(1L, (Query<?, ?>)this.historicQuery().caseActivityType("humanTask"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryPaging() {
        this.createCaseInstance();
        this.createCaseInstance();
        this.createCaseInstance();
        this.createCaseInstance();
        HistoricCaseActivityInstanceTest.assertEquals((int)3, (int)this.historicQuery().listPage(0, 3).size());
        HistoricCaseActivityInstanceTest.assertEquals((int)2, (int)this.historicQuery().listPage(2, 2).size());
        HistoricCaseActivityInstanceTest.assertEquals((int)1, (int)this.historicQuery().listPage(3, 2).size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn", "org/camunda/bpm/engine/test/api/cmmn/twoTaskCase.cmmn"})
    public void testQuerySorting() {
        String taskId1 = "PI_HumanTask_1";
        String taskId2 = "PI_HumanTask_2";
        String oneTaskCaseId = this.createCaseInstanceByKey("oneTaskCase").getId();
        String twoTaskCaseId = this.createCaseInstanceByKey("twoTaskCase").getId();
        CaseExecution task1 = (CaseExecution)this.caseService.createCaseExecutionQuery().caseInstanceId(oneTaskCaseId).activityId(taskId1).singleResult();
        CaseExecution task2 = (CaseExecution)this.caseService.createCaseExecutionQuery().caseInstanceId(twoTaskCaseId).activityId(taskId1).singleResult();
        CaseExecution task3 = (CaseExecution)this.caseService.createCaseExecutionQuery().caseInstanceId(twoTaskCaseId).activityId(taskId2).singleResult();
        this.assertQuerySorting("id", (Query<?, ?>)this.historicQuery().orderByHistoricCaseActivityInstanceId(), new Comparable[]{task1.getId(), task2.getId(), task3.getId()});
        this.assertQuerySorting("caseInstanceId", (Query<?, ?>)this.historicQuery().orderByCaseInstanceId(), new Comparable[]{oneTaskCaseId, twoTaskCaseId, twoTaskCaseId});
        this.assertQuerySorting("caseExecutionId", (Query<?, ?>)this.historicQuery().orderByCaseExecutionId(), new Comparable[]{task1.getId(), task2.getId(), task3.getId()});
        this.assertQuerySorting("caseActivityId", (Query<?, ?>)this.historicQuery().orderByCaseActivityId(), new Comparable[]{taskId1, taskId1, taskId2});
        this.assertQuerySorting("caseActivityName", (Query<?, ?>)this.historicQuery().orderByCaseActivityName(), new Comparable[]{"A HumanTask", "A HumanTask", "Another HumanTask"});
        this.assertQuerySorting("caseDefinitionId", (Query<?, ?>)this.historicQuery().orderByCaseDefinitionId(), new Comparable[]{task1.getCaseDefinitionId(), task2.getCaseDefinitionId(), task3.getCaseDefinitionId()});
        this.manualStart(task2.getId());
        this.manualStart(task3.getId());
        for (Task task : this.taskService.createTaskQuery().list()) {
            this.taskService.complete(task.getId());
        }
        HistoricCaseActivityInstanceQuery query = this.historyService.createHistoricCaseActivityInstanceQuery();
        HistoricCaseActivityInstance historicTask1 = (HistoricCaseActivityInstance)query.caseInstanceId(oneTaskCaseId).caseActivityId(taskId1).singleResult();
        HistoricCaseActivityInstance historicTask2 = (HistoricCaseActivityInstance)query.caseInstanceId(twoTaskCaseId).caseActivityId(taskId1).singleResult();
        HistoricCaseActivityInstance historicTask3 = (HistoricCaseActivityInstance)query.caseInstanceId(twoTaskCaseId).caseActivityId(taskId2).singleResult();
        this.assertQuerySorting("createTime", (Query<?, ?>)this.historicQuery().orderByHistoricCaseActivityInstanceCreateTime(), historicTask1.getCreateTime(), historicTask2.getCreateTime(), historicTask3.getCreateTime());
        this.assertQuerySorting("endTime", (Query<?, ?>)this.historicQuery().orderByHistoricCaseActivityInstanceEndTime(), historicTask1.getEndTime(), historicTask2.getEndTime(), historicTask3.getEndTime());
        this.assertQuerySorting("durationInMillis", (Query<?, ?>)this.historicQuery().orderByHistoricCaseActivityInstanceDuration(), historicTask1.getDurationInMillis(), historicTask2.getDurationInMillis(), historicTask3.getDurationInMillis());
    }

    @Deployment
    public void testQuerySortingCaseActivityType() {
        this.createCaseInstance().getId();
        this.assertQuerySorting("caseActivityType", (Query<?, ?>)this.historicQuery().orderByCaseActivityType(), new Comparable[]{"milestone", "processTask", "humanTask"});
    }

    public void testInvalidSorting() {
        try {
            this.historicQuery().asc();
            HistoricCaseActivityInstanceTest.fail((String)"Exception expected");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.historicQuery().desc();
            HistoricCaseActivityInstanceTest.fail((String)"Exception expected");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.historicQuery().orderByHistoricCaseActivityInstanceId().count();
            HistoricCaseActivityInstanceTest.fail((String)"Exception expected");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testNativeQuery() {
        this.createCaseInstance();
        this.createCaseInstance();
        this.createCaseInstance();
        this.createCaseInstance();
        String instanceId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").list().get(0)).getId();
        String tablePrefix = this.processEngineConfiguration.getDatabaseTablePrefix();
        String tableName = this.managementService.getTableName(HistoricCaseActivityInstance.class);
        HistoricCaseActivityInstanceTest.assertEquals((String)(tablePrefix + "ACT_HI_CASEACTINST"), (String)tableName);
        HistoricCaseActivityInstanceTest.assertEquals((String)tableName, (String)this.managementService.getTableName(HistoricCaseActivityInstanceEntity.class));
        HistoricCaseActivityInstanceTest.assertEquals((int)4, (int)((NativeHistoricCaseActivityInstanceQuery)this.historyService.createNativeHistoricCaseActivityInstanceQuery().sql("SELECT * FROM " + tableName)).list().size());
        HistoricCaseActivityInstanceTest.assertEquals((long)4L, (long)((NativeHistoricCaseActivityInstanceQuery)this.historyService.createNativeHistoricCaseActivityInstanceQuery().sql("SELECT count(*) FROM " + tableName)).count());
        HistoricCaseActivityInstanceTest.assertEquals((long)16L, (long)((NativeHistoricCaseActivityInstanceQuery)this.historyService.createNativeHistoricCaseActivityInstanceQuery().sql("SELECT count(*) FROM " + tableName + " H1, " + tableName + " H2")).count());
        HistoricCaseActivityInstanceTest.assertEquals((int)4, (int)((NativeHistoricCaseActivityInstanceQuery)this.historyService.createNativeHistoricCaseActivityInstanceQuery().sql("SELECT DISTINCT * FROM " + tableName)).list().size());
        HistoricCaseActivityInstanceTest.assertEquals((long)1L, (long)((NativeHistoricCaseActivityInstanceQuery)this.historyService.createNativeHistoricCaseActivityInstanceQuery().sql("SELECT count(*) FROM " + tableName + " H WHERE H.ID_ = '" + instanceId + "'")).count());
        HistoricCaseActivityInstanceTest.assertEquals((int)1, (int)((NativeHistoricCaseActivityInstanceQuery)this.historyService.createNativeHistoricCaseActivityInstanceQuery().sql("SELECT * FROM " + tableName + " H WHERE H.ID_ = '" + instanceId + "'")).list().size());
        HistoricCaseActivityInstanceTest.assertEquals((long)1L, (long)((NativeHistoricCaseActivityInstanceQuery)((NativeHistoricCaseActivityInstanceQuery)this.historyService.createNativeHistoricCaseActivityInstanceQuery().sql("SELECT count(*) FROM " + tableName + " H WHERE H.ID_ = #{caseActivityInstanceId}")).parameter("caseActivityInstanceId", (Object)instanceId)).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testNativeQueryPaging() {
        this.createCaseInstance();
        this.createCaseInstance();
        this.createCaseInstance();
        this.createCaseInstance();
        String tableName = this.managementService.getTableName(HistoricCaseActivityInstance.class);
        HistoricCaseActivityInstanceTest.assertEquals((int)3, (int)((NativeHistoricCaseActivityInstanceQuery)this.historyService.createNativeHistoricCaseActivityInstanceQuery().sql("SELECT * FROM " + tableName)).listPage(0, 3).size());
        HistoricCaseActivityInstanceTest.assertEquals((int)2, (int)((NativeHistoricCaseActivityInstanceQuery)this.historyService.createNativeHistoricCaseActivityInstanceQuery().sql("SELECT * FROM " + tableName)).listPage(2, 2).size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCaseWithManualActivation.cmmn"})
    public void testDeleteHistoricCaseActivityInstance() {
        CaseInstance caseInstance = this.createCaseInstance();
        HistoricCaseActivityInstance historicInstance = (HistoricCaseActivityInstance)this.historicQuery().singleResult();
        HistoricCaseActivityInstanceTest.assertNotNull((Object)historicInstance);
        this.disable(historicInstance.getId());
        this.close(caseInstance.getId());
        this.historyService.deleteHistoricCaseInstance(caseInstance.getId());
        this.assertCount(0L, (Query<?, ?>)this.historicQuery());
    }

    @Deployment
    public void testNonBlockingHumanTask() {
        CaseInstance caseInstance = this.createCaseInstance();
        HistoricCaseActivityInstanceTest.assertNotNull((Object)caseInstance);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/required/RequiredRuleTest.testVariableBasedRule.cmmn"})
    public void testRequiredRuleEvaluatesToTrue() {
        this.caseService.createCaseInstanceByKey("case", Collections.singletonMap("required", true));
        HistoricCaseActivityInstance task = (HistoricCaseActivityInstance)this.historyService.createHistoricCaseActivityInstanceQuery().caseActivityId("PI_HumanTask_1").singleResult();
        HistoricCaseActivityInstanceTest.assertNotNull((Object)task);
        HistoricCaseActivityInstanceTest.assertTrue((boolean)task.isRequired());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/required/RequiredRuleTest.testVariableBasedRule.cmmn"})
    public void testRequiredRuleEvaluatesToFalse() {
        this.caseService.createCaseInstanceByKey("case", Collections.singletonMap("required", false));
        HistoricCaseActivityInstance task = (HistoricCaseActivityInstance)this.historyService.createHistoricCaseActivityInstanceQuery().caseActivityId("PI_HumanTask_1").singleResult();
        HistoricCaseActivityInstanceTest.assertNotNull((Object)task);
        HistoricCaseActivityInstanceTest.assertFalse((boolean)task.isRequired());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/required/RequiredRuleTest.testVariableBasedRule.cmmn"})
    public void testQueryByRequired() {
        this.caseService.createCaseInstanceByKey("case", Collections.singletonMap("required", true));
        HistoricCaseActivityInstanceQuery query = this.historyService.createHistoricCaseActivityInstanceQuery().required();
        HistoricCaseActivityInstanceTest.assertEquals((long)1L, (long)query.count());
        HistoricCaseActivityInstanceTest.assertEquals((int)1, (int)query.list().size());
        HistoricCaseActivityInstance activityInstance = (HistoricCaseActivityInstance)query.singleResult();
        HistoricCaseActivityInstanceTest.assertNotNull((Object)activityInstance);
        HistoricCaseActivityInstanceTest.assertTrue((boolean)activityInstance.isRequired());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/stage/AutoCompleteTest.testCasePlanModel.cmmn"})
    public void testAutoCompleteEnabled() {
        String caseInstanceId = this.createCaseInstanceByKey("case").getId();
        HistoricCaseInstance caseInstance = (HistoricCaseInstance)this.historyService.createHistoricCaseInstanceQuery().caseInstanceId(caseInstanceId).singleResult();
        HistoricCaseActivityInstanceTest.assertNotNull((Object)caseInstance);
        HistoricCaseActivityInstanceTest.assertTrue((boolean)caseInstance.isCompleted());
        HistoricCaseActivityInstanceQuery query = this.historyService.createHistoricCaseActivityInstanceQuery();
        HistoricCaseActivityInstance humanTask1 = (HistoricCaseActivityInstance)query.caseActivityId("PI_HumanTask_1").singleResult();
        HistoricCaseActivityInstanceTest.assertNotNull((Object)humanTask1);
        HistoricCaseActivityInstanceTest.assertTrue((boolean)humanTask1.isEnabled());
        HistoricCaseActivityInstanceTest.assertNull((Object)humanTask1.getEndTime());
        HistoricCaseActivityInstanceTest.assertNull((Object)humanTask1.getDurationInMillis());
        HistoricCaseActivityInstance humanTask2 = (HistoricCaseActivityInstance)query.caseActivityId("PI_HumanTask_2").singleResult();
        HistoricCaseActivityInstanceTest.assertNotNull((Object)humanTask2);
        HistoricCaseActivityInstanceTest.assertTrue((boolean)humanTask2.isEnabled());
        HistoricCaseActivityInstanceTest.assertNull((Object)humanTask2.getEndTime());
        HistoricCaseActivityInstanceTest.assertNull((Object)humanTask2.getDurationInMillis());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/repetition/RepetitionRuleTest.testRepeatTask.cmmn"})
    public void testRepeatTask() {
        this.createCaseInstance();
        String firstHumanTaskId = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        this.complete(firstHumanTaskId);
        HistoricCaseActivityInstanceQuery query = this.historicQuery().caseActivityId("PI_HumanTask_2");
        HistoricCaseActivityInstanceTest.assertEquals((long)2L, (long)query.count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/repetition/RepetitionRuleTest.testRepeatStage.cmmn"})
    public void testRepeatStage() {
        this.createCaseInstance();
        String firstHumanTaskId = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        this.complete(firstHumanTaskId);
        HistoricCaseActivityInstanceQuery query = this.historicQuery().caseActivityId("PI_Stage_1");
        HistoricCaseActivityInstanceTest.assertEquals((long)2L, (long)query.count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/repetition/RepetitionRuleTest.testRepeatMilestone.cmmn"})
    public void testRepeatMilestone() {
        this.createCaseInstance();
        String firstHumanTaskId = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        this.complete(firstHumanTaskId);
        HistoricCaseActivityInstanceQuery query = this.historicQuery().caseActivityId("PI_Milestone_1");
        HistoricCaseActivityInstanceTest.assertEquals((long)2L, (long)query.count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/repetition/RepetitionRuleTest.testAutoCompleteStage.cmmn"})
    public void testAutoCompleteStage() {
        this.createCaseInstance();
        String humanTask1 = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        this.complete(humanTask1);
        HistoricCaseActivityInstanceQuery query = this.historicQuery().caseActivityId("PI_Stage_1");
        HistoricCaseActivityInstanceTest.assertEquals((long)1L, (long)query.count());
        query = this.historicQuery().caseActivityId("PI_HumanTask_1");
        HistoricCaseActivityInstanceTest.assertEquals((long)1L, (long)query.count());
        query = this.historicQuery().caseActivityId("PI_HumanTask_2");
        HistoricCaseActivityInstanceTest.assertEquals((long)2L, (long)query.count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/repetition/RepetitionRuleTest.testAutoCompleteStageWithoutEntryCriteria.cmmn"})
    public void testAutoCompleteStageWithRepeatableTaskWithoutEntryCriteria() {
        this.createCaseInstanceByKey("case", Variables.createVariables().putValue("manualActivation", (Object)false));
        this.queryCaseExecutionByActivityId("PI_Stage_1");
        String humanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        this.complete(humanTask);
        HistoricCaseActivityInstanceQuery query = this.historicQuery().caseActivityId("PI_HumanTask_1");
        HistoricCaseActivityInstanceTest.assertEquals((long)2L, (long)query.count());
        query = this.historicQuery().caseActivityId("PI_Stage_1");
        HistoricCaseActivityInstanceTest.assertEquals((long)1L, (long)query.count());
    }

    @Deployment
    public void testDecisionTask() {
        this.createCaseInstance();
        HistoricCaseActivityInstance decisionTask = (HistoricCaseActivityInstance)this.historyService.createHistoricCaseActivityInstanceQuery().caseActivityId("PI_DecisionTask_1").singleResult();
        HistoricCaseActivityInstanceTest.assertNotNull((Object)decisionTask);
        HistoricCaseActivityInstanceTest.assertEquals((String)"decisionTask", (String)decisionTask.getCaseActivityType());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByCaseInstanceId() {
        this.createCaseInstance();
        String taskInstanceId = this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId();
        HistoricCaseActivityInstanceQuery query = this.historicQuery().caseActivityInstanceIdIn(new String[]{taskInstanceId});
        this.assertCount(1L, (Query<?, ?>)query);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByCaseInstanceIds() {
        CaseInstance instance1 = this.createCaseInstance();
        CaseInstance instance2 = this.createCaseInstance();
        String taskInstanceId1 = ((CaseExecution)this.caseService.createCaseExecutionQuery().caseInstanceId(instance1.getId()).activityId("PI_HumanTask_1").singleResult()).getId();
        String taskInstanceId2 = ((CaseExecution)this.caseService.createCaseExecutionQuery().caseInstanceId(instance2.getId()).activityId("PI_HumanTask_1").singleResult()).getId();
        HistoricCaseActivityInstanceQuery query = this.historicQuery().caseActivityInstanceIdIn(new String[]{taskInstanceId1, taskInstanceId2});
        this.assertCount(2L, (Query<?, ?>)query);
    }

    public void testQueryByInvalidCaseInstanceId() {
        HistoricCaseActivityInstanceQuery query = this.historicQuery().caseActivityInstanceIdIn(new String[]{"invalid"});
        this.assertCount(0L, (Query<?, ?>)query);
        try {
            this.historicQuery().caseActivityInstanceIdIn((String[])null);
            HistoricCaseActivityInstanceTest.fail((String)"A NotValidException was expected.");
        }
        catch (NotValidException e) {
            // empty catch block
        }
        try {
            this.historicQuery().caseActivityInstanceIdIn(new String[]{null});
            HistoricCaseActivityInstanceTest.fail((String)"A NotValidException was expected.");
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn", "org/camunda/bpm/engine/test/api/cmmn/twoTaskCase.cmmn"})
    public void testQueryByCaseActivityIds() {
        this.createCaseInstanceByKey("oneTaskCase");
        this.createCaseInstanceByKey("twoTaskCase");
        HistoricCaseActivityInstanceQuery query = this.historicQuery().caseActivityIdIn(new String[]{"PI_HumanTask_1", "PI_HumanTask_2"});
        this.assertCount(3L, (Query<?, ?>)query);
    }

    public void testQueryByInvalidCaseActivityId() {
        HistoricCaseActivityInstanceQuery query = this.historicQuery().caseActivityIdIn(new String[]{"invalid"});
        this.assertCount(0L, (Query<?, ?>)query);
        try {
            this.historicQuery().caseActivityIdIn((String[])null);
            HistoricCaseActivityInstanceTest.fail((String)"A NotValidException was expected.");
        }
        catch (NotValidException e) {
            // empty catch block
        }
        try {
            this.historicQuery().caseActivityIdIn(new String[]{null});
            HistoricCaseActivityInstanceTest.fail((String)"A NotValidException was expected.");
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    protected HistoricCaseActivityInstanceQuery historicQuery() {
        return this.historyService.createHistoricCaseActivityInstanceQuery();
    }

    protected HistoricCaseActivityInstance queryHistoricActivityCaseInstance(String activityId) {
        HistoricCaseActivityInstance historicActivityInstance = (HistoricCaseActivityInstance)this.historicQuery().caseActivityId(activityId).singleResult();
        HistoricCaseActivityInstanceTest.assertNotNull((String)("No historic activity instance found for activity id: " + activityId), (Object)historicActivityInstance);
        return historicActivityInstance;
    }

    protected void assertHistoricState(String activityId, CaseExecutionState expectedState) {
        HistoricCaseActivityInstanceEventEntity historicActivityInstance = (HistoricCaseActivityInstanceEventEntity)this.queryHistoricActivityCaseInstance(activityId);
        int actualStateCode = historicActivityInstance.getCaseActivityInstanceState();
        CaseExecutionState actualState = CaseExecutionState.CaseExecutionStateImpl.getStateForCode((Integer)actualStateCode);
        HistoricCaseActivityInstanceTest.assertEquals((String)("The state of historic case activity '" + activityId + "' wasn't as expected"), (Object)expectedState, (Object)actualState);
    }

    protected void assertHistoricCreateTime(String activityId, Date expectedCreateTime) {
        HistoricCaseActivityInstance historicActivityInstance = this.queryHistoricActivityCaseInstance(activityId);
        Date actualCreateTime = historicActivityInstance.getCreateTime();
        this.assertSimilarDate(expectedCreateTime, actualCreateTime);
    }

    protected void assertHistoricEndTime(String activityId, Date expectedEndTime) {
        HistoricCaseActivityInstance historicActivityInstance = this.queryHistoricActivityCaseInstance(activityId);
        Date actualEndTime = historicActivityInstance.getEndTime();
        this.assertSimilarDate(expectedEndTime, actualEndTime);
    }

    protected void assertSimilarDate(Date expectedDate, Date actualDate) {
        long difference = Math.abs(expectedDate.getTime() - actualDate.getTime());
        HistoricCaseActivityInstanceTest.assertTrue((difference < 1000L ? 1 : 0) != 0);
    }

    protected void assertHistoricDuration(String activityId, long expectedDuration) {
        Long actualDuration = this.queryHistoricActivityCaseInstance(activityId).getDurationInMillis();
        HistoricCaseActivityInstanceTest.assertNotNull((Object)actualDuration);
        HistoricCaseActivityInstanceTest.assertTrue((actualDuration >= expectedDuration ? 1 : 0) != 0);
        HistoricCaseActivityInstanceTest.assertTrue((actualDuration < expectedDuration + 1000L ? 1 : 0) != 0);
    }

    protected void assertCount(long count, Query<?, ?> historicQuery) {
        HistoricCaseActivityInstanceTest.assertEquals((long)count, (long)historicQuery.count());
    }

    protected void assertStateQuery(CaseExecutionState ... states) {
        CaseExecutionStateCountMap stateCounts = new CaseExecutionStateCountMap();
        if (states != null) {
            for (CaseExecutionState state : states) {
                stateCounts.put(state, stateCounts.get(state) + 1L);
            }
        }
        this.assertCount(stateCounts.count(), (Query<?, ?>)this.historicQuery());
        this.assertCount(stateCounts.unfinished(), (Query<?, ?>)this.historicQuery().notEnded());
        this.assertCount(stateCounts.finished(), (Query<?, ?>)this.historicQuery().ended());
        this.assertCount(stateCounts.get(CaseExecutionState.ACTIVE), (Query<?, ?>)this.historicQuery().active());
        this.assertCount(stateCounts.get(CaseExecutionState.AVAILABLE), (Query<?, ?>)this.historicQuery().available());
        this.assertCount(stateCounts.get(CaseExecutionState.COMPLETED), (Query<?, ?>)this.historicQuery().completed());
        this.assertCount(stateCounts.get(CaseExecutionState.DISABLED), (Query<?, ?>)this.historicQuery().disabled());
        this.assertCount(stateCounts.get(CaseExecutionState.ENABLED), (Query<?, ?>)this.historicQuery().enabled());
        this.assertCount(stateCounts.get(CaseExecutionState.TERMINATED), (Query<?, ?>)this.historicQuery().terminated());
    }

    protected void assertQuerySorting(String property, Query<?, ?> query, Comparable ... items) {
        AbstractQuery queryImpl = (AbstractQuery)query;
        List orderProperties = queryImpl.getOrderingProperties();
        List<Comparable> sortedList = Arrays.asList(items);
        Collections.sort(sortedList);
        ArrayList<Matcher> matchers = new ArrayList<Matcher>();
        for (Comparable comparable : sortedList) {
            matchers.add(Matchers.hasProperty((String)property, (Matcher)Matchers.equalTo((Object)comparable)));
        }
        List instances = query.asc().list();
        HistoricCaseActivityInstanceTest.assertEquals((int)sortedList.size(), (int)instances.size());
        Assert.assertThat((Object)instances, (Matcher)IsIterableContainingInOrder.contains((Matcher[])matchers.toArray(new Matcher[matchers.size()])));
        for (QueryOrderingProperty orderingProperty : orderProperties) {
            orderingProperty.setDirection(Direction.DESCENDING);
        }
        Collections.reverse(matchers);
        instances = query.list();
        HistoricCaseActivityInstanceTest.assertEquals((int)sortedList.size(), (int)instances.size());
        Assert.assertThat((Object)instances, (Matcher)IsIterableContainingInOrder.contains((Matcher[])matchers.toArray(new Matcher[matchers.size()])));
    }

    protected class CaseExecutionStateCountMap
    extends HashMap<CaseExecutionState, Long> {
        private static final long serialVersionUID = 1L;
        public final Collection<CaseExecutionState> ALL_STATES = CaseExecutionState.CASE_EXECUTION_STATES.values();
        public final Collection<CaseExecutionState> ENDED_STATES = Arrays.asList(CaseExecutionState.COMPLETED, CaseExecutionState.TERMINATED);
        public final Collection<CaseExecutionState> NOT_ENDED_STATES = new ArrayList<CaseExecutionState>(this.ALL_STATES);

        public CaseExecutionStateCountMap() {
            this.NOT_ENDED_STATES.removeAll(this.ENDED_STATES);
        }

        public Long get(CaseExecutionState state) {
            return state != null && this.containsKey(state) ? (Long)super.get(state) : 0L;
        }

        public Long count() {
            return this.count(this.ALL_STATES);
        }

        public Long finished() {
            return this.count(this.ENDED_STATES);
        }

        public Long unfinished() {
            return this.count(this.NOT_ENDED_STATES);
        }

        public Long count(Collection<CaseExecutionState> states) {
            long count = 0L;
            for (CaseExecutionState state : states) {
                count += this.get(state).longValue();
            }
            return count;
        }
    }
}

