/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.jobexecutor;

import java.util.List;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.jobexecutor.AbstractJobExecutorAcquireJobsTest;
import org.camunda.bpm.engine.test.util.ClockTestUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JobExecutorAcquireJobsByPriorityAndDueDateTest
extends AbstractJobExecutorAcquireJobsTest {
    @Before
    public void prepareProcessEngineConfiguration() {
        this.configuration.setJobExecutorAcquireByPriority(true);
        this.configuration.setJobExecutorAcquireByDueDate(true);
    }

    @Test
    public void testProcessEngineConfiguration() {
        Assert.assertFalse((boolean)this.configuration.isJobExecutorPreferTimerJobs());
        Assert.assertTrue((boolean)this.configuration.isJobExecutorAcquireByDueDate());
        Assert.assertTrue((boolean)this.configuration.isJobExecutorAcquireByPriority());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/jobexecutor/jobPrioProcess.bpmn20.xml", "org/camunda/bpm/engine/test/jobexecutor/timerJobPrioProcess.bpmn20.xml"})
    public void testAcquisitionByPriorityAndDueDate() {
        String instance1 = this.startProcess("jobPrioProcess", "task1");
        ClockTestUtil.incrementClock(1L);
        String instance2 = this.startProcess("jobPrioProcess", "task2");
        ClockTestUtil.incrementClock(1L);
        String instance3 = this.startProcess("jobPrioProcess", "task1");
        ClockTestUtil.incrementClock(1L);
        String instance4 = this.startProcess("jobPrioProcess", "task2");
        List<JobEntity> acquirableJobs = this.findAcquirableJobs();
        Assert.assertEquals((long)4L, (long)acquirableJobs.size());
        Assert.assertEquals((Object)instance1, (Object)acquirableJobs.get(0).getProcessInstanceId());
        Assert.assertEquals((Object)instance3, (Object)acquirableJobs.get(1).getProcessInstanceId());
        Assert.assertEquals((Object)instance2, (Object)acquirableJobs.get(2).getProcessInstanceId());
        Assert.assertEquals((Object)instance4, (Object)acquirableJobs.get(3).getProcessInstanceId());
    }
}

