/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.standalone.util;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.impl.util.JsonUtil;
import org.camunda.bpm.engine.impl.util.json.JSONArray;
import org.camunda.bpm.engine.impl.util.json.JSONObject;
import org.junit.Assert;
import org.junit.Test;

public class JsonUtilTest {
    @Test
    public void testJsonObjectToMap() {
        Assert.assertNull((Object)JsonUtil.jsonObjectAsMap(null));
        JSONObject jsonObject = new JSONObject();
        Map map = JsonUtil.jsonObjectAsMap((JSONObject)jsonObject);
        Assert.assertTrue((boolean)map.isEmpty());
        jsonObject.put("boolean", true);
        jsonObject.put("int", 12);
        jsonObject.put("double", 11.1);
        jsonObject.put("long", 13L);
        jsonObject.put("string", (Object)"test");
        jsonObject.put("list", Collections.singletonList("test"));
        jsonObject.put("map", Collections.singletonMap("test", "test"));
        jsonObject.put("date", (Object)new Date(0L));
        map = JsonUtil.jsonObjectAsMap((JSONObject)jsonObject);
        Assert.assertEquals((long)8L, (long)map.size());
        Assert.assertEquals((Object)true, map.get("boolean"));
        Assert.assertEquals((Object)12, map.get("int"));
        Assert.assertEquals((Object)11.1, map.get("double"));
        Assert.assertEquals((Object)13L, map.get("long"));
        Assert.assertEquals((Object)"test", map.get("string"));
        List embeddedList = (List)map.get("list");
        Assert.assertEquals((long)1L, (long)embeddedList.size());
        Assert.assertEquals((Object)"test", embeddedList.get(0));
        Map embeddedMap = (Map)map.get("map");
        Assert.assertEquals((long)1L, (long)embeddedMap.size());
        Assert.assertTrue((boolean)embeddedMap.containsKey("test"));
        Assert.assertEquals((Object)"test", embeddedMap.get("test"));
        Date embeddedDate = (Date)map.get("date");
        Assert.assertEquals((Object)new Date(0L), (Object)embeddedDate);
    }

    @Test
    public void testJsonArrayToList() {
        Assert.assertNull((Object)JsonUtil.jsonArrayAsList(null));
        JSONArray jsonArray = new JSONArray();
        List list = JsonUtil.jsonArrayAsList((JSONArray)jsonArray);
        Assert.assertTrue((boolean)list.isEmpty());
        jsonArray.put(true);
        jsonArray.put(12);
        jsonArray.put(11.1);
        jsonArray.put(13L);
        jsonArray.put((Object)"test");
        jsonArray.put(Collections.singletonList("test"));
        jsonArray.put(Collections.singletonMap("test", "test"));
        jsonArray.put((Object)new Date(0L));
        list = JsonUtil.jsonArrayAsList((JSONArray)jsonArray);
        Assert.assertEquals((long)8L, (long)list.size());
        Assert.assertEquals((Object)true, list.get(0));
        Assert.assertEquals((Object)12, list.get(1));
        Assert.assertEquals((Object)11.1, list.get(2));
        Assert.assertEquals((Object)13L, list.get(3));
        Assert.assertEquals((Object)"test", list.get(4));
        List embeddedList = (List)list.get(5);
        Assert.assertEquals((long)1L, (long)embeddedList.size());
        Assert.assertEquals((Object)"test", embeddedList.get(0));
        Map embeddedMap = (Map)list.get(6);
        Assert.assertEquals((long)1L, (long)embeddedMap.size());
        Assert.assertTrue((boolean)embeddedMap.containsKey("test"));
        Assert.assertEquals((Object)"test", embeddedMap.get("test"));
        Date embeddedDate = (Date)list.get(7);
        Assert.assertEquals((Object)new Date(0L), (Object)embeddedDate);
    }
}

