/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.batch;

import java.io.ByteArrayOutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import org.camunda.bpm.engine.impl.batch.AbstractProcessInstanceBatchConfiguration;
import org.camunda.bpm.engine.impl.batch.BatchEntity;
import org.camunda.bpm.engine.impl.batch.BatchJobConfiguration;
import org.camunda.bpm.engine.impl.batch.BatchJobContext;
import org.camunda.bpm.engine.impl.batch.BatchJobHandler;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.jobexecutor.JobDeclaration;
import org.camunda.bpm.engine.impl.json.JsonObjectConverter;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayManager;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobManager;
import org.camunda.bpm.engine.impl.persistence.entity.MessageEntity;
import org.camunda.bpm.engine.impl.util.IoUtil;
import org.camunda.bpm.engine.impl.util.StringUtil;
import org.camunda.bpm.engine.impl.util.json.JSONObject;
import org.camunda.bpm.engine.impl.util.json.JSONTokener;

public abstract class AbstractProcessInstanceBatchJobHandler<T extends AbstractProcessInstanceBatchConfiguration>
implements BatchJobHandler<T> {
    @Override
    public abstract JobDeclaration<BatchJobContext, MessageEntity> getJobDeclaration();

    @Override
    public boolean createJobs(BatchEntity batch) {
        CommandContext commandContext = Context.getCommandContext();
        ByteArrayManager byteArrayManager = commandContext.getByteArrayManager();
        JobManager jobManager = commandContext.getJobManager();
        Object configuration = this.readConfiguration(batch.getConfigurationBytes());
        int batchJobsPerSeed = batch.getBatchJobsPerSeed();
        int invocationsPerBatchJob = batch.getInvocationsPerBatchJob();
        List<String> processInstanceIds = ((AbstractProcessInstanceBatchConfiguration)configuration).getProcessInstanceIds();
        int numberOfInstancesToProcess = Math.min(invocationsPerBatchJob * batchJobsPerSeed, processInstanceIds.size());
        List<String> processInstancesToProcess = processInstanceIds.subList(0, numberOfInstancesToProcess);
        int createdJobs = 0;
        while (!processInstancesToProcess.isEmpty()) {
            int lastIdIndex = Math.min(invocationsPerBatchJob, processInstancesToProcess.size());
            List<String> idsForJob = processInstancesToProcess.subList(0, lastIdIndex);
            Object jobConfiguration = this.createJobConfiguration(configuration, idsForJob);
            ByteArrayEntity configurationEntity = this.saveConfiguration(byteArrayManager, jobConfiguration);
            JobEntity job = this.createBatchJob(batch, configurationEntity);
            this.postProcessJob(configuration, job);
            jobManager.insertAndHintJobExecutor(job);
            idsForJob.clear();
            ++createdJobs;
        }
        batch.setJobsCreated(batch.getJobsCreated() + createdJobs);
        batch.setConfigurationBytes(this.writeConfiguration((T)configuration));
        return processInstanceIds.isEmpty();
    }

    protected abstract T createJobConfiguration(T var1, List<String> var2);

    protected void postProcessJob(T configuration, JobEntity job) {
    }

    protected JobEntity createBatchJob(BatchEntity batch, ByteArrayEntity configuration) {
        BatchJobContext creationContext = new BatchJobContext(batch, configuration);
        return this.getJobDeclaration().createJobInstance(creationContext);
    }

    @Override
    public void deleteJobs(BatchEntity batch) {
        List<JobEntity> jobs = Context.getCommandContext().getJobManager().findJobsByJobDefinitionId(batch.getBatchJobDefinitionId());
        for (JobEntity job : jobs) {
            job.delete();
        }
    }

    @Override
    public BatchJobConfiguration newConfiguration(String canonicalString) {
        return new BatchJobConfiguration(canonicalString);
    }

    @Override
    public void onDelete(BatchJobConfiguration configuration, JobEntity jobEntity) {
        String byteArrayId = configuration.getConfigurationByteArrayId();
        if (byteArrayId != null) {
            Context.getCommandContext().getByteArrayManager().deleteByteArrayById(byteArrayId);
        }
    }

    protected ByteArrayEntity saveConfiguration(ByteArrayManager byteArrayManager, T jobConfiguration) {
        ByteArrayEntity configurationEntity = new ByteArrayEntity();
        configurationEntity.setBytes(this.writeConfiguration(jobConfiguration));
        byteArrayManager.insert(configurationEntity);
        return configurationEntity;
    }

    @Override
    public byte[] writeConfiguration(T configuration) {
        JSONObject jsonObject = this.getJsonConverterInstance().toJsonObject(configuration);
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        Writer writer = StringUtil.writerForStream(outStream);
        jsonObject.write(writer);
        IoUtil.flushSilently(writer);
        return outStream.toByteArray();
    }

    @Override
    public T readConfiguration(byte[] serializedConfiguration) {
        Reader jsonReader = StringUtil.readerFromBytes(serializedConfiguration);
        return (T)((AbstractProcessInstanceBatchConfiguration)this.getJsonConverterInstance().toObject(new JSONObject(new JSONTokener(jsonReader))));
    }

    protected abstract JsonObjectConverter<T> getJsonConverterInstance();
}

