/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.batch.deletion;

import java.util.List;
import org.camunda.bpm.engine.impl.batch.AbstractProcessInstanceBatchJobHandler;
import org.camunda.bpm.engine.impl.batch.BatchJobConfiguration;
import org.camunda.bpm.engine.impl.batch.BatchJobContext;
import org.camunda.bpm.engine.impl.batch.deletion.DeleteProcessInstanceBatchConfiguration;
import org.camunda.bpm.engine.impl.batch.deletion.DeleteProcessInstanceBatchConfigurationJsonConverter;
import org.camunda.bpm.engine.impl.batch.deletion.DeleteProcessInstancesBatchJobDeclaration;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.jobexecutor.JobDeclaration;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.MessageEntity;

public class DeleteProcessInstancesJobHandler
extends AbstractProcessInstanceBatchJobHandler<DeleteProcessInstanceBatchConfiguration> {
    public static final DeleteProcessInstancesBatchJobDeclaration JOB_DECLARATION = new DeleteProcessInstancesBatchJobDeclaration();

    @Override
    public String getType() {
        return "instance-deletion";
    }

    protected DeleteProcessInstanceBatchConfigurationJsonConverter getJsonConverterInstance() {
        return DeleteProcessInstanceBatchConfigurationJsonConverter.INSTANCE;
    }

    @Override
    public JobDeclaration<BatchJobContext, MessageEntity> getJobDeclaration() {
        return JOB_DECLARATION;
    }

    @Override
    protected DeleteProcessInstanceBatchConfiguration createJobConfiguration(DeleteProcessInstanceBatchConfiguration configuration, List<String> processIdsForJob) {
        return DeleteProcessInstanceBatchConfiguration.create(processIdsForJob, configuration.getDeleteReason());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(BatchJobConfiguration configuration, ExecutionEntity execution, CommandContext commandContext, String tenantId) {
        ByteArrayEntity configurationEntity = commandContext.getDbEntityManager().selectById(ByteArrayEntity.class, configuration.getConfigurationByteArrayId());
        DeleteProcessInstanceBatchConfiguration batchConfiguration = (DeleteProcessInstanceBatchConfiguration)this.readConfiguration(configurationEntity.getBytes());
        boolean initialLegacyRestrictions = commandContext.isRestrictUserOperationLogToAuthenticatedUsers();
        commandContext.disableUserOperationLog();
        commandContext.setRestrictUserOperationLogToAuthenticatedUsers(true);
        try {
            commandContext.getProcessEngineConfiguration().getRuntimeService().deleteProcessInstances(batchConfiguration.getProcessInstanceIds(), batchConfiguration.deleteReason, true, true);
        }
        finally {
            commandContext.enableUserOperationLog();
            commandContext.setRestrictUserOperationLogToAuthenticatedUsers(initialLegacyRestrictions);
        }
        commandContext.getByteArrayManager().delete(configurationEntity);
    }
}

