/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd.batch;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.impl.ProcessInstanceQueryImpl;
import org.camunda.bpm.engine.impl.batch.BatchEntity;
import org.camunda.bpm.engine.impl.batch.BatchJobHandler;
import org.camunda.bpm.engine.impl.batch.deletion.DeleteProcessInstanceBatchConfiguration;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cmd.batch.AbstractBatchCmd;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyChange;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;

public class DeleteProcessInstanceBatchCmd
extends AbstractBatchCmd<Batch> {
    protected final String deleteReason;
    protected List<String> processInstanceIds;
    protected ProcessInstanceQuery processInstanceQuery;

    public DeleteProcessInstanceBatchCmd(List<String> processInstances, ProcessInstanceQuery processInstanceQuery, String deleteReason) {
        this.processInstanceIds = processInstances;
        this.processInstanceQuery = processInstanceQuery;
        this.deleteReason = deleteReason;
    }

    protected List<String> collectProcessInstanceIds() {
        ProcessInstanceQueryImpl processInstanceQuery;
        HashSet<String> collectedProcessInstanceIds = new HashSet<String>();
        List<String> processInstanceIds = this.getProcessInstanceIds();
        if (processInstanceIds != null) {
            collectedProcessInstanceIds.addAll(processInstanceIds);
        }
        if ((processInstanceQuery = (ProcessInstanceQueryImpl)this.processInstanceQuery) != null) {
            collectedProcessInstanceIds.addAll(processInstanceQuery.listIds());
        }
        return new ArrayList<String>(collectedProcessInstanceIds);
    }

    public List<String> getProcessInstanceIds() {
        return this.processInstanceIds;
    }

    @Override
    public Batch execute(CommandContext commandContext) {
        List<String> processInstanceIds = this.collectProcessInstanceIds();
        EnsureUtil.ensureNotEmpty(BadUserRequestException.class, "processInstanceIds", processInstanceIds);
        this.checkAuthorizations(commandContext);
        this.writeUserOperationLog(commandContext, this.deleteReason, processInstanceIds.size(), true);
        BatchEntity batch = this.createBatch(commandContext, processInstanceIds, this.deleteReason);
        batch.createSeedJobDefinition();
        batch.createMonitorJobDefinition();
        batch.createBatchJobDefinition();
        batch.fireHistoricStartEvent();
        batch.createSeedJob();
        return batch;
    }

    protected BatchEntity createBatch(CommandContext commandContext, List<String> processInstanceIds, String deleteReason) {
        ProcessEngineConfigurationImpl processEngineConfiguration = commandContext.getProcessEngineConfiguration();
        BatchJobHandler<DeleteProcessInstanceBatchConfiguration> batchJobHandler = this.getBatchJobHandler(processEngineConfiguration);
        DeleteProcessInstanceBatchConfiguration configuration = DeleteProcessInstanceBatchConfiguration.create(processInstanceIds, deleteReason);
        BatchEntity batch = new BatchEntity();
        batch.setType(batchJobHandler.getType());
        batch.setTotalJobs(this.calculateSize(processEngineConfiguration, configuration));
        batch.setBatchJobsPerSeed(processEngineConfiguration.getBatchJobsPerSeed());
        batch.setInvocationsPerBatchJob(processEngineConfiguration.getInvocationsPerBatchJob());
        batch.setConfigurationBytes(batchJobHandler.writeConfiguration(configuration));
        commandContext.getBatchManager().insert(batch);
        return batch;
    }

    protected int calculateSize(ProcessEngineConfigurationImpl engineConfiguration, DeleteProcessInstanceBatchConfiguration batchConfiguration) {
        int invocationsPerBatchJob = engineConfiguration.getInvocationsPerBatchJob();
        int processInstanceCount = batchConfiguration.getProcessInstanceIds().size();
        return (int)Math.ceil(processInstanceCount / invocationsPerBatchJob);
    }

    protected BatchJobHandler<DeleteProcessInstanceBatchConfiguration> getBatchJobHandler(ProcessEngineConfigurationImpl processEngineConfiguration) {
        return processEngineConfiguration.getBatchHandlers().get("instance-deletion");
    }

    protected void writeUserOperationLog(CommandContext commandContext, String deleteReason, int numInstances, boolean async) {
        ArrayList<PropertyChange> propertyChanges = new ArrayList<PropertyChange>();
        propertyChanges.add(new PropertyChange("nrOfInstances", null, numInstances));
        propertyChanges.add(new PropertyChange("async", null, async));
        propertyChanges.add(new PropertyChange("deleteReason", null, deleteReason));
        commandContext.getOperationLogManager().logProcessInstanceOperation("Delete", null, null, null, propertyChanges);
    }
}

